/* Copyright (c) 1999, 2002 Michael J. Roberts.  All Rights Reserved. */
/*
Name
  vminitim.cpp - VM initialization - "flat" pool implementation
Function

Notes

Modified
  07/21/99 MJRoberts  - Creation
*/

#include "vminit.h"
#include "vmpool.h"

/* ------------------------------------------------------------------------ */
/*
 *   Initialize the VM with the "flat" pool manager
 */
void vm_init_flat(vm_globals **vmg, class CVmHostIfc *hostifc,
                  class CVmMainClientIfc *clientifc,
                  const char *charset)
{
    vm_globals *vmg__;

    /* initialize the base VM structures */
    vm_init_base(vmg, hostifc, clientifc, charset);

    /* 
     *   assign the global pointer to the special vmg__ local for
     *   globals-on-stack configuration 
     */
    vmg__ = *vmg;

    /* create the in-memory pools */
    VM_IF_ALLOC_EXT_GLOBAL(G_code_pool = new CVmPoolFlat());
    VM_IF_ALLOC_EXT_GLOBAL(G_const_pool = new CVmPoolFlat());
}

