/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;

public final class FilterList
extends TransformedList {
    private Barcode flagList = new Barcode();
    private Matcher currentMatcher = Matchers.trueMatcher();
    private MatcherEditor currentEditor = null;
    protected MatcherEditor.Listener listener = new PrivateMatcherEditorListener();

    public FilterList(EventList source) {
        super(source);
        this.flagList.addBlack(0, source.size());
        source.addListEventListener(this);
    }

    public FilterList(EventList source, Matcher matcher) {
        this(source);
        this.setMatcher(matcher);
    }

    public FilterList(EventList source, MatcherEditor matcherEditor) {
        this(source);
        this.setMatcherEditor(matcherEditor);
    }

    public void setMatcher(Matcher matcher) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
            this.currentEditor = null;
        }
        this.listener.changedMatcher(new MatcherEditor.Event(this, 4, matcher));
    }

    public void setMatcherEditor(MatcherEditor editor) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.addMatcherEditorListener(this.listener);
            this.currentMatcher = this.currentEditor.getMatcher();
            this.listener.changedMatcher(new MatcherEditor.Event(this.currentEditor, 4, this.currentMatcher));
        } else {
            this.currentMatcher = Matchers.trueMatcher();
            this.listener.changedMatcher(new MatcherEditor.Event(this, 4, this.currentMatcher));
        }
    }

    public final void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        if (listChanges.isReordering()) {
            int[] sourceReorderMap = listChanges.getReorderMap();
            int[] filterReorderMap = new int[this.flagList.blackSize()];
            Barcode previousFlagList = this.flagList;
            this.flagList = new Barcode();
            for (int i = 0; i < sourceReorderMap.length; ++i) {
                Object flag = previousFlagList.get(sourceReorderMap[i]);
                this.flagList.add(i, flag, 1);
                if (flag == Barcode.WHITE) continue;
                filterReorderMap[this.flagList.getBlackIndex((int)i)] = previousFlagList.getBlackIndex(sourceReorderMap[i]);
            }
            this.updates.reorder(filterReorderMap);
        } else {
            while (listChanges.next()) {
                int filteredIndex;
                int sourceIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType == 0) {
                    filteredIndex = this.flagList.getBlackIndex(sourceIndex);
                    if (filteredIndex != -1) {
                        this.updates.addDelete(filteredIndex);
                    }
                    this.flagList.remove(sourceIndex, 1);
                    continue;
                }
                if (changeType == 2) {
                    boolean include = this.currentMatcher.matches(this.source.get(sourceIndex));
                    if (include) {
                        this.flagList.addBlack(sourceIndex, 1);
                        int filteredIndex2 = this.flagList.getBlackIndex(sourceIndex);
                        this.updates.addInsert(filteredIndex2);
                        continue;
                    }
                    this.flagList.addWhite(sourceIndex, 1);
                    continue;
                }
                if (changeType != 1) continue;
                filteredIndex = this.flagList.getBlackIndex(sourceIndex);
                boolean wasIncluded = filteredIndex != -1;
                boolean include = this.currentMatcher.matches(this.source.get(sourceIndex));
                if (wasIncluded && !include) {
                    this.flagList.setWhite(sourceIndex, 1);
                    this.updates.addDelete(filteredIndex);
                    continue;
                }
                if (!wasIncluded && include) {
                    this.flagList.setBlack(sourceIndex, 1);
                    this.updates.addInsert(this.flagList.getBlackIndex(sourceIndex));
                    continue;
                }
                if (!wasIncluded || !include) continue;
                this.updates.addUpdate(filteredIndex);
            }
        }
        this.updates.commitEvent();
    }

    public final int size() {
        return this.flagList.blackSize();
    }

    protected final int getSourceIndex(int mutationIndex) {
        return this.flagList.getIndex(mutationIndex, Barcode.BLACK);
    }

    protected boolean isWritable() {
        return true;
    }

    private class PrivateMatcherEditorListener
    implements MatcherEditor.Listener {
        private PrivateMatcherEditorListener() {
        }

        public void changedMatcher(MatcherEditor.Event matcherEvent) {
            MatcherEditor matcherEditor = matcherEvent.getMatcherEditor();
            Matcher matcher = matcherEvent.getMatcher();
            switch (matcherEvent.getType()) {
                case 2: {
                    this.constrained(matcherEditor, matcher);
                    break;
                }
                case 3: {
                    this.relaxed(matcherEditor, matcher);
                    break;
                }
                case 4: {
                    this.changed(matcherEditor, matcher);
                    break;
                }
                case 0: {
                    this.matchAll(matcherEditor);
                    break;
                }
                case 1: {
                    this.matchNone(matcherEditor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void matchNone(MatcherEditor editor) {
            FilterList.this.getReadWriteLock().writeLock().lock();
            try {
                if (FilterList.this.currentEditor != editor) {
                    throw new IllegalStateException();
                }
                FilterList.this.currentMatcher = Matchers.falseMatcher();
                FilterList.this.updates.beginEvent();
                if (FilterList.this.size() > 0) {
                    FilterList.this.updates.addDelete(0, FilterList.this.size() - 1);
                }
                FilterList.this.flagList.clear();
                FilterList.this.flagList.addWhite(0, FilterList.this.source.size());
                FilterList.this.updates.commitEvent();
            }
            finally {
                FilterList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void matchAll(MatcherEditor editor) {
            FilterList.this.getReadWriteLock().writeLock().lock();
            try {
                if (FilterList.this.currentEditor != editor) {
                    throw new IllegalStateException();
                }
                FilterList.this.currentMatcher = Matchers.trueMatcher();
                FilterList.this.updates.beginEvent();
                BarcodeIterator i = FilterList.this.flagList.iterator();
                while (i.hasNextWhite()) {
                    i.nextWhite();
                    FilterList.this.updates.addInsert(i.getIndex());
                }
                FilterList.this.flagList.clear();
                FilterList.this.flagList.addBlack(0, FilterList.this.source.size());
                FilterList.this.updates.commitEvent();
            }
            finally {
                FilterList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void relaxed(MatcherEditor editor, Matcher matcher) {
            FilterList.this.getReadWriteLock().writeLock().lock();
            try {
                if (FilterList.this.currentEditor != editor) {
                    throw new IllegalStateException();
                }
                FilterList.this.currentMatcher = matcher;
                FilterList.this.updates.beginEvent();
                BarcodeIterator i = FilterList.this.flagList.iterator();
                while (i.hasNextWhite()) {
                    i.nextWhite();
                    if (!FilterList.this.currentMatcher.matches(FilterList.this.source.get(i.getIndex()))) continue;
                    FilterList.this.updates.addInsert(i.setBlack());
                }
                FilterList.this.updates.commitEvent();
            }
            finally {
                FilterList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void constrained(MatcherEditor editor, Matcher matcher) {
            FilterList.this.getReadWriteLock().writeLock().lock();
            try {
                if (FilterList.this.currentEditor != editor) {
                    throw new IllegalStateException();
                }
                FilterList.this.currentMatcher = matcher;
                FilterList.this.updates.beginEvent();
                BarcodeIterator i = FilterList.this.flagList.iterator();
                while (i.hasNextBlack()) {
                    i.nextBlack();
                    if (FilterList.this.currentMatcher.matches(FilterList.this.source.get(i.getIndex()))) continue;
                    int blackIndex = i.getBlackIndex();
                    i.setWhite();
                    FilterList.this.updates.addDelete(blackIndex);
                }
                FilterList.this.updates.commitEvent();
            }
            finally {
                FilterList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed(MatcherEditor editor, Matcher matcher) {
            FilterList.this.getReadWriteLock().writeLock().lock();
            try {
                if (FilterList.this.currentEditor != editor) {
                    throw new IllegalStateException();
                }
                FilterList.this.currentMatcher = matcher;
                FilterList.this.updates.beginEvent();
                BarcodeIterator i = FilterList.this.flagList.iterator();
                while (i.hasNext()) {
                    i.next();
                    int filteredIndex = i.getBlackIndex();
                    boolean wasIncluded = filteredIndex != -1;
                    boolean include = FilterList.this.currentMatcher.matches(FilterList.this.source.get(i.getIndex()));
                    if (wasIncluded && !include) {
                        i.setWhite();
                        FilterList.this.updates.addDelete(filteredIndex);
                        continue;
                    }
                    if (wasIncluded || !include) continue;
                    FilterList.this.updates.addInsert(i.setBlack());
                }
                FilterList.this.updates.commitEvent();
            }
            finally {
                FilterList.this.getReadWriteLock().writeLock().unlock();
            }
        }
    }
}

