/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;

public class ObservableElementList
extends TransformedList {
    private List observedElements;
    private Connector elementConnector = null;
    private boolean singleListenerMode = true;
    private List multiEventListenerRegistry = null;
    private EventListener singleEventListener = null;
    private Barcode singleEventListenerRegistry = null;

    public ObservableElementList(EventList source, Connector elementConnector) {
        super(source);
        this.elementConnector = elementConnector;
        this.elementConnector.setObservableElementList(this);
        this.observedElements = new ArrayList(source);
        this.singleEventListenerRegistry = new Barcode();
        this.singleEventListenerRegistry.addWhite(0, source.size());
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            EventListener listener = this.connectElement(iter.next());
            this.registerListener(index, listener, false);
            ++index;
        }
        source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        if (this.observedElements == null) {
            throw new IllegalStateException("This list has been disposed and can no longer be used.");
        }
        while (listChanges.next()) {
            EventListener listener;
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                Object inserted = this.get(changeIndex);
                this.observedElements.add(changeIndex, inserted);
                listener = this.connectElement(inserted);
                this.registerListener(changeIndex, listener, false);
                continue;
            }
            if (changeType == 0) {
                Object deleted = this.observedElements.remove(changeIndex);
                listener = this.unregisterListener(changeIndex);
                this.disconnectElement(deleted, listener);
                continue;
            }
            if (changeType != 1) continue;
            Object previousValue = this.observedElements.get(changeIndex);
            Object newValue = this.get(changeIndex);
            if (newValue == previousValue) continue;
            this.observedElements.set(changeIndex, newValue);
            this.disconnectElement(previousValue, this.getListener(changeIndex));
            EventListener listener2 = this.connectElement(newValue);
            this.registerListener(changeIndex, listener2, true);
        }
        listChanges.reset();
        this.updates.forwardEvent(listChanges);
    }

    private void registerListener(int index, EventListener listener, boolean replace) {
        if (replace) {
            if (this.singleListenerMode) {
                this.singleEventListenerRegistry.set(index, listener == null ? Barcode.WHITE : Barcode.BLACK, 1);
            } else {
                this.multiEventListenerRegistry.set(index, listener);
            }
        } else if (this.singleListenerMode) {
            this.singleEventListenerRegistry.add(index, listener == null ? Barcode.WHITE : Barcode.BLACK, 1);
        } else {
            this.multiEventListenerRegistry.add(index, listener);
        }
    }

    private EventListener getListener(int index) {
        EventListener listener = null;
        if (this.singleListenerMode) {
            if (this.singleEventListenerRegistry.get(index) == Barcode.BLACK) {
                listener = this.singleEventListener;
            }
        } else {
            listener = (EventListener)this.multiEventListenerRegistry.get(index);
        }
        return listener;
    }

    private EventListener unregisterListener(int index) {
        EventListener listener = null;
        if (this.singleListenerMode) {
            if (this.singleEventListenerRegistry.get(index) == Barcode.BLACK) {
                listener = this.singleEventListener;
            }
            this.singleEventListenerRegistry.remove(index, 1);
        } else {
            listener = (EventListener)this.multiEventListenerRegistry.remove(index);
        }
        return listener;
    }

    private EventListener connectElement(Object listElement) {
        if (listElement == null) {
            return null;
        }
        EventListener listener = this.elementConnector.installListener(listElement);
        if (this.singleListenerMode && listener != null) {
            if (this.singleEventListener == null) {
                this.singleEventListener = listener;
            } else if (listener != this.singleEventListener) {
                this.switchToMultiListenerMode();
            }
        }
        return listener;
    }

    private void disconnectElement(Object listElement, EventListener listener) {
        if (listElement != null && listener != null) {
            this.elementConnector.uninstallListener(listElement, listener);
        }
    }

    private void switchToMultiListenerMode() {
        if (!this.singleListenerMode) {
            throw new IllegalStateException();
        }
        this.multiEventListenerRegistry = new ArrayList(this.source.size());
        BarcodeIterator iter = this.singleEventListenerRegistry.iterator();
        while (iter.hasNextBlack()) {
            iter.nextBlack();
            this.multiEventListenerRegistry.add(iter.getIndex(), this.singleEventListener);
        }
        this.singleEventListener = null;
        this.singleEventListenerRegistry = null;
        this.singleListenerMode = false;
    }

    protected boolean isWritable() {
        return true;
    }

    public void dispose() {
        for (int i = 0; i < this.observedElements.size(); ++i) {
            Object element = this.observedElements.get(i);
            EventListener listener = this.getListener(i);
            this.disconnectElement(element, listener);
        }
        this.elementConnector.setObservableElementList(null);
        this.observedElements = null;
        this.multiEventListenerRegistry = null;
        this.singleEventListener = null;
        this.singleEventListenerRegistry = null;
        this.elementConnector = null;
        super.dispose();
    }

    public void elementChanged(Object listElement) {
        if (this.observedElements == null) {
            throw new IllegalStateException("This list has been disposed and can no longer be used.");
        }
        this.updates.beginEvent();
        for (int i = 0; i < this.size(); ++i) {
            if (listElement != this.get(i)) continue;
            this.updates.addUpdate(i);
        }
        boolean foundElement = !this.updates.isEventEmpty();
        this.updates.commitEvent();
        if (!foundElement) {
            throw new IllegalStateException("Failed to find list listElement \"" + listElement + "\" in list " + this);
        }
    }

    public static interface Connector {
        public EventListener installListener(Object var1);

        public void uninstallListener(Object var1, EventListener var2);

        public void setObservableElementList(ObservableElementList var1);
    }
}

