/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: logindialog.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2006/04/07 14:21:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_LOGINDIALOG_HXX_
#include <services/logindialog.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _CPPUHELPER_PROPTYPEHLP_HXX
#include <cppuhelper/proptypehlp.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_SYSDATA_HXX
    #if defined( WIN ) || defined( WNT ) || defined( OS2 )
        typedef sal_Int32 HWND;
        typedef sal_Int32 HMENU;
    #endif
    #include <vcl/sysdata.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::awt			;
using namespace ::com::sun::star::beans			;
using namespace ::com::sun::star::lang			;
using namespace ::com::sun::star::uno			;
using namespace ::com::sun::star::util          ;
using namespace ::cppu							;
using namespace ::osl							;
using namespace ::rtl							;
using namespace ::vos							;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

#define	MAX_VALUELENGTH		1000
#define	INIENCODING			RTL_TEXTENCODING_UTF8
#define	LANGUAGE_SEPERATOR	(sal_Unicode)(';')

#define PROP_DIALOG_SMALL			"small"
#define	PROP_DIALOG_SMALL_LENGTH	5

#define PROP_USEPROXY_BROWSER		"browser"
#define PROP_USEPROXY_BROWSER_LEN	7
#define PROP_USEPROXY_CUSTOM		"custom"
#define PROP_USEPROXY_CUSTOM_LEN	6
#define PROP_USEPROXY_NONE			"none"
#define PROP_USEPROXY_NONE_LEN		4

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor cIMPL_Dialog
//*****************************************************************************************************************

//*****************************************************************************************************************
cIMPL_Dialog::cIMPL_Dialog( Locale aLocale, Window* pParent )
    :   ModalDialog					( pParent, impl_getResId( RID_DLG_LOGIN					, aLocale ))
    ,   m_imageHeader				( this   , impl_getResId( RID_FI_HEADER					, aLocale ))
    ,   m_textLoginText				( this   , impl_getResId( RID_FT_LOGINTEXT				, aLocale ))
    ,   m_textUserName				( this   , impl_getResId( RID_FT_USERNAME				, aLocale ))
    ,   m_editUserName				( this   , impl_getResId( RID_ED_USERNAME				, aLocale ))
    ,   m_textPassword				( this   , impl_getResId( RID_FT_PASSWORD				, aLocale ))
    ,   m_editPassword				( this   , impl_getResId( RID_ED_PASSWORD				, aLocale ))
	,	m_fixedLineServer			( this	 , impl_getResId( RID_FL_SERVER					, aLocale ))
    ,   m_textServer				( this   , impl_getResId( RID_FT_SERVER					, aLocale ))
    ,   m_comboServer				( this   , impl_getResId( RID_CB_SERVER					, aLocale ))
	,	m_fixedLineProxySettings	( this	 , impl_getResId( RID_FL_PROXYSETTINGS			, aLocale ))
	,	m_radioNoProxy				( this	 , impl_getResId( RID_RB_NOPROXY				, aLocale ))
	,	m_radioBrowserProxy			( this	 , impl_getResId( RID_RB_USEBROWSERPROXY		, aLocale ))
	,	m_radioCustomProxy			( this	 , impl_getResId( RID_RB_USECUSTOMPROXY			, aLocale ))
	,	m_textSecurityProxy			( this	 , impl_getResId( RID_FT_SECURITYPROXY			, aLocale ))
	,	m_textSecurityProxyHost		( this	 , impl_getResId( RID_FT_SECURITYPROXYHOST		, aLocale ))
	,	m_editSecurityProxyHost		( this	 , impl_getResId( RID_ED_SECURITYPROXYHOST		, aLocale ))
	,	m_textSecurityProxyPort		( this	 , impl_getResId( RID_FT_SECURITYPROXYPORT		, aLocale ))
 	,	m_editSecurityProxyPort		( this	 , impl_getResId( RID_ED_SECURITYPROXYPORT		, aLocale ))
	,	m_fixedLineButtons			( this	 , impl_getResId( RID_FL_BUTTONS				, aLocale ))
	,   m_buttonOK					( this   , impl_getResId( RID_PB_OK						, aLocale ))
    ,   m_buttonCancel				( this   , impl_getResId( RID_PB_CANCEL					, aLocale ))
	,	m_buttonAdditionalSettings	( this   , impl_getResId( RID_PB_ADDITIONALSETTINGS		, aLocale ))
{
	// Initialize ressources.
	FreeResource();
	m_textLoginText.SetStyle( m_textLoginText.GetStyle() ^ WB_WORDBREAK );

	m_buttonAdditionalSettings.SetClickHdl( LINK( this, cIMPL_Dialog, ClickHdl ) );
	m_radioNoProxy.SetClickHdl( LINK( this, cIMPL_Dialog, ClickHdl ) );
	m_radioBrowserProxy.SetClickHdl( LINK( this, cIMPL_Dialog, ClickHdl ) );
	m_radioCustomProxy.SetClickHdl( LINK( this, cIMPL_Dialog, ClickHdl ) );

	m_editSecurityProxyHost.Enable( FALSE );
	m_editSecurityProxyPort.Enable( FALSE );
    m_textSecurityProxy.Enable    ( FALSE );
    m_textSecurityProxyHost.Enable( FALSE );
    m_textSecurityProxyPort.Enable( FALSE );

	// init fields for collapsed/expanded Dialog support
	m_expandedDialogSize = GetSizePixel();
	m_collapsedDialogSize = GetSizePixel();

	Point	aLinePos	= m_fixedLineServer.GetPosPixel();
	Size	aButtonSize	= m_buttonOK.GetSizePixel();

	// calc collapsed dialog size
	m_collapsedDialogSize.Height() = aLinePos.Y() + m_fixedLineServer.GetSizePixel().Height() + aButtonSize.Height() + 10;

	// get expanded button positions
	m_expOKButtonPos = m_buttonOK.GetPosPixel();
	m_expCancelButtonPos = m_buttonCancel.GetPosPixel();
	m_expAdditionalButtonPos = m_buttonAdditionalSettings.GetPosPixel();

	// calc new collapsed button positions
	m_colOKButtonPos = m_buttonOK.GetPosPixel();
	m_colCancelButtonPos = m_buttonCancel.GetPosPixel();
	m_colAdditionalButtonPos = m_buttonAdditionalSettings.GetPosPixel();

	m_colOKButtonPos.Y() = m_collapsedDialogSize.Height() - aButtonSize.Height() - 5;
	m_colCancelButtonPos.Y() = m_colOKButtonPos.Y();
	m_colAdditionalButtonPos.Y() = m_colOKButtonPos.Y();

	m_colButtonAddText = OUString( RTL_CONSTASCII_USTRINGPARAM( ">> " ));
	m_colButtonAddText += m_buttonAdditionalSettings.GetText();

	m_expButtonAddText = OUString( RTL_CONSTASCII_USTRINGPARAM( "<< " ));
	m_expButtonAddText += m_buttonAdditionalSettings.GetText();

	m_buttonAdditionalSettings.SetText( m_expButtonAddText );
}


//*****************************************************************************************************************
//	destructor cIMPL_Dialog
//*****************************************************************************************************************
cIMPL_Dialog::~cIMPL_Dialog()
{
	// Deinitialize something.
	Close();
	Flush();
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
void cIMPL_Dialog::setValues( const tIMPL_DialogData& aDataSet )
{
	m_aDataSet = aDataSet;

	// Set user name and his password
	m_editUserName.SetText( m_aDataSet.sUserName );
	m_editPassword.SetText( m_aDataSet.sPassword );

	// initialize proxy fields
	OUString aProxyHost;
	OUString aProxyPort;
	getProxyHostPort( m_aDataSet.sSecurityProxy, aProxyHost, aProxyPort );
	m_editSecurityProxyHost.SetText( aProxyHost );
	m_editSecurityProxyPort.SetText( aProxyPort );

	// initialize server list
	m_aDataSet.seqServerList = aDataSet.seqServerList;
	sal_Int32 nCount = m_aDataSet.seqServerList.getLength();
	for( sal_Int32 nServer=0; nServer<nCount; ++nServer )
	{
		m_comboServer.InsertEntry( m_aDataSet.seqServerList[nServer] );
	}

	m_comboServer.SetText( m_comboServer.GetEntry( m_aDataSet.nActiveServer-1 ) ); // First index of nActiveServer is 1 ... but list start at 0!

	if ( m_aDataSet.sDialog.equalsIgnoreAsciiCaseAsciiL( PROP_DIALOG_SMALL, PROP_DIALOG_SMALL_LENGTH ))
		showDialogCollapsed();
	else
		m_aDataSet.sDialog = OUString( RTL_CONSTASCII_USTRINGPARAM( "big" ));

	// set radio buttons
	if ( m_aDataSet.sUseProxy.equalsIgnoreAsciiCaseAsciiL( PROP_USEPROXY_NONE, PROP_USEPROXY_NONE_LEN ))
		m_radioNoProxy.Check();
	else if ( m_aDataSet.sUseProxy.equalsIgnoreAsciiCaseAsciiL( PROP_USEPROXY_CUSTOM, PROP_USEPROXY_CUSTOM_LEN ))
	{
		m_radioCustomProxy.Check();
		setCustomSettings();
	}
	else
	{
		m_radioBrowserProxy.Check();
		m_aDataSet.sUseProxy = OUString( RTL_CONSTASCII_USTRINGPARAM( PROP_USEPROXY_BROWSER ));
	}

	// set initial focus to right field
	m_editUserName.GrabFocus();
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
tIMPL_DialogData cIMPL_Dialog::getValues()
{
	// Copy user properties to data set.
	m_aDataSet.sUserName = m_editUserName.GetText();
	m_aDataSet.sPassword = m_editPassword.GetText();

	OUStringBuffer aBuffer( m_editSecurityProxyHost.GetText() );
	aBuffer.appendAscii( ":" );
	aBuffer.append( m_editSecurityProxyPort.GetText() );

	OUString sTemp = aBuffer.makeStringAndClear();
	if ( sTemp.getLength() > 1 )
		m_aDataSet.sSecurityProxy = sTemp;
	else
		m_aDataSet.sSecurityProxy = OUString();

	// Get current selected item from "Server" - combobox
	OUString	sSelectedServer	= m_comboServer.GetText();
	sal_uInt16	nSelectedNumber	= m_comboServer.GetEntryPos( (XubString)sSelectedServer );
	if( nSelectedNumber == COMBOBOX_ENTRY_NOTFOUND )
	{
		// User has created a new entry!
		// We must add it to our history.
		sal_Int32 nBeforeCount = m_aDataSet.seqServerList.getLength();
		m_aDataSet.seqServerList.realloc( nBeforeCount+1 );
		m_aDataSet.seqServerList[nBeforeCount] = sSelectedServer;
	}
	// Now we can search for our active element in list.
	m_aDataSet.nActiveServer = 1; // Set fallback if search failed.
	sal_Int32 nCount = m_aDataSet.seqServerList.getLength();
	for( sal_Int32 nSearchEntry=0; nSearchEntry<nCount; ++nSearchEntry )
	{
		if( m_aDataSet.seqServerList[nSearchEntry] == sSelectedServer )
		{
			m_aDataSet.nActiveServer = nSearchEntry+1; // First index is 0!
			break;
		}
	}
	// Return values.

	return m_aDataSet;
}


//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
IMPL_LINK( cIMPL_Dialog, ClickHdl, void*, pBtn )
{
	if ( (PushButton *)pBtn == &m_buttonAdditionalSettings )
	{
		if ( m_aDataSet.sDialog.equalsIgnoreAsciiCaseAscii( "small" ))
			showDialogExpanded();
		else
			showDialogCollapsed();
	}
	else if ( (RadioButton *)pBtn == &m_radioNoProxy )
	{
		m_editSecurityProxyHost.Enable( FALSE );
		m_editSecurityProxyPort.Enable( FALSE );
        m_textSecurityProxy.Enable    ( FALSE );
        m_textSecurityProxyHost.Enable( FALSE );
        m_textSecurityProxyPort.Enable( FALSE );
		m_aDataSet.sUseProxy = OUString( RTL_CONSTASCII_USTRINGPARAM( PROP_USEPROXY_NONE ));
	}
	else if ( (RadioButton *)pBtn == &m_radioBrowserProxy )
	{
		m_editSecurityProxyHost.Enable( FALSE );
		m_editSecurityProxyPort.Enable( FALSE );
        m_textSecurityProxy.Enable    ( FALSE );
        m_textSecurityProxyHost.Enable( FALSE );
        m_textSecurityProxyPort.Enable( FALSE );
		m_aDataSet.sUseProxy = OUString( RTL_CONSTASCII_USTRINGPARAM( PROP_USEPROXY_BROWSER ));
	}
	else if ( (RadioButton *)pBtn == &m_radioCustomProxy )
	{
		m_editSecurityProxyHost.Enable( TRUE );
		m_editSecurityProxyPort.Enable( TRUE );
        m_textSecurityProxy.Enable    ( TRUE );
        m_textSecurityProxyHost.Enable( TRUE );
        m_textSecurityProxyPort.Enable( TRUE );
		m_aDataSet.sUseProxy = OUString( RTL_CONSTASCII_USTRINGPARAM( PROP_USEPROXY_CUSTOM ));
	}

	return 0;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************

void cIMPL_Dialog::getProxyHostPort( const OUString& aProxyHostPort, OUString& aHost, OUString& aPort )
{
	aHost = aProxyHostPort;

	if ( aProxyHostPort.indexOf( (sal_Unicode)':' ) > 0 ) // is there a port
	{
		long nTokenIndex = 0;
		OUString tmp = aProxyHostPort.getToken( 0, (sal_Unicode)':', nTokenIndex );
		aPort = aProxyHostPort.getToken( 0, (sal_Unicode)':', nTokenIndex );
		aHost = tmp;
	}
}


//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************

ResId cIMPL_Dialog::impl_getResId(	sal_uInt16		nId			,
									::com::sun::star::lang::Locale aLocale )
{
	// If our ressource member not initialized we must create a new one.
	static ResMgr* pRessourceManager = ResMgr::SearchCreateResMgr( "lgd" MAKE_NUMSTR(SUPD), aLocale );
	// Ask our ressource member to get right ressource for given ID.
	return ResId( nId, pRessourceManager );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************

void cIMPL_Dialog::setCustomSettings()
{
	m_editSecurityProxyHost.Enable( TRUE );
	m_editSecurityProxyPort.Enable( TRUE );
    m_textSecurityProxy.Enable    ( TRUE );
    m_textSecurityProxyHost.Enable( TRUE );
    m_textSecurityProxyPort.Enable( TRUE );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************

void cIMPL_Dialog::showDialogExpanded()
{
	m_textServer.Show();
	m_comboServer.Show();
	m_fixedLineProxySettings.Show();
	m_radioNoProxy.Show();
	m_radioBrowserProxy.Show();
	m_radioCustomProxy.Show();
	m_textSecurityProxy.Show();
	m_textSecurityProxyHost.Show();
	m_editSecurityProxyHost.Show();
	m_textSecurityProxyPort.Show();
	m_editSecurityProxyPort.Show();
	m_fixedLineButtons.Show();

	m_buttonOK.SetPosPixel( m_expOKButtonPos );
	m_buttonCancel.SetPosPixel( m_expCancelButtonPos );
	m_buttonAdditionalSettings.SetPosPixel( m_expAdditionalButtonPos );

	m_buttonAdditionalSettings.SetText( m_expButtonAddText );

	SetSizePixel( m_expandedDialogSize );

	m_aDataSet.sDialog = OUString( RTL_CONSTASCII_USTRINGPARAM( "big" ));
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************

void cIMPL_Dialog::showDialogCollapsed()
{
	SetSizePixel( m_collapsedDialogSize );

	m_textServer.Hide();
	m_comboServer.Hide();
	m_fixedLineProxySettings.Hide();
	m_radioNoProxy.Hide();
	m_radioBrowserProxy.Hide();
	m_radioCustomProxy.Hide();
	m_textSecurityProxy.Hide();
	m_textSecurityProxyHost.Hide();
	m_editSecurityProxyHost.Hide();
	m_textSecurityProxyPort.Hide();
	m_editSecurityProxyPort.Hide();
	m_fixedLineButtons.Hide();

	m_buttonOK.SetPosPixel( m_colOKButtonPos );
	m_buttonCancel.SetPosPixel( m_colCancelButtonPos );
	m_buttonAdditionalSettings.SetPosPixel( m_colAdditionalButtonPos );

	m_buttonAdditionalSettings.SetText( m_colButtonAddText );

	m_aDataSet.sDialog = OUString( RTL_CONSTASCII_USTRINGPARAM( "small" ));
}

//*****************************************************************************************************************
//	constructor LoginDialog
//*****************************************************************************************************************
LoginDialog::LoginDialog( const Reference< XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
        :   ThreadHelpBase      ( &Application::GetSolarMutex()                 )
        ,   OBroadcastHelper    ( m_aLock.getShareableOslMutex()                )
		,	OPropertySetHelper	( *SAL_STATIC_CAST( OBroadcastHelper *, this )	)
        ,   OWeakObject         (                                               )
		// Init member
        ,   m_xFactory          ( xFactory                                      )
        ,   m_bInExecuteMode    ( sal_False                                     )
        ,   m_pINIManager       ( NULL                                          )
{
	// Initialize this object.
	impl_openProfile();
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
LoginDialog::~LoginDialog()
{
	// Forget servicemanager and let him die.
	if( m_xFactory.is() == sal_True )
	{
		Reference< XMultiServiceFactory >();
	}
	// Deinitialize important ressources.
	impl_closeProfile();
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************

DEFINE_XINTERFACE_7                 (   LoginDialog                         ,
										OWeakObject							,
										DIRECT_INTERFACE(XTypeProvider		),
										DIRECT_INTERFACE(XServiceInfo		),
										DIRECT_INTERFACE(XDialog			),
										DIRECT_INTERFACE(XPropertySet		),
										DIRECT_INTERFACE(XFastPropertySet	),
                                        DIRECT_INTERFACE(XMultiPropertySet  ),
                                        DIRECT_INTERFACE(XFlushable         )
									)

DEFINE_XTYPEPROVIDER_7              (   LoginDialog         ,
										XTypeProvider		,
										XServiceInfo		,
										XDialog				,
										XPropertySet		,
										XFastPropertySet	,
                                        XMultiPropertySet   ,
                                        XFlushable
									)

DEFINE_XSERVICEINFO_MULTISERVICE    (   LoginDialog                     ,
                                        OWeakObject                     ,
										SERVICENAME_LOGINDIALOG			,
										IMPLEMENTATIONNAME_LOGINDIALOG
									)

DEFINE_INIT_SERVICE                 (   LoginDialog,
                                        {
                                        }
                                    )

//*****************************************************************************************************************
//	XFlushable
//*****************************************************************************************************************
void SAL_CALL LoginDialog::flush() throw( RuntimeException )
{
	// Ready for multithreading
    ResetableGuard aGuard( m_aLock );
	impl_writeProfile();
}

//*****************************************************************************************************************
//	XFlushable
//*****************************************************************************************************************
void SAL_CALL LoginDialog::addFlushListener( const Reference< XFlushListener >& xListener ) throw( RuntimeException )
{
	LOG_WARNING("LoginDialog::addFlushListener()", "Not implemented yet!")
}

//*****************************************************************************************************************
//	XFlushable
//*****************************************************************************************************************
void SAL_CALL LoginDialog::removeFlushListener( const Reference< XFlushListener >& xListener ) throw( RuntimeException )
{
	LOG_WARNING("LoginDialog::removeFlushListener()", "Not implemented yet!")
}

//*****************************************************************************************************************
//	XDialog
//*****************************************************************************************************************
void SAL_CALL LoginDialog::setTitle( const OUString& sTitle ) throw( RuntimeException )
{
	LOG_ASSERT( sal_False, "LoginDialog::setTitle()Not implemented yet!\n" );
}

//*****************************************************************************************************************
//	XDialog
//*****************************************************************************************************************
OUString SAL_CALL LoginDialog::getTitle() throw( RuntimeException )
{
	LOG_ASSERT( sal_False, "LoginDialog::getTitle()Not implemented yet!\n" );
	return OUString();
}

//*****************************************************************************************************************
//	XDialog
//*****************************************************************************************************************
sal_Int16 SAL_CALL LoginDialog::execute() throw( RuntimeException )
{
	// Ready for multithreading
    ResetableGuard aGuard( m_aLock );
	// Use SolarMutex for threadsafe code too!
	OGuard aSolarGuard( Application::GetSolarMutex() );

    // Look for set parent to use it as parent for our vcl-dialog!
    WorkWindow* pParentWindow = NULL;
    if( m_aPropertySet.aParentWindow.hasValue() == sal_True )
    {
		sal_Int32		 nHandle    ;
		SystemParentData aParentInfo;

		m_aPropertySet.aParentWindow >>= nHandle;

		#if defined( WIN ) || defined( WNT )
		aParentInfo.hWnd    = nHandle;
		aParentInfo.nSize   = sizeof( aParentInfo.nSize ) + sizeof( aParentInfo.hWnd    );
		#elif defined( OS2 )
		aParentInfo.hWnd    = nHandle;
		aParentInfo.nSize   = sizeof( aParentInfo.nSize ) + sizeof( aParentInfo.hWnd    );
		#elif defined( UNX )
		aParentInfo.aWindow = nHandle;
		aParentInfo.nSize   = sizeof( aParentInfo.nSize ) + sizeof( aParentInfo.aWindow );
		#endif

        Sequence< sal_Int8 > lInfoStream      ( (sal_Int8*)(&aParentInfo), aParentInfo.nSize );
        Any                  aPackedParentInfo                                                ;
        aPackedParentInfo <<= lInfoStream;
        pParentWindow = new WorkWindow( NULL, aPackedParentInfo );
    }

	// Create vcl-dialog on demand and initialize it with right ressource language!
    m_pDialog = new cIMPL_Dialog( m_aPropertySet.aLanguage, (Window*)pParentWindow );

	// Set values on dialog and show him.
	// If user say "OK" set changed values on internal member, otherwise do nothing!
	m_pDialog->setValues( m_aPropertySet );

	sal_Int16 nReturn = m_pDialog->Execute();
	if( nReturn == 1 )
	{
		m_aPropertySet = m_pDialog->getValues();
		impl_writeProfile();
	}

	// Don't forget to release vcl-dialog!
	delete m_pDialog;
	m_pDialog = NULL;

	if( pParentWindow != NULL )
	{
		delete pParentWindow;
		pParentWindow = NULL;
	}

	// Return result of operation to caller.
	return nReturn;
}

//*****************************************************************************************************************
//	XDialog
//*****************************************************************************************************************
void SAL_CALL LoginDialog::endExecute() throw( RuntimeException )
{
	LOG_ASSERT( sal_False, "LoginDialog::endExecute()Not implemented yet!\n" )
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
sal_Bool SAL_CALL LoginDialog::convertFastPropertyValue(		Any&		aConvertedValue	,
				  												Any&		aOldValue		,
																sal_Int32	nHandle			,
														const	Any&		aValue			) throw( IllegalArgumentException )
{
	// Ready for multithreading
    ResetableGuard aGuard( m_aLock );

	//	Check, if value of property will changed in method "setFastPropertyValue_NoBroadcast()".
	//	Return TRUE, if changed - else return FALSE.
	//	Attention:
	//		Method "impl_tryToChangeProperty()" can throw the IllegalArgumentException !!!

	//	Initialize state with FALSE !!!
	//	(Handle can be invalid)
	sal_Bool bReturn = sal_False;

	switch ( nHandle )
	{
		case PROPERTYHANDLE_CONNECTIONTYPE			:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sConnectionType, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_LANGUAGE				:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.aLanguage, aValue, aOldValue, aConvertedValue );
														}
														break;
        case PROPERTYHANDLE_PARENTWINDOW            :   {
                                                            bReturn = impl_tryToChangeProperty( m_aPropertySet.aParentWindow, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_PASSWORD				:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sPassword, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_SERVER					:   {
															if( m_aPropertySet.seqServerList.getLength() < 1 )
															{
																// If current server history empty, we must call our impl method with an empty value.
																// We have no valid list and a valid index in it ...
																bReturn = impl_tryToChangeProperty( OUString(), aValue, aOldValue, aConvertedValue );
															}
															else
															{
																// In this case we can use our current server list and our index.
																LOG_ASSERT( !(m_aPropertySet.nActiveServer<1 || m_aPropertySet.nActiveServer>m_aPropertySet.seqServerList.getLength()), "LoginDialog::convertFastPropertyValue()\nActiveServer out of range!\n" )
																bReturn = impl_tryToChangeProperty( m_aPropertySet.seqServerList[m_aPropertySet.nActiveServer-1], aValue, aOldValue, aConvertedValue );
															}
														}
														break;
		case PROPERTYHANDLE_SERVERHISTORY			:   {
															LOG_ASSERT( sal_False, "LoginDialog::convertFastPropertyValue()\nCan't change readonly property!\n" )
														}
														break;
		case PROPERTYHANDLE_USERNAME				:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sUserName, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_SECURITYPROXY			:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sSecurityProxy, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_USEPROXY				:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sUseProxy, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_DIALOG					:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.sDialog, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_HTTP					:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.nPortHttp, aValue, aOldValue, aConvertedValue );
														}
														break;
		case PROPERTYHANDLE_HTTPS					:	{
															bReturn = impl_tryToChangeProperty( m_aPropertySet.nPortHttps, aValue, aOldValue, aConvertedValue );
														}
														break;
	}

	// Return state of operation.
	return bReturn ;
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
void SAL_CALL LoginDialog::setFastPropertyValue_NoBroadcast(			sal_Int32	nHandle	,
			   													const	Any&		aValue	) throw( Exception )
{
	// Ready for multithreading
    ResetableGuard aGuard( m_aLock );

	// Search for right handle ... and try to set property value.
	switch ( nHandle )
	{
		case PROPERTYHANDLE_CONNECTIONTYPE			:	{
															aValue >>= m_aPropertySet.sConnectionType;
														}
														break;
		case PROPERTYHANDLE_LANGUAGE				:	{
															aValue >>= m_aPropertySet.aLanguage;
														}
														break;
        case PROPERTYHANDLE_PARENTWINDOW            :   {
                                                            m_aPropertySet.aParentWindow = aValue;
														}
														break;
		case PROPERTYHANDLE_PASSWORD				:	{
															aValue >>= m_aPropertySet.sPassword;
														}
														break;
		case PROPERTYHANDLE_SERVER					:   {
															OUString sValue;
															aValue >>= sValue;
															impl_addServerToHistory( m_aPropertySet.seqServerList, m_aPropertySet.nActiveServer, sValue );
														}
														break;
		case PROPERTYHANDLE_SERVERHISTORY			:   {
															LOG_ASSERT( sal_False, "LoginDialog::setFastPropertyValue_NoBroadcast()\nCan't change readonly property!\n" )
														}
														break;
		case PROPERTYHANDLE_USERNAME				:	{
															aValue >>= m_aPropertySet.sUserName;
														}
														break;
		case PROPERTYHANDLE_SECURITYPROXY			:	{
															aValue >>= m_aPropertySet.sSecurityProxy;
														}
														break;
		case PROPERTYHANDLE_USEPROXY				:	{
															aValue >>= m_aPropertySet.sUseProxy;
														}
														break;
		case PROPERTYHANDLE_DIALOG					:	{
															aValue >>= m_aPropertySet.sDialog;
														}
														break;
		case PROPERTYHANDLE_HTTP					:	{
															aValue >>= m_aPropertySet.nPortHttp;
														}
														break;
		case PROPERTYHANDLE_HTTPS					:	{
															aValue >>= m_aPropertySet.nPortHttps;
														}
														break;
	}
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
void SAL_CALL LoginDialog::getFastPropertyValue(	Any&		aValue	,
			  										sal_Int32	nHandle ) const
{
	// Ready for multithreading
    ResetableGuard aGuard( m_aLock );

	// Search for right handle ... and try to set property value.
	switch ( nHandle )
	{
		case PROPERTYHANDLE_CONNECTIONTYPE			:	{
															aValue <<= m_aPropertySet.sConnectionType;
														}
														break;
		case PROPERTYHANDLE_LANGUAGE				:	{
															aValue <<= m_aPropertySet.aLanguage;
														}
														break;
        case PROPERTYHANDLE_PARENTWINDOW            :   {
                                                            aValue = m_aPropertySet.aParentWindow;
														}
														break;
		case PROPERTYHANDLE_PASSWORD				:	{
															aValue <<= m_aPropertySet.sPassword;
														}
														break;
		case PROPERTYHANDLE_SERVER					:   {
															LOG_ASSERT( !(m_aPropertySet.nActiveServer<1 || m_aPropertySet.nActiveServer>m_aPropertySet.seqServerList.getLength()), "LoginDialog::getFastPropertyValue()\nActiveServer out of range!\n" )
															aValue <<= m_aPropertySet.seqServerList[m_aPropertySet.nActiveServer-1];
														}
														break;
		case PROPERTYHANDLE_SERVERHISTORY			:   {
															aValue <<= m_aPropertySet.seqServerList;
														}
														break;
		case PROPERTYHANDLE_USERNAME				:	{
															aValue <<= m_aPropertySet.sUserName;
														}
														break;
		case PROPERTYHANDLE_SECURITYPROXY			:	{
															aValue <<= m_aPropertySet.sSecurityProxy;
														}
														break;
		case PROPERTYHANDLE_USEPROXY				:	{
															aValue <<= m_aPropertySet.sUseProxy;
														}
														break;
		case PROPERTYHANDLE_DIALOG					:	{
															aValue <<= m_aPropertySet.sDialog;
														}
														break;
		case PROPERTYHANDLE_HTTP					:	{
															aValue <<= m_aPropertySet.nPortHttp;
														}
														break;
		case PROPERTYHANDLE_HTTPS					:	{
															aValue <<= m_aPropertySet.nPortHttps;
														}
														break;
	}
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
IPropertyArrayHelper& SAL_CALL LoginDialog::getInfoHelper()
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfoHelper is NULL - for the second call pInfoHelper is different from NULL!
	static OPropertyArrayHelper* pInfoHelper = NULL;

	if ( pInfoHelper == NULL )
	{
		// Ready for multithreading
        ::osl::MutexGuard aGuard( LockHelper::getGlobalLock().getShareableOslMutex() );
		// Control this pointer again, another instance can be faster then these!
		if ( pInfoHelper == NULL )
		{
			// Define static member to give structure of properties to baseclass "OPropertySetHelper".
			// "impl_getStaticPropertyDescriptor" is a non exported and static funtion, who will define a static propertytable.
			// "sal_True" say: Table is sorted by name.
			static OPropertyArrayHelper aInfoHelper( impl_getStaticPropertyDescriptor(), sal_True );
			pInfoHelper = &aInfoHelper;
		}
	}

	return (*pInfoHelper);
}

//*****************************************************************************************************************
//	OPropertySetHelper
//*****************************************************************************************************************
Reference< XPropertySetInfo > SAL_CALL LoginDialog::getPropertySetInfo() throw (::com::sun::star::uno::RuntimeException)
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfo is NULL - for the second call pInfo is different from NULL!
	static Reference< XPropertySetInfo >* pInfo = NULL ;

	if ( pInfo == NULL )
	{
		// Ready for multithreading
        ::osl::MutexGuard aGuard( LockHelper::getGlobalLock().getShareableOslMutex() );
		// Control this pointer again, another instance can be faster then these!
		if ( pInfo == NULL )
		{
			// Create structure of propertysetinfo for baseclass "OPropertySetHelper".
			// (Use method "getInfoHelper()".)
			static Reference< XPropertySetInfo > xInfo( createPropertySetInfo( getInfoHelper() ) );
			pInfo = &xInfo;
		}
	}

	return (*pInfo);
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
const Sequence< Property > LoginDialog::impl_getStaticPropertyDescriptor()
{
	// Create a new static property array to initialize sequence!
	// Table of all predefined properties of this class. Its used from OPropertySetHelper-class!
	// Don't forget to change the defines (see begin of this file), if you add, change or delete a property in this list!!!
	// It's necessary for methods of OPropertySetHelper.
	// ATTENTION:
	//		YOU MUST SORT FOLLOW TABLE BY NAME !!!

	static const Property pPropertys[] =
	{
		Property( PROPERTYNAME_CONNECTIONTYPE	, PROPERTYHANDLE_CONNECTIONTYPE		, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_DIALOG			, PROPERTYHANDLE_DIALOG				, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_LANGUAGE			, PROPERTYHANDLE_LANGUAGE			, ::getCppuType((const Locale*)NULL)				, PropertyAttribute::TRANSIENT									),
        Property( PROPERTYNAME_PARENTWINDOW     , PROPERTYHANDLE_PARENTWINDOW       , ::getCppuType((const Any*)NULL)                   , PropertyAttribute::TRANSIENT                                  ),
		Property( PROPERTYNAME_PASSWORD			, PROPERTYHANDLE_PASSWORD			, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_SECURITYPROXY	, PROPERTYHANDLE_SECURITYPROXY		, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_SERVER			, PROPERTYHANDLE_SERVER				, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_SERVERHISTORY	, PROPERTYHANDLE_SERVERHISTORY		, ::getCppuType((const Sequence< OUString >*)NULL)	, PropertyAttribute::TRANSIENT | PropertyAttribute::READONLY	),
		Property( PROPERTYNAME_USEPROXY			, PROPERTYHANDLE_USEPROXY			, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_USERNAME			, PROPERTYHANDLE_USERNAME			, ::getCppuType((const OUString*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_HTTP				, PROPERTYHANDLE_HTTP				, ::getCppuType((const sal_Int32*)NULL)				, PropertyAttribute::TRANSIENT									),
		Property( PROPERTYNAME_HTTPS			, PROPERTYHANDLE_HTTPS				, ::getCppuType((const sal_Int32*)NULL)				, PropertyAttribute::TRANSIENT									)
	};
	// Use it to initialize sequence!
	static const Sequence< Property > seqPropertyDescriptor( pPropertys, PROPERTYCOUNT );
	// Return static "PropertyDescriptor"
	return seqPropertyDescriptor ;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool LoginDialog::impl_tryToChangeProperty(	const	OUString&	sProperty		,
												const	Any&		aValue			,
														Any&		aOldValue		,
														Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	OUString sNewValue;
	convertPropertyValue( sNewValue, aValue );

	// If value change ...
	if ( sNewValue != sProperty )
	{
		// ... set information of change.
		aOldValue.setValue		( &sProperty, ::getCppuType((const OUString*)NULL) );
		aConvertedValue.setValue( &sNewValue, ::getCppuType((const OUString*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool LoginDialog::impl_tryToChangeProperty(	const	Sequence< OUString >&	seqProperty		,
												const	Any&					aValue			,
														Any&					aOldValue		,
														Any&					aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	Sequence< OUString > seqNewValue;
	convertPropertyValue( seqNewValue, aValue );

	// If value change ...
	if ( seqNewValue != seqProperty )
	{
		// ... set information of change.
		aOldValue.setValue		( &seqProperty, ::getCppuType((const Sequence< OUString >*)NULL) );
		aConvertedValue.setValue( &seqNewValue, ::getCppuType((const Sequence< OUString >*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool LoginDialog::impl_tryToChangeProperty(	const	sal_Int32&	nProperty		,
												const	Any&		aValue			,
														Any&		aOldValue		,
														Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_Int32 nNewValue;
	convertPropertyValue( nNewValue, aValue );

	// If value change ...
	if ( nNewValue != nProperty )
	{
		// ... set information of change.
		aOldValue.setValue		( &nProperty, ::getCppuType((const sal_Int32*)NULL) );
		aConvertedValue.setValue( &nNewValue, ::getCppuType((const sal_Int32*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool LoginDialog::impl_tryToChangeProperty(	const	Locale&		aProperty		,
												const	Any&		aValue			,
														Any&		aOldValue		,
														Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	Locale aNewValue;
	convertPropertyValue( aNewValue, aValue );

	// If value change ...
	if	(
			( aNewValue.Language	!= aProperty.Language	)	||
			( aNewValue.Country		!= aProperty.Country	)	||
			( aNewValue.Variant		!= aProperty.Variant	)
		)
	{
		// ... set information of change.
		aOldValue.setValue		( &aProperty, ::getCppuType((const Locale*)NULL) );
		aConvertedValue.setValue( &aNewValue, ::getCppuType((const Locale*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Bool LoginDialog::impl_tryToChangeProperty( const   Any&  aProperty       ,
                                                const   Any&  aValue          ,
                                                        Any&  aOldValue       ,
                                                        Any&  aConvertedValue ) throw( IllegalArgumentException )
{
	// Set default return value.
	sal_Bool bReturn = sal_False;

	// Clear information of return parameter!
	aOldValue.clear();
	aConvertedValue.clear();

	// If value change ...
    if( aProperty != aValue )
	{
		// ... set information of change.
        aOldValue.setValue      ( &aProperty, ::getCppuType((const Any*)NULL) );
        aConvertedValue.setValue( &aValue   , ::getCppuType((const Any*)NULL) );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}

	return bReturn;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_openProfile()
{
	// First search for our configuration file.
 	OUString		sApplicationUNC	;
	OStartupInfo	aInfo			;

	if( aInfo.getExecutableFile( sApplicationUNC ) == osl_Process_E_None )
	{
		sal_Int32 nPosition = sApplicationUNC.lastIndexOf( UNCPATHSEPERATOR );
		if( nPosition > 1 )
		{
            m_sININame = sApplicationUNC.copy( 0, nPosition );
		}
		m_sININame	+= OUString(UNCPATHSEPERATOR);
		m_sININame	+= ININAME;

		// Open profile for reading and writing.
		// I think we can create it, if it not exist.
		// OProfile will do that automaticly if file not already exist!
		m_pINIManager = NULL;
		m_pINIManager = new Config( m_sININame );
		LOG_ASSERT( !(m_pINIManager==NULL), "LoginDialog::impl_openProfile()Could not open \"login.ini\".\n" )
		if( m_pINIManager != NULL )
		{
			// Set default values on properties, if follow reading from profile failed!
			m_aPropertySet.sUserName		=	OUString()	;
			m_aPropertySet.sPassword		=   OUString()	;
			m_aPropertySet.sSecurityProxy	=	OUString()	;
			m_aPropertySet.nActiveServer	=	1			;
			m_aPropertySet.seqServerList.realloc( 0 )		;

			// Fill property set with values from profile.
			m_aPropertySet.sUserName		= impl_readUserName()		;
			m_aPropertySet.seqServerList	= impl_readServerHistory()	;
			sal_Int32 nActiveServer			= impl_readActiveServer()	;
			if	(
					( nActiveServer	>	0											)	&&
					( nActiveServer	<=	m_aPropertySet.seqServerList.getLength()	)
				)
			{
				m_aPropertySet.nActiveServer = nActiveServer;
			}
			m_aPropertySet.sConnectionType			= impl_readConnectionType()			;
			m_aPropertySet.aLanguage				= impl_readLanguage()				;
			m_aPropertySet.sSecurityProxy			= impl_readSecurityProxy()			;
			m_aPropertySet.sUseProxy				= impl_readUseProxy()				;
			m_aPropertySet.sDialog					= impl_readDialog()					;
			m_aPropertySet.nPortHttp				= impl_readPortHttp()				;
			m_aPropertySet.nPortHttps				= impl_readPortHttps()				;
		}
	}
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_closeProfile()
{
	// Safe impossible cases. INI must open!
	LOG_ASSERT( !(m_pINIManager==NULL), "LoginDialog::impl_closeProfile()\nInvalid INIManager detected!\n" )

	// Close ini file.
	m_pINIManager->Flush();
	delete m_pINIManager;
	m_pINIManager = NULL;

    // Reset member.
	m_sININame								=	OUString()										;
	m_aPropertySet.sUserName				=	OUString()										;
	m_aPropertySet.sPassword				=   OUString()										;
	m_aPropertySet.nActiveServer			=	1												;
	m_aPropertySet.seqServerList			=	Sequence< OUString >()							;
	m_aPropertySet.sConnectionType			=	OUString()										;
	m_aPropertySet.aLanguage				=	Locale( OUString(), OUString(), OUString() )	;
	m_aPropertySet.sSecurityProxy			=	OUString()										;
	m_aPropertySet.sUseProxy				=	OUString()										;
	m_aPropertySet.sDialog					=	OUString()										;
	m_aPropertySet.bProxyChanged			=	sal_False										;
	m_aPropertySet.nPortHttp				=	0												;
	m_aPropertySet.nPortHttps				=	0												;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeProfile()
{
	// Safe impossible cases. INI must open!
	LOG_ASSERT( !(m_pINIManager==NULL), "LoginDialog::impl_closeProfile()\nInvalid INIManager detected!\n" )

	// Safe current values of our property set.
	// (SetGroup create empty section again!)
	impl_writeUserName				( m_aPropertySet.sUserName				);
	impl_writeActiveServer			( m_aPropertySet.nActiveServer			);
	impl_writeServerHistory			( m_aPropertySet.seqServerList			);
	impl_writeConnectionType		( m_aPropertySet.sConnectionType		);
	impl_writeLanguage	  			( m_aPropertySet.aLanguage				);
	impl_writeSecurityProxy			( m_aPropertySet.sSecurityProxy			);
	impl_writeUseProxy				( m_aPropertySet.sUseProxy				);
	impl_writeDialog				( m_aPropertySet.sDialog				);
	impl_writePortHttp				( m_aPropertySet.nPortHttp				);
	impl_writePortHttps				( m_aPropertySet.nPortHttps				);

	// Close ini file.
	m_pINIManager->Flush();
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_addServerToHistory(			SEQUENCE< OUSTRING >&	seqHistory		,
													sal_Int32&				nActiveServer	,
											const	OUSTRING&				sServer			)
{
	if( sServer.getLength() > 0 )
	{
		// If history full we must delete old entries.
		// These are the first entries of list. We append ne server at the end of list.
		sal_Int32 nCount = seqHistory.getLength();
		if( nCount >= MAX_SERVERHISTORY )
		{
			sal_Int32 nDestination	= 0								;
			sal_Int32 nSource		= nCount-(MAX_SERVERHISTORY-1)	; // -1 ... we need place for new item!
			while( nSource < MAX_SERVERHISTORY )
			{
				seqHistory[nDestination] = seqHistory[nSource];
				++nDestination	;
				++nSource		;
			}
			nCount = (MAX_SERVERHISTORY-1); // -1 ... we need place for new item!
		}
		// Check for already existing entries in list. If value not exist add it to history.
		sal_Bool	bAlreadyExist	= sal_False	;
		sal_Int32	nPosition		= 0			;
		while	(
					( nPosition		<	nCount		)	&&
					( bAlreadyExist	==	sal_False	)
				)
		{
			if( seqHistory[nPosition] == sServer )
			{
				bAlreadyExist = sal_True;
			}
			++nPosition;
		}
		if( bAlreadyExist == sal_False )
		{
			// If new server not already exist in list we must add him!
			seqHistory.realloc( nCount+1 );
			seqHistory[nCount] = sServer;
			nActiveServer = nCount+1;
		}
		else
		{
			// Else; Entrie already exist ... but we have copyied all other entries from position n+1 to n.
			// Last element is double now! We must delete it. => realloc sequence
			seqHistory.realloc( nCount );
		}
	}
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeUserName( const OUString& sUserName )
{
	m_pINIManager->SetGroup( SECTION_USERNAME );
	m_pINIManager->WriteKey( KEY_USERNAME, sUserName, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeActiveServer( sal_Int32 nActiveServer )
{
	m_pINIManager->SetGroup( SECTION_ACTIVESERVER );
	OUString sValue = OUString::valueOf((sal_Int32)nActiveServer);
	m_pINIManager->WriteKey( KEY_ACTIVESERVER, sValue, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeServerHistory( const Sequence< OUString >& lHistory )
{
	// Write complete list every time!
	// Delete old one and write new entries!
	m_pINIManager->DeleteGroup	( SECTION_SERVERHISTORY );
	m_pINIManager->SetGroup		( SECTION_SERVERHISTORY );

	sal_uInt32	nCount			= lHistory.getLength()	;
	OString		sBaseKeyName	= KEY_SERVER_X			;
	OString		sKeyName								;
	for( sal_uInt32 nEntry=0; nEntry<nCount; ++nEntry )
	{
		// History has follow structure:
		//		[ServerHistory]
		//			Server_0=...
		//			Server_1=...
		//			...
		//			Server_n=...
		sKeyName  = sBaseKeyName						;
		sKeyName += OString::valueOf((sal_Int32)nEntry)	;
		m_pINIManager->WriteKey( sKeyName, lHistory[nEntry], INIENCODING );
	}
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeConnectionType( const OUString& sConnectionType )
{
	m_pINIManager->SetGroup( SECTION_CONNECTIONTYPE );
	m_pINIManager->WriteKey( KEY_CONNECTIONTYPE, sConnectionType, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeLanguage( const Locale& aLanguage )
{
	m_pINIManager->SetGroup( SECTION_LANGUAGE );

	// Format of language in INI-file:	"Language=<language>;<country>;<variant>;"
	// Attention: Last ";" is neccessary for eaysier reading!
	OUStringBuffer sValue( 1000 );
	sValue.append( aLanguage.Language	);
	sValue.append( LANGUAGE_SEPERATOR	);
	sValue.append( aLanguage.Country	);
	sValue.append( LANGUAGE_SEPERATOR	);
	sValue.append( aLanguage.Variant	);
	sValue.append( LANGUAGE_SEPERATOR	);

	m_pINIManager->WriteKey( KEY_LANGUAGE, sValue.makeStringAndClear(), INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writePortHttp( sal_Int32 nPort )
{
	m_pINIManager->SetGroup( SECTION_HTTP );
	OUString sValue = OUString::valueOf((sal_Int32)nPort);
	m_pINIManager->WriteKey( KEY_HTTP, sValue, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writePortHttps( sal_Int32 nPort )
{
	m_pINIManager->SetGroup( SECTION_HTTPS );
	OUString sValue = OUString::valueOf((sal_Int32)nPort);
	m_pINIManager->WriteKey( KEY_HTTPS, sValue, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeSecurityProxy( const OUString& sSecurityProxy )
{
	m_pINIManager->SetGroup( SECTION_SECURITYPROXY );
	m_pINIManager->WriteKey( KEY_SECURITYPROXY, sSecurityProxy, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeUseProxy( const	OUSTRING& sUseProxy )
{
	m_pINIManager->SetGroup( SECTION_SECURITYPROXY );
	m_pINIManager->WriteKey( KEY_USESECURITYPROXY, sUseProxy, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void LoginDialog::impl_writeDialog(	const OUSTRING& sDialog )
{
	m_pINIManager->SetGroup( SECTION_DIALOG );
	m_pINIManager->WriteKey( KEY_DIALOG, sDialog, INIENCODING );
}


//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
OUString LoginDialog::impl_readUserName()
{
	m_pINIManager->SetGroup( SECTION_USERNAME );
	return m_pINIManager->ReadKey( KEY_USERNAME, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Int32 LoginDialog::impl_readActiveServer()
{
	m_pINIManager->SetGroup( SECTION_ACTIVESERVER );
	return m_pINIManager->ReadKey( KEY_ACTIVESERVER, INIENCODING ).ToInt32();
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
Sequence< OUString > LoginDialog::impl_readServerHistory()
{
	// Set default return value if method failed.
	Sequence< OUString > lHistory;

	// Get count of current entries in list, resize return list
	// and copy elements in it.
	m_pINIManager->SetGroup( SECTION_SERVERHISTORY );
	sal_uInt16 nCount = m_pINIManager->GetKeyCount();
	lHistory.realloc( nCount );
	for( sal_uInt16 nEntry=0; nEntry<nCount; ++nEntry )
	{
		OString sKeyName = m_pINIManager->GetKeyName( nEntry );
		lHistory[nEntry] = m_pINIManager->ReadKey( sKeyName, INIENCODING );
	}

	return lHistory;
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
OUString LoginDialog::impl_readConnectionType()
{
	m_pINIManager->SetGroup( SECTION_CONNECTIONTYPE );
	return m_pINIManager->ReadKey( KEY_CONNECTIONTYPE, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
Locale LoginDialog::impl_readLanguage()
{
	m_pINIManager->SetGroup( SECTION_LANGUAGE );
	OUString sValue = m_pINIManager->ReadKey( KEY_LANGUAGE, INIENCODING );

	OUString sLanguage	;
	OUString sCountry	;
	OUString sVariant	;

	// Two posibilities exist:	a) entry not exist in file
	//							b) entry exist - format must right one!
	// Otherwise follow algorithm will fail!

	if( sValue.getLength() > 0 )
	{
		sal_Int32 nLanguageEnd	= sValue.indexOf( LANGUAGE_SEPERATOR, 0					);
		sal_Int32 nCountryEnd	= sValue.indexOf( LANGUAGE_SEPERATOR, nLanguageEnd+1	);
		sal_Int32 nVariantEnd	= sValue.indexOf( LANGUAGE_SEPERATOR, nCountryEnd+1		);

		sLanguage	= sValue.copy( 0				, nLanguageEnd					);
		sCountry	= sValue.copy( nLanguageEnd+1	, nCountryEnd-nLanguageEnd-1	);
		sVariant	= sValue.copy( nCountryEnd+1	, nVariantEnd-nCountryEnd-1		);
	}

	return Locale( sLanguage, sCountry, sVariant );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Int32 LoginDialog::impl_readPortHttp()
{
	m_pINIManager->SetGroup( SECTION_HTTP );
	return m_pINIManager->ReadKey( KEY_HTTP, INIENCODING ).ToInt32();
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
sal_Int32 LoginDialog::impl_readPortHttps()
{
	m_pINIManager->SetGroup( SECTION_HTTPS );
	return m_pINIManager->ReadKey( KEY_HTTPS, INIENCODING ).ToInt32();
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
OUString LoginDialog::impl_readSecurityProxy()
{
	m_pINIManager->SetGroup( SECTION_SECURITYPROXY );
	return m_pINIManager->ReadKey( KEY_SECURITYPROXY, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
OUString LoginDialog::impl_readUseProxy()
{
	m_pINIManager->SetGroup( SECTION_SECURITYPROXY );
	return m_pINIManager->ReadKey( KEY_USESECURITYPROXY, INIENCODING );
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
OUString LoginDialog::impl_readDialog()
{
	m_pINIManager->SetGroup( SECTION_DIALOG );
	return m_pINIManager->ReadKey( KEY_DIALOG, INIENCODING );
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact Andreas Schluens [as] or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool LoginDialog::impldbg_checkParameter_LoginDialog( const Reference< XMultiServiceFactory >& xFactory )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xFactory		==	NULL		)	||
			( xFactory.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool LoginDialog::impldbg_checkParameter_setTitle( const OUString& sTitle )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sTitle				==	NULL	)	||
			( sTitle.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
