/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmpnt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:22:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MPNT_HXX
#include "b2dmpnt.hxx"
#endif

//************************************************************
//   MarkerData
//************************************************************

static BYTE _b2d_iao_marker_plus[] =
{
	2, 2,		// size of marker
	1, 1,		// position of center
	5, 0,		// 5x BaseColor, 0x 2ndColor
	
	// points BaseColor
	1, 0,	0, 1,	1, 1,	2, 1,	1, 2
};

static BYTE _b2d_iao_marker_cross[] =
{
	2, 2,		// size of marker
	1, 1,		// position of center
	5, 0,		// BaseColor, 2ndColor
	
	// points BaseColor
	0, 0,	2, 0,	1, 1,	0, 2,	2, 2
};

static BYTE _b2d_iao_marker_rect_3x3[] =
{
	2, 2,		// size of marker
	1, 1,		// position of center
	1, 8,		// BaseColor, 2ndColor
	
	// points BaseColor
	1, 1,

	// points 2ndColor
	0, 0,	1, 0,	2, 0,
	0, 1,	2, 1,
	0, 2,	1, 2,	2, 2
};

static BYTE _b2d_iao_marker_rect_5x5[] =
{
	4, 4,		// size of marker
	2, 2,		// position of center
	9, 16,		// BaseColor, 2ndColor
	
	// points BaseColor
	1, 1,	2, 1,	3, 1,
	1, 2,	2, 2,	3, 2,	
	1, 3,	2, 3,	3, 3,	

	// points 2ndColor
	0, 0,	1, 0,	2, 0,	3, 0,	4, 0,	
	0, 1,	4, 1,	0, 2,	4, 2,	0, 3,	4, 3,	
	0, 4,	1, 4,	2, 4,	3, 4,	4, 4,	
};

static BYTE _b2d_iao_marker_rect_7x7[] =
{
	6, 6,		// size of marker
	3, 3,		// position of center
	25, 24,		// BaseColor, 2ndColor
	
	// points BaseColor
	1, 1,	2, 1,	3, 1,	4, 1,	5, 1,	
	1, 2,	2, 2,	3, 2,	4, 2,	5, 2,	
	1, 3,	2, 3,	3, 3,	4, 3,	5, 3,	
	1, 4,	2, 4,	3, 4,	4, 4,	5, 4,	
	1, 5,	2, 5,	3, 5,	4, 5,	5, 5,	

	// points 2ndColor
	0, 0,	1, 0,	2, 0,	3, 0,	4, 0,	5, 0,	6, 0,	
	0, 1,	6, 1,	0, 2,	6, 2,	0, 3,	6, 3,	0, 4,	6, 4,	0, 5,	6, 5,	
	0, 6,	1, 6,	2, 6,	3, 6,	4, 6,	5, 6,	6, 6	
};

static BYTE _b2d_iao_marker_rect_9x9[] =
{
	8, 8,		// size of marker
	4, 4,		// position of center
	49, 32,		// BaseColor, 2ndColor
	
	// points BaseColor
	1, 1,	2, 1,	3, 1,	4, 1,	5, 1,	6, 1,	7, 1,	
	1, 2,	2, 2,	3, 2,	4, 2,	5, 2,	6, 2,	7, 2,	
	1, 3,	2, 3,	3, 3,	4, 3,	5, 3,	6, 3,	7, 3,	
	1, 4,	2, 4,	3, 4,	4, 4,	5, 4,	6, 4,	7, 4,	
	1, 5,	2, 5,	3, 5,	4, 5,	5, 5,	6, 5,	7, 5,	
	1, 6,	2, 6,	3, 6,	4, 6,	5, 6,	6, 6,	7, 6,	
	1, 7,	2, 7,	3, 7,	4, 7,	5, 7,	6, 7,	7, 7,	

	// points 2ndColor
	0, 0,	1, 0,	2, 0,	3, 0,	4, 0,	5, 0,	6, 0,	7, 0,	8, 0,	
	0, 1,	8, 1,	0, 2,	8, 2,	0, 3,	8, 3,	0, 4,	8, 4,	0, 5,	8, 5,	0, 6,	8, 6,	0, 7,	8, 7,	
	0, 8,	1, 8,	2, 8,	3, 8,	4, 8,	5, 8,	6, 8,	7, 8,	8, 8	
};

static BYTE	_b2d_iao_marker_circle_3x3[] =
{
	3, 3,		// size of marker
	1, 1,		// position of center
	1, 4,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,1,
	
	// points 2ndColor
	1,0,0,1,2,1,1,2
};

static BYTE	_b2d_iao_marker_circle_5x5[] =
{
	5, 5,		// size of marker
	2, 2,		// position of center
	9, 12,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,1,2,1,3,1,
	1,2,2,2,3,2,
	1,3,2,3,3,3,

	// points 2ndColor
	1,0,2,0,3,0,
	0,1,4,1,0,2,4,2,0,3,4,3,
	1,4,2,4,3,4
};

static BYTE	_b2d_iao_marker_circle_7x7[] =
{
	7, 7,		// size of marker
	3, 3,		// position of center
	21, 16,		// BaseColor, 2ndColor
	
	// points BaseColor
	2,1,3,1,4,1,
	1,2,2,2,3,2,4,2,5,2,
	1,3,2,3,3,3,4,3,5,3,
	1,4,2,4,3,4,4,4,5,4,
	2,5,3,5,4,5,
	
	// points 2ndColor
	2,0,3,0,4,0,
	1,1,5,1,
	0,2,6,2,
	0,3,6,3,
	0,4,6,4,
	1,5,5,5,
	2,6,3,6,4,6
};

static BYTE	_b2d_iao_marker_circle_9x9[] =
{
	9, 9,		// size of marker
	4, 4,		// position of center
	37, 20,		// BaseColor, 2ndColor
	
	// points BaseColor
	3,1,4,1,5,1,
	2,2,3,2,4,2,5,2,6,2,
	1,3,2,3,3,3,4,3,5,3,6,3,7,3,
	1,4,2,4,3,4,4,4,5,4,6,4,7,4,
	1,5,2,5,3,5,4,5,5,5,6,5,7,5,
	2,6,3,6,4,6,5,6,6,6,
	3,7,4,7,5,7,

	// points 2ndColor
	3,0,4,0,5,0,
	2,1,6,1,
	1,2,7,2,
	0,3,8,3,
	0,4,8,4,
	0,5,8,5,
	1,6,7,6,
	2,7,6,7,
	3,8,4,8,5,8
};

static BYTE	_b2d_iao_marker_ellipse_5x3[] =
{
	5, 3,		// size of marker
	2, 1,		// position of center
	3, 8,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,1,2,1,3,1,

	// points 2ndColor
	1,0,2,0,3,0,
	0,1,4,1,
	1,2,2,2,3,2
};

static BYTE	_b2d_iao_marker_ellipse_7x5[] =
{
	7, 5,		// size of marker
	3, 2,		// position of center
	11, 12,		// BaseColor, 2ndColor
	
	// points BaseColor
	2,1,3,1,4,1,
	1,2,2,2,3,2,4,2,5,2,
	2,3,3,3,4,3,

	// points 2ndColor
	2,0,3,0,4,0,
	1,1,5,1,
	0,2,6,2,
	1,3,5,3,
	2,4,3,4,4,4
};

static BYTE	_b2d_iao_marker_ellipse_9x7[] =
{
	9, 7,		// size of marker
	4, 3,		// position of center
	31, 20,		// BaseColor, 2ndColor
	
	// points BaseColor
	2,1,3,1,4,1,5,1,6,1,
	1,2,2,2,3,2,4,2,5,2,6,2,7,2,
	1,3,2,3,3,3,4,3,5,3,6,3,7,3,
	1,4,2,4,3,4,4,4,5,4,6,4,7,4,
	2,5,3,5,4,5,5,5,6,5,

	// points 2ndColor
	2,0,3,0,4,0,5,0,6,0,
	1,1,7,1,
	0,2,8,2,
	0,3,8,3,
	0,4,8,4,
	1,5,7,5,
	2,6,3,6,4,6,5,6,6,6
};

static BYTE	_b2d_iao_marker_ellipse_3x5[] =
{
	3, 5,		// size of marker
	1, 2,		// position of center
	3, 8,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,1,1,2,1,3,

	// points 2ndColor
	0,1,0,2,0,3,
	1,0,1,4,
	2,1,2,2,2,3
};

static BYTE	_b2d_iao_marker_ellipse_5x7[] =
{
	5, 7,		// size of marker
	2, 3,		// position of center
	11, 12,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,2,1,3,1,4,
	2,1,2,2,2,3,2,4,2,5,
	3,2,3,3,3,4,

	// points 2ndColor
	0,2,0,3,0,4,
	1,1,1,5,
	2,0,2,6,
	3,1,3,5,
	4,2,4,3,4,4
};

static BYTE	_b2d_iao_marker_ellipse_7x9[] =
{
	7, 9,		// size of marker
	3, 4,		// position of center
	31, 20,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,2,1,3,1,4,1,5,1,6,
	2,1,2,2,2,3,2,4,2,5,2,6,2,7,
	3,1,3,2,3,3,3,4,3,5,3,6,3,7,
	4,1,4,2,4,3,4,4,4,5,4,6,4,7,
	5,2,5,3,5,4,5,5,5,6,

	// points 2ndColor
	0,2,0,3,0,4,0,5,0,6,
	1,1,1,7,
	2,0,2,8,
	3,0,3,8,
	4,0,4,8,
	5,1,5,7,
	6,2,6,3,6,4,6,5,6,6
};

static BYTE _b2d_iao_marker_crosshair_3x3[] =
{
	3, 3,		// size of marker
	1, 1,		// position of center
	4, 1,		// BaseColor, 2ndColor
	
	// points BaseColor
	1,0,0,1,2,1,1,2,

	// points 2ndColor
	1,1
};

static BYTE _b2d_iao_marker_crosshair_5x5[] =
{
	5, 5,		// size of marker
	2, 2,		// position of center
	12, 1,		// BaseColor, 2ndColor
	
	// points BaseColor
	2,0,
	1,1,2,1,3,1,
	0,2,1,2,3,2,4,2,
	1,3,2,3,3,3,
	2,4,

	// points 2ndColor
	2,2
};

static BYTE _b2d_iao_marker_crosshair_7x7[] =
{
	7, 7,		// size of marker
	3, 3,		// position of center
	20, 1,		// BaseColor, 2ndColor
	
	// points BaseColor
	3,0,
	2,1,3,1,4,1,
	1,2,3,2,5,2,
	0,3,1,3,2,3,4,3,5,3,6,3,
	1,4,3,4,5,4,
	2,5,3,5,4,5,
	3,6,

	// points 2ndColor
	3,3
};

static BYTE _b2d_iao_marker_crosshair_9x9[] =
{
	9, 9,		// size of marker
	4, 4,		// position of center
	32, 1,		// BaseColor, 2ndColor
	
	// points BaseColor
	4,0,
	2,1,3,1,4,1,5,1,6,1,
	1,2,4,2,7,2,
	1,3,4,3,7,3,
	0,4,1,4,2,4,3,4,5,4,6,4,7,4,8,4,
	1,5,4,5,7,5,
	1,6,4,6,7,6,
	2,7,3,7,4,7,5,7,6,7,
	4,8,

	// points 2ndColor
	4,4
};

//************************************************************
//   InterActionObjectMarker
//************************************************************

TYPEINIT1(B2dIAOMarker, B2dIAObject);

B2dIAOMarker::B2dIAOMarker(B2dIAOManager* pMan, Point aPos, B2dIAOMarkerKind eKind)
:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN))
{
	// Init vars
	a2ndColor = Color(COL_YELLOW);
	eMarkerKind = eKind;
}

B2dIAOMarker::~B2dIAOMarker() 
{
}

void B2dIAOMarker::CreateGeometry()
{
	// Create geometry using AddPixel()
	switch(eMarkerKind)
	{
		case B2D_IAO_MARKER_POINT : AddPixel(GetBasePositionPixel(), GetBaseColor()); break;
		case B2D_IAO_MARKER_PLUS : CreateGeometryFromMarkerData(_b2d_iao_marker_plus); break;
		case B2D_IAO_MARKER_CROSS : CreateGeometryFromMarkerData(_b2d_iao_marker_cross); break;

		case B2D_IAO_MARKER_RECT_3X3 : CreateGeometryFromMarkerData(_b2d_iao_marker_rect_3x3); break;
		case B2D_IAO_MARKER_RECT_5X5 : CreateGeometryFromMarkerData(_b2d_iao_marker_rect_5x5); break;
		case B2D_IAO_MARKER_RECT_7X7 : CreateGeometryFromMarkerData(_b2d_iao_marker_rect_7x7); break;
		case B2D_IAO_MARKER_RECT_9X9 : CreateGeometryFromMarkerData(_b2d_iao_marker_rect_9x9); break;
		
		case B2D_IAO_MARKER_CIRCLE_3X3 : CreateGeometryFromMarkerData(_b2d_iao_marker_circle_3x3); break;
		case B2D_IAO_MARKER_CIRCLE_5X5 : CreateGeometryFromMarkerData(_b2d_iao_marker_circle_5x5); break;
		case B2D_IAO_MARKER_CIRCLE_7X7 : CreateGeometryFromMarkerData(_b2d_iao_marker_circle_7x7); break;
		case B2D_IAO_MARKER_CIRCLE_9X9 : CreateGeometryFromMarkerData(_b2d_iao_marker_circle_9x9); break;
		
		case B2D_IAO_MARKER_ELLIPSE_5X3 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_5x3); break;
		case B2D_IAO_MARKER_ELLIPSE_7X5 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_7x5); break;
		case B2D_IAO_MARKER_ELLIPSE_9X7 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_9x7); break;
		
		case B2D_IAO_MARKER_ELLIPSE_3X5 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_3x5); break;
		case B2D_IAO_MARKER_ELLIPSE_5X7 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_5x7); break;
		case B2D_IAO_MARKER_ELLIPSE_7X9 : CreateGeometryFromMarkerData(_b2d_iao_marker_ellipse_7x9); break;

		case B2D_IAO_MARKER_CROSSHAIR_3X3 : CreateGeometryFromMarkerData(_b2d_iao_marker_crosshair_3x3); break;
		case B2D_IAO_MARKER_CROSSHAIR_5X5 : CreateGeometryFromMarkerData(_b2d_iao_marker_crosshair_5x5); break;
		case B2D_IAO_MARKER_CROSSHAIR_7X7 : CreateGeometryFromMarkerData(_b2d_iao_marker_crosshair_7x7); break;
		case B2D_IAO_MARKER_CROSSHAIR_9X9 : CreateGeometryFromMarkerData(_b2d_iao_marker_crosshair_9x9); break;
	}
}

void B2dIAOMarker::CreateBaseRect()
{
	switch(eMarkerKind)
	{
		case B2D_IAO_MARKER_POINT : SetBaseRect(Rectangle(GetBasePositionPixel(), GetBasePositionPixel())); break;
		case B2D_IAO_MARKER_PLUS : CreateBaseRectFromMarkerData(_b2d_iao_marker_plus); break;
		case B2D_IAO_MARKER_CROSS : CreateBaseRectFromMarkerData(_b2d_iao_marker_cross); break;
		
		case B2D_IAO_MARKER_RECT_3X3 : CreateBaseRectFromMarkerData(_b2d_iao_marker_rect_3x3); break;
		case B2D_IAO_MARKER_RECT_5X5 : CreateBaseRectFromMarkerData(_b2d_iao_marker_rect_5x5); break;
		case B2D_IAO_MARKER_RECT_7X7 : CreateBaseRectFromMarkerData(_b2d_iao_marker_rect_7x7); break;
		case B2D_IAO_MARKER_RECT_9X9 : CreateBaseRectFromMarkerData(_b2d_iao_marker_rect_9x9); break;
		
		case B2D_IAO_MARKER_CIRCLE_3X3 : CreateBaseRectFromMarkerData(_b2d_iao_marker_circle_3x3); break;
		case B2D_IAO_MARKER_CIRCLE_5X5 : CreateBaseRectFromMarkerData(_b2d_iao_marker_circle_5x5); break;
		case B2D_IAO_MARKER_CIRCLE_7X7 : CreateBaseRectFromMarkerData(_b2d_iao_marker_circle_7x7); break;
		case B2D_IAO_MARKER_CIRCLE_9X9 : CreateBaseRectFromMarkerData(_b2d_iao_marker_circle_9x9); break;
		
		case B2D_IAO_MARKER_ELLIPSE_5X3 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_5x3); break;
		case B2D_IAO_MARKER_ELLIPSE_7X5 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_7x5); break;
		case B2D_IAO_MARKER_ELLIPSE_9X7 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_9x7); break;
		
		case B2D_IAO_MARKER_ELLIPSE_3X5 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_3x5); break;
		case B2D_IAO_MARKER_ELLIPSE_5X7 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_5x7); break;
		case B2D_IAO_MARKER_ELLIPSE_7X9 : CreateBaseRectFromMarkerData(_b2d_iao_marker_ellipse_7x9); break;

		case B2D_IAO_MARKER_CROSSHAIR_3X3 : CreateBaseRectFromMarkerData(_b2d_iao_marker_crosshair_3x3); break;
		case B2D_IAO_MARKER_CROSSHAIR_5X5 : CreateBaseRectFromMarkerData(_b2d_iao_marker_crosshair_5x5); break;
		case B2D_IAO_MARKER_CROSSHAIR_7X7 : CreateBaseRectFromMarkerData(_b2d_iao_marker_crosshair_7x7); break;
		case B2D_IAO_MARKER_CROSSHAIR_9X9 : CreateBaseRectFromMarkerData(_b2d_iao_marker_crosshair_9x9); break;
	}
}

BOOL B2dIAOMarker::IsHit(const Point& rPixelPos, UINT16 nTol)
{
	BOOL bRetval(FALSE);

	if(IsHittable())
	{
		switch(eMarkerKind)
		{
			case B2D_IAO_MARKER_POINT : return B2dIAObject::IsHit(rPixelPos, nTol); break;
			case B2D_IAO_MARKER_PLUS : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_plus, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CROSS : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_cross, rPixelPos, nTol); break;
			
			case B2D_IAO_MARKER_RECT_3X3 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_rect_3x3, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_RECT_5X5 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_rect_5x5, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_RECT_7X7 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_rect_7x7, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_RECT_9X9 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_rect_9x9, rPixelPos, nTol); break;
			
			case B2D_IAO_MARKER_CIRCLE_3X3 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_circle_3x3, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CIRCLE_5X5 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_circle_5x5, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CIRCLE_7X7 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_circle_7x7, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CIRCLE_9X9 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_circle_9x9, rPixelPos, nTol); break;
			
			case B2D_IAO_MARKER_ELLIPSE_5X3 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_5x3, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_ELLIPSE_7X5 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_7x5, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_ELLIPSE_9X7 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_9x7, rPixelPos, nTol); break;
			
			case B2D_IAO_MARKER_ELLIPSE_3X5 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_3x5, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_ELLIPSE_5X7 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_5x7, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_ELLIPSE_7X9 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_ellipse_7x9, rPixelPos, nTol); break;

			case B2D_IAO_MARKER_CROSSHAIR_3X3 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_crosshair_3x3, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CROSSHAIR_5X5 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_crosshair_5x5, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CROSSHAIR_7X7 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_crosshair_7x7, rPixelPos, nTol); break;
			case B2D_IAO_MARKER_CROSSHAIR_9X9 : bRetval = DoHitTestWithMarkerData(_b2d_iao_marker_crosshair_9x9, rPixelPos, nTol); break;
		}
	}

	return bRetval;
}

void B2dIAOMarker::CreateBaseRectFromMarkerData(BYTE* pData)
{
	Point aPos(GetBasePositionPixel());
	Point aSize; aSize.X() = *pData++; aSize.Y() = *pData++;
	Point aCenter; aCenter.X() = *pData++; aCenter.Y() = *pData++;
	aPos -= aCenter;
	SetBaseRect(Rectangle(aPos, aPos + aSize));
}

void B2dIAOMarker::CreateGeometryFromMarkerData(BYTE* pData)
{
	Point aPos(GetBasePositionPixel());
	Point aSize; aSize.X() = *pData++; aSize.Y() = *pData++;
	Point aCenter; aCenter.X() = *pData++; aCenter.Y() = *pData++;
	aPos -= aCenter;

	// does intersect with ClipRegion?
	Rectangle aRect(aPos, aPos + aSize);
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(aRect));

	if(!aOverRegion.IsEmpty())
	{
		UINT16 nNumBase = *pData++;
		UINT16 nNum2nd = *pData++;

		UINT16 a;
		for(a=0;a<nNumBase;a++)
		{
			Point aNew(aPos.X() + *pData++, aPos.Y() + *pData++);
			AddPixel(aNew, GetBaseColor());
		}
		for(a=0;a<nNum2nd;a++)
		{
			Point aNew(aPos.X() + *pData++, aPos.Y() + *pData++);
			AddPixel(aNew, Get2ndColor());
		}
	}
}

BOOL B2dIAOMarker::DoHitTestWithMarkerData(BYTE* pData, const Point& rPixelPos, UINT16 nTol)
{
	Point aPos(GetBasePositionPixel());
	Point aSize; aSize.X() = *pData++; aSize.Y() = *pData++;
	Point aCenter; aCenter.X() = *pData++; aCenter.Y() = *pData++;
	aPos -= aCenter;

	UINT16 nNum = *pData++;
	UINT16 nNum2nd = *pData++;
	nNum += nNum2nd;

	for(UINT16 a=0;a<nNum;a++)
	{
		Point aNew(aPos.X() + *pData++, aPos.Y() + *pData++);
		if(nTol)
		{
			Rectangle aRect(aNew.X() - nTol, aNew.Y() - nTol, aNew.X() + nTol, aNew.Y() + nTol);
			if(aRect.IsInside(rPixelPos))
				return TRUE;
		}
		else
		{
			if(aNew == rPixelPos)
				return TRUE;
		}
	}

	return FALSE;
}

void B2dIAOMarker::Set2ndColor(Color aNew) 
{ 
	if(aNew != a2ndColor) 
	{
		// throw away geometry
		GeometryChange(); 

		// remember new color
		a2ndColor = aNew; 
	}
}

void B2dIAOMarker::SetMarkerKind(B2dIAOMarkerKind eNew) 
{ 
	if(eNew != eMarkerKind) 
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new marker kind
		eMarkerKind = eNew;
	}
}


