<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:fo="http://www.w3.org/1999/XSL/Format">

<!--
#############################################################################
 
	StarOffice Help Format to HTML converter - DRAFT Feb-12-2004
	==================================================================
	(c) 2004, Sun Microsystems, Inc. - FPE

	attribute values:
	o means no need for support
	+ means is supported
	# means is not supported
#############################################################################
-->

<!-- TODO
 - Relative locations for links, css, img
 - convert xhp extensions to html for links 
 
 -->


<xsl:param name="am" select="'&amp;'"/>
<xsl:param name="sl" select="'/'"/>
<xsl:param name="qt" select="'&quot;'"/>
<xsl:param name="fsroot" select="'file:///opt/data/Sun/CVS/ooo/documentation/documentation/helpcontent2/'"/>
<xsl:param name="fsrootrel" select="''"/>
<xsl:param name="fsrootsource" select="concat($fsroot,'/source/')"/>
<xsl:param name="fsrootsourcerel" select="''"/>
<xsl:param name="section" select="'nochange'"/>

<xsl:param name="imgroot" select="concat($fsrootsourcerel,'img/')"/>
<xsl:param name="toolbar" select="'1'"/>
<xsl:param name="back" select="'n'"/>
<xsl:param name="anchor" select="''"/>

<xsl:param name="note_img" select="concat($imgroot,'res/helpimg/note.png')"/>
<xsl:param name="tip_img" select="concat($imgroot,'res/helpimg/tip.png')"/>
<xsl:param name="warning_img" select="concat($imgroot,'res/helpimg/warning.png')"/>

<xsl:param name="dpi" select="'96'"/>
<xsl:param name="dpcm" select="'38'"/>

<xsl:variable name="status">
	<xsl:choose>
		<xsl:when test="not(/helpdocument/meta/topic/@status='')">
			<xsl:value-of select="/helpdocument/meta/topic/@status"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="'UNDEFINED'"/>
		</xsl:otherwise>
	</xsl:choose>
 </xsl:variable>

<xsl:param name="os"/>
<xsl:param name="appl"/>
<xsl:param name="distrib"/>
<xsl:param name="prodname"/>
<xsl:param name="view"/>
<xsl:param name="filename"/>

<xsl:template match="/">
	<html>
		<head>
			<link href="{$fsrootsourcerel}ooohelp.css" rel="stylesheet" type="text/css"/>
			<script src="{$fsrootsourcerel}ooohelp.js" type="text/javascript" language="JavaScript"></script>
			
			<!-- insert keywords into meta for search engines --> 
			 
			<xsl:variable name="kw">
				<xsl:for-each select="//bookmark[@branch='index']/bookmark_value">
					<xsl:value-of select="concat(.,', ')"/>
				</xsl:for-each>
			</xsl:variable>
			
			<meta name="keywords" content="{$kw}" />
						
		</head>
		
		<xsl:param name="fname">
			<xsl:value-of select="concat('text',substring-after(/helpdocument/meta/topic/filename,'text'))"/>
		</xsl:param>

		<body class="helpcontent" onLoad="setsection('{$fsrootsourcerel}','{$section}','{$filename}')">
			<div class="helptext">
				<xsl:apply-templates />
			</div>
			
		</body>
	</html>
</xsl:template>

<!-- 
###################################################### 
AHELP 
	+ hid CDATA #REQUIRED
  + visibility (hidden | visible) #IMPLIED
###################################################### 
-->

<xsl:template match="ahelp">
	<xsl:choose>
		<xsl:when test="@visibility='hidden'">
			<span class="ahelp_hidden"><xsl:apply-templates /></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="ahelp"><xsl:apply-templates /></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
ALT
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED (is the same as for theimage except for "alt_"
  + localize CDATA #IMPLIED 
###################################################### 
-->

<xsl:template match="alt"/>

<!-- 
###################################################### 
BODY, SEE HEADER
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="body" >
	<xsl:apply-templates />
</xsl:template>

<!-- 
###################################################### 
BOOKMARK
  + branch CDATA #REQUIRED
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED 
###################################################### 
-->
<xsl:template match="bookmark">
	<div class="bookmark" title="Bookmark">
		<xsl:choose>
			<xsl:when test="starts-with(@branch,'hid')">
			<p class="bookmark_value hidden">
				<xsl:value-of select="@branch"/>
			</p>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates />
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

<!-- 
###################################################### 
BOOKMARK_VALUE 
###################################################### 
-->
<xsl:template match="bookmark_value">
	<p class="bookmark_value">
		<xsl:apply-templates />
	</p>
</xsl:template>

<!-- 
###################################################### 
BR 
###################################################### 
-->
<xsl:template match="br"><br /></xsl:template>
<xsl:template match="br" mode="embedded"><br /></xsl:template>

<!-- 
###################################################### 
CAPTION 
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED   (in parent elements)
  + localize CDATA #IMPLIED (in parent elements)
###################################################### 
-->
<xsl:template match="caption" />

<!-- 
###################################################### 
CASE
  + select CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="case">
	<div class="case {@select}" title="{@select}">
		<xsl:apply-templates />
	</div>
</xsl:template>

<!-- 
###################################################### 
CASEINLINE
  + select CDATA #REQUIRED 
###################################################### 
-->
<xsl:template match="caseinline">
	<span class="caseinline {@select}" title="{@select}">
		<xsl:apply-templates />
	</span>
</xsl:template>

<!-- 
###################################################### 
COMMENT 
###################################################### 
-->
<xsl:template match="comment" />

<!-- 
###################################################### 
CREATED,  SEE HEADER
  + date CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="created" />

<!-- 
###################################################### 
DEFAULT 
###################################################### 
-->
<xsl:template match="default">
	<div class="default" title="DEFAULT">
		<xsl:apply-templates />
	</div>
</xsl:template>

<!-- 
###################################################### 
DEFAULTINLINE 
###################################################### 
-->
<xsl:template match="defaultinline">
	<span class="defaultinline" title="DEFAULT">
		<xsl:apply-templates />
	</span>
</xsl:template>

<!-- 
###################################################### 
EMBED
	+ href CDATA #REQUIRED
  + role CDATA #IMPLIED
  + level CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="embed">

	<div class="embedded">
		<xsl:variable name="href"><xsl:value-of select="substring-before(concat($fsrootsource,@href),'#')"/></xsl:variable>
		<xsl:variable name="anchor"><xsl:value-of select="substring-after(@href,'#')"/></xsl:variable>
		<xsl:variable name="doc" select="document($href)"/>
		
		<xsl:choose>
			<xsl:when test="$doc//section[@id=$anchor]"> <!-- first test for a section of that name -->
				<xsl:apply-templates select="$doc//section[@id=$anchor]" mode="embedded"/>
			</xsl:when>
			<xsl:when test="$doc//paragraph[@id=$anchor]"> <!-- then test for a para of that name -->
				<p class="falseembed">
					<xsl:apply-templates select="$doc//paragraph[@id=$anchor]" mode="embedded"/>
				</p>
			</xsl:when>
			<xsl:when test="$doc//variable[@id=$anchor]"> <!-- then test for a variable of that name -->
				<p class="falseembed">
					<xsl:apply-templates select="$doc//variable[@id=$anchor]" mode="embedded"/>
				</p>
			</xsl:when>
			<xsl:otherwise> <!-- then give up -->
				<p class="bug">D'oh! You found a bug (<xsl:value-of select="$href"/> not found).</p> 
			</xsl:otherwise>
		</xsl:choose>
	</div>

</xsl:template>

<!-- 
###################################################### 
EMBEDVAR
 + href CDATA #REQUIRED
 + markup (keep | ignore) #IMPLIED
###################################################### 
-->
<xsl:template match="embedvar">
	<xsl:if test="not(@href='text/shared/00/00000004.xhp#wie')"> <!-- special treatment if howtoget links -->
		<xsl:variable name="href"><xsl:value-of select="substring-before(concat($fsrootsource,@href),'#')"/></xsl:variable>
		<xsl:variable name="anchor"><xsl:value-of select="substring-after(@href,'#')"/></xsl:variable>
		<xsl:variable name="doc" select="document($href)"/>
		
		<xsl:choose>
			<xsl:when test="$doc//variable[@id=$anchor]"> <!-- test for a variable of that name -->
				<xsl:apply-templates select="$doc//variable[@id=$anchor]" mode="embedded"/>
			</xsl:when>
			<xsl:otherwise> <!-- or give up -->
				<span class="bug">[<xsl:value-of select="$href"/> not found].</span> 
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:if>
</xsl:template>

<!-- 
###################################################### 
EMPH 
###################################################### 
-->
<xsl:template match="emph"><span class="emph"><xsl:apply-templates /></span></xsl:template>
<xsl:template match="emph" mode="embedded"><span class="emph"><xsl:apply-templates /></span></xsl:template>

<!-- 
###################################################### 
FILENAME,  SEE HEADER
###################################################### 
-->
<xsl:template match="filename" />


<!-- 
###################################################### 
HELPDOCUMENT,  SEE HEADER
  + version CDATA #REQUIRED
###################################################### 
-->
<!-- <xsl:template match="helpdocument" /> -->

<!-- 
###################################################### 
HISTORY,  SEE HEADER
###################################################### 
-->
<xsl:template match="history" />


<!-- 
###################################################### 
IMAGE 
  + src CDATA #REQUIRED
  + width CDATA #IMPLIED
  + height CDATA #IMPLIED
  + id CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="image">
	<xsl:variable name="src">
		<xsl:value-of select="concat($imgroot,@src)"/> 
	</xsl:variable>
	
	<xsl:variable name="width" select="''"/>
	<xsl:variable name="height" select="''" />
	
	<img src="{$src}" alt="{alt}" title="{alt}" align="top" />
</xsl:template>


<!-- 
###################################################### 
ITEM 
  + type CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="item">
	<span class="{@type}">
		<xsl:apply-templates />
	</span>
</xsl:template>

<!-- 
###################################################### 
LASTEDITED,  SEE HEADER
  + date CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="lastedited" />

<!-- 
###################################################### 
LINK
  + href CDATA #REQUIRED
  + name CDATA #REQUIRED
  + type CDATA #IMPLIED
  + target CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="link">


	<xsl:choose>
	
		<xsl:when test="contains(child::embedvar/@href,'/00/00000004.xhp#wie')"> <!-- special treatment if howtoget links -->
				<xsl:variable name="tmp_href"><xsl:value-of select="concat($fsrootsource,substring-before(child::embedvar/@href,'#'))"/></xsl:variable>
				<xsl:variable name="tmp_doc" select="document($tmp_href)"/>
				<div class="howtoget">
					<p class="howtogetheader"><xsl:apply-templates select="$tmp_doc//variable[@id='wie']"/></p>
					
					<xsl:variable name="href"><xsl:value-of select="substring-before(concat($fsrootsource,@href),'#')"/></xsl:variable>
					<xsl:variable name="anchor"><xsl:value-of select="substring-after(@href,'#')"/></xsl:variable>
					<xsl:variable name="doc" select="document($href)"/>

					<xsl:choose>
						<xsl:when test="$doc//section[@id=$anchor]"> <!-- first test for a section of that name -->
							<xsl:apply-templates select="$doc//section[@id=$anchor]" mode="embedded"/>
						</xsl:when>
						<xsl:when test="$doc//paragraph[@id=$anchor]"> <!-- then test for a para of that name -->
							<xsl:apply-templates select="$doc//paragraph[@id=$anchor]" mode="embedded"/>
						</xsl:when>
						<xsl:when test="$doc//variable[@id=$anchor]"> <!-- test for a variable of that name -->
							<xsl:apply-templates select="$doc//variable[@id=$anchor]" mode="embedded"/>
						</xsl:when>
						<xsl:otherwise> <!-- or give up -->
							<span class="bug">[<xsl:value-of select="@href"/> not found].</span> 
						</xsl:otherwise>
					</xsl:choose>
				
				</div>
		</xsl:when>
		
		<xsl:when test="contains(@href,'://')">
			<a href="{@href}"><xsl:apply-templates /></a>
		</xsl:when>
		
		<xsl:otherwise>
			<xsl:variable name="anchor">
				<xsl:choose>
					<xsl:when test="contains(@href,'#')">
						<xsl:value-of select="substring-after(@href,'#')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="''"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="hreffile">
				<xsl:choose>
					<xsl:when test="contains(@href,'#')">
						<xsl:value-of select="substring-before(@href,'#')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@href"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="href">
				<xsl:choose>
					<xsl:when test="contains(@href,'#')">
						<xsl:value-of select="concat($fsrootsourcerel,$hreffile,'#',$anchor)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($fsrootsourcerel,$hreffile)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<a href="{$href}"><xsl:apply-templates /></a>
		</xsl:otherwise>
	
	</xsl:choose>
</xsl:template>

<xsl:template match="link" mode="embedded">
	<xsl:variable name="href">
		<xsl:value-of select="concat($fsrootsourcerel,@href)"/>
	</xsl:variable>
	<a href="{$href}"><xsl:apply-templates /></a>
</xsl:template>


<!-- 
###################################################### 
LIST
  + type CDATA #REQUIRED
  + startwith CDATA #IMPLIED
  # format (1 | i | I | a | A) #IMPLIED
  # bullet (disc | circle | square) #IMPLIED
  # localize CDATA #IMPLIED
  # sorted (asc | desc) #IMPLIED
###################################################### 
-->
<xsl:template match="list">
	<xsl:choose>
		<xsl:when test="@type='ordered'">
			<ol>
				<xsl:if test="@startwith">
					<xsl:attribute name="start"><xsl:value-of select="@startwith"/></xsl:attribute>
				</xsl:if>
				<xsl:apply-templates />
			</ol>
		</xsl:when>
		<xsl:otherwise>
			<ul>
				<xsl:apply-templates />
			</ul>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
LISTITEM 
  # format (1 | i | I | a | A) #IMPLIED
  # bullet (disc | circle | square) #IMPLIED
  # localize CDATA #IMPLIED
  # class CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="listitem">
	<li>
		<xsl:apply-templates />
	</li>
</xsl:template>

<!-- 
###################################################### 
META, SEE HEADER
###################################################### 
-->
<xsl:template match="meta">
	<xsl:apply-templates />
</xsl:template>

<!-- 
###################################################### 
OBJECT
  + type CDATA #REQUIRED
  + id CDATA #REQUIRED
  + data CDATA #REQUIRED
  + height CDATA #IMPLIED
  + width CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="object" />

<!-- 
###################################################### 
PARAGRAPH 
  + role CDATA #REQUIRED
  + level CDATA #IMPLIED
  + id CDATA #REQUIRED
  + l10n CDATA #REQUIRED
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + oldref CDATA #IMPLIED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="paragraph">
	<xsl:choose>
		
		<xsl:when test="@role='heading'">
			<xsl:text disable-output-escaping="yes">&lt;h</xsl:text><xsl:value-of select="@level"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text> 
				<xsl:apply-templates />
			<xsl:text disable-output-escaping="yes">&lt;/h</xsl:text><xsl:value-of select="@level"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		</xsl:when>
		
		<xsl:when test="@role='note'">
			<div class="note">
			<table border="0">
				<tr>
					<td><img src="{$note_img}"/></td>
					<td><xsl:apply-templates /></td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="@role='tip'">
			<div class="tip">
			<table border="0">
				<tr>
					<td><img src="{$tip_img}"/></td>
					<td>
						<xsl:apply-templates />
					</td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="@role='warning'">
			<div class="warning">
			<table border="0">
				<tr>
					<td><img src="{$warning_img}"/></td>
					<td><xsl:apply-templates /></td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
	
		<xsl:otherwise>
			<p class="{@role}">
				<xsl:apply-templates />
			</p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="paragraph" mode="embedded">
	<xsl:choose>
		
		<xsl:when test="@role='heading'">
			<xsl:text disable-output-escaping="yes">&lt;h</xsl:text><xsl:value-of select="@level"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text> 
				<xsl:apply-templates />
			<xsl:text disable-output-escaping="yes">&lt;/h</xsl:text><xsl:value-of select="@level"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		</xsl:when>
		
		<xsl:when test="@role='note'">
			<div class="note">
			<table border="0">
				<tr>
					<td><img src="{$note_img}"/></td>
					<td><xsl:apply-templates /></td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="@role='tip'">
			<div class="tip">
			<table border="0">
				<tr>
					<td><img src="{$tip_img}"/></td>
					<td>
						<xsl:apply-templates />
					</td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="@role='warning'">
			<div class="warning">
			<table border="0">
				<tr>
					<td><img src="{$warning_img}"/></td>
					<td><xsl:apply-templates /></td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
	
		<xsl:otherwise>
			<p class="{@role}">
				<xsl:apply-templates />
			</p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- 
###################################################### 
SECTION
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED 
###################################################### 
-->

<xsl:template match="section">
	<a name="{@id}"></a>
	<div class="section">
	
		<xsl:choose>
			
			<xsl:when test="@id='relatedtopics'">
				<div class="relatedtopics">
				<xsl:variable name="href"><xsl:value-of select="concat($fsrootsource,'text/shared/00/00000004.xhp')"/></xsl:variable>
				<xsl:variable name="anchor"><xsl:value-of select="'related'"/></xsl:variable>
				<xsl:variable name="doc" select="document($href)"/>
				
					<xsl:choose>
					
						<xsl:when test="$doc//variable[@id=$anchor]"> <!-- then test for a variable of that name -->
						<p class="related">
							<xsl:apply-templates select="$doc//variable[@id=$anchor]" mode="embedded"/>
						</p>
						</xsl:when>
						<xsl:otherwise> <!-- then give up -->
							<p class="bug">D'oh! You found a bug (<xsl:value-of select="@href"/> not found).</p> 
						</xsl:otherwise>
						</xsl:choose>
			
				
				<xsl:apply-templates />
				</div>
			</xsl:when>
			
			<xsl:when test="@id='howtoget'">
				<xsl:variable name="href"><xsl:value-of select="concat($fsrootsource,'text/shared/00/00000004.xhp')"/></xsl:variable>
				<xsl:variable name="doc" select="document($href)"/>
				<xsl:variable name="anchor"><xsl:value-of select="'wie'"/></xsl:variable>
				<div class="howtoget">
					<xsl:choose>
					
						<xsl:when test="$doc//variable[@id=$anchor]"> <!-- then test for a variable of that name -->
						<p class="howtogetheader">
							<xsl:apply-templates select="$doc//variable[@id='wie']" mode="embedded"/>
						</p>
						</xsl:when>
						<xsl:otherwise> <!-- then give up -->
						<p class="bug">D'oh! You found a bug (<xsl:value-of select="@href"/> not found).</p> 
						</xsl:otherwise>
						</xsl:choose>
		
					<xsl:apply-templates />
				</div>
			</xsl:when>
			<xsl:otherwise>
						<xsl:apply-templates/>
			</xsl:otherwise>
		
		</xsl:choose>
		
	</div>
</xsl:template>

<xsl:template match="section" mode="embedded">
	<a name="{@id}"></a>
	<div class="section">
	
		<xsl:choose>
			
			<xsl:when test="@id='relatedtopics'">
				<xsl:variable name="href"><xsl:value-of select="concat($fsrootsource,'text/shared/00/00000004.xhp')"/></xsl:variable>
				<xsl:variable name="anchor"><xsl:value-of select="'related'"/></xsl:variable>
				<xsl:variable name="doc" select="document($href)"/>
				
					<xsl:choose>
					
						<xsl:when test="$doc//variable[@id=$anchor]"> <!-- then test for a variable of that name -->
						<p class="related">
						<xsl:apply-templates select="$doc//variable[@id=$anchor]" mode="embedded"/>
						</p>
						</xsl:when>
						<xsl:otherwise> <!-- then give up -->
						<p class="bug">D'oh! You found a bug (<xsl:value-of select="@href"/> not found).</p> 
						</xsl:otherwise>
						</xsl:choose>
			
				
				<xsl:apply-templates />
			</xsl:when>
			
			<xsl:when test="@id='howtoget'">
				<xsl:variable name="href"><xsl:value-of select="concat($fsrootsource,'text/shared/00/00000004.xhp')"/></xsl:variable>
				<xsl:variable name="doc" select="document($href)"/>
				<div class="howtoget">
					<xsl:choose>
					
						<xsl:when test="$doc//variable[@id=$anchor]"> <!-- then test for a variable of that name -->
						<p class="howtogetheader">
						<xsl:apply-templates select="$doc//variable[@id='wie']" mode="embedded"/>
						</p>
						</xsl:when>
						<xsl:otherwise> <!-- then give up -->
						<p class="bug">D'oh! You found a bug (<xsl:value-of select="@href"/> not found).</p> 
						</xsl:otherwise>
						</xsl:choose>
		
					<xsl:apply-templates />
				</div>
			</xsl:when>
			<xsl:otherwise>
						<xsl:apply-templates/>
			</xsl:otherwise>
		
		</xsl:choose>
		
	</div>
</xsl:template>


<!-- 
###################################################### 
SORT 
  + order (asc | desc) #IMPLIED
###################################################### 
-->

<xsl:template match="sort" >
	<xsl:apply-templates>
		<xsl:sort select="descendant::paragraph"/>
	</xsl:apply-templates>
</xsl:template>

<!-- 
###################################################### 
SWITCH
  + select (sys | appl | distrib | target | lang | ver) #REQUIRED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="switch">
	<div class="switch" title="{@select}">
		<div class="switchselect"><xsl:value-of select="@select"/></div>
		<xsl:apply-templates />
	</div>
</xsl:template>

<!-- 
###################################################### 
SWITCHINLINE
  + select (sys | appl | distrib | target | ver | lang) #REQUIRED
###################################################### 
-->
<xsl:template match="switchinline">
	<span class="switchinline">
		<xsl:apply-templates />
	</span>
</xsl:template>

<!-- 
###################################################### 
TABLE
  + name CDATA #IMPLIED
  + width CDATA #IMPLIED
  + height CDATA #IMPLIED
  + unit CDATA #IMPLIED
  + class CDATA #IMPLIED
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="table">
	<xsl:variable name="imgsrc">
		<xsl:value-of select="tablerow/tablecell[1]/paragraph[1]/image/@src"/>
	</xsl:variable>
	<xsl:choose>
		
		<xsl:when test="contains($imgsrc,'hinweis.gif')">
			<div class="note">
			<table border="0">
				<tr>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[1]/paragraph[1]/image"/>		
					</td>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[2]"/>
					</td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="contains($imgsrc,'tip.gif')">
			<div class="tip">
			<table border="0">
				<tr>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[1]/paragraph[1]/image"/>		
					</td>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[2]"/>
					</td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="contains($imgsrc,'achtung.gif')">
			<div class="warning">
			<table border="0">
				<tr>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[1]/paragraph[1]/image"/>		
					</td>
					<td>
						<xsl:apply-templates select="tablerow/tablecell[2]"/>
					</td>
				</tr>
			</table>
			</div>			
		</xsl:when>
		
		<xsl:when test="count(descendant::tablecell)=1">
			<table border="0" class="onecell" cellpadding="0" cellspacing="0">
				<xsl:apply-templates />
		 </table>
		</xsl:when>
		
	
		<xsl:when test="descendant::tablecell[1]/descendant::image">
			<table border="0" class="icontable" cellpadding="0" cellspacing="0">
				<xsl:apply-templates />
		 </table>
		</xsl:when>
		
		
		<xsl:otherwise>
			<table border="0" class="border" cellpadding="0" cellspacing="0" >
				<xsl:apply-templates />
		 </table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
TABLECELL
  + colspan CDATA #IMPLIED
  + rowspan CDATA #IMPLIED
  # width CDATA #IMPLIED
  # class CDATA #IMPLIED
  # unit CDATA #IMPLIED
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="tablecell">
	<td valign="top">
		<xsl:if test="not(child::*)"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:if>
		<xsl:apply-templates />
	</td>
</xsl:template>

<!-- 
###################################################### 
TABLEROW
  # height CDATA #IMPLIED
  # class CDATA #IMPLIED
  # unit CDATA #IMPLIED
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="tablerow">
	<tr>
		<xsl:apply-templates />
	</tr>
</xsl:template>

<!-- 
###################################################### 
TITLE,  SEE HEADER
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  o id CDATA #REQUIRED (is always tit for the title)
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="title"/>

<!-- 
###################################################### 
TOPIC,  SEE HEADER
  + id CDATA #REQUIRED
  + indexer (exclude | include) #IMPLIED 
###################################################### 
-->
<xsl:template match="topic"/>

<!-- 
###################################################### 
VARIABLE 
  + id CDATA #REQUIRED
  + visibility (hidden | visible) #IMPLIED
###################################################### 
-->
<xsl:template match="variable">
	<span class="variable">
		<xsl:apply-templates />
	</span>
</xsl:template>

<!-- 
###################################################### 
-->

</xsl:stylesheet>
