/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: animationbasenode.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2005/10/11 08:42:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX
#define INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX

#include "basecontainernode.hxx"
#include "activitiesfactory.hxx"
#include "shapeattributelayer.hxx"
#include "shapeattributelayerholder.hxx"
#include "attributableshape.hxx"
#include "shapesubset.hxx"
#include "com/sun/star/animations/XAnimate.hpp"

namespace presentation {
namespace internal {

/** Common base class for all leaf animation nodes.
    
    This class basically holds the target shape
*/
class AnimationBaseNode : public BaseNode
{
public:
    AnimationBaseNode(
        ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimationNode> const & xNode,
        BaseContainerNodeSharedPtr const & rParent,
        NodeContext const & rContext );
    
    virtual bool init();
    virtual void dispose();
    virtual bool resolve();
    virtual bool activate();
    virtual void deactivate();
    virtual void end();
    virtual void notifyDeactivating( AnimationNodeSharedPtr const & rNotifier );
    virtual bool hasPendingAnimation() const;
    
#if defined(VERBOSE) && defined(DBG_UTIL)
    virtual void showState() const;
#endif
protected:
    
    /** Animation-specific end().
        
        This is also called from deactivate, for subsetted
        shapes. Actually force-ends the underlying animation
        activity.
    */
    void endAnimation();
    
    /** Create parameter struct for ActivitiesFactory
     */
    ActivitiesFactory::CommonParameters fillCommonParameters() const;
    
    /** Create AnimationActivity from common XAnimate parameters
     */
    AnimationActivitySharedPtr createActivity() const;
    
    /// Returns true, if this node animates a subset of a shape
    bool isSubsettedShape() const;
    
    /** Returns true, if this is a subset animation, and
        the subset is autogenerated (e.g. from an
        iteration)
    */
    bool isDependentSubsettedShape() const;
    
    /** This method enables a subset shape
     */
    void enableShapeSubset();
    
    /** This method removes subset shapes
        
        Subset shapes may be only temporarily added to a
        slide. When the animation active duration ends,
        and they are generated from iterated effects, they
        are removed again for redraw
        performance. Furthermore, they are revoked from
        the original shape, such that it displays the full
        content again.
    */
    void disableShapeSubset();
    
    AttributableShapeSharedPtr getShape() const;
    
    // inline accessors
    // ----------------
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate> const & getXAnimateNode() const
        { return mxAnimateNode; }
    ShapeAttributeLayerHolder const & getAttributeLayerHolder() const
        { return maAttributeLayerHolder; }
    AnimationActivitySharedPtr const & getActivity() const
        { return mpActivity; }
    AnimationActivitySharedPtr & getActivity()
        { return mpActivity; }
    
private:
    ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimate>     mxAnimateNode;
    ShapeAttributeLayerHolder                       maAttributeLayerHolder;
    AnimationActivitySharedPtr                      mpActivity;
    
    /// When valid, this node has a plain target shape
    AttributableShapeSharedPtr                      mpShape;
    /// When valid, this is a subsetted target shape 
    ShapeSubsetSharedPtr                            mpShapeSubset;
    bool                                            mbIsIndependentSubset;
};

} // namespace internal
} // namespace presentation

#endif /* INCLUDED_SLIDESHOW_ANIMATIONBASENODE_HXX */
