/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: strmadpt.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 13:58:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVTOOLS_STRMADPT_HXX
#define SVTOOLS_STRMADPT_HXX

#ifndef INCLUDED_SVLDLLAPI_H
#include "svtools/svldllapi.h"
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XSEEKABLE_HPP_
#include <com/sun/star/io/XSeekable.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

//============================================================================
class SVL_DLLPUBLIC SvOutputStreamOpenLockBytes: public SvOpenLockBytes
{
	com::sun::star::uno::Reference< com::sun::star::io::XOutputStream >
	    m_xOutputStream;
	sal_uInt32 m_nPosition;

public:
	TYPEINFO();

	SvOutputStreamOpenLockBytes(
		    const com::sun::star::uno::Reference<
			          com::sun::star::io::XOutputStream > &
			    rTheOutputStream):
		m_xOutputStream(rTheOutputStream), m_nPosition(0) {}

	virtual ErrCode ReadAt(ULONG, void *, ULONG, ULONG *) const;

	virtual ErrCode WriteAt(ULONG nPos, const void * pBuffer, ULONG nCount,
							ULONG * pWritten);

	virtual ErrCode Flush() const;

	virtual ErrCode SetSize(ULONG);

	virtual ErrCode Stat(SvLockBytesStat * pStat, SvLockBytesStatFlag) const;

	virtual ErrCode FillAppend(const void * pBuffer, ULONG nCount,
							   ULONG * pWritten);

	virtual ULONG Tell() const;

	virtual ULONG Seek(ULONG);

	virtual void Terminate();
};

//============================================================================
class SVL_DLLPUBLIC SvLockBytesInputStream: public cppu::OWeakObject,
							  public com::sun::star::io::XInputStream,
							  public com::sun::star::io::XSeekable
{
	SvLockBytesRef m_xLockBytes;
	sal_Int64 m_nPosition;
	bool m_bDone;

public:
	SvLockBytesInputStream(SvLockBytes * pTheLockBytes):
		m_xLockBytes(pTheLockBytes), m_nPosition(0), m_bDone(false) {}

	virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire() throw();

	virtual void SAL_CALL release() throw();

    virtual sal_Int32 SAL_CALL
	readBytes(com::sun::star::uno::Sequence< sal_Int8 > & rData,
			  sal_Int32 nBytesToRead)
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL
	readSomeBytes(com::sun::star::uno::Sequence< sal_Int8 > & rData,
				  sal_Int32 nMaxBytesToRead)
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL skipBytes(sal_Int32 nBytesToSkip)
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL available()
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL closeInput()
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL seek(sal_Int64 nLocation)
		throw (com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual sal_Int64 SAL_CALL getPosition()
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);

    virtual sal_Int64 SAL_CALL getLength()
		throw (com::sun::star::io::IOException,
			   com::sun::star::uno::RuntimeException);
};

#endif // SVTOOLS_STRMADPT_HXX

