/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: outdev5.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:06:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <tools/ref.hxx>
#ifndef _SV_SVSYS_HXX
#include <svsys.h>
#endif

#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SV_SVDATA_HXX
#include <svdata.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SV_METAACT_HXX
#include <metaact.hxx>
#endif
#ifndef _SV_GDIMTF_HXX
#include <gdimtf.hxx>
#endif
#ifndef _SV_OUTDATA_HXX
#include <outdata.hxx>
#endif
#ifndef _SV_OUTDEV_H
#include <outdev.h>
#endif
#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <virdev.hxx>
#endif

// =======================================================================

DBG_NAMEEX( OutputDevice );

// =======================================================================

void OutputDevice::DrawRect( const Rectangle& rRect,
							 ULONG nHorzRound, ULONG nVertRound )
{
	DBG_TRACE( "OutputDevice::DrawRoundRect()" );
	DBG_CHKTHIS( OutputDevice, ImplDbgCheckOutputDevice );

	if ( mpMetaFile )
		mpMetaFile->AddAction( new MetaRoundRectAction( rRect, nHorzRound, nVertRound ) );

	if ( !IsDeviceOutputNecessary() || (!mbLineColor && !mbFillColor) || ImplIsRecordLayout() )
		return;

	const Rectangle aRect( ImplLogicToDevicePixel( rRect ) );

	if ( aRect.IsEmpty() )
		return;

	nHorzRound = ImplLogicWidthToDevicePixel( nHorzRound );
	nVertRound = ImplLogicHeightToDevicePixel( nVertRound );

	// we need a graphics
	if ( !mpGraphics )
	{
		if ( !ImplGetGraphics() )
			return;
	}

	if ( mbInitClipRegion )
		ImplInitClipRegion();
	if ( mbOutputClipped )
		return;

	if ( mbInitLineColor )
		ImplInitLineColor();
	if ( mbInitFillColor )
		ImplInitFillColor();

	if ( !nHorzRound && !nVertRound )
		mpGraphics->DrawRect( aRect.Left(), aRect.Top(), aRect.GetWidth(), aRect.GetHeight(), this );
	else
	{
		const Polygon aRoundRectPoly( aRect, nHorzRound, nVertRound );

		if ( aRoundRectPoly.GetSize() >= 2 )
		{
			const SalPoint* pPtAry = (const SalPoint*) aRoundRectPoly.GetConstPointAry();
			
			if ( !mbFillColor )
				mpGraphics->DrawPolyLine( aRoundRectPoly.GetSize(), pPtAry, this );
			else
				mpGraphics->DrawPolygon( aRoundRectPoly.GetSize(), pPtAry, this );
		}
	}

    if( mpAlphaVDev )
        mpAlphaVDev->DrawRect( rRect, nHorzRound, nVertRound );
}

// -----------------------------------------------------------------------

void OutputDevice::DrawEllipse( const Rectangle& rRect )
{
	DBG_TRACE( "OutputDevice::DrawEllipse()" );
	DBG_CHKTHIS( OutputDevice, ImplDbgCheckOutputDevice );

	if ( mpMetaFile )
		mpMetaFile->AddAction( new MetaEllipseAction( rRect ) );

	if	( !IsDeviceOutputNecessary() || (!mbLineColor && !mbFillColor) || ImplIsRecordLayout() )
		return;

	Rectangle aRect( ImplLogicToDevicePixel( rRect ) );
	if ( aRect.IsEmpty() )
		return;

	// we need a graphics
	if ( !mpGraphics )
	{
		if ( !ImplGetGraphics() )
			return;
	}

	if ( mbInitClipRegion )
		ImplInitClipRegion();
	if ( mbOutputClipped )
		return;

	if ( mbInitLineColor )
		ImplInitLineColor();

	Polygon aRectPoly( aRect.Center(), aRect.GetWidth() >> 1, aRect.GetHeight() >> 1 );
	if ( aRectPoly.GetSize() >= 2 )
	{
		const SalPoint* pPtAry = (const SalPoint*)aRectPoly.GetConstPointAry();
		if ( !mbFillColor )
			mpGraphics->DrawPolyLine( aRectPoly.GetSize(), pPtAry, this );
		else
		{
			if ( mbInitFillColor )
				ImplInitFillColor();
			mpGraphics->DrawPolygon( aRectPoly.GetSize(), pPtAry, this );
		}
	}

    if( mpAlphaVDev )
        mpAlphaVDev->DrawEllipse( rRect );
}

// -----------------------------------------------------------------------

void OutputDevice::DrawArc( const Rectangle& rRect,
							const Point& rStartPt, const Point& rEndPt )
{
	DBG_TRACE( "OutputDevice::DrawArc()" );
	DBG_CHKTHIS( OutputDevice, ImplDbgCheckOutputDevice );

	if ( mpMetaFile )
		mpMetaFile->AddAction( new MetaArcAction( rRect, rStartPt, rEndPt ) );

	if ( !IsDeviceOutputNecessary() || !mbLineColor || ImplIsRecordLayout() )
		return;

	Rectangle aRect( ImplLogicToDevicePixel( rRect ) );
	if ( aRect.IsEmpty() )
		return;

	// we need a graphics
	if ( !mpGraphics )
	{
		if ( !ImplGetGraphics() )
			return;
	}

	if ( mbInitClipRegion )
		ImplInitClipRegion();
	if ( mbOutputClipped )
		return;

	if ( mbInitLineColor )
		ImplInitLineColor();

	const Point 	aStart( ImplLogicToDevicePixel( rStartPt ) );
	const Point 	aEnd( ImplLogicToDevicePixel( rEndPt ) );
	Polygon 		aArcPoly( aRect, aStart, aEnd, POLY_ARC );

	if ( aArcPoly.GetSize() >= 2 )
	{
		const SalPoint* pPtAry = (const SalPoint*)aArcPoly.GetConstPointAry();
		mpGraphics->DrawPolyLine( aArcPoly.GetSize(), pPtAry, this );
	}

    if( mpAlphaVDev )
        mpAlphaVDev->DrawArc( rRect, rStartPt, rEndPt );
}

// -----------------------------------------------------------------------

void OutputDevice::DrawPie( const Rectangle& rRect,
							const Point& rStartPt, const Point& rEndPt )
{
	DBG_TRACE( "OutputDevice::DrawPie()" );
	DBG_CHKTHIS( OutputDevice, ImplDbgCheckOutputDevice );

	if ( mpMetaFile )
		mpMetaFile->AddAction( new MetaPieAction( rRect, rStartPt, rEndPt ) );

	if ( !IsDeviceOutputNecessary() || (!mbLineColor && !mbFillColor) || ImplIsRecordLayout() )
		return;

	Rectangle aRect( ImplLogicToDevicePixel( rRect ) );
	if ( aRect.IsEmpty() )
		return;

	// we need a graphics
	if ( !mpGraphics )
	{
		if ( !ImplGetGraphics() )
			return;
	}

	if ( mbInitClipRegion )
		ImplInitClipRegion();
	if ( mbOutputClipped )
		return;

	if ( mbInitLineColor )
		ImplInitLineColor();

	const Point 	aStart( ImplLogicToDevicePixel( rStartPt ) );
	const Point 	aEnd( ImplLogicToDevicePixel( rEndPt ) );
	Polygon 		aPiePoly( aRect, aStart, aEnd, POLY_PIE );

	if ( aPiePoly.GetSize() >= 2 )
	{
		const SalPoint* pPtAry = (const SalPoint*)aPiePoly.GetConstPointAry();
		if ( !mbFillColor )
			mpGraphics->DrawPolyLine( aPiePoly.GetSize(), pPtAry, this );
		else
		{
			if ( mbInitFillColor )
				ImplInitFillColor();
			mpGraphics->DrawPolygon( aPiePoly.GetSize(), pPtAry, this );
		}
	}

    if( mpAlphaVDev )
        mpAlphaVDev->DrawPie( rRect, rStartPt, rEndPt );
}

// -----------------------------------------------------------------------

void OutputDevice::DrawChord( const Rectangle& rRect,
							  const Point& rStartPt, const Point& rEndPt )
{
	DBG_TRACE( "OutputDevice::DrawChord()" );
	DBG_CHKTHIS( OutputDevice, ImplDbgCheckOutputDevice );

	if ( mpMetaFile )
		mpMetaFile->AddAction( new MetaChordAction( rRect, rStartPt, rEndPt ) );

	if ( !IsDeviceOutputNecessary() || (!mbLineColor && !mbFillColor) || ImplIsRecordLayout() )
		return;

	Rectangle aRect( ImplLogicToDevicePixel( rRect ) );
	if ( aRect.IsEmpty() )
		return;

	// we need a graphics
	if ( !mpGraphics )
	{
		if ( !ImplGetGraphics() )
			return;
	}

	if ( mbInitClipRegion )
		ImplInitClipRegion();
	if ( mbOutputClipped )
		return;

	if ( mbInitLineColor )
		ImplInitLineColor();

	const Point 	aStart( ImplLogicToDevicePixel( rStartPt ) );
	const Point 	aEnd( ImplLogicToDevicePixel( rEndPt ) );
	Polygon 		aChordPoly( aRect, aStart, aEnd, POLY_CHORD );

	if ( aChordPoly.GetSize() >= 2 )
	{
		const SalPoint* pPtAry = (const SalPoint*)aChordPoly.GetConstPointAry();
		if ( !mbFillColor )
			mpGraphics->DrawPolyLine( aChordPoly.GetSize(), pPtAry, this );
		else
		{
			if ( mbInitFillColor )
				ImplInitFillColor();
			mpGraphics->DrawPolygon( aChordPoly.GetSize(), pPtAry, this );
		}
	}

    if( mpAlphaVDev )
        mpAlphaVDev->DrawChord( rRect, rStartPt, rEndPt );
}
