package com.sun.star.wizards.tutorial.executer;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertyAccess;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.task.XJob;
import com.sun.star.task.XJobExecutor;
import com.sun.star.uno.Type;
import com.sun.star.wizards.tutorial.creator.frame.Framework;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * This class capsulates the class, that implements the minimal component, a factory for
 * creating the service (<CODE>__getServiceFactory</CODE>) and a method, that writes the
 * information into the given registry key (<CODE>__writeRegistryServiceInfo</CODE>).
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class CallTutorialFramework {
    static boolean bWizardstartedalready;

    /**
     * Gives a factory for creating the service. This method is called by the
     * <code>JavaLoader</code>
     * 
     * <p></p>
     *
     * @param stringImplementationName The implementation name of the component.
     * @param xMSF The service manager, who gives access to every known service.
     * @param xregistrykey Makes structural information (except regarding tree
     *        structures) of a single registry key accessible.
     *
     * @return Returns a <code>XSingleServiceFactory</code> for creating the component.
     *
     * @see com.sun.star.comp.loader.JavaLoader#
     */
    public static XSingleServiceFactory __getServiceFactory(String stringImplementationName, XMultiServiceFactory xMSF, XRegistryKey xregistrykey) {
        XSingleServiceFactory xsingleservicefactory = null;

        if (stringImplementationName.equals(TutorialFrameworkImplementation.class.getName())) {
            xsingleservicefactory = FactoryHelper.getServiceFactory(TutorialFrameworkImplementation.class, TutorialFrameworkImplementation.__serviceName, xMSF, xregistrykey);
        }

        return xsingleservicefactory;
    }

    /**
     * Writes the service information into the given registry key. This method is called
     * by the <code>JavaLoader</code>.
     *
     * @param xregistrykey Makes structural information (except regarding tree
     *        structures) of a single registry key accessible.
     *
     * @return returns true if the operation succeeded
     *
     * @see com.sun.star.comp.loader.JavaLoader#
     */
    public static boolean __writeRegistryServiceInfo(XRegistryKey xregistrykey) {
        return FactoryHelper.writeRegistryServiceInfo(TutorialFrameworkImplementation.class.getName(), TutorialFrameworkImplementation.__serviceName, xregistrykey);
    }

    /**
     * This class implements the component. At least the interfaces XServiceInfo,
     * XTypeProvider, and XInitialization should be provided by the service.
     */
    public static class TutorialFrameworkImplementation implements XInitialization, XTypeProvider, XServiceInfo, XJob, XJobExecutor, XPropertyAccess {
        public Helper m_helper = null;
        public ExecuteCache m_executeCache = null;
        public ExecutePropertiesMethod m_executePropertiesMethod = null;

        /**
         * The constructor of the inner class has a XMultiServiceFactory parameter.
         *
         * @param xmultiservicefactoryInitialization A special service factory could be
         *        introduced while initializing.
         */
        public TutorialFrameworkImplementation(XMultiServiceFactory xmultiservicefactoryInitialization) {
            xmultiservicefactory = xmultiservicefactoryInitialization;

            if (xmultiservicefactory != null) {
                m_helper = new Helper(xmultiservicefactory);
                LocalisationCache.initialize(m_helper);

                try {
                    m_executeCache = new ExecuteCache(m_helper);
                    m_executeCache.setPriority(Thread.MAX_PRIORITY);
                    m_executeCache.start();
                    m_executePropertiesMethod = new ExecutePropertiesMethod(m_helper);
                } catch (java.lang.Exception ex) {
                }
            }
        }

        /**
         * Execute Tutorial - Creator
         *
         * @param str only valid parameter is 'StartTutorialCreator' at the moment.
         */
        public void trigger(String str) {
            if (str.equalsIgnoreCase("StartTutorialCreator")) {
                Thread thread = new Thread(new Runnable() {
                    public void run() {
                        new Framework(xmultiservicefactory);
                    }
                });
                thread.setPriority(Thread.MAX_PRIORITY);
                thread.start();
            }
        }

        /**
         * Get properties in form of an array
         *
         * @return Properties
         */
        public com.sun.star.beans.PropertyValue[] getPropertyValues() {
            return m_executePropertiesMethod.getPropertyValues();
        }

        /**
         * Set properties for the tutorial executor
         *
         * @param propertyValue
         *
         * @throws com.sun.star.beans.UnknownPropertyException
         * @throws com.sun.star.beans.PropertyVetoException
         * @throws com.sun.star.lang.IllegalArgumentException
         * @throws com.sun.star.lang.WrappedTargetException
         */
        public void setPropertyValues(com.sun.star.beans.PropertyValue[] propertyValue) throws com.sun.star.beans.UnknownPropertyException, com.sun.star.beans.PropertyVetoException, com.sun.star.lang.IllegalArgumentException, com.sun.star.lang.WrappedTargetException {
            m_executePropertiesMethod.setPropertyValues(propertyValue);
        }

        /**
         * Executes commands for the tutorial executor
         *
         * @param commands commands
         *
         * @return Null
         *
         * @throws com.sun.star.lang.IllegalArgumentException
         * @throws com.sun.star.uno.Exception
         */
        public synchronized Object execute(final NamedValue[] commands) throws com.sun.star.lang.IllegalArgumentException, com.sun.star.uno.Exception {
            //Helper.log("connected :" + m_helper.isConnected());            
            Helper.log("CAll INSERT");

            if ((commands != null) && (commands.length > 0)) {
                new Thread(new Runnable() {
                    public void run() {
                        execute_commands(commands);
                    }
                }).start();
            }

            Helper.log("Call Exit");

            return null;
        }

        /**
         * DOCUMENT ME!
         *
         * @param commands DOCUMENT ME!
         */
        private void execute_commands(NamedValue[] commands) {
            Control.setBreakControl(false);

            String macroName = "";
            String executeForm = "Name";
            String debug = "False";
            String localisation = "";
            NamedValue[] properties = null;

            if (commands[0].Name.equalsIgnoreCase("Properties")) {
                properties = (NamedValue[]) commands[0].Value;

                if (properties.length > 0) {
                    for (int i = 0; i < properties.length; i++) {
                        NamedValue namedValue = (NamedValue) properties[i];

                        if (namedValue.Name.equalsIgnoreCase("MacroName")) {
                            macroName = (String) namedValue.Value;
                        } else if (namedValue.Name.equalsIgnoreCase("ExecuteForm")) {
                            executeForm = (String) namedValue.Value;
                        } else if (namedValue.Name.equalsIgnoreCase("Debug")) {
                            debug = (String) namedValue.Value;
                        }
                    }
                }
            } else if (commands[0].Name.equalsIgnoreCase("Localisation")) {
                properties = (NamedValue[]) commands[0].Value;

                if (properties.length > 0) {
                    for (int i = 0; i < properties.length; i++) {
                        NamedValue namedValue = (NamedValue) properties[i];

                        if (namedValue.Name.equalsIgnoreCase("MacroName")) {
                            macroName = (String) namedValue.Value;
                        } else if (namedValue.Name.equalsIgnoreCase("ExecuteForm")) {
                            executeForm = "Index"; //(String)namedValue.Value;
                        } else if (namedValue.Name.equalsIgnoreCase("Debug")) {
                            debug = (String) namedValue.Value;
                        } else if (namedValue.Name.equalsIgnoreCase("Localisation")) {
                            localisation = (String) namedValue.Value;
                        }
                    }
                }
            } else {

                return;
            }

            Helper.log(" ********************************");
            Helper.log("macroName : " + macroName);
            Helper.log("executeForm : " + executeForm);
            Helper.log("localisation : " + localisation);
            Helper.log(" ********************************");

            if (debug.equalsIgnoreCase("True")) {
                Helper.setLogState(true);
            }

            if (localisation.equalsIgnoreCase("True")) {
                execute_Localisation(macroName);
            } else if (executeForm.equalsIgnoreCase("Name")) {
                execute_name(commands);
            } else if (executeForm.equalsIgnoreCase("Index")) {
                execute_index(commands);
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param commands DOCUMENT ME!
         */
        private void execute_name(final NamedValue[] commands) {
            Helper.log("execute_name");

            try {
                AccessibilityTools.setSearchForm(AccessibilityTools.SERCH_FORM_NAME);
                m_executeCache.put(commands);
            } catch (Exception ex) {
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param commands DOCUMENT ME!
         */
        private void execute_index(final NamedValue[] commands) {
            Helper.log("execute_index");

            try {
                AccessibilityTools.setSearchForm(AccessibilityTools.SERCH_FORM_INDEX);
                m_executeCache.put(commands);
            } catch (Exception ex) {
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param macroName DOCUMENT ME!
         */
        private void execute_Localisation(String macroName) {
            Helper.log("execute_Localisation");

            try {
                AccessibilityTools.setSearchForm(AccessibilityTools.SERCH_FORM_INDEX);
                LocalisationCache.put(macroName);
            } catch (Exception ex) {
            }
        }

        //*******************************************

        /**
         * The service name, that must be used to get an instance of this service.
         */
        private static final String __serviceName = "com.sun.star.wizards.tutorial.executer.CallTutorialFramework";

        /**
         * The service manager, that gives access to all registered services.
         */
        private XMultiServiceFactory xmultiservicefactory;

        /**
         * This method is a member of the interface for initializing an object directly
         * after its creation.
         *
         * @param object This array of arbitrary objects will be passed to the component
         *        after its creation.
         *
         * @throws com.sun.star.uno.Exception Every exception will not be handled, but
         *         will be passed to the caller.
         */
        public void initialize(Object[] object) throws com.sun.star.uno.Exception {
            bWizardstartedalready = true;
        }

        /**
         * This method returns an array of all supported service names.
         *
         * @return Array of supported service names.
         */
        public java.lang.String[] getSupportedServiceNames() {
            String[] stringSupportedServiceNames = new String[1];
            stringSupportedServiceNames[0] = __serviceName;

            return (stringSupportedServiceNames);
        }

        /**
         * This method returns true, if the given service will be supported by the
         * component.
         *
         * @param stringService Service name.
         *
         * @return True, if the given service name will be supported.
         */
        public boolean supportsService(String stringService) {
            boolean booleanSupportsService = false;

            if (stringService.equals(__serviceName)) {
                booleanSupportsService = true;
            }

            return (booleanSupportsService);
        }

        /**
         * This method returns an array of bytes, that can be used to unambiguously
         * distinguish between two sets of types, e.g. to realise hashing functionality
         * when the object is introspected. Two objects that return the same ID also
         * have to return the same set of types in getTypes(). If an unique
         * implementation Id cannot be provided this method has to return an empty
         * sequence. Important: If the object aggregates other objects the ID has to be
         * unique for the whole combination of objects.
         *
         * @return Array of bytes, in order to distinguish between two sets.
         */
        public byte[] getImplementationId() {
            byte[] byteReturn = {
            };

            try {
                byteReturn = ("" + this.hashCode()).getBytes();
            } catch (Exception exception) {
                System.err.println(exception);
            }

            return (byteReturn);
        }

        /**
         * Return the class name of the component.
         *
         * @return Class name of the component.
         */
        public java.lang.String getImplementationName() {
            return (TutorialFrameworkImplementation.class.getName());
        }

        /**
         * Provides a sequence of all types (usually interface types) provided by the
         * object.
         *
         * @return Sequence of all types (usually interface types) provided by the
         *         service.
         */
        public com.sun.star.uno.Type[] getTypes() {
            Type[] typeReturn = {
            };

            try {
                typeReturn = new Type[] { new Type(XPropertyAccess.class), new Type(XJob.class), new Type(XJobExecutor.class), new Type(XTypeProvider.class), new Type(XServiceInfo.class), new Type(XInitialization.class)};
            } catch (Exception exception) {
                System.err.println(exception);
            }

            return (typeReturn);
        }
    }
}
