/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undoblk.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:26:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_UNDOBLK_HXX
#define SC_UNDOBLK_HXX

#ifndef SC_UNDOBASE_HXX
#include "undobase.hxx"
#endif
#ifndef SC_MARKDATA_HXX
#include "markdata.hxx"
#endif
namespace binfilter {

class ScDocShell;
class ScDocument;
class ScOutlineTable;
class ScRangeName;
class ScRangeList;
class ScDBCollection;
class ScPatternAttr;
class SvxBoxItem;
class SvxBoxInfoItem;
class SvxSearchItem;
class SdrUndoAction;

//----------------------------------------------------------------------------

//STRIP001 class ScUndoInsertCells: public ScMoveUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoInsertCells( ScDocShell* pNewDocShell,
//STRIP001 									   const ScRange& rRange, InsCellCmd eNewCmd,
//STRIP001 									   ScDocument* pUndoDocument, ScRefUndoData* pRefData,
//STRIP001 									   BOOL bNewPartOfPaste );
//STRIP001 	virtual			~ScUndoInsertCells();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat( SfxRepeatTarget& rTarget );
//STRIP001 	virtual BOOL	CanRepeat( SfxRepeatTarget& rTarget ) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 	virtual BOOL	Merge( SfxUndoAction *pNextAction );
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aEffRange;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	InsCellCmd		eCmd;
//STRIP001 	BOOL			bPartOfPaste;
//STRIP001 	SfxUndoAction*	pPasteUndo;
//STRIP001 
//STRIP001 	void			DoChange ( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoDeleteCells: public ScMoveUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoDeleteCells( ScDocShell* pNewDocShell,
//STRIP001 									   const ScRange& rRange, DelCellCmd eNewCmd,
//STRIP001 									   ScDocument* pUndoDocument, ScRefUndoData* pRefData );
//STRIP001 	virtual 		~ScUndoDeleteCells();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aEffRange;
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	DelCellCmd		eCmd;
//STRIP001 
//STRIP001 	void			DoChange ( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoDeleteMulti: public ScMoveUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoDeleteMulti( ScDocShell* pNewDocShell,
//STRIP001 									   BOOL bNewRows, USHORT nNewTab,
//STRIP001 									   const USHORT* pRng, USHORT nRngCnt,
//STRIP001 									   ScDocument* pUndoDocument, ScRefUndoData* pRefData );
//STRIP001 	virtual			~ScUndoDeleteMulti();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	BOOL			bRows;
//STRIP001 	USHORT			nTab;
//STRIP001 	USHORT*			pRanges;
//STRIP001 	USHORT			nRangeCnt;
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 
//STRIP001 	void			DoChange() const;
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoCut: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoCut( ScDocShell* pNewDocShell,
//STRIP001 							   ScRange aRange,		// incl. Merge
//STRIP001 							   ScAddress aOldEnd,	// Ende ohne Merge
//STRIP001 							   ScDocument* pNewUndoDoc );
//STRIP001 	virtual			~ScUndoCut();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	ScRange			aExtendedRange;
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 
//STRIP001 	void			DoChange( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


struct ScUndoPasteOptions
{
	USHORT nFunction;
	BOOL bSkipEmpty;
	BOOL bTranspose;
	BOOL bAsLink;
	InsCellCmd eMoveMode;

	ScUndoPasteOptions() :
		nFunction( PASTE_NOFUNC ),
		bSkipEmpty( FALSE ),
		bTranspose( FALSE ),
		bAsLink( FALSE ),
		eMoveMode( INS_NONE )
	{}
};

class ScUndoPaste: public ScBlockUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoPaste( ScDocShell* pNewDocShell,
								 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
								 USHORT nEndX, USHORT nEndY, USHORT nEndZ,
								 const ScMarkData& rMark,
								 ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc,
								 USHORT nNewFlags,
								 ScRefUndoData* pRefData, void* pFill1, void* pFill2, void* pFill3, 
								 BOOL bRedoIsFilled = TRUE,
								 const ScUndoPasteOptions* pOptions = NULL );
	virtual 		~ScUndoPaste();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
private:
	ScMarkData		aMarkData;
	ScDocument*		pUndoDoc;
	ScDocument*		pRedoDoc;
	USHORT			nFlags;
	ScRefUndoData*	pRefUndoData;
	ScRefUndoData*	pRefRedoData;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;
	BOOL			bRedoFilled;
	ScUndoPasteOptions aPasteOptions;

//STRIP001 	void			DoChange( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
};


//STRIP001 class ScUndoDragDrop: public ScMoveUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoDragDrop( ScDocShell* pNewDocShell,
//STRIP001 									const ScRange& rRange, ScAddress aNewDestPos, BOOL bNewCut,
//STRIP001 									ScDocument* pUndoDocument, ScRefUndoData* pRefData,
//STRIP001 									BOOL bScenario );
//STRIP001 	virtual 		~ScUndoDragDrop();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aSrcRange;
//STRIP001 	ScRange			aDestRange;
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	BOOL			bCut;
//STRIP001 	BOOL			bKeepScenarioFlags;
//STRIP001 
//STRIP001 	void			PaintArea( ScRange aRange ) const;
//STRIP001 	void			DoUndo( ScRange aRange ) const;
//STRIP001 
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoDeleteContents: public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoDeleteContents( ScDocShell* pNewDocShell,
//STRIP001 										  const ScMarkData& rMark,
//STRIP001 										  const ScRange& rRange,
//STRIP001 										  ScDocument* pNewUndoDoc, BOOL bNewMulti,
//STRIP001 										  USHORT nNewFlags, BOOL bObjects );
//STRIP001 	virtual 		~ScUndoDeleteContents();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aRange;
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;		// Blockmarkierung und geloeschte Daten
//STRIP001 	SdrUndoAction*	pDrawUndo;		// geloeschte Objekte
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	USHORT			nFlags;
//STRIP001 	BOOL			bMulti;			// Mehrfachselektion
//STRIP001 
//STRIP001 	void			DoChange( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoFillTable: public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoFillTable( ScDocShell* pNewDocShell,
//STRIP001 									 const ScMarkData& rMark,
//STRIP001 									 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 									 USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 									 ScDocument* pNewUndoDoc, BOOL bNewMulti, USHORT nSrc,
//STRIP001 									 USHORT nFlg, USHORT nFunc, BOOL bSkip, BOOL bLink );
//STRIP001 	virtual			~ScUndoFillTable();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aRange;
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;		// Blockmarkierung und geloeschte Daten
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	USHORT			nFlags;
//STRIP001 	USHORT			nFunction;
//STRIP001 	USHORT			nSrcTab;
//STRIP001 	BOOL			bMulti;			// Mehrfachselektion
//STRIP001 	BOOL			bSkipEmpty;
//STRIP001 	BOOL			bAsLink;
//STRIP001 
//STRIP001 	void			DoChange( const BOOL bUndo );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


class ScUndoSelectionAttr: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoSelectionAttr( ScDocShell* pNewDocShell,
										 const ScMarkData& rMark,
										 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
										 USHORT nEndX, USHORT nEndY, USHORT nEndZ,
										 ScDocument* pNewUndoDoc, BOOL bNewMulti,
										 const ScPatternAttr* pNewApply,
										 const SvxBoxItem* pNewOuter = NULL,
										 const SvxBoxInfoItem* pNewInner = NULL );
	virtual 		~ScUndoSelectionAttr();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScMarkData		aMarkData;
	ScRange			aRange;
	ScDocument*		pUndoDoc;
	BOOL			bMulti;
	ScPatternAttr*	pApplyPattern;
	SvxBoxItem*		pLineOuter;
	SvxBoxInfoItem*	pLineInner;

//STRIP001 	void			DoChange( const BOOL bUndo );
};


class ScUndoWidthOrHeight: public ScSimpleUndo
{
public:
							TYPEINFO();
							ScUndoWidthOrHeight( ScDocShell* pNewDocShell,
									const ScMarkData& rMark,
									USHORT nNewStart, USHORT nNewStartTab,
									USHORT nNewEnd, USHORT nNewEndTab,
									ScDocument* pNewUndoDoc,
									USHORT nNewCnt, USHORT* pNewRanges,
									ScOutlineTable* pNewUndoTab,
									ScSizeMode eNewMode, USHORT nNewSizeTwips,
									BOOL bNewWidth );
	virtual 				~ScUndoWidthOrHeight();

//STRIP001 	virtual void			Undo();
//STRIP001 	virtual void			Redo();
//STRIP001 	virtual void			Repeat(SfxRepeatTarget& rTarget);
	virtual BOOL			CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String          GetComment() const;

private:
	ScMarkData		aMarkData;
	USHORT			nStart;
	USHORT			nEnd;
	USHORT			nStartTab;
	USHORT			nEndTab;
	ScDocument*		pUndoDoc;
	ScOutlineTable*	pUndoTab;
	USHORT			nRangeCnt;
	USHORT*			pRanges;
	USHORT			nNewSize;
	BOOL			bWidth;
	ScSizeMode		eMode;
	SdrUndoAction*	pDrawUndo;
};


//STRIP001 class ScUndoAutoFill: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoAutoFill( ScDocShell* pNewDocShell,
//STRIP001 									const ScRange& rRange, const ScRange& rSourceArea,
//STRIP001 									ScDocument* pNewUndoDoc, const ScMarkData& rMark,
//STRIP001 									FillDir eNewFillDir,
//STRIP001 									FillCmd eNewFillCmd, FillDateCmd eNewFillDateCmd,
//STRIP001 									double fNewStartValue, double fNewStepValue, double fNewMaxValue,
//STRIP001 									USHORT nMaxShIndex );
//STRIP001 	virtual 		~ScUndoAutoFill();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aSource;
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	FillDir			eFillDir;
//STRIP001 	FillCmd			eFillCmd;
//STRIP001 	FillDateCmd		eFillDateCmd;
//STRIP001 	double			fStartValue;
//STRIP001 	double			fStepValue;
//STRIP001 	double			fMaxValue;
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 	USHORT			nMaxSharedIndex;
//STRIP001 
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


class ScUndoMerge: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoMerge( ScDocShell* pNewDocShell,
								 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
								 USHORT nEndX,   USHORT nEndY,   USHORT nEndZ,
								 BOOL bNewDoMerge, ScDocument* pNewUndoDoc = NULL );
	virtual 		~ScUndoMerge();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScRange			aRange;
	BOOL			bDoMerge;				// Merge oder aufheben
	ScDocument*		pUndoDoc;				// wenn Daten zusammengefasst

//STRIP001 	void			DoChange( const BOOL bUndo ) const;
};


//STRIP001 class ScUndoAutoFormat: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoAutoFormat( ScDocShell* pNewDocShell,
//STRIP001 									  const ScRange& rRange, ScDocument* pNewUndoDoc,
//STRIP001 									  const ScMarkData& rMark,
//STRIP001 									  BOOL bNewSize, USHORT nNewFormatNo );
//STRIP001 	virtual 		~ScUndoAutoFormat();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScDocument*		pUndoDoc;		// geloeschte Daten
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	BOOL			bSize;
//STRIP001 	USHORT			nFormatNo;
//STRIP001 };


class ScUndoReplace: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoReplace( ScDocShell* pNewDocShell,
								   const ScMarkData& rMark,
								   USHORT nCurX, USHORT nCurY, USHORT nCurZ,
								   const String& rNewUndoStr, ScDocument* pNewUndoDoc,
								   const SvxSearchItem* pItem );
	virtual 		~ScUndoReplace();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

//STRIP001 	virtual String	GetComment() const;

private:
	ScTripel		aCursorPos;
	ScMarkData		aMarkData;
	String			aUndoStr;			// Daten bei Einfachmarkierung
	ScDocument*		pUndoDoc;			// Blockmarkierung und geloeschte Daten
	SvxSearchItem*	pSearchItem;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;

//STRIP001 			void	SetChangeTrack();
};


//STRIP001 class ScUndoTabOp: public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoTabOp( ScDocShell* pNewDocShell,
//STRIP001 								 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 								 USHORT nEndX,   USHORT nEndY,   USHORT nEndZ,
//STRIP001 								 ScDocument* pNewUndoDoc,
//STRIP001 								 const ScRefTripel& rFormulaCell,
//STRIP001 								 const ScRefTripel& rFormulaEnd,
//STRIP001 								 const ScRefTripel& rRowCell,
//STRIP001 								 const ScRefTripel& rColCell,
//STRIP001 								 BYTE nMode );
//STRIP001 	virtual			~ScUndoTabOp();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScRange			aRange;
//STRIP001 	ScDocument*		pUndoDoc;		// geloeschte Daten
//STRIP001 	ScRefTripel		theFormulaCell;
//STRIP001 	ScRefTripel		theFormulaEnd;
//STRIP001 	ScRefTripel		theRowCell;
//STRIP001 	ScRefTripel		theColCell;
//STRIP001 	BYTE			nMode;
//STRIP001 };


//STRIP001 class ScUndoSpelling: public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoSpelling( ScDocShell* pNewDocShell,
//STRIP001 									const ScMarkData& rMark,
//STRIP001 									USHORT nCurX, USHORT nCurY, USHORT nCurZ,
//STRIP001 									ScDocument* pNewUndoDoc,
//STRIP001 									USHORT nNewX, USHORT nNewY, USHORT nNewZ,
//STRIP001 									ScDocument* pNewRedoDoc);
//STRIP001 	virtual 		~ScUndoSpelling();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScTripel		aCursorPos;
//STRIP001 	ScDocument*		pUndoDoc;			// Blockmarkierung und geloeschte Daten
//STRIP001 	ScTripel		aNewCursorPos;
//STRIP001 	ScDocument*		pRedoDoc;			// Blockmarkierung und neue Daten
//STRIP001 	ULONG			nStartChangeAction;
//STRIP001 	ULONG			nEndChangeAction;
//STRIP001 
//STRIP001 	void			DoChange( ScDocument* pRefDoc, const ScTripel& rCursorPos );
//STRIP001 	void			SetChangeTrack();
//STRIP001 };


//STRIP001 class ScUndoListNames: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoListNames( ScDocShell* pNewDocShell,
//STRIP001 									 const ScRange& rRange,
//STRIP001 									 ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc );
//STRIP001 	virtual 		~ScUndoListNames();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	ScDocument*		pRedoDoc;
//STRIP001 
//STRIP001 	void			DoChange( ScDocument* pSrcDoc ) const;
//STRIP001 };


//STRIP001 class ScUndoUseScenario: public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 							TYPEINFO();
//STRIP001 							ScUndoUseScenario( ScDocShell* pNewDocShell,
//STRIP001 									const ScMarkData& rMark,
//STRIP001 									const ScArea& rDestArea, ScDocument* pNewUndoDoc,
//STRIP001 									const String& rNewName );
//STRIP001 	virtual 				~ScUndoUseScenario();
//STRIP001 
//STRIP001 	virtual void			Undo();
//STRIP001 	virtual void			Redo();
//STRIP001 	virtual void			Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL			CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String          GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	ScRange			aRange;
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	String			aName;
//STRIP001 };


class ScUndoSelectionStyle: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoSelectionStyle( ScDocShell* pNewDocShell,
										  const ScMarkData& rMark,
										  const ScRange& rRange,
										  const String& rName,
										  ScDocument* pNewUndoDoc );
	virtual 		~ScUndoSelectionStyle();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;
//STRIP001 	virtual USHORT	GetId() const;

private:
	ScMarkData		aMarkData;
	ScDocument*		pUndoDoc;
	String			aStyleName;
	ScRange			aRange;

//STRIP001 	void			DoChange( const BOOL bUndo );
};


class ScUndoRefreshLink: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoRefreshLink( ScDocShell* pNewDocShell,
									   ScDocument* pNewUndoDoc );
	virtual 		~ScUndoRefreshLink();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;

private:
	ScDocument*		pUndoDoc;
	ScDocument*		pRedoDoc;
};


class ScUndoEnterMatrix: public ScBlockUndo
{
public:
					TYPEINFO();
					ScUndoEnterMatrix( ScDocShell* pNewDocShell,
									   const ScRange& rArea,
									   ScDocument* pNewUndoDoc,
									   const String& rForm );
	virtual 		~ScUndoEnterMatrix();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScDocument*		pUndoDoc;
	String			aFormula;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;

	void			SetChangeTrack();
};


//STRIP001 class ScUndoInsertAreaLink : public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoInsertAreaLink( ScDocShell* pShell,
//STRIP001 										  const String& rDoc,
//STRIP001 										  const String& rFlt, const String& rOpt,
//STRIP001 										  const String& rArea, const ScRange& rDestRange,
//STRIP001 										  ULONG nRefreshDelay );
//STRIP001 	virtual			~ScUndoInsertAreaLink();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	String			aDocName;
//STRIP001 	String			aFltName;
//STRIP001 	String			aOptions;
//STRIP001 	String			aAreaName;
//STRIP001 	ScRange			aRange;
//STRIP001 	ULONG			nRefreshDelay;
//STRIP001 };


//STRIP001 class ScUndoRemoveAreaLink : public ScSimpleUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoRemoveAreaLink( ScDocShell* pShell,
//STRIP001 										  const String& rDoc,
//STRIP001 										  const String& rFlt, const String& rOpt,
//STRIP001 										  const String& rArea, const ScRange& rDestRange,
//STRIP001 										  ULONG nRefreshDelay );
//STRIP001 	virtual			~ScUndoRemoveAreaLink();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	String			aDocName;
//STRIP001 	String			aFltName;
//STRIP001 	String			aOptions;
//STRIP001 	String			aAreaName;
//STRIP001 	ScRange			aRange;
//STRIP001 	ULONG			nRefreshDelay;
//STRIP001 };


//STRIP001 class ScUndoUpdateAreaLink : public ScSimpleUndo		//! auch BlockUndo umstellen?
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoUpdateAreaLink( ScDocShell* pShell,
//STRIP001 										  const String& rOldD,
//STRIP001 										  const String& rOldF, const String& rOldO,
//STRIP001 										  const String& rOldA, const ScRange& rOldR,
//STRIP001 										  ULONG nOldRD,
//STRIP001 										  const String& rNewD,
//STRIP001 										  const String& rNewF, const String& rNewO,
//STRIP001 										  const String& rNewA, const ScRange& rNewR,
//STRIP001 										  ULONG nNewRD,
//STRIP001 										  ScDocument* pUndo, ScDocument* pRedo,
//STRIP001 										  BOOL bDoInsert );
//STRIP001 	virtual			~ScUndoUpdateAreaLink();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	String			aOldDoc;
//STRIP001 	String			aOldFlt;
//STRIP001 	String			aOldOpt;
//STRIP001 	String			aOldArea;
//STRIP001 	ScRange			aOldRange;
//STRIP001 	String			aNewDoc;
//STRIP001 	String			aNewFlt;
//STRIP001 	String			aNewOpt;
//STRIP001 	String			aNewArea;
//STRIP001 	ScRange			aNewRange;
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	ScDocument*		pRedoDoc;
//STRIP001 	ULONG			nOldRefresh;
//STRIP001 	ULONG			nNewRefresh;
//STRIP001 	BOOL			bWithInsert;
//STRIP001 
//STRIP001 	void			DoChange( const BOOL bUndo ) const;
//STRIP001 };


//STRIP001 class ScUndoIndent: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoIndent( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 									ScDocument* pNewUndoDoc, BOOL bIncrement );
//STRIP001 	virtual 		~ScUndoIndent();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	BOOL			bIsIncrement;
//STRIP001 };


//STRIP001 class ScUndoTransliterate: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoTransliterate( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 										ScDocument* pNewUndoDoc, sal_Int32 nType );
//STRIP001 	virtual 		~ScUndoTransliterate();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	sal_Int32		nTransliterationType;
//STRIP001 };


//STRIP001 class ScUndoClearItems: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoClearItems( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 										ScDocument* pNewUndoDoc, const USHORT* pW );
//STRIP001 	virtual 		~ScUndoClearItems();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScMarkData		aMarkData;
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 	USHORT*			pWhich;
//STRIP001 };


class ScUndoRemoveBreaks: public ScSimpleUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoRemoveBreaks( ScDocShell* pNewDocShell,
									USHORT nNewTab, ScDocument* pNewUndoDoc );
	virtual 		~ScUndoRemoveBreaks();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;

private:
	USHORT			nTab;
	ScDocument*		pUndoDoc;
};


//STRIP001 class ScUndoRemoveMerge: public ScBlockUndo
//STRIP001 {
//STRIP001 public:
//STRIP001 					TYPEINFO();
//STRIP001 					ScUndoRemoveMerge( ScDocShell* pNewDocShell,
//STRIP001 									   const ScRange& rArea,
//STRIP001 									   ScDocument* pNewUndoDoc );
//STRIP001 	virtual 		~ScUndoRemoveMerge();
//STRIP001 
//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;
//STRIP001 
//STRIP001 	virtual String	GetComment() const;
//STRIP001 
//STRIP001 private:
//STRIP001 	ScDocument*		pUndoDoc;
//STRIP001 };


class ScUndoBorder: public ScBlockUndo
{
public:
//STRIP001 					TYPEINFO();
					ScUndoBorder( ScDocShell* pNewDocShell,
									const ScRangeList& rRangeList,
									ScDocument* pNewUndoDoc,
									const SvxBoxItem& rNewOuter,
									const SvxBoxInfoItem& rNewInner );
	virtual 		~ScUndoBorder();

//STRIP001 	virtual void	Undo();
//STRIP001 	virtual void	Redo();
//STRIP001 	virtual void	Repeat(SfxRepeatTarget& rTarget);
//STRIP001 	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

//STRIP001 	virtual String	GetComment() const;

private:
	ScDocument*		pUndoDoc;
	ScRangeList*	pRanges;
	SvxBoxItem*		pOuter;
	SvxBoxInfoItem*	pInner;
};




} //namespace binfilter
#endif

