/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undocell.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:06:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/editobj.hxx>
// auto strip #include <svtools/zforlist.hxx>
// auto strip #include <bf_sfx2/app.hxx>

#include "undocell.hxx"
// auto strip #include "document.hxx"
// auto strip #include "docpool.hxx"
// auto strip #include "patattr.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
#include "cell.hxx"
// auto strip #include "target.hxx"
#include "undoolk.hxx"
// auto strip #include "detdata.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "printfun.hxx"
#include "rangenam.hxx"
// auto strip #include "chgtrack.hxx"
#include "bf_sc.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1(ScUndoCursorAttr, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoEnterData, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoEnterValue, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoPutCell, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoPageBreak, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoPrintZoom, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoThesaurus, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoNote, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoEditNote, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoDetective, ScSimpleUndo);
//STRIP001 TYPEINIT1(ScUndoRangeNames, ScSimpleUndo);


// -----------------------------------------------------------------------
//
//		Attribute auf Cursor anwenden
//

//STRIP001 ScUndoCursorAttr::ScUndoCursorAttr( ScDocShell* pNewDocShell,
//STRIP001 			USHORT nNewCol, USHORT nNewRow, USHORT nNewTab,
//STRIP001 			const ScPatternAttr* pOldPat, const ScPatternAttr* pNewPat,
//STRIP001 			const ScPatternAttr* pApplyPat, BOOL bAutomatic ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nCol( nNewCol ),
//STRIP001 	nRow( nNewRow ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	bIsAutomatic( bAutomatic )
//STRIP001 {
//STRIP001 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
//STRIP001 	pNewPattern = (ScPatternAttr*) &pPool->Put( *pNewPat );
//STRIP001 	pOldPattern = (ScPatternAttr*) &pPool->Put( *pOldPat );
//STRIP001 	pApplyPattern = (ScPatternAttr*) &pPool->Put( *pApplyPat );
//STRIP001 }

//STRIP001 __EXPORT ScUndoCursorAttr::~ScUndoCursorAttr()
//STRIP001 {
//STRIP001 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
//STRIP001 	pPool->Remove(*pNewPattern);
//STRIP001 	pPool->Remove(*pOldPattern);
//STRIP001 	pPool->Remove(*pApplyPattern);
//STRIP001 }

//STRIP001 String __EXPORT ScUndoCursorAttr::GetComment() const
//STRIP001 {
//STRIP001 	//!	eigener Text fuer automatische Attributierung
//STRIP001 
//STRIP001 	USHORT nId = STR_UNDO_CURSORATTR;		 // "Attribute"
//STRIP001 	return ScGlobal::GetRscString( nId );
//STRIP001 }

//STRIP001 void ScUndoCursorAttr::DoChange( const ScPatternAttr* pWhichPattern ) const
//STRIP001 {
//STRIP001 	pDocShell->GetDocument()->SetPattern( nCol, nRow, nTab, *pWhichPattern, TRUE );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 		pViewShell->MoveCursorAbs( nCol, nRow, SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 		pViewShell->AdjustBlockHeight();
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxItemSet& rApplySet = pApplyPattern->GetItemSet();
//STRIP001 	BOOL bPaintExt = ( rApplySet.GetItemState( ATTR_SHADOW, TRUE ) != SFX_ITEM_DEFAULT ||
//STRIP001 					   rApplySet.GetItemState( ATTR_CONDITIONAL, TRUE ) != SFX_ITEM_DEFAULT );
//STRIP001 
//STRIP001 	USHORT nFlags = SC_PF_TESTMERGE;
//STRIP001 	if (bPaintExt)
//STRIP001 		nFlags |= SC_PF_LINES;
//STRIP001 	pDocShell->PostPaint( nCol,nRow,nTab, nCol,nRow,nTab, PAINT_GRID, nFlags );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCursorAttr::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange(pOldPattern);
//STRIP001 
//STRIP001 	if ( bIsAutomatic )
//STRIP001 	{
//STRIP001 		//	wenn automatische Formatierung rueckgaengig gemacht wird,
//STRIP001 		//	soll auch nicht weiter automatisch formatiert werden:
//STRIP001 
//STRIP001 		ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->ForgetFormatArea();
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCursorAttr::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange(pNewPattern);
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCursorAttr::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->ApplySelectionPattern( *pApplyPattern );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoCursorAttr::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Daten eingeben
//

//STRIP001 ScUndoEnterData::ScUndoEnterData( ScDocShell* pNewDocShell,
//STRIP001 			USHORT nNewCol, USHORT nNewRow, USHORT nNewTab,
//STRIP001 			USHORT nNewCount, USHORT* pNewTabs, ScBaseCell** ppOldData,
//STRIP001 			BOOL* pHasForm, ULONG* pOldForm,
//STRIP001 			const String& rNewStr, EditTextObject* pObj ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nCol( nNewCol ),
//STRIP001 	nRow( nNewRow ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	nCount( nNewCount ),
//STRIP001 	pTabs( pNewTabs ),
//STRIP001 	ppOldCells( ppOldData ),
//STRIP001 	pHasFormat( pHasForm ),
//STRIP001 	pOldFormats( pOldForm ),
//STRIP001 	aNewString( rNewStr ),
//STRIP001 	pNewEditData( pObj )
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoEnterData::~ScUndoEnterData()
//STRIP001 {
//STRIP001 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
//STRIP001 
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 		if (ppOldCells[i])
//STRIP001 			ppOldCells[i]->Delete();
//STRIP001 	delete[] ppOldCells;
//STRIP001 
//STRIP001 	delete[] pHasFormat;
//STRIP001 	delete[] pOldFormats;
//STRIP001 	delete[] pTabs;
//STRIP001 
//STRIP001 	delete pNewEditData;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoEnterData::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_ENTERDATA ); // "Eingabe"
//STRIP001 }

//STRIP001 void ScUndoEnterData::DoChange() const
//STRIP001 {
//STRIP001 	//	Zeilenhoehe anpassen
//STRIP001 	//!	nur wenn noetig (alte oder neue EditZelle, oder Attribute) ??
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 		pDocShell->AdjustRowHeight( nRow, nRow, pTabs[i] );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 		pViewShell->MoveCursorAbs( nCol, nRow, SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 }

//STRIP001 void ScUndoEnterData::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		nEndChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		ScAddress aPos( nCol, nRow, nTab );
//STRIP001 		for (USHORT i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			aPos.SetTab( pTabs[i] );
//STRIP001 			ULONG nFormat = 0;
//STRIP001 			if ( pHasFormat && pOldFormats )
//STRIP001 			{
//STRIP001 				if ( pHasFormat[i] )
//STRIP001 					nFormat = pOldFormats[i];
//STRIP001 			}
//STRIP001 			pChangeTrack->AppendContent( aPos, ppOldCells[i], nFormat );
//STRIP001 		}
//STRIP001 		if ( nEndChangeAction > pChangeTrack->GetActionMax() )
//STRIP001 			nEndChangeAction = 0;		// nichts appended
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterData::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		ScBaseCell* pNewCell;
//STRIP001 		if ( ppOldCells[i] )
//STRIP001 		{
//STRIP001 			// Formelzelle mit CompileTokenArray() !
//STRIP001 			if ( ppOldCells[i]->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 				pNewCell = ((ScFormulaCell*)ppOldCells[i])->Clone( pDoc,
//STRIP001 					ScAddress( nCol, nRow, pTabs[i] ) );
//STRIP001 			else
//STRIP001 				pNewCell = ppOldCells[i]->Clone(pDoc);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pNewCell = NULL;
//STRIP001 		pDoc->PutCell( nCol, nRow, pTabs[i], pNewCell );
//STRIP001 
//STRIP001 		if (pHasFormat && pOldFormats)
//STRIP001 		{
//STRIP001 			if ( pHasFormat[i] )
//STRIP001 				pDoc->ApplyAttr( nCol, nRow, pTabs[i],
//STRIP001 									SfxUInt32Item( ATTR_VALUE_FORMAT, pOldFormats[i] ) );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ScPatternAttr aPattern( *pDoc->GetPattern( nCol, nRow, pTabs[i] ) );
//STRIP001 				aPattern.GetItemSet().ClearItem( ATTR_VALUE_FORMAT );
//STRIP001 				pDoc->SetPattern( nCol, nRow, pTabs[i], aPattern, TRUE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pDocShell->PostPaintCell( nCol, nRow, pTabs[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack && nEndChangeAction >= nCount )
//STRIP001 		pChangeTrack->Undo( nEndChangeAction - nCount + 1, nEndChangeAction );
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterData::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		if (pNewEditData)
//STRIP001 			pDoc->PutCell( nCol, nRow, pTabs[i], new ScEditCell( pNewEditData,
//STRIP001 				pDoc, NULL ) );
//STRIP001 		else
//STRIP001 			pDoc->SetString( nCol, nRow, pTabs[i], aNewString );
//STRIP001 		pDocShell->PostPaintCell( nCol, nRow, pTabs[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterData::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		String aTemp = aNewString;
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->EnterDataAtCursor( aTemp );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoEnterData::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Wert aendern
//

//STRIP001 ScUndoEnterValue::ScUndoEnterValue( ScDocShell* pNewDocShell, const ScAddress& rNewPos,
//STRIP001 									ScBaseCell* pUndoCell, double nVal, BOOL bHeight ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aPos		( rNewPos ),
//STRIP001 	pOldCell	( pUndoCell ),
//STRIP001 	nValue		( nVal ),
//STRIP001 	bNeedHeight	( bHeight )
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoEnterValue::~ScUndoEnterValue()
//STRIP001 {
//STRIP001 	if (pOldCell)
//STRIP001 		pOldCell->Delete();
//STRIP001 }

//STRIP001 String __EXPORT ScUndoEnterValue::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_ENTERDATA ); // "Eingabe"
//STRIP001 }

//STRIP001 void ScUndoEnterValue::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		nEndChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		pChangeTrack->AppendContent( aPos, pOldCell );
//STRIP001 		if ( nEndChangeAction > pChangeTrack->GetActionMax() )
//STRIP001 			nEndChangeAction = 0;		// nichts appended
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterValue::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScBaseCell* pNewCell;
//STRIP001 	if ( pOldCell )
//STRIP001 	{
//STRIP001 		// Formelzelle mit CompileTokenArray() !
//STRIP001 		if ( pOldCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 			pNewCell = ((ScFormulaCell*)pOldCell)->Clone( pDoc, aPos );
//STRIP001 		else
//STRIP001 			pNewCell = pOldCell->Clone(pDoc);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNewCell = NULL;
//STRIP001 
//STRIP001 	pDoc->PutCell( aPos.Col(), aPos.Row(), aPos.Tab(), pNewCell );
//STRIP001 
//STRIP001 	pDocShell->PostPaintCell( aPos.Col(), aPos.Row(), aPos.Tab() );
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nEndChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterValue::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->SetValue( aPos.Col(), aPos.Row(), aPos.Tab(), nValue );
//STRIP001 	pDocShell->PostPaintCell( aPos.Col(), aPos.Row(), aPos.Tab() );
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterValue::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoEnterValue::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Beliebige Zelle eingeben
//

/*N*/ ScUndoPutCell::ScUndoPutCell( ScDocShell* pNewDocShell, const ScAddress& rNewPos,
/*N*/ 							ScBaseCell* pUndoCell, ScBaseCell* pRedoCell, BOOL bHeight ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aPos		( rNewPos ),
/*N*/ 	pOldCell	( pUndoCell ),
/*N*/ 	pEnteredCell( pRedoCell ),
/*N*/ 	bNeedHeight	( bHeight )
/*N*/ {
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoPutCell::~ScUndoPutCell()
/*N*/ {
/*N*/ 	if (pOldCell)
/*N*/ 		pOldCell->Delete();
/*N*/ 	if (pEnteredCell)
/*N*/ 		pEnteredCell->Delete();
/*N*/ }

/*N*/ String __EXPORT ScUndoPutCell::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_ENTERDATA ); // "Eingabe"
/*N*/ }

/*N*/ void ScUndoPutCell::SetChangeTrack()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 nEndChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 /*?*/ 		pChangeTrack->AppendContent( aPos, pOldCell );
//STRIP001 /*?*/ 		if ( nEndChangeAction > pChangeTrack->GetActionMax() )
//STRIP001 /*?*/ 			nEndChangeAction = 0;		// nichts appended
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nEndChangeAction = 0;
/*N*/ }

//STRIP001 void __EXPORT ScUndoPutCell::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScBaseCell* pNewCell;
//STRIP001 	if ( pOldCell )
//STRIP001 	{
//STRIP001 		// Formelzelle mit CompileTokenArray() !
//STRIP001 		if ( pOldCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 			pNewCell = ((ScFormulaCell*)pOldCell)->Clone( pDoc, aPos );
//STRIP001 		else
//STRIP001 			pNewCell = pOldCell->Clone(pDoc);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNewCell = NULL;
//STRIP001 
//STRIP001 	pDoc->PutCell( aPos.Col(), aPos.Row(), aPos.Tab(), pNewCell );
//STRIP001 
//STRIP001 	pDocShell->PostPaintCell( aPos.Col(), aPos.Row(), aPos.Tab() );
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nEndChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPutCell::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 //	pDoc->SetValue( aPos.Col(), aPos.Row(), aPos.Tab(), nValue );
//STRIP001 
//STRIP001 	ScBaseCell* pNewCell;
//STRIP001 	if ( pEnteredCell )
//STRIP001 	{
//STRIP001 		// Formelzelle mit CompileTokenArray() !
//STRIP001 		if ( pEnteredCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 			pNewCell = ((ScFormulaCell*)pEnteredCell)->Clone( pDoc, aPos );
//STRIP001 		else
//STRIP001 			pNewCell = pEnteredCell->Clone(pDoc);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNewCell = NULL;
//STRIP001 
//STRIP001 	pDoc->PutCell( aPos.Col(), aPos.Row(), aPos.Tab(), pNewCell );
//STRIP001 
//STRIP001 	pDocShell->PostPaintCell( aPos.Col(), aPos.Row(), aPos.Tab() );
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPutCell::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoPutCell::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }


// -----------------------------------------------------------------------
//
//		Seitenumbrueche
//

//STRIP001 ScUndoPageBreak::ScUndoPageBreak( ScDocShell* pNewDocShell,
//STRIP001 			USHORT nNewCol, USHORT nNewRow, USHORT nNewTab,
//STRIP001 			BOOL bNewColumn, BOOL bNewInsert ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nCol( nNewCol ),
//STRIP001 	nRow( nNewRow ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	bColumn( bNewColumn ),
//STRIP001 	bInsert( bNewInsert )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoPageBreak::~ScUndoPageBreak()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoPageBreak::GetComment() const
//STRIP001 {
//STRIP001 	//"Spaltenumbruch" | "Zeilenumbruch"  "einfuegen" | "loeschen"
//STRIP001 	return String ( bColumn ?
//STRIP001 		( bInsert ?
//STRIP001 			ScGlobal::GetRscString( STR_UNDO_INSCOLBREAK ) :
//STRIP001 			ScGlobal::GetRscString( STR_UNDO_DELCOLBREAK )
//STRIP001 		) :
//STRIP001 		( bInsert ?
//STRIP001 			ScGlobal::GetRscString( STR_UNDO_INSROWBREAK ) :
//STRIP001 			ScGlobal::GetRscString( STR_UNDO_DELROWBREAK )
//STRIP001 		) );
//STRIP001 }

//STRIP001 void ScUndoPageBreak::DoChange( BOOL bInsert ) const
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 		pViewShell->MoveCursorAbs( nCol, nRow, SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 
//STRIP001 		if (bInsert)
//STRIP001 			pViewShell->InsertPageBreak(bColumn, FALSE);
//STRIP001 		else
//STRIP001 			pViewShell->DeletePageBreak(bColumn, FALSE);
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPageBreak::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange(!bInsert);
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPageBreak::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange(bInsert);
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPageBreak::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 
//STRIP001 		if (bInsert)
//STRIP001 			rViewShell.InsertPageBreak(bColumn, TRUE);
//STRIP001 		else
//STRIP001 			rViewShell.DeletePageBreak(bColumn, TRUE);
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoPageBreak::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Druck-Skalierung
//

//STRIP001 ScUndoPrintZoom::ScUndoPrintZoom( ScDocShell* pNewDocShell,
//STRIP001 			USHORT nT, USHORT nOS, USHORT nOP, USHORT nNS, USHORT nNP ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nT ),
//STRIP001 	nOldScale( nOS ),
//STRIP001 	nOldPages( nOP ),
//STRIP001 	nNewScale( nNS ),
//STRIP001 	nNewPages( nNP )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoPrintZoom::~ScUndoPrintZoom()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoPrintZoom::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_PRINTSCALE );
//STRIP001 }

//STRIP001 void ScUndoPrintZoom::DoChange( BOOL bUndo )
//STRIP001 {
//STRIP001 	USHORT nScale = bUndo ? nOldScale : nNewScale;
//STRIP001 	USHORT nPages = bUndo ? nOldPages : nNewPages;
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	String aStyleName = pDoc->GetPageStyle( nTab );
//STRIP001 	ScStyleSheetPool* pStylePool = pDoc->GetStyleSheetPool();
//STRIP001 	SfxStyleSheetBase* pStyleSheet = pStylePool->Find( aStyleName, SFX_STYLE_FAMILY_PAGE );
//STRIP001 	DBG_ASSERT( pStyleSheet, "PageStyle not found" );
//STRIP001 	if ( pStyleSheet )
//STRIP001 	{
//STRIP001 		SfxItemSet& rSet = pStyleSheet->GetItemSet();
//STRIP001 		rSet.Put( SfxUInt16Item( ATTR_PAGE_SCALE, nScale ) );
//STRIP001 		rSet.Put( SfxUInt16Item( ATTR_PAGE_SCALETOPAGES, nPages ) );
//STRIP001 
//STRIP001 		ScPrintFunc aPrintFunc( pDocShell, pDocShell->GetPrinter(), nTab );
//STRIP001 		aPrintFunc.UpdatePages();
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintZoom::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange(TRUE);
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintZoom::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange(FALSE);
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintZoom::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		ScViewData* pViewData = rViewShell.GetViewData();
//STRIP001 		pViewData->GetDocShell()->SetPrintZoom( pViewData->GetTabNo(), nNewScale, nNewPages );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoPrintZoom::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Thesaurus
//

//STRIP001 ScUndoThesaurus::ScUndoThesaurus( ScDocShell* pNewDocShell,
//STRIP001 								  USHORT nNewCol, USHORT nNewRow, USHORT nNewTab,
//STRIP001 								  const String& rNewUndoStr, const EditTextObject* pUndoTObj,
//STRIP001 								  const String& rNewRedoStr, const EditTextObject* pRedoTObj) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nCol( nNewCol ),
//STRIP001 	nRow( nNewRow ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	aUndoStr( rNewUndoStr ),
//STRIP001 	aRedoStr( rNewRedoStr )
//STRIP001 {
//STRIP001 	pUndoTObject = (pUndoTObj) ? pUndoTObj->Clone() : NULL;
//STRIP001 	pRedoTObject = (pRedoTObj) ? pRedoTObj->Clone() : NULL;
//STRIP001 
//STRIP001 	ScBaseCell* pOldCell;
//STRIP001 	if ( pUndoTObject )
//STRIP001 		pOldCell = new ScEditCell( pUndoTObject, pDocShell->GetDocument(), NULL );
//STRIP001 	else
//STRIP001 		pOldCell = new ScStringCell( aUndoStr );
//STRIP001 	SetChangeTrack( pOldCell );
//STRIP001 	pOldCell->Delete();
//STRIP001 }

//STRIP001 __EXPORT ScUndoThesaurus::~ScUndoThesaurus()
//STRIP001 {
//STRIP001 	delete pUndoTObject;
//STRIP001 	delete pRedoTObject;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoThesaurus::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_THESAURUS );	// "Thesaurus"
//STRIP001 }

//STRIP001 void ScUndoThesaurus::SetChangeTrack( ScBaseCell* pOldCell )
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		nEndChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		pChangeTrack->AppendContent( ScAddress( nCol, nRow, nTab ), pOldCell );
//STRIP001 		if ( nEndChangeAction > pChangeTrack->GetActionMax() )
//STRIP001 			nEndChangeAction = 0;		// nichts appended
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoThesaurus::DoChange( BOOL bUndo, const String& rStr,
//STRIP001 			const EditTextObject* pTObj )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 		pViewShell->MoveCursorAbs( nCol, nRow, SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTObj)
//STRIP001 	{
//STRIP001 		ScBaseCell* pCell;
//STRIP001 		pDoc->GetCell( nCol, nRow, nTab, pCell );
//STRIP001 		if (pCell)
//STRIP001 		{
//STRIP001 			if (pCell->GetCellType() == CELLTYPE_EDIT )
//STRIP001 			{
//STRIP001 				ScEditCell* pNewCell = new ScEditCell( pTObj, pDoc, NULL );
//STRIP001 				pDoc->PutCell( nCol, nRow, nTab, pNewCell );
//STRIP001 				if ( !bUndo )
//STRIP001 					SetChangeTrack( pCell );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				DBG_ERROR("Nicht CELLTYPE_EDIT bei Un/RedoThesaurus");
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ScBaseCell* pCell;
//STRIP001 		if ( !bUndo )
//STRIP001 			pDoc->GetCell( nCol, nRow, nTab, pCell );
//STRIP001 		pDoc->SetString( nCol, nRow, nTab, rStr );
//STRIP001 		if ( !bUndo )
//STRIP001 			SetChangeTrack( pCell );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PostPaintCell( nCol, nRow, nTab );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoThesaurus::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE, aUndoStr, pUndoTObject );
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nEndChangeAction, nEndChangeAction );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoThesaurus::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE, aRedoStr, pRedoTObject );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoThesaurus::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DoThesaurus( TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoThesaurus::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Notizen ein-/ausblenden
//

/*N*/ ScUndoNote::ScUndoNote( ScDocShell* pNewDocShell, BOOL bShow,
/*N*/ 						const ScAddress& rNewPos, SdrUndoAction* pDraw ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	bIsShow		( bShow ),
/*N*/ 	aPos		( rNewPos ),
/*N*/ 	pDrawUndo	( pDraw )
/*N*/ 
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoNote::~ScUndoNote()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

//STRIP001 String __EXPORT ScUndoNote::GetComment() const
//STRIP001 {
//STRIP001 	if ( bIsShow )
//STRIP001 		return ScGlobal::GetRscString( STR_UNDO_SHOWNOTE );		// Notiz anzeigen
//STRIP001 	else
//STRIP001 		return ScGlobal::GetRscString( STR_UNDO_HIDENOTE );		// Notiz ausblenden
//STRIP001 }


//STRIP001 void __EXPORT ScUndoNote::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction(pDrawUndo);
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScPostIt aNote;
//STRIP001 	pDoc->GetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aNote );
//STRIP001 	aNote.SetShown( !bIsShow );
//STRIP001 	pDoc->SetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aNote );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoNote::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction(pDrawUndo);
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScPostIt aNote;
//STRIP001 	pDoc->GetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aNote );
//STRIP001 	aNote.SetShown( bIsShow );
//STRIP001 	pDoc->SetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aNote );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoNote::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	hammanich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoNote::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Text von Notiz aendern (ohne Drawing-Krempel)
//

//STRIP001 ScUndoEditNote::ScUndoEditNote( ScDocShell* pNewDocShell, const ScAddress& rNewPos,
//STRIP001 								const ScPostIt& rOld, const ScPostIt& rNew ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aPos		( rNewPos ),
//STRIP001 	aOldNote	( rOld ),
//STRIP001 	aNewNote	( rNew )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoEditNote::~ScUndoEditNote()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoEditNote::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_SHOWNOTE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEditNote::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->SetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aOldNote );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEditNote::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->SetNote( aPos.Col(), aPos.Row(), aPos.Tab(), aNewNote );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEditNote::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	hammanich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoEditNote::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Detektiv
//

//STRIP001 ScUndoDetective::ScUndoDetective( ScDocShell* pNewDocShell,
//STRIP001 									SdrUndoAction* pDraw, const ScDetOpData* pOperation,
//STRIP001 									ScDetOpList* pUndoList ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	pDrawUndo	( pDraw ),
//STRIP001 	nAction		( 0 ),
//STRIP001 	pOldList	( pUndoList )
//STRIP001 {
//STRIP001 	bIsDelete = ( pOperation == NULL );
//STRIP001 	if (!bIsDelete)
//STRIP001 	{
//STRIP001 		nAction = (USHORT) pOperation->GetOperation();
//STRIP001 		aPos = pOperation->GetPos();
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoDetective::~ScUndoDetective()
//STRIP001 {
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 	delete pOldList;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDetective::GetComment() const
//STRIP001 {
//STRIP001 	USHORT nId = STR_UNDO_DETDELALL;
//STRIP001 	if ( !bIsDelete )
//STRIP001 		switch ( (ScDetOpType) nAction )
//STRIP001 		{
//STRIP001 			case SCDETOP_ADDSUCC:	nId = STR_UNDO_DETADDSUCC;	break;
//STRIP001 			case SCDETOP_DELSUCC:	nId = STR_UNDO_DETDELSUCC;	break;
//STRIP001 			case SCDETOP_ADDPRED:	nId = STR_UNDO_DETADDPRED;	break;
//STRIP001 			case SCDETOP_DELPRED:	nId = STR_UNDO_DETDELPRED;	break;
//STRIP001 			case SCDETOP_ADDERROR:	nId = STR_UNDO_DETADDERROR;	break;
//STRIP001 		}
//STRIP001 
//STRIP001 	return ScGlobal::GetRscString( nId );
//STRIP001 }


//STRIP001 void __EXPORT ScUndoDetective::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction(pDrawUndo);
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (bIsDelete)
//STRIP001 	{
//STRIP001 		if ( pOldList )
//STRIP001 			pDoc->SetDetOpList( new ScDetOpList(*pOldList) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	Eintrag aus der Liste loeschen
//STRIP001 
//STRIP001 		ScDetOpList* pList = pDoc->GetDetOpList();
//STRIP001 		if (pList && pList->Count())
//STRIP001 		{
//STRIP001 			USHORT nPos = pList->Count() - 1;
//STRIP001 			ScDetOpData* pData = (*pList)[nPos];
//STRIP001 			if ( pData->GetOperation() == (ScDetOpType) nAction && pData->GetPos() == aPos )
//STRIP001 				pList->DeleteAndDestroy( nPos, 1 );
//STRIP001 			else
//STRIP001 				DBG_ERROR("Detektiv-Eintrag in der Liste nicht gefunden");
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->RecalcPPT();	//! use broadcast instead?
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDetective::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction(pDrawUndo);
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (bIsDelete)
//STRIP001 		pDoc->ClearDetectiveOperations();
//STRIP001 	else
//STRIP001 		pDoc->AddDetectiveOperation( ScDetOpData( aPos, (ScDetOpType) nAction ) );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->RecalcPPT();	//! use broadcast instead?
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDetective::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	hammanich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDetective::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Benannte Bereiche
//

/*N*/ ScUndoRangeNames::ScUndoRangeNames( ScDocShell* pNewDocShell,
/*N*/ 									ScRangeName* pOld, ScRangeName* pNew ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	pOldRanges	( pOld ),
/*N*/ 	pNewRanges	( pNew )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoRangeNames::~ScUndoRangeNames()
/*N*/ {
/*N*/ 	delete pOldRanges;
/*N*/ 	delete pNewRanges;
/*N*/ }

/*N*/ String __EXPORT ScUndoRangeNames::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_RANGENAMES );
/*N*/ }

//STRIP001 void ScUndoRangeNames::DoChange( BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->CompileNameFormula( TRUE );	// CreateFormulaString
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 		pDoc->SetRangeName( new ScRangeName( *pOldRanges ) );
//STRIP001 	else
//STRIP001 		pDoc->SetRangeName( new ScRangeName( *pNewRanges ) );
//STRIP001 
//STRIP001 	pDoc->CompileNameFormula( FALSE );	// CompileFormulaString
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREAS_CHANGED ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRangeNames::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRangeNames::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRangeNames::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	hammanich
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoRangeNames::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }




}
