/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_olinewin.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:29:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_TASKPANELIST_HXX
#include <vcl/taskpanelist.hxx>
#endif

#include "olinewin.hxx"
// auto strip #include "olinetab.hxx"
// auto strip #include "document.hxx"
// auto strip #include "dbfunc.hxx"
#include "bf_sc.hrc"

#ifndef _SV_SYSWIN_HXX
#include <vcl/syswin.hxx>
#endif

namespace binfilter {

// ============================================================================

const sal_Int32 SC_OL_BITMAPSIZE            = 12;
const sal_Int32 SC_OL_POSOFFSET             = 2;

const sal_uInt16 SC_OL_NOLEVEL              = 0xFFFF;
const sal_uInt16 SC_OL_HEADERENTRY          = 0xFFFF;

const sal_uInt16 SC_OL_IMAGE_PLUS           = 9;
const sal_uInt16 SC_OL_IMAGE_MINUS          = SC_OL_IMAGE_PLUS + 1;
const sal_uInt16 SC_OL_IMAGE_NOTPRESSED     = SC_OL_IMAGE_MINUS + 1;
const sal_uInt16 SC_OL_IMAGE_PRESSED        = SC_OL_IMAGE_NOTPRESSED + 1;


// ============================================================================

/*N*/ ScOutlineWindow::ScOutlineWindow( Window* pParent, ScOutlineMode eMode, ScViewData* pViewData, ScSplitPos eWhich ) :
/*N*/ 	Window( pParent ),
/*N*/     mrViewData( *pViewData ),
/*N*/     meWhich( eWhich ),
/*N*/     mbHoriz( eMode == SC_OUTLINE_HOR ),
/*N*/     mpSymbols( NULL ),
/*N*/     maLineColor( COL_BLACK ),
/*N*/     mnHeaderSize( 0 ),
/*N*/     mnHeaderPos( 0 ),
/*N*/     mnMainFirstPos( 0 ),
/*N*/     mnMainLastPos( 0 ),
/*N*/     mbMTActive( false ),
/*N*/     mbMTPressed( false ),
/*N*/     mnFocusLevel( 0 ),
/*N*/     mnFocusEntry( SC_OL_HEADERENTRY ),
/*N*/     mbDontDrawFocus( false )
/*N*/ {
/*N*/     EnableRTL( !mbHoriz ); // #107809# do not mirror (horizontal) column outline window
/*N*/     mbMirrorHdr = mbHoriz && Application::GetSettings().GetLayoutRTL();
/*N*/ 
/*N*/     InitSettings();
/*N*/     maFocusRect.SetEmpty();
/*N*/     SetHeaderSize( 0 );
/*N*/ 
/*N*/     // insert the window into task pane list for "F6 cycling"
/*N*/     if( SystemWindow* pSysWin = GetSystemWindow() )
/*N*/         if( TaskPaneList* pTaskPaneList = pSysWin->GetTaskPaneList() )
/*N*/             pTaskPaneList->AddWindow( this );
/*N*/ }

/*N*/ ScOutlineWindow::~ScOutlineWindow()
/*N*/ {
/*N*/     // remove the window from task pane list
/*N*/     if( SystemWindow* pSysWin = GetSystemWindow() )
/*N*/         if( TaskPaneList* pTaskPaneList = pSysWin->GetTaskPaneList() )
/*N*/             pTaskPaneList->RemoveWindow( this );
/*N*/ }

/*N*/ void ScOutlineWindow::SetHeaderSize( sal_Int32 nNewSize )
/*N*/ {
/*N*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bool bNew = (nNewSize != mnHeaderSize);
//STRIP001 /*?*/     mnHeaderSize = nNewSize;
//STRIP001 /*?*/     mnHeaderPos = mbMirrorHdr ? (GetOutputSizeEntry() - mnHeaderSize) : 0;
//STRIP001 /*?*/     mnMainFirstPos = mbMirrorHdr ? 0 : mnHeaderSize;
//STRIP001 /*?*/     mnMainLastPos = GetOutputSizeEntry() - (mbMirrorHdr ? mnHeaderSize : 0) - 1;
//STRIP001 /*?*/     if ( bNew )
//STRIP001 /*?*/         Invalidate();
/*N*/ }

/*N*/ sal_Int32 ScOutlineWindow::GetDepthSize() const
/*N*/ {
    DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 sal_Int32 nSize = GetLevelCount() * SC_OL_BITMAPSIZE;
//STRIP001 //STRIP001     if ( nSize > 0 )
//STRIP001 //STRIP001         nSize += 2 * SC_OL_POSOFFSET + 1;
//STRIP001 //STRIP001     return nSize;
/*N*/ }

//STRIP001 void ScOutlineWindow::ScrollPixel( sal_Int32 nDiff )
//STRIP001 {
//STRIP001     HideFocus();
//STRIP001     mbDontDrawFocus = true;
//STRIP001 
//STRIP001     sal_Int32 nStart = mnMainFirstPos;
//STRIP001     sal_Int32 nEnd = mnMainLastPos;
//STRIP001 
//STRIP001     sal_Int32 nInvStart, nInvEnd;
//STRIP001     if (nDiff < 0)
//STRIP001     {
//STRIP001         nStart -= nDiff;
//STRIP001         nInvStart = nEnd + nDiff;
//STRIP001         nInvEnd = nEnd;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         nEnd -= nDiff;
//STRIP001         nInvStart = nStart;
//STRIP001         nInvEnd = nStart + nDiff;
//STRIP001     }
//STRIP001 
//STRIP001     ScrollRel( nDiff, nStart, nEnd );
//STRIP001     Invalidate( GetRectangle( 0, nInvStart, GetOutputSizeLevel() - 1, nInvEnd ) );
//STRIP001     Update();
//STRIP001 
//STRIP001     // if focus becomes invisible, move it to next visible button
//STRIP001     ImplMoveFocusToVisible( nDiff < 0 );
//STRIP001 
//STRIP001     mbDontDrawFocus = false;
//STRIP001     ShowFocus();
//STRIP001 }

//STRIP001 void ScOutlineWindow::ScrollRel( sal_Int32 nEntryDiff )
//STRIP001 {
//STRIP001     if ( mbHoriz )
//STRIP001         Scroll( nEntryDiff, 0 );
//STRIP001     else
//STRIP001         Scroll( 0, nEntryDiff );
//STRIP001 }

//STRIP001 void ScOutlineWindow::ScrollRel( sal_Int32 nEntryDiff, sal_Int32 nEntryStart, sal_Int32 nEntryEnd )
//STRIP001 {
//STRIP001     Rectangle aRect( GetRectangle( 0, nEntryStart, GetOutputSizeLevel() - 1, nEntryEnd ) );
//STRIP001     if ( mbHoriz )
//STRIP001         Scroll( nEntryDiff, 0, aRect );
//STRIP001     else
//STRIP001         Scroll( 0, nEntryDiff, aRect );
//STRIP001 }


// internal -------------------------------------------------------------------

/*N*/ void ScOutlineWindow::InitSettings()
/*N*/ {
/*N*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 /*?*/     SetBackground( rStyleSettings.GetFaceColor() );
//STRIP001 /*?*/     maLineColor = rStyleSettings.GetButtonTextColor();
//STRIP001 /*?*/     mpSymbols = ScGlobal::GetOutlineSymbols( !!GetBackground().GetColor().IsDark() );
//STRIP001 /*?*/     Invalidate();
/*N*/ }

//STRIP001 const ScOutlineArray* ScOutlineWindow::GetOutlineArray() const
//STRIP001 {
//STRIP001     const ScOutlineTable* pTable = GetDoc().GetOutlineTable( GetTab() );
//STRIP001     if ( !pTable ) return NULL;
//STRIP001     return mbHoriz ? pTable->GetColArray() : pTable->GetRowArray();
//STRIP001 }

//STRIP001 const ScOutlineEntry* ScOutlineWindow::GetOutlineEntry( sal_uInt16 nLevel, sal_uInt16 nEntry ) const
//STRIP001 {
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     return pArray ? pArray->GetEntry( nLevel, nEntry ) : NULL;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::IsHidden( sal_uInt16 nColRowIndex ) const
//STRIP001 {
//STRIP001     sal_uInt8 nFlags = mbHoriz ?
//STRIP001         GetDoc().GetColFlags( nColRowIndex, GetTab() ) :
//STRIP001         GetDoc().GetRowFlags( nColRowIndex, GetTab() );
//STRIP001     return (nFlags & CR_HIDDEN) != 0;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::IsFiltered( sal_uInt16 nColRowIndex ) const
//STRIP001 {
//STRIP001     // columns cannot be filtered
//STRIP001     return !mbHoriz && GetDoc().IsFiltered( nColRowIndex, GetTab() );
//STRIP001 }

//STRIP001 bool ScOutlineWindow::IsFirstVisible( sal_uInt16 nColRowIndex ) const
//STRIP001 {
//STRIP001     bool bAllHidden = true;
//STRIP001     for ( sal_uInt16 nPos = 0; (nPos < nColRowIndex) && bAllHidden; ++nPos )
//STRIP001         bAllHidden = IsHidden( nPos );
//STRIP001     return bAllHidden;
//STRIP001 }

//STRIP001 void ScOutlineWindow::GetVisibleRange( sal_uInt16& rnColRowStart, sal_uInt16& rnColRowEnd ) const
//STRIP001 {
//STRIP001     if ( mbHoriz )
//STRIP001     {
//STRIP001         rnColRowStart = mrViewData.GetPosX( WhichH( meWhich ) );
//STRIP001         rnColRowEnd = rnColRowStart + mrViewData.VisibleCellsX( WhichH( meWhich ) );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         rnColRowStart = mrViewData.GetPosY( WhichV( meWhich ) );
//STRIP001         rnColRowEnd = rnColRowStart + mrViewData.VisibleCellsY( WhichV( meWhich ) );
//STRIP001     }
//STRIP001 
//STRIP001     // include collapsed columns/rows in front of visible range
//STRIP001     while ( (rnColRowStart > 0) && IsHidden( rnColRowStart - 1 ) )
//STRIP001         --rnColRowStart;
//STRIP001 }

//STRIP001 Point ScOutlineWindow::GetPoint( sal_Int32 nLevelPos, sal_Int32 nEntryPos ) const
//STRIP001 {
//STRIP001     return mbHoriz ? Point( nEntryPos, nLevelPos ) : Point( nLevelPos, nEntryPos );
//STRIP001 }

//STRIP001 Rectangle ScOutlineWindow::GetRectangle(
//STRIP001         sal_Int32 nLevelStart, sal_Int32 nEntryStart,
//STRIP001         sal_Int32 nLevelEnd, sal_Int32 nEntryEnd ) const
//STRIP001 {
//STRIP001     return Rectangle( GetPoint( nLevelStart, nEntryStart ), GetPoint( nLevelEnd, nEntryEnd ) );
//STRIP001 }

//STRIP001 sal_Int32 ScOutlineWindow::GetOutputSizeLevel() const
//STRIP001 {
//STRIP001     Size aSize( GetOutputSizePixel() );
//STRIP001     return mbHoriz ? aSize.Height() : aSize.Width();
//STRIP001 }

//STRIP001 sal_Int32 ScOutlineWindow::GetOutputSizeEntry() const
//STRIP001 {
//STRIP001     Size aSize( GetOutputSizePixel() );
//STRIP001     return mbHoriz ? aSize.Width() : aSize.Height();
//STRIP001 }

//STRIP001 sal_uInt16 ScOutlineWindow::GetLevelCount() const
//STRIP001 {
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     return pArray ? (pArray->GetDepth() + 1) : 0;
//STRIP001 }

//STRIP001 sal_Int32 ScOutlineWindow::GetLevelPos( sal_uInt16 nLevel ) const
//STRIP001 {
//STRIP001     return SC_OL_POSOFFSET + nLevel * SC_OL_BITMAPSIZE;
//STRIP001 }

//STRIP001 sal_uInt16 ScOutlineWindow::GetLevelFromPos( sal_Int32 nLevelPos ) const
//STRIP001 {
//STRIP001     if ( nLevelPos < SC_OL_POSOFFSET ) return SC_OL_NOLEVEL;
//STRIP001     sal_uInt16 nLevel = static_cast< sal_uInt16 >( (nLevelPos - SC_OL_POSOFFSET) / SC_OL_BITMAPSIZE );
//STRIP001     return (nLevel < GetLevelCount()) ? nLevel : SC_OL_NOLEVEL;
//STRIP001 }

//STRIP001 sal_Int32 ScOutlineWindow::GetColRowPos( sal_uInt16 nColRowIndex ) const
//STRIP001 {
//STRIP001     sal_Int32 nDocPos = mbHoriz ?
//STRIP001         mrViewData.GetScrPos( nColRowIndex, 0, meWhich, TRUE ).X() :
//STRIP001         mrViewData.GetScrPos( 0, nColRowIndex, meWhich, TRUE ).Y();
//STRIP001     return mnMainFirstPos + nDocPos;
//STRIP001 }

//STRIP001 sal_Int32 ScOutlineWindow::GetHeaderEntryPos() const
//STRIP001 {
//STRIP001     return mnHeaderPos + (mnHeaderSize - SC_OL_BITMAPSIZE) / 2;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::GetEntryPos(
//STRIP001         sal_uInt16 nLevel, sal_uInt16 nEntry,
//STRIP001         sal_Int32& rnStartPos, sal_Int32& rnEndPos, sal_Int32& rnImagePos ) const
//STRIP001 {
//STRIP001     const ScOutlineEntry* pEntry = GetOutlineEntry( nLevel, nEntry );
//STRIP001     if ( !pEntry || !pEntry->IsVisible() )
//STRIP001         return false;
//STRIP001 
//STRIP001     sal_uInt16 nStart = pEntry->GetStart();
//STRIP001     sal_uInt16 nEnd = pEntry->GetEnd();
//STRIP001 
//STRIP001     // --- common calculation ---
//STRIP001 
//STRIP001     rnStartPos = GetColRowPos( nStart );
//STRIP001     rnEndPos = GetColRowPos( nEnd + 1 );
//STRIP001 
//STRIP001     bool bHidden = IsHidden( nStart );
//STRIP001     rnImagePos = bHidden ? (rnStartPos - SC_OL_BITMAPSIZE / 2) : rnStartPos + 1;
//STRIP001     rnImagePos = Min( rnImagePos, (rnStartPos + rnEndPos - SC_OL_BITMAPSIZE) / 2L );
//STRIP001 
//STRIP001     // --- refinements ---
//STRIP001 
//STRIP001     // do not cut leftmost/topmost image
//STRIP001     if ( bHidden && IsFirstVisible( nStart ) )
//STRIP001         rnImagePos = rnStartPos;
//STRIP001 
//STRIP001     // do not cover previous collapsed image
//STRIP001     if ( !bHidden && nEntry )
//STRIP001     {
//STRIP001         const ScOutlineEntry* pPrevEntry = GetOutlineEntry( nLevel, nEntry - 1 );
//STRIP001         sal_uInt16 nPrevEnd = pPrevEntry->GetEnd();
//STRIP001         if ( (nPrevEnd + 1 == nStart) && IsHidden( nPrevEnd ) )
//STRIP001         {
//STRIP001             if ( IsFirstVisible( pPrevEntry->GetStart() ) )
//STRIP001                 rnStartPos += SC_OL_BITMAPSIZE;
//STRIP001             else
//STRIP001                 rnStartPos += SC_OL_BITMAPSIZE / 2;
//STRIP001             rnImagePos = rnStartPos;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // restrict rnStartPos...rnEndPos to valid area
//STRIP001     rnStartPos = Max( rnStartPos, mnMainFirstPos );
//STRIP001     rnEndPos = Max( rnEndPos, mnMainFirstPos );
//STRIP001 
//STRIP001     // --- all rows filtered? ---
//STRIP001 
//STRIP001     bool bVisible = true;
//STRIP001     if ( !mbHoriz )
//STRIP001     {
//STRIP001         bVisible = false;
//STRIP001         for ( sal_uInt16 nRow = nStart; (nRow <= nEnd) && !bVisible; ++nRow )
//STRIP001             bVisible = !IsFiltered( nRow );
//STRIP001     }
//STRIP001     return bVisible;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::GetImagePos( sal_uInt16 nLevel, sal_uInt16 nEntry, Point& rPos ) const
//STRIP001 {
//STRIP001     bool bRet = nLevel < GetLevelCount();
//STRIP001     if ( bRet )
//STRIP001     {
//STRIP001         sal_Int32 nLevelPos = GetLevelPos( nLevel );
//STRIP001         if ( nEntry == SC_OL_HEADERENTRY )
//STRIP001             rPos = GetPoint( nLevelPos, GetHeaderEntryPos() );
//STRIP001         else
//STRIP001         {
//STRIP001             sal_Int32 nStartPos, nEndPos, nImagePos;
//STRIP001             bRet = GetEntryPos( nLevel, nEntry, nStartPos, nEndPos, nImagePos );
//STRIP001             rPos = GetPoint( nLevelPos, nImagePos );
//STRIP001         }
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::IsButtonVisible( sal_uInt16 nLevel, sal_uInt16 nEntry ) const
//STRIP001 {
//STRIP001     bool bRet = false;
//STRIP001     if ( nEntry == SC_OL_HEADERENTRY )
//STRIP001         bRet = (mnHeaderSize > 0) && (nLevel < GetLevelCount());
//STRIP001     else
//STRIP001     {
//STRIP001         const ScOutlineEntry* pEntry = GetOutlineEntry( nLevel, nEntry );
//STRIP001         if ( pEntry && pEntry->IsVisible() )
//STRIP001         {
//STRIP001             sal_uInt16 nStart, nEnd;
//STRIP001             GetVisibleRange( nStart, nEnd );
//STRIP001             bRet = (nStart <= pEntry->GetStart()) && (pEntry->GetStart() <= nEnd);
//STRIP001         }
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::ItemHit( const Point& rPos, sal_uInt16& rnLevel, sal_uInt16& rnEntry, bool& rbButton ) const
//STRIP001 {
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     if ( !pArray ) return false;
//STRIP001 
//STRIP001     sal_uInt16 nStartIndex, nEndIndex;
//STRIP001     GetVisibleRange( nStartIndex, nEndIndex );
//STRIP001 
//STRIP001     sal_uInt16 nLevel = GetLevelFromPos( mbHoriz ? rPos.Y() : rPos.X() );
//STRIP001     if ( nLevel == SC_OL_NOLEVEL )
//STRIP001         return false;
//STRIP001 
//STRIP001     sal_Int32 nLevelPos = GetLevelPos( nLevel );
//STRIP001     sal_Int32 nEntryMousePos = mbHoriz ? rPos.X() : rPos.Y();
//STRIP001 
//STRIP001     // --- level buttons ---
//STRIP001 
//STRIP001     if ( mnHeaderSize > 0 )
//STRIP001     {
//STRIP001         sal_Int32 nImagePos = GetHeaderEntryPos();
//STRIP001         if ( (nImagePos <= nEntryMousePos) && (nEntryMousePos < nImagePos + SC_OL_BITMAPSIZE) )
//STRIP001         {
//STRIP001             rnLevel = nLevel;
//STRIP001             rnEntry = SC_OL_HEADERENTRY;
//STRIP001             rbButton = true;
//STRIP001             return true;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // --- expand/collapse buttons and expanded lines ---
//STRIP001 
//STRIP001     // search outline entries backwards
//STRIP001     sal_uInt16 nEntry = pArray->GetCount( nLevel );
//STRIP001     while ( nEntry )
//STRIP001     {
//STRIP001         --nEntry;
//STRIP001 
//STRIP001         const ScOutlineEntry* pEntry = pArray->GetEntry( nLevel, nEntry );
//STRIP001         sal_uInt16 nStart = pEntry->GetStart();
//STRIP001         sal_uInt16 nEnd = pEntry->GetEnd();
//STRIP001 
//STRIP001         if ( (nEnd >= nStartIndex) && (nStart <= nEndIndex) )
//STRIP001         {
//STRIP001             sal_Int32 nStartPos, nEndPos, nImagePos;
//STRIP001             if ( GetEntryPos( nLevel, nEntry, nStartPos, nEndPos, nImagePos ) )
//STRIP001             {
//STRIP001                 rnLevel = nLevel;
//STRIP001                 rnEntry = nEntry;
//STRIP001 
//STRIP001                 // button?
//STRIP001                 if ( (nStart >= nStartIndex) && (nImagePos <= nEntryMousePos) && (nEntryMousePos < nImagePos + SC_OL_BITMAPSIZE) )
//STRIP001                 {
//STRIP001                     rbButton = true;
//STRIP001                     return true;
//STRIP001                 }
//STRIP001 
//STRIP001                 // line?
//STRIP001                 if ( (nStartPos <= nEntryMousePos) && (nEntryMousePos <= nEndPos) )
//STRIP001                 {
//STRIP001                     rbButton = false;
//STRIP001                     return true;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return false;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::ButtonHit( const Point& rPos, sal_uInt16& rnLevel, sal_uInt16& rnEntry ) const
//STRIP001 {
//STRIP001     bool bButton;
//STRIP001     bool bRet = ItemHit( rPos, rnLevel, rnEntry, bButton );
//STRIP001     return bRet && bButton;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::LineHit( const Point& rPos, sal_uInt16& rnLevel, sal_uInt16& rnEntry ) const
//STRIP001 {
//STRIP001     bool bButton;
//STRIP001     bool bRet = ItemHit( rPos, rnLevel, rnEntry, bButton );
//STRIP001     return bRet && !bButton;
//STRIP001 }

//STRIP001 void ScOutlineWindow::DoFunction( sal_uInt16 nLevel, sal_uInt16 nEntry ) const
//STRIP001 {
//STRIP001     ScDBFunc& rFunc = *mrViewData.GetView();
//STRIP001     if ( nEntry == SC_OL_HEADERENTRY )
//STRIP001         rFunc.SelectLevel( mbHoriz, nLevel );
//STRIP001     else
//STRIP001     {
//STRIP001         const ScOutlineEntry* pEntry = GetOutlineEntry( nLevel, nEntry );
//STRIP001         if ( pEntry )
//STRIP001         {
//STRIP001             if ( pEntry->IsHidden() )
//STRIP001                 rFunc.ShowOutline( mbHoriz, nLevel, nEntry );
//STRIP001             else
//STRIP001                 rFunc.HideOutline( mbHoriz, nLevel, nEntry );
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScOutlineWindow::DoExpand( sal_uInt16 nLevel, sal_uInt16 nEntry ) const
//STRIP001 {
//STRIP001     const ScOutlineEntry* pEntry = GetOutlineEntry( nLevel, nEntry );
//STRIP001     if ( pEntry && pEntry->IsHidden() )
//STRIP001         DoFunction( nLevel, nEntry );
//STRIP001 }

//STRIP001 void ScOutlineWindow::DoCollapse( sal_uInt16 nLevel, sal_uInt16 nEntry ) const
//STRIP001 {
//STRIP001     const ScOutlineEntry* pEntry = GetOutlineEntry( nLevel, nEntry );
//STRIP001     if ( pEntry && !pEntry->IsHidden() )
//STRIP001         DoFunction( nLevel, nEntry );
//STRIP001 }

//STRIP001 void ScOutlineWindow::Resize()
//STRIP001 {
//STRIP001     Window::Resize();
//STRIP001     SetHeaderSize( mnHeaderSize );  // recalculates header/group positions
//STRIP001     if ( !IsFocusButtonVisible() )
//STRIP001     {
//STRIP001         HideFocus();
//STRIP001         ShowFocus();    // calculates valid position
//STRIP001     }
//STRIP001 }

//STRIP001 void ScOutlineWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         InitSettings();
//STRIP001         Invalidate();
//STRIP001     }
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }


// drawing --------------------------------------------------------------------

//STRIP001 void ScOutlineWindow::SetEntryAreaClipRegion()
//STRIP001 {
//STRIP001     SetClipRegion( Rectangle(
//STRIP001         GetPoint( 0, mnMainFirstPos ),
//STRIP001         GetPoint( GetOutputSizeLevel() - 1, mnMainLastPos ) ) );
//STRIP001 }

//STRIP001 void ScOutlineWindow::DrawLineRel(
//STRIP001         sal_Int32 nLevelStart, sal_Int32 nEntryStart,
//STRIP001         sal_Int32 nLevelEnd, sal_Int32 nEntryEnd )
//STRIP001 {
//STRIP001     DrawLine( GetPoint( nLevelStart, nEntryStart ), GetPoint( nLevelEnd, nEntryEnd ) );
//STRIP001 }

//STRIP001 void ScOutlineWindow::DrawRectRel(
//STRIP001         sal_Int32 nLevelStart, sal_Int32 nEntryStart,
//STRIP001         sal_Int32 nLevelEnd, sal_Int32 nEntryEnd )
//STRIP001 {
//STRIP001     DrawRect( GetRectangle( nLevelStart, nEntryStart, nLevelEnd, nEntryEnd ) );
//STRIP001 }

//STRIP001 void ScOutlineWindow::DrawImageRel( sal_Int32 nLevelPos, sal_Int32 nEntryPos, sal_uInt16 nId )
//STRIP001 {
//STRIP001     DBG_ASSERT( mpSymbols, "ScOutlineWindow::DrawImageRel - no images" );
//STRIP001     const Image& rImage = mpSymbols->GetImage( nId );
//STRIP001     SetLineColor();
//STRIP001     SetFillColor( GetBackground().GetColor() );
//STRIP001     Point aPos( GetPoint( nLevelPos, nEntryPos ) );
//STRIP001     DrawRect( Rectangle( aPos, rImage.GetSizePixel() ) );
//STRIP001     DrawImage( aPos, rImage );
//STRIP001 }

//STRIP001 void ScOutlineWindow::DrawBorderRel( sal_uInt16 nLevel, sal_uInt16 nEntry, bool bPressed )
//STRIP001 {
//STRIP001     Point aPos;
//STRIP001     if ( GetImagePos( nLevel, nEntry, aPos ) )
//STRIP001     {
//STRIP001         DBG_ASSERT( mpSymbols, "ScOutlineWindow::DrawBorderRel - no images" );
//STRIP001         sal_uInt16 nId = bPressed ? SC_OL_IMAGE_PRESSED : SC_OL_IMAGE_NOTPRESSED;
//STRIP001         bool bClip = (nEntry != SC_OL_HEADERENTRY);
//STRIP001         if ( bClip )
//STRIP001             SetEntryAreaClipRegion();
//STRIP001         DrawImage( aPos, mpSymbols->GetImage( nId ) );
//STRIP001         if ( bClip )
//STRIP001             SetClipRegion();
//STRIP001     }
//STRIP001     mbMTPressed = bPressed;
//STRIP001 }

//STRIP001 void ScOutlineWindow::ShowFocus()
//STRIP001 {
//STRIP001     if ( HasFocus() )
//STRIP001     {
//STRIP001         // first move to a visible position
//STRIP001         ImplMoveFocusToVisible( true );
//STRIP001 
//STRIP001         if ( IsFocusButtonVisible() )
//STRIP001         {
//STRIP001             Point aPos;
//STRIP001             if ( GetImagePos( mnFocusLevel, mnFocusEntry, aPos ) )
//STRIP001             {
//STRIP001                 aPos += Point( 1, 1 );
//STRIP001                 maFocusRect = Rectangle( aPos, Size( SC_OL_BITMAPSIZE - 2, SC_OL_BITMAPSIZE - 2 ) );
//STRIP001                 bool bClip = (mnFocusEntry != SC_OL_HEADERENTRY);
//STRIP001                 if ( bClip )
//STRIP001                     SetEntryAreaClipRegion();
//STRIP001                 InvertTracking( maFocusRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW );
//STRIP001                 if ( bClip )
//STRIP001                     SetClipRegion();
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScOutlineWindow::HideFocus()
//STRIP001 {
//STRIP001     if ( !maFocusRect.IsEmpty() )
//STRIP001     {
//STRIP001         bool bClip = (mnFocusEntry != SC_OL_HEADERENTRY);
//STRIP001         if ( bClip )
//STRIP001             SetEntryAreaClipRegion();
//STRIP001         InvertTracking( maFocusRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW );
//STRIP001         if ( bClip )
//STRIP001             SetClipRegion();
//STRIP001         maFocusRect.SetEmpty();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScOutlineWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     Size aSize = GetOutputSizePixel();
//STRIP001     sal_Int32 nLevelEnd = (mbHoriz ? aSize.Height() : aSize.Width()) - 1;
//STRIP001     sal_Int32 nEntryEnd = (mbHoriz ? aSize.Width() : aSize.Height()) - 1;
//STRIP001 
//STRIP001     SetLineColor( maLineColor );
//STRIP001     DrawLineRel( nLevelEnd, 0, nLevelEnd, nEntryEnd );
//STRIP001 
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     if ( !pArray ) return;
//STRIP001 
//STRIP001     sal_uInt16 nLevelCount = GetLevelCount();
//STRIP001 
//STRIP001     // --- draw header images ---
//STRIP001 
//STRIP001     if ( mnHeaderSize > 0 )
//STRIP001     {
//STRIP001         sal_Int32 nEntryPos = GetHeaderEntryPos();
//STRIP001         for ( sal_uInt16 nLevel = 0; nLevel < nLevelCount; ++nLevel )
//STRIP001             DrawImageRel( GetLevelPos( nLevel ), nEntryPos, nLevel + 1 );
//STRIP001 
//STRIP001         SetLineColor( maLineColor );
//STRIP001         sal_Int32 nLinePos = mnHeaderPos + (mbMirrorHdr ? 0 : (mnHeaderSize - 1));
//STRIP001         DrawLineRel( 0, nLinePos, nLevelEnd, nLinePos );
//STRIP001     }
//STRIP001 
//STRIP001     // --- draw lines & collapse/expand images ---
//STRIP001 
//STRIP001     SetEntryAreaClipRegion();
//STRIP001 
//STRIP001     sal_uInt16 nStartIndex, nEndIndex;
//STRIP001     GetVisibleRange( nStartIndex, nEndIndex );
//STRIP001 
//STRIP001     for ( sal_uInt16 nLevel = 0; nLevel < nLevelCount - 1; ++nLevel )
//STRIP001     {
//STRIP001         sal_Int32 nLevelPos = GetLevelPos( nLevel );
//STRIP001         sal_Int32 nEntryPos1, nEntryPos2, nImagePos;
//STRIP001 
//STRIP001         sal_uInt16 nEntryCount = pArray->GetCount( nLevel );
//STRIP001         sal_uInt16 nEntry;
//STRIP001 
//STRIP001         // first draw all lines in the current level
//STRIP001         SetLineColor();
//STRIP001         SetFillColor( maLineColor );
//STRIP001         for ( nEntry = 0; nEntry < nEntryCount; ++nEntry )
//STRIP001         {
//STRIP001             const ScOutlineEntry* pEntry = pArray->GetEntry( nLevel, nEntry );
//STRIP001             sal_uInt16 nStart = pEntry->GetStart();
//STRIP001             sal_uInt16 nEnd = pEntry->GetEnd();
//STRIP001 
//STRIP001             // visible range?
//STRIP001             bool bDraw = (nEnd >= nStartIndex) && (nStart <= nEndIndex);
//STRIP001             // find output coordinates
//STRIP001             if ( bDraw )
//STRIP001                 bDraw = GetEntryPos( nLevel, nEntry, nEntryPos1, nEntryPos2, nImagePos );
//STRIP001             // draw, if not collapsed
//STRIP001             if ( bDraw && !pEntry->IsHidden() )
//STRIP001             {
//STRIP001                 if ( nStart >= nStartIndex )
//STRIP001                     ++nEntryPos1;
//STRIP001                 nEntryPos2 -= 2;
//STRIP001                 DrawRectRel( nLevelPos, nEntryPos1, nLevelPos + 1, nEntryPos2 );
//STRIP001 
//STRIP001                 if ( nEnd <= nEndIndex )
//STRIP001                     DrawRectRel( nLevelPos, nEntryPos2 - 1, nLevelPos + SC_OL_BITMAPSIZE / 3, nEntryPos2 );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // draw all images in the level from last to first
//STRIP001         nEntry = nEntryCount;
//STRIP001         while ( nEntry )
//STRIP001         {
//STRIP001             --nEntry;
//STRIP001 
//STRIP001             const ScOutlineEntry* pEntry = pArray->GetEntry( nLevel, nEntry );
//STRIP001             sal_uInt16 nStart = pEntry->GetStart();
//STRIP001             sal_uInt16 nEnd = pEntry->GetEnd();
//STRIP001 
//STRIP001             // visible range?
//STRIP001             bool bDraw = (nStartIndex <= nStart) && (nStart <= nEndIndex + 1);
//STRIP001             // find output coordinates
//STRIP001             if ( bDraw )
//STRIP001                 bDraw = GetEntryPos( nLevel, nEntry, nEntryPos1, nEntryPos2, nImagePos );
//STRIP001             // draw, if not hidden by higher levels
//STRIP001             if ( bDraw )
//STRIP001             {
//STRIP001                 sal_uInt16 nImageId = pEntry->IsHidden() ? SC_OL_IMAGE_PLUS : SC_OL_IMAGE_MINUS;
//STRIP001                 DrawImageRel( nLevelPos, nImagePos, nImageId );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     SetClipRegion();
//STRIP001 
//STRIP001     if ( !mbDontDrawFocus )
//STRIP001         ShowFocus();
//STRIP001 }


// focus ----------------------------------------------------------------------

/** Increments or decrements a value and wraps at the specified limits.
    @return  true = value wrapped. */
//STRIP001 bool lcl_RotateValue( sal_uInt16& rnValue, sal_uInt16 nMin, sal_uInt16 nMax, bool bForward )
//STRIP001 {
//STRIP001     bool bWrap = false;
//STRIP001     if ( bForward )
//STRIP001     {
//STRIP001         if ( rnValue < nMax )
//STRIP001             ++rnValue;
//STRIP001         else
//STRIP001         {
//STRIP001             rnValue = nMin;
//STRIP001             bWrap = true;
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         if ( rnValue > nMin )
//STRIP001             --rnValue;
//STRIP001         else
//STRIP001         {
//STRIP001             rnValue = nMax;
//STRIP001             bWrap = true;
//STRIP001         }
//STRIP001     }
//STRIP001     return bWrap;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::IsFocusButtonVisible() const
//STRIP001 {
//STRIP001     return IsButtonVisible( mnFocusLevel, mnFocusEntry );
//STRIP001 }
//STRIP001 
//STRIP001 bool ScOutlineWindow::ImplMoveFocusByEntry( bool bForward, bool bFindVisible )
//STRIP001 {
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     if ( !pArray )
//STRIP001         return false;
//STRIP001 
//STRIP001     bool bWrapped = false;
//STRIP001     sal_uInt16 nEntryCount = pArray->GetCount( mnFocusLevel );
//STRIP001     sal_uInt16 nOldEntry = mnFocusEntry;
//STRIP001 
//STRIP001     do
//STRIP001     {
//STRIP001         if ( mnFocusEntry == SC_OL_HEADERENTRY )
//STRIP001         {
//STRIP001             // move from header to first or last entry
//STRIP001             if ( nEntryCount > 0 )
//STRIP001                 mnFocusEntry = bForward ? 0 : (nEntryCount - 1);
//STRIP001             /*  wrapped, if forward from right header to first entry,
//STRIP001                 or if backward from left header to last entry */
//STRIP001             if ( !nEntryCount || (bForward == mbMirrorHdr) )
//STRIP001                 bWrapped = true;
//STRIP001         }
//STRIP001         else if ( lcl_RotateValue( mnFocusEntry, 0, nEntryCount - 1, bForward ) )
//STRIP001         {
//STRIP001             // lcl_RotateValue returns true -> wrapped the entry range -> move to header
//STRIP001             mnFocusEntry = SC_OL_HEADERENTRY;
//STRIP001             /*  wrapped, if forward from last entry to left header,
//STRIP001                 or if backward from first entry to right header */
//STRIP001             if ( bForward != mbMirrorHdr )
//STRIP001                 bWrapped = true;
//STRIP001         }
//STRIP001     }
//STRIP001     while ( bFindVisible && !IsFocusButtonVisible() && (nOldEntry != mnFocusEntry) );
//STRIP001 
//STRIP001     return bWrapped;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::ImplMoveFocusByLevel( bool bForward )
//STRIP001 {
//STRIP001     const ScOutlineArray* pArray = GetOutlineArray();
//STRIP001     if ( !pArray )
//STRIP001         return false;
//STRIP001 
//STRIP001     bool bWrapped = false;
//STRIP001     sal_uInt16 nLevelCount = GetLevelCount();
//STRIP001 
//STRIP001     if ( mnFocusEntry == SC_OL_HEADERENTRY )
//STRIP001     {
//STRIP001         if ( nLevelCount > 0 )
//STRIP001             bWrapped = lcl_RotateValue( mnFocusLevel, 0, nLevelCount - 1, bForward );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         const ScOutlineEntry* pEntry = pArray->GetEntry( mnFocusLevel, mnFocusEntry );
//STRIP001         if ( pEntry )
//STRIP001         {
//STRIP001             sal_uInt16 nStart = pEntry->GetStart();
//STRIP001             sal_uInt16 nEnd = pEntry->GetEnd();
//STRIP001             sal_uInt16 nNewLevel = mnFocusLevel;
//STRIP001             sal_uInt16 nNewEntry;
//STRIP001 
//STRIP001             bool bFound = false;
//STRIP001             if ( bForward && (mnFocusLevel + 2 < nLevelCount) )
//STRIP001             {
//STRIP001                 // next level -> find first child entry
//STRIP001                 nNewLevel = mnFocusLevel + 1;
//STRIP001                 bFound = !!pArray->GetEntryIndexInRange( nNewLevel, nStart, nEnd, nNewEntry );
//STRIP001             }
//STRIP001             else if ( !bForward && (mnFocusLevel > 0) )
//STRIP001             {
//STRIP001                 // previous level -> find parent entry
//STRIP001                 nNewLevel = mnFocusLevel - 1;
//STRIP001                 bFound = !!pArray->GetEntryIndex( nNewLevel, nStart, nNewEntry );
//STRIP001             }
//STRIP001 
//STRIP001             if ( bFound && IsButtonVisible( nNewLevel, nNewEntry ) )
//STRIP001             {
//STRIP001                 mnFocusLevel = nNewLevel;
//STRIP001                 mnFocusEntry = nNewEntry;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bWrapped;
//STRIP001 }

//STRIP001 bool ScOutlineWindow::ImplMoveFocusByTabOrder( bool bForward, bool bFindVisible )
//STRIP001 {
//STRIP001     bool bRet = false;
//STRIP001     sal_uInt16 nOldLevel = mnFocusLevel;
//STRIP001     sal_uInt16 nOldEntry = mnFocusEntry;
//STRIP001 
//STRIP001     do
//STRIP001     {
//STRIP001         /*  one level up, if backward from left header,
//STRIP001             or one level down, if forward from right header */
//STRIP001         if ( (bForward == mbMirrorHdr) && (mnFocusEntry == SC_OL_HEADERENTRY) )
//STRIP001             bRet |= ImplMoveFocusByLevel( bForward );
//STRIP001         // move to next/previous entry
//STRIP001         bool bWrapInLevel = ImplMoveFocusByEntry( bForward, false );
//STRIP001         bRet |= bWrapInLevel;
//STRIP001         /*  one level up, if wrapped backward to right header,
//STRIP001             or one level down, if wrapped forward to right header */
//STRIP001         if ( (bForward != mbMirrorHdr) && bWrapInLevel )
//STRIP001             bRet |= ImplMoveFocusByLevel( bForward );
//STRIP001     }
//STRIP001     while ( bFindVisible && !IsFocusButtonVisible() && ((nOldLevel != mnFocusLevel) || (nOldEntry != mnFocusEntry)) );
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 void ScOutlineWindow::ImplMoveFocusToVisible( bool bForward )
//STRIP001 {
//STRIP001     // first try to find an entry in the same level
//STRIP001     if ( !IsFocusButtonVisible() )
//STRIP001         ImplMoveFocusByEntry( bForward, true );
//STRIP001     // then try to find any other entry
//STRIP001     if ( !IsFocusButtonVisible() )
//STRIP001         ImplMoveFocusByTabOrder( bForward, true );
//STRIP001 }

//STRIP001 void ScOutlineWindow::MoveFocusByEntry( bool bForward )
//STRIP001 {
//STRIP001     HideFocus();
//STRIP001     ImplMoveFocusByEntry( bForward, true );
//STRIP001     ShowFocus();
//STRIP001 }
//STRIP001 
//STRIP001 void ScOutlineWindow::MoveFocusByLevel( bool bForward )
//STRIP001 {
//STRIP001     HideFocus();
//STRIP001     ImplMoveFocusByLevel( bForward );
//STRIP001     ShowFocus();
//STRIP001 }
//STRIP001 
//STRIP001 void ScOutlineWindow::MoveFocusByTabOrder( bool bForward )
//STRIP001 {
//STRIP001     HideFocus();
//STRIP001     ImplMoveFocusByTabOrder( bForward, true );
//STRIP001     ShowFocus();
//STRIP001 }

//STRIP001 void ScOutlineWindow::GetFocus()
//STRIP001 {
//STRIP001     Window::GetFocus();
//STRIP001     ShowFocus();
//STRIP001 }

//STRIP001 void ScOutlineWindow::LoseFocus()
//STRIP001 {
//STRIP001     HideFocus();
//STRIP001     Window::LoseFocus();
//STRIP001 }


// mouse ----------------------------------------------------------------------

//STRIP001 void ScOutlineWindow::StartMouseTracking( sal_uInt16 nLevel, sal_uInt16 nEntry )
//STRIP001 {
//STRIP001     mbMTActive = true;
//STRIP001     mnMTLevel = nLevel;
//STRIP001     mnMTEntry = nEntry;
//STRIP001     DrawBorderRel( nLevel, nEntry, true );
//STRIP001 }

//STRIP001 void ScOutlineWindow::EndMouseTracking()
//STRIP001 {
//STRIP001     if ( mbMTPressed )
//STRIP001         DrawBorderRel( mnMTLevel, mnMTEntry, false );
//STRIP001     mbMTActive = false;
//STRIP001 }

//STRIP001 void ScOutlineWindow::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if ( IsMouseTracking() )
//STRIP001 	{
//STRIP001         sal_uInt16 nLevel, nEntry;
//STRIP001         bool bHit = false;
//STRIP001 
//STRIP001         if ( ButtonHit( rMEvt.GetPosPixel(), nLevel, nEntry ) )
//STRIP001             bHit = (nLevel == mnMTLevel) && (nEntry == mnMTEntry);
//STRIP001 
//STRIP001         if ( bHit != mbMTPressed )
//STRIP001             DrawBorderRel( mnMTLevel, mnMTEntry, bHit );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutlineWindow::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if ( IsMouseTracking() )
//STRIP001 	{
//STRIP001         EndMouseTracking();
//STRIP001 
//STRIP001         sal_uInt16 nLevel, nEntry;
//STRIP001         if ( ButtonHit( rMEvt.GetPosPixel(), nLevel, nEntry ) )
//STRIP001             if ( (nLevel == mnMTLevel) && (nEntry == mnMTEntry) )
//STRIP001                 DoFunction( nLevel, nEntry );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutlineWindow::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     sal_uInt16 nLevel, nEntry;
//STRIP001     bool bHit = ButtonHit( rMEvt.GetPosPixel(), nLevel, nEntry );
//STRIP001     if ( bHit )
//STRIP001         StartMouseTracking( nLevel, nEntry );
//STRIP001     else if ( rMEvt.GetClicks() == 2 )
//STRIP001 	{
//STRIP001         bHit = LineHit( rMEvt.GetPosPixel(), nLevel, nEntry );
//STRIP001         if ( bHit )
//STRIP001             DoFunction( nLevel, nEntry );
//STRIP001 	}
//STRIP001 
//STRIP001     // if an item has been hit and window is focused, move focus to this item
//STRIP001     if ( bHit && HasFocus() )
//STRIP001     {
//STRIP001         HideFocus();
//STRIP001         mnFocusLevel = nLevel;
//STRIP001         mnFocusEntry = nEntry;
//STRIP001         ShowFocus();
//STRIP001     }
//STRIP001 }


// keyboard -------------------------------------------------------------------

//STRIP001 void ScOutlineWindow::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     const KeyCode& rKCode = rKEvt.GetKeyCode();
//STRIP001     bool bNoMod = !rKCode.GetModifier();
//STRIP001     bool bShift = (rKCode.GetModifier() == KEY_SHIFT);
//STRIP001     bool bCtrl = (rKCode.GetModifier() == KEY_MOD1);
//STRIP001 
//STRIP001     sal_uInt16 nCode = rKCode.GetCode();
//STRIP001     bool bUpDownKey = (nCode == KEY_UP) || (nCode == KEY_DOWN);
//STRIP001     bool bLeftRightKey = (nCode == KEY_LEFT) || (nCode == KEY_RIGHT);
//STRIP001 
//STRIP001     // TAB key
//STRIP001     if ( (nCode == KEY_TAB) && (bNoMod || bShift) )
//STRIP001         // move forward without SHIFT key
//STRIP001         MoveFocusByTabOrder( bNoMod );
//STRIP001 
//STRIP001     // LEFT/RIGHT/UP/DOWN keys
//STRIP001     else if ( bNoMod && (bUpDownKey || bLeftRightKey) )
//STRIP001     {
//STRIP001         bool bForward = (nCode == KEY_DOWN) || (nCode == KEY_RIGHT);
//STRIP001         if ( mbHoriz == bLeftRightKey )
//STRIP001             // move inside level with LEFT/RIGHT in horizontal and with UP/DOWN in vertical
//STRIP001             MoveFocusByEntry( bForward );
//STRIP001         else
//STRIP001             // move to next/prev level with LEFT/RIGHT in vertical and with UP/DOWN in horizontal
//STRIP001             MoveFocusByLevel( bForward );
//STRIP001     }
//STRIP001 
//STRIP001     // CTRL + number
//STRIP001     else if ( bCtrl && (nCode >= KEY_1) && (nCode <= KEY_9) )
//STRIP001     {
//STRIP001         sal_uInt16 nLevel = nCode - KEY_1;
//STRIP001         if ( nLevel < GetLevelCount() )
//STRIP001             DoFunction( nLevel, SC_OL_HEADERENTRY );
//STRIP001     }
//STRIP001 
//STRIP001     // other key codes
//STRIP001     else switch ( rKCode.GetFullCode() )
//STRIP001     {
//STRIP001         case KEY_ADD:       DoExpand( mnFocusLevel, mnFocusEntry );     break;
//STRIP001         case KEY_SUBTRACT:  DoCollapse( mnFocusLevel, mnFocusEntry );   break;
//STRIP001         case KEY_SPACE:
//STRIP001         case KEY_RETURN:    DoFunction( mnFocusLevel, mnFocusEntry );   break;
//STRIP001         default:            Window::KeyInput( rKEvt );
//STRIP001     }
//STRIP001 }


// ============================================================================

}
