/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_prevloc.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:32:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <vcl/window.hxx>
// auto strip #include <tools/debug.hxx>

// auto strip #include "prevloc.hxx"
// auto strip #include "document.hxx"
namespace binfilter {

//==================================================================

//STRIP001 enum ScPreviewLocationType
//STRIP001 {
//STRIP001 	SC_PLOC_CELLRANGE,
//STRIP001 	SC_PLOC_COLHEADER,
//STRIP001 	SC_PLOC_ROWHEADER,
//STRIP001 	SC_PLOC_LEFTHEADER,
//STRIP001 	SC_PLOC_RIGHTHEADER,
//STRIP001 	SC_PLOC_LEFTFOOTER,
//STRIP001 	SC_PLOC_RIGHTFOOTER,
//STRIP001 	SC_PLOC_NOTEMARK,
//STRIP001 	SC_PLOC_NOTETEXT
//STRIP001 };

//STRIP001 struct ScPreviewLocationEntry
//STRIP001 {
//STRIP001 	ScPreviewLocationType	eType;
//STRIP001 	Rectangle				aPixelRect;
//STRIP001 	ScRange					aCellRange;
//STRIP001 	BOOL					bRepeatCol;
//STRIP001 	BOOL					bRepeatRow;
//STRIP001 
//STRIP001 	ScPreviewLocationEntry( ScPreviewLocationType eNewType, const Rectangle& rPixel, const ScRange& rRange,
//STRIP001 							BOOL bRepCol, BOOL bRepRow ) :
//STRIP001 		eType( eNewType ),
//STRIP001 		aPixelRect( rPixel ),
//STRIP001 		aCellRange( rRange ),
//STRIP001 		bRepeatCol( bRepCol ),
//STRIP001 		bRepeatRow( bRepRow )
//STRIP001 	{
//STRIP001 	}
//STRIP001 };

//==================================================================

//STRIP001 ScPreviewTableInfo::ScPreviewTableInfo() :
//STRIP001 	nTab(0),
//STRIP001 	nCols(0),
//STRIP001 	nRows(0),
//STRIP001 	pColInfo(NULL),
//STRIP001 	pRowInfo(NULL)
//STRIP001 {
//STRIP001 }

//STRIP001 ScPreviewTableInfo::~ScPreviewTableInfo()
//STRIP001 {
//STRIP001 	delete[] pColInfo;
//STRIP001 	delete[] pRowInfo;
//STRIP001 }

//STRIP001 void ScPreviewTableInfo::SetTab( USHORT nNewTab )
//STRIP001 {
//STRIP001 	nTab = nNewTab;
//STRIP001 }

//STRIP001 void ScPreviewTableInfo::SetColInfo( USHORT nCount, ScPreviewColRowInfo* pNewInfo )
//STRIP001 {
//STRIP001 	delete[] pColInfo;
//STRIP001 	pColInfo = pNewInfo;
//STRIP001 	nCols = nCount;
//STRIP001 }

//STRIP001 void ScPreviewTableInfo::SetRowInfo( USHORT nCount, ScPreviewColRowInfo* pNewInfo )
//STRIP001 {
//STRIP001 	delete[] pRowInfo;
//STRIP001 	pRowInfo = pNewInfo;
//STRIP001 	nRows = nCount;
//STRIP001 }

//STRIP001 void ScPreviewTableInfo::LimitToArea( const Rectangle& rPixelArea )
//STRIP001 {
//STRIP001 	if ( pColInfo )
//STRIP001 	{
//STRIP001 		//	cells completely left of the visible area
//STRIP001 		USHORT nStart = 0;
//STRIP001 		while ( nStart < nCols && pColInfo[nStart].nPixelEnd < rPixelArea.Left() )
//STRIP001 			++nStart;
//STRIP001 
//STRIP001 		//	cells completely right of the visible area
//STRIP001 		USHORT nEnd = nCols;
//STRIP001 		while ( nEnd > 0 && pColInfo[nEnd-1].nPixelStart > rPixelArea.Right() )
//STRIP001 			--nEnd;
//STRIP001 
//STRIP001 		if ( nStart > 0 || nEnd < nCols )
//STRIP001 		{
//STRIP001 			if ( nEnd > nStart )
//STRIP001 			{
//STRIP001 				USHORT nNewCount = nEnd - nStart;
//STRIP001 				ScPreviewColRowInfo* pNewInfo = new ScPreviewColRowInfo[nNewCount];
//STRIP001 				for (USHORT i=0; i<nNewCount; i++)
//STRIP001 					pNewInfo[i] = pColInfo[nStart + i];
//STRIP001 				SetColInfo( nNewCount, pNewInfo );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				SetColInfo( 0, NULL );		// all invisible
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pRowInfo )
//STRIP001 	{
//STRIP001 		//	cells completely above the visible area
//STRIP001 		USHORT nStart = 0;
//STRIP001 		while ( nStart < nRows && pRowInfo[nStart].nPixelEnd < rPixelArea.Top() )
//STRIP001 			++nStart;
//STRIP001 
//STRIP001 		//	cells completely below the visible area
//STRIP001 		USHORT nEnd = nRows;
//STRIP001 		while ( nEnd > 0 && pRowInfo[nEnd-1].nPixelStart > rPixelArea.Bottom() )
//STRIP001 			--nEnd;
//STRIP001 
//STRIP001 		if ( nStart > 0 || nEnd < nRows )
//STRIP001 		{
//STRIP001 			if ( nEnd > nStart )
//STRIP001 			{
//STRIP001 				USHORT nNewCount = nEnd - nStart;
//STRIP001 				ScPreviewColRowInfo* pNewInfo = new ScPreviewColRowInfo[nNewCount];
//STRIP001 				for (USHORT i=0; i<nNewCount; i++)
//STRIP001 					pNewInfo[i] = pRowInfo[nStart + i];
//STRIP001 				SetRowInfo( nNewCount, pNewInfo );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				SetRowInfo( 0, NULL );		// all invisible
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 ScPreviewLocationData::ScPreviewLocationData( ScDocument* pDocument, Window* pWin ) :
//STRIP001 	pDoc( pDocument ),
//STRIP001 	pWindow( pWin ),
//STRIP001 	nDrawRanges( 0 ),
//STRIP001 	nPrintTab( 0 )
//STRIP001 {
//STRIP001 }

//STRIP001 ScPreviewLocationData::~ScPreviewLocationData()
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 }

//STRIP001 void ScPreviewLocationData::SetCellMapMode( const MapMode& rMapMode )
//STRIP001 {
//STRIP001 	aCellMapMode = rMapMode;
//STRIP001 }

//STRIP001 void ScPreviewLocationData::SetPrintTab( USHORT nNew )
//STRIP001 {
//STRIP001 	nPrintTab = nNew;
//STRIP001 }

//STRIP001 void ScPreviewLocationData::Clear()
//STRIP001 {
//STRIP001 	void* pEntry = aEntries.First();
//STRIP001 	while ( pEntry )
//STRIP001 	{
//STRIP001 		delete (ScPreviewLocationEntry*) pEntry;
//STRIP001 		pEntry = aEntries.Next();
//STRIP001 	}
//STRIP001 	aEntries.Clear();
//STRIP001 
//STRIP001 	nDrawRanges = 0;
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddCellRange( const Rectangle& rRect, const ScRange& rRange, BOOL bRepCol, BOOL bRepRow,
//STRIP001 											const MapMode& rDrawMap )
//STRIP001 {
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( SC_PLOC_CELLRANGE, aPixelRect, rRange, bRepCol, bRepRow ) );
//STRIP001 
//STRIP001 	DBG_ASSERT( nDrawRanges < SC_PREVIEW_MAXRANGES, "too many ranges" );
//STRIP001 	if ( nDrawRanges < SC_PREVIEW_MAXRANGES )
//STRIP001 	{
//STRIP001 		aDrawRectangle[nDrawRanges] = aPixelRect;
//STRIP001 		aDrawMapMode[nDrawRanges] = rDrawMap;
//STRIP001 	        if (bRepCol)
//STRIP001         	    if (bRepRow)
//STRIP001                 	aDrawRangeId[nDrawRanges] = SC_PREVIEW_RANGE_EDGE;
//STRIP001 	            else
//STRIP001         	        aDrawRangeId[nDrawRanges] = SC_PREVIEW_RANGE_REPCOL;
//STRIP001 	        else
//STRIP001         	    if (bRepRow)
//STRIP001                 	aDrawRangeId[nDrawRanges] = SC_PREVIEW_RANGE_REPROW;
//STRIP001 	            else
//STRIP001         	        aDrawRangeId[nDrawRanges] = SC_PREVIEW_RANGE_TAB;
//STRIP001 		++nDrawRanges;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddColHeaders( const Rectangle& rRect, USHORT nStartCol, USHORT nEndCol, BOOL bRepCol )
//STRIP001 {
//STRIP001 	USHORT nTab = 0;	//! ?
//STRIP001 	ScRange aRange( nStartCol, 0, nTab, nEndCol, 0, nTab );
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( SC_PLOC_COLHEADER, aPixelRect, aRange, bRepCol, FALSE ) );
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddRowHeaders( const Rectangle& rRect, USHORT nStartRow, USHORT nEndRow, BOOL bRepRow )
//STRIP001 {
//STRIP001 	USHORT nTab = 0;	//! ?
//STRIP001 	ScRange aRange( 0, nStartRow, nTab, 0, nEndRow, nTab );
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( SC_PLOC_ROWHEADER, aPixelRect, aRange, FALSE, bRepRow ) );
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddHeaderFooter( const Rectangle& rRect, BOOL bHeader, BOOL bLeft )
//STRIP001 {
//STRIP001 	ScRange aRange;		//! ?
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 
//STRIP001 	ScPreviewLocationType eType = bHeader ?
//STRIP001 				( bLeft ? SC_PLOC_LEFTHEADER : SC_PLOC_RIGHTHEADER ) :
//STRIP001 				( bLeft ? SC_PLOC_LEFTFOOTER : SC_PLOC_RIGHTFOOTER );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( eType, aPixelRect, aRange, FALSE, FALSE ) );
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddNoteMark( const Rectangle& rRect, const ScAddress& rPos )
//STRIP001 {
//STRIP001 	ScRange aRange( rPos );
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( SC_PLOC_NOTEMARK, aPixelRect, aRange, FALSE, FALSE ) );
//STRIP001 }

//STRIP001 void ScPreviewLocationData::AddNoteText( const Rectangle& rRect, const ScAddress& rPos )
//STRIP001 {
//STRIP001 	ScRange aRange( rPos );
//STRIP001 	Rectangle aPixelRect( pWindow->LogicToPixel( rRect ) );
//STRIP001 	aEntries.Insert( new ScPreviewLocationEntry( SC_PLOC_NOTETEXT, aPixelRect, aRange, FALSE, FALSE ) );
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScPreviewLocationData::GetDrawRange( USHORT nPos, Rectangle& rPixelRect, MapMode& rMapMode, sal_uInt8& rRangeId ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( nPos < nDrawRanges, "wrong position" );
//STRIP001 	if ( nPos < nDrawRanges )
//STRIP001 	{
//STRIP001 		rPixelRect = aDrawRectangle[nPos];
//STRIP001 		rMapMode = aDrawMapMode[nPos];
//STRIP001         rRangeId = aDrawRangeId[nPos];
//STRIP001 	}
//STRIP001 }

//STRIP001 ScPreviewLocationEntry* lcl_GetEntryByPosition( const List& rEntries, const Point& rPos, ScPreviewLocationType eType )
//STRIP001 {
//STRIP001 	ULONG nCount = rEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)rEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == eType && pEntry->aPixelRect.IsInside( rPos ) )
//STRIP001 			return pEntry;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 ScPreviewLocationEntry* lcl_GetEntryByAddress( const List& rEntries, const ScAddress& rPos, ScPreviewLocationType eType )
//STRIP001 {
//STRIP001 	ULONG nCount = rEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)rEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == eType && pEntry->aCellRange.In( rPos ) )
//STRIP001 			return pEntry;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 ScAddress ScPreviewLocationData::GetCellFromRange( const Size& rOffsetPixel, const ScRange& rRange ) const
//STRIP001 {
//STRIP001 	const double nScaleX = HMM_PER_TWIPS;
//STRIP001 	const double nScaleY = HMM_PER_TWIPS;
//STRIP001 
//STRIP001 	Size aOffsetLogic = pWindow->PixelToLogic( rOffsetPixel, aCellMapMode );
//STRIP001 	USHORT nTab = rRange.aStart.Tab();
//STRIP001 
//STRIP001 	long nPosX = 0;
//STRIP001 	USHORT nCol = rRange.aStart.Col();
//STRIP001 	USHORT nEndCol = rRange.aEnd.Col();
//STRIP001 	while ( nCol <= nEndCol && nPosX < aOffsetLogic.Width() )
//STRIP001 	{
//STRIP001 		USHORT nDocW = pDoc->GetColWidth( nCol, nTab );
//STRIP001 		if (nDocW)
//STRIP001 			nPosX += (long) (nDocW * nScaleX);
//STRIP001 		++nCol;
//STRIP001 	}
//STRIP001 	if ( nCol > rRange.aStart.Col() )
//STRIP001 		--nCol;
//STRIP001 
//STRIP001 	long nPosY = 0;
//STRIP001 	USHORT nRow = rRange.aStart.Row();
//STRIP001 	USHORT nEndRow = rRange.aEnd.Row();
//STRIP001 	while ( nRow <= nEndRow && nPosY < aOffsetLogic.Height() )
//STRIP001 	{
//STRIP001 		USHORT nDocH = pDoc->FastGetRowHeight( nRow, nTab );
//STRIP001 		if (nDocH)
//STRIP001 			nPosY += (long) (nDocH * nScaleY);
//STRIP001 		++nRow;
//STRIP001 	}
//STRIP001 	if ( nRow > rRange.aStart.Row() )
//STRIP001 		--nRow;
//STRIP001 
//STRIP001 	return ScAddress( nCol, nRow, nTab );
//STRIP001 }

//STRIP001 Rectangle ScPreviewLocationData::GetOffsetPixel( const ScAddress& rCellPos, const ScRange& rRange ) const
//STRIP001 {
//STRIP001 	const double nScaleX = HMM_PER_TWIPS;
//STRIP001 	const double nScaleY = HMM_PER_TWIPS;
//STRIP001 	USHORT nTab = rRange.aStart.Tab();
//STRIP001 
//STRIP001 	long nPosX = 0;
//STRIP001 	USHORT nEndCol = rCellPos.Col();
//STRIP001 	for (USHORT nCol = rRange.aStart.Col(); nCol < nEndCol; nCol++)
//STRIP001 	{
//STRIP001 		USHORT nDocW = pDoc->GetColWidth( nCol, nTab );
//STRIP001 		if (nDocW)
//STRIP001 			nPosX += (long) (nDocW * nScaleX);
//STRIP001 	}
//STRIP001 	long nSizeX = (long) ( pDoc->GetColWidth( nEndCol, nTab ) * nScaleX );
//STRIP001 
//STRIP001 	long nPosY = 0;
//STRIP001 	USHORT nEndRow = rCellPos.Row();
//STRIP001 	for (USHORT nRow = rRange.aStart.Row(); nRow < nEndRow; nRow++)
//STRIP001 	{
//STRIP001 		USHORT nDocH = pDoc->FastGetRowHeight( nRow, nTab );
//STRIP001 		if (nDocH)
//STRIP001 			nPosY += (long) (nDocH * nScaleY);
//STRIP001 	}
//STRIP001 	long nSizeY = (long) ( pDoc->FastGetRowHeight( nEndRow, nTab ) * nScaleY );
//STRIP001 
//STRIP001 	Size aOffsetLogic( nPosX, nPosY );
//STRIP001 	Size aSizeLogic( nSizeX, nSizeY );
//STRIP001 	Size aOffsetPixel = pWindow->LogicToPixel( aOffsetLogic, aCellMapMode );
//STRIP001 	Size aSizePixel = pWindow->LogicToPixel( aSizeLogic, aCellMapMode );
//STRIP001 
//STRIP001 	return Rectangle( Point( aOffsetPixel.Width(), aOffsetPixel.Height() ), aSizePixel );
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::GetCell( const Point& rPos, ScAddress& rCellPos, Rectangle& rCellRect ) const
//STRIP001 {
//STRIP001 	ScPreviewLocationEntry* pEntry = lcl_GetEntryByPosition( aEntries, rPos, SC_PLOC_CELLRANGE );
//STRIP001 	if ( pEntry )
//STRIP001 	{
//STRIP001 		Size aOffsetPixel( rPos.X() - pEntry->aPixelRect.Left(), rPos.Y() - pEntry->aPixelRect.Top() );
//STRIP001 		rCellPos = GetCellFromRange( aOffsetPixel, pEntry->aCellRange );
//STRIP001 
//STRIP001 		Rectangle aOffsetRect = GetOffsetPixel( rCellPos, pEntry->aCellRange );
//STRIP001 		rCellRect = Rectangle( aOffsetRect.Left() + pEntry->aPixelRect.Left(),
//STRIP001 							   aOffsetRect.Top() + pEntry->aPixelRect.Top(),
//STRIP001 							   aOffsetRect.Right() + pEntry->aPixelRect.Left(),
//STRIP001 							   aOffsetRect.Bottom() + pEntry->aPixelRect.Top() );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::GetCellPosition( const ScAddress& rCellPos, Rectangle& rCellRect ) const
//STRIP001 {
//STRIP001 	ScPreviewLocationEntry* pEntry = lcl_GetEntryByAddress( aEntries, rCellPos, SC_PLOC_CELLRANGE );
//STRIP001 	if ( pEntry )
//STRIP001 	{
//STRIP001 		Rectangle aOffsetRect = GetOffsetPixel( rCellPos, pEntry->aCellRange );
//STRIP001 		rCellRect = Rectangle( aOffsetRect.Left() + pEntry->aPixelRect.Left(),
//STRIP001 							   aOffsetRect.Top() + pEntry->aPixelRect.Top(),
//STRIP001 							   aOffsetRect.Right() + pEntry->aPixelRect.Left(),
//STRIP001 							   aOffsetRect.Bottom() + pEntry->aPixelRect.Top() );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::HasCellsInRange( const Rectangle& rVisiblePixel ) const
//STRIP001 {
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		ScPreviewLocationType eType = pEntry->eType;
//STRIP001 		if ( eType == SC_PLOC_CELLRANGE || eType == SC_PLOC_COLHEADER || eType == SC_PLOC_ROWHEADER )
//STRIP001 			if ( pEntry->aPixelRect.IsOver( rVisiblePixel ) )
//STRIP001 				return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::GetHeaderPosition( Rectangle& rRect ) const
//STRIP001 {
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == SC_PLOC_LEFTHEADER || pEntry->eType == SC_PLOC_RIGHTHEADER )
//STRIP001 		{
//STRIP001 			rRect = pEntry->aPixelRect;
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::GetFooterPosition( Rectangle& rRect ) const
//STRIP001 {
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == SC_PLOC_LEFTFOOTER || pEntry->eType == SC_PLOC_RIGHTFOOTER )
//STRIP001 		{
//STRIP001 			rRect = pEntry->aPixelRect;
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::IsHeaderLeft() const
//STRIP001 {
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == SC_PLOC_LEFTHEADER )
//STRIP001 			return TRUE;
//STRIP001 		if ( pEntry->eType == SC_PLOC_RIGHTHEADER )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::IsFooterLeft() const
//STRIP001 {
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == SC_PLOC_LEFTFOOTER )
//STRIP001 			return TRUE;
//STRIP001 		if ( pEntry->eType == SC_PLOC_RIGHTFOOTER )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 long ScPreviewLocationData::GetNoteCountInRange( const Rectangle& rVisiblePixel, BOOL bNoteMarks ) const
//STRIP001 {
//STRIP001 	ScPreviewLocationType eType = bNoteMarks ? SC_PLOC_NOTEMARK : SC_PLOC_NOTETEXT;
//STRIP001 
//STRIP001 	ULONG nRet = 0;
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == eType && pEntry->aPixelRect.IsOver( rVisiblePixel ) )
//STRIP001 			++nRet;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 BOOL ScPreviewLocationData::GetNoteInRange( const Rectangle& rVisiblePixel, long nIndex, BOOL bNoteMarks,
//STRIP001 											ScAddress& rCellPos, Rectangle& rNoteRect ) const
//STRIP001 {
//STRIP001 	ScPreviewLocationType eType = bNoteMarks ? SC_PLOC_NOTEMARK : SC_PLOC_NOTETEXT;
//STRIP001 
//STRIP001 	ULONG nPos = 0;
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == eType && pEntry->aPixelRect.IsOver( rVisiblePixel ) )
//STRIP001 		{
//STRIP001 			if ( nPos == nIndex )
//STRIP001 			{
//STRIP001 				rCellPos = pEntry->aCellRange.aStart;
//STRIP001 				rNoteRect = pEntry->aPixelRect;
//STRIP001 				return TRUE;
//STRIP001 			}
//STRIP001 			++nPos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 Rectangle ScPreviewLocationData::GetNoteInRangeOutputRect(const Rectangle& rVisiblePixel, BOOL bNoteMarks, const ScAddress& aCellPos) const
//STRIP001 {
//STRIP001 	ScPreviewLocationType eType = bNoteMarks ? SC_PLOC_NOTEMARK : SC_PLOC_NOTETEXT;
//STRIP001 
//STRIP001 	ULONG nPos = 0;
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == eType && pEntry->aPixelRect.IsOver( rVisiblePixel ) )
//STRIP001 		{
//STRIP001 			if ( aCellPos == pEntry->aCellRange.aStart )
//STRIP001 				return pEntry->aPixelRect;
//STRIP001 			++nPos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return Rectangle();
//STRIP001 }

//STRIP001 void ScPreviewLocationData::GetTableInfo( const Rectangle& rVisiblePixel, ScPreviewTableInfo& rInfo ) const
//STRIP001 {
//STRIP001 	const double nScaleX = HMM_PER_TWIPS;
//STRIP001 	const double nScaleY = HMM_PER_TWIPS;
//STRIP001 
//STRIP001 	// from left to right:
//STRIP001 	BOOL bHasHeaderCol = FALSE;
//STRIP001 	BOOL bHasRepCols   = FALSE;
//STRIP001 	BOOL bHasMainCols  = FALSE;
//STRIP001 	USHORT nRepeatColStart = 0;
//STRIP001 	USHORT nRepeatColEnd   = 0;
//STRIP001 	USHORT nMainColStart   = 0;
//STRIP001 	USHORT nMainColEnd     = 0;
//STRIP001 
//STRIP001 	// from top to bottom:
//STRIP001 	BOOL bHasHeaderRow = FALSE;
//STRIP001 	BOOL bHasRepRows   = FALSE;
//STRIP001 	BOOL bHasMainRows  = FALSE;
//STRIP001 	USHORT nRepeatRowStart = 0;
//STRIP001 	USHORT nRepeatRowEnd   = 0;
//STRIP001 	USHORT nMainRowStart   = 0;
//STRIP001 	USHORT nMainRowEnd     = 0;
//STRIP001 
//STRIP001 	Rectangle aHeaderRect, aRepeatRect, aMainRect;
//STRIP001 	USHORT nTab = 0;
//STRIP001 
//STRIP001 	ULONG nCount = aEntries.Count();
//STRIP001 	for (ULONG nListPos=0; nListPos<nCount; nListPos++)
//STRIP001 	{
//STRIP001 		ScPreviewLocationEntry* pEntry = (ScPreviewLocationEntry*)aEntries.GetObject(nListPos);
//STRIP001 		if ( pEntry->eType == SC_PLOC_CELLRANGE )
//STRIP001 		{
//STRIP001 			if ( pEntry->bRepeatCol )
//STRIP001 			{
//STRIP001 				bHasRepCols = TRUE;
//STRIP001 				nRepeatColStart = pEntry->aCellRange.aStart.Col();
//STRIP001 				nRepeatColEnd = pEntry->aCellRange.aEnd.Col();
//STRIP001 				aRepeatRect.Left() = pEntry->aPixelRect.Left();
//STRIP001 				aRepeatRect.Right() = pEntry->aPixelRect.Right();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bHasMainCols = TRUE;
//STRIP001 				nMainColStart = pEntry->aCellRange.aStart.Col();
//STRIP001 				nMainColEnd = pEntry->aCellRange.aEnd.Col();
//STRIP001 				aMainRect.Left() = pEntry->aPixelRect.Left();
//STRIP001 				aMainRect.Right() = pEntry->aPixelRect.Right();
//STRIP001 			}
//STRIP001 			if ( pEntry->bRepeatRow )
//STRIP001 			{
//STRIP001 				bHasRepRows = TRUE;
//STRIP001 				nRepeatRowStart = pEntry->aCellRange.aStart.Row();
//STRIP001 				nRepeatRowEnd = pEntry->aCellRange.aEnd.Row();
//STRIP001 				aRepeatRect.Top() = pEntry->aPixelRect.Top();
//STRIP001 				aRepeatRect.Bottom() = pEntry->aPixelRect.Bottom();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bHasMainRows = TRUE;
//STRIP001 				nMainRowStart = pEntry->aCellRange.aStart.Row();
//STRIP001 				nMainRowEnd = pEntry->aCellRange.aEnd.Row();
//STRIP001 				aMainRect.Top() = pEntry->aPixelRect.Top();
//STRIP001 				aMainRect.Bottom() = pEntry->aPixelRect.Bottom();
//STRIP001 			}
//STRIP001 			nTab = pEntry->aCellRange.aStart.Tab();		//! store separately?
//STRIP001 		}
//STRIP001 		else if ( pEntry->eType == SC_PLOC_ROWHEADER )
//STRIP001 		{
//STRIP001 			// row headers result in an additional column
//STRIP001 			bHasHeaderCol = TRUE;
//STRIP001 			aHeaderRect.Left() = pEntry->aPixelRect.Left();
//STRIP001 			aHeaderRect.Right() = pEntry->aPixelRect.Right();
//STRIP001 		}
//STRIP001 		else if ( pEntry->eType == SC_PLOC_COLHEADER )
//STRIP001 		{
//STRIP001 			// column headers result in an additional row
//STRIP001 			bHasHeaderRow = TRUE;
//STRIP001 			aHeaderRect.Top() = pEntry->aPixelRect.Top();
//STRIP001 			aHeaderRect.Bottom() = pEntry->aPixelRect.Bottom();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 	//	get column info
//STRIP001 	//
//STRIP001 
//STRIP001 	USHORT nColCount = 0;
//STRIP001 	USHORT nCol;
//STRIP001 	if ( bHasHeaderCol )
//STRIP001 		++nColCount;
//STRIP001 	if ( bHasRepCols )
//STRIP001 		for ( nCol=nRepeatColStart; nCol<=nRepeatColEnd; nCol++ )
//STRIP001 			if ( ( pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				++nColCount;
//STRIP001 	if ( bHasMainCols )
//STRIP001 		for ( nCol=nMainColStart; nCol<=nMainColEnd; nCol++ )
//STRIP001 			if ( ( pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				++nColCount;
//STRIP001 
//STRIP001 	if ( nColCount > 0 )
//STRIP001 	{
//STRIP001 		ScPreviewColRowInfo* pColInfo = new ScPreviewColRowInfo[ nColCount ];
//STRIP001 		USHORT nColPos = 0;
//STRIP001 
//STRIP001 		if ( bHasHeaderCol )
//STRIP001 		{
//STRIP001 			pColInfo[nColPos].Set( TRUE, 0, aHeaderRect.Left(), aHeaderRect.Right() );
//STRIP001 			++nColPos;
//STRIP001 		}
//STRIP001 		if ( bHasRepCols )
//STRIP001 		{
//STRIP001 			long nPosX = 0;
//STRIP001 			for ( nCol=nRepeatColStart; nCol<=nRepeatColEnd; nCol++ )
//STRIP001 				if ( ( pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				{
//STRIP001 					USHORT nDocW = pDoc->GetColWidth( nCol, nTab );
//STRIP001 					long nNextX = nPosX + (long) (nDocW * nScaleX);
//STRIP001 
//STRIP001 					long nPixelStart = pWindow->LogicToPixel( Size( nPosX, 0 ), aCellMapMode ).Width();
//STRIP001 					long nPixelEnd = pWindow->LogicToPixel( Size( nNextX, 0 ), aCellMapMode ).Width() - 1;
//STRIP001 					pColInfo[nColPos].Set( FALSE, nCol,
//STRIP001 												aRepeatRect.Left() + nPixelStart,
//STRIP001 												aRepeatRect.Left() + nPixelEnd );
//STRIP001 
//STRIP001 					nPosX = nNextX;
//STRIP001 					++nColPos;
//STRIP001 				}
//STRIP001 		}
//STRIP001 		if ( bHasMainCols )
//STRIP001 		{
//STRIP001 			long nPosX = 0;
//STRIP001 			for ( nCol=nMainColStart; nCol<=nMainColEnd; nCol++ )
//STRIP001 				if ( ( pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				{
//STRIP001 					USHORT nDocW = pDoc->GetColWidth( nCol, nTab );
//STRIP001 					long nNextX = nPosX + (long) (nDocW * nScaleX);
//STRIP001 
//STRIP001 					long nPixelStart = pWindow->LogicToPixel( Size( nPosX, 0 ), aCellMapMode ).Width();
//STRIP001 					long nPixelEnd = pWindow->LogicToPixel( Size( nNextX, 0 ), aCellMapMode ).Width() - 1;
//STRIP001 					pColInfo[nColPos].Set( FALSE, nCol,
//STRIP001 												aMainRect.Left() + nPixelStart,
//STRIP001 												aMainRect.Left() + nPixelEnd );
//STRIP001 
//STRIP001 					nPosX = nNextX;
//STRIP001 					++nColPos;
//STRIP001 				}
//STRIP001 		}
//STRIP001 		rInfo.SetColInfo( nColCount, pColInfo );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rInfo.SetColInfo( 0, NULL );
//STRIP001 
//STRIP001 	//
//STRIP001 	//	get row info
//STRIP001 	//
//STRIP001 
//STRIP001 	USHORT nRowCount = 0;
//STRIP001 	USHORT nRow;
//STRIP001 	if ( bHasHeaderRow )
//STRIP001 		++nRowCount;
//STRIP001 	if ( bHasRepRows )
//STRIP001 		for ( nRow=nRepeatRowStart; nRow<=nRepeatRowEnd; nRow++ )
//STRIP001 			if ( ( pDoc->GetRowFlags( nRow, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				++nRowCount;
//STRIP001 	if ( bHasMainRows )
//STRIP001 		for ( nRow=nMainRowStart; nRow<=nMainRowEnd; nRow++ )
//STRIP001 			if ( ( pDoc->GetRowFlags( nRow, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				++nRowCount;
//STRIP001 
//STRIP001 	if ( nRowCount > 0 )
//STRIP001 	{
//STRIP001 		ScPreviewColRowInfo* pRowInfo = new ScPreviewColRowInfo[ nRowCount ];
//STRIP001 		USHORT nRowPos = 0;
//STRIP001 
//STRIP001 		if ( bHasHeaderRow )
//STRIP001 		{
//STRIP001 			pRowInfo[nRowPos].Set( TRUE, 0, aHeaderRect.Top(), aHeaderRect.Bottom() );
//STRIP001 			++nRowPos;
//STRIP001 		}
//STRIP001 		if ( bHasRepRows )
//STRIP001 		{
//STRIP001 			long nPosY = 0;
//STRIP001 			for ( nRow=nRepeatRowStart; nRow<=nRepeatRowEnd; nRow++ )
//STRIP001 				if ( ( pDoc->GetRowFlags( nRow, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				{
//STRIP001 					USHORT nDocH = pDoc->FastGetRowHeight( nRow, nTab );
//STRIP001 					long nNextY = nPosY + (long) (nDocH * nScaleY);
//STRIP001 
//STRIP001 					long nPixelStart = pWindow->LogicToPixel( Size( 0, nPosY ), aCellMapMode ).Height();
//STRIP001 					long nPixelEnd = pWindow->LogicToPixel( Size( 0, nNextY ), aCellMapMode ).Height() - 1;
//STRIP001 					pRowInfo[nRowPos].Set( FALSE, nRow,
//STRIP001 												aRepeatRect.Top() + nPixelStart,
//STRIP001 												aRepeatRect.Top() + nPixelEnd );
//STRIP001 
//STRIP001 					nPosY = nNextY;
//STRIP001 					++nRowPos;
//STRIP001 				}
//STRIP001 		}
//STRIP001 		if ( bHasMainRows )
//STRIP001 		{
//STRIP001 			long nPosY = 0;
//STRIP001 			for ( nRow=nMainRowStart; nRow<=nMainRowEnd; nRow++ )
//STRIP001 				if ( ( pDoc->GetRowFlags( nRow, nTab ) & CR_HIDDEN ) == 0 )
//STRIP001 				{
//STRIP001 					USHORT nDocH = pDoc->FastGetRowHeight( nRow, nTab );
//STRIP001 					long nNextY = nPosY + (long) (nDocH * nScaleY);
//STRIP001 
//STRIP001 					long nPixelStart = pWindow->LogicToPixel( Size( 0, nPosY ), aCellMapMode ).Height();
//STRIP001 					long nPixelEnd = pWindow->LogicToPixel( Size( 0, nNextY ), aCellMapMode ).Height() - 1;
//STRIP001 					pRowInfo[nRowPos].Set( FALSE, nRow,
//STRIP001 												aMainRect.Top() + nPixelStart,
//STRIP001 												aMainRect.Top() + nPixelEnd );
//STRIP001 
//STRIP001 					nPosY = nNextY;
//STRIP001 					++nRowPos;
//STRIP001 				}
//STRIP001 		}
//STRIP001 		rInfo.SetRowInfo( nRowCount, pRowInfo );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rInfo.SetRowInfo( 0, NULL );
//STRIP001 
//STRIP001 	//
//STRIP001 	//	limit to visible area
//STRIP001 	//
//STRIP001 
//STRIP001 	rInfo.SetTab( nTab );
//STRIP001 	rInfo.LimitToArea( rVisiblePixel );
//STRIP001 }

//STRIP001 Rectangle ScPreviewLocationData::GetHeaderCellOutputRect(const Rectangle& rVisRect, const ScAddress& rCellPos, sal_Bool bColHeader) const
//STRIP001 {
//STRIP001 	// first a stupid implementation
//STRIP001 	// NN says here should be done more
//STRIP001 	Rectangle aClipRect;
//STRIP001 	ScPreviewTableInfo aTableInfo;
//STRIP001 	GetTableInfo( rVisRect, aTableInfo );
//STRIP001 
//STRIP001 	if ( (rCellPos.Col() >= 0) &&
//STRIP001 		(rCellPos.Row() >= 0) && (rCellPos.Col() < aTableInfo.GetCols()) &&
//STRIP001 		(rCellPos.Row() < aTableInfo.GetRows()) )
//STRIP001 	{
//STRIP001 		sal_Int16 nCol(0);
//STRIP001 		sal_Int16 nRow(0);
//STRIP001 		if (bColHeader)
//STRIP001 			nCol = rCellPos.Col();
//STRIP001 		else
//STRIP001 			nRow = rCellPos.Row();
//STRIP001 		const ScPreviewColRowInfo& rColInfo = aTableInfo.GetColInfo()[nCol];
//STRIP001 		const ScPreviewColRowInfo& rRowInfo = aTableInfo.GetRowInfo()[nRow];
//STRIP001 
//STRIP001 		if ( rColInfo.bIsHeader || rRowInfo.bIsHeader )
//STRIP001 			aClipRect = Rectangle( rColInfo.nPixelStart, rRowInfo.nPixelStart, rColInfo.nPixelEnd, rRowInfo.nPixelEnd );
//STRIP001 	}
//STRIP001 	return aClipRect;
//STRIP001 }

//STRIP001 Rectangle ScPreviewLocationData::GetCellOutputRect(const ScAddress& rCellPos) const
//STRIP001 {
//STRIP001 	// first a stupid implementation
//STRIP001 	// NN says here should be done more
//STRIP001 	Rectangle aRect;
//STRIP001 	GetCellPosition(rCellPos, aRect);
//STRIP001 	return aRect;
//STRIP001 }
}
