/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drbezob.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:34:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_SHELL_HXX //autogen
// auto strip #include <bf_sfx2/shell.hxx>
// auto strip #endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX //autogen
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

#pragma hdrstop


#include "res_bmp.hrc"
#include "glob.hrc"
#include "strings.hrc"

#include "docshell.hxx"
#include "viewshel.hxx"
// auto strip #include "sdwindow.hxx"
#include "drawview.hxx"
// auto strip #include "drawdoc.hxx"
#include "sdresid.hxx"
#include "drbezob.hxx"
// auto strip #include "fusel.hxx"
// auto strip #include "fuconbez.hxx"

/*************************************************************************
|*
|* Standardinterface deklarieren (Die Slotmap darf nicht leer sein)
|*
\************************************************************************/
namespace binfilter {

#define SdDrawBezierObjectBar

SFX_DECL_TYPE(13);

#include "sdslots.hxx"

/*N*/ SFX_IMPL_INTERFACE(SdDrawBezierObjectBar, SfxShell, SdResId(STR_BEZIEROBJECTBARSHELL))
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_BEZIER_TOOLBOX) );
/*N*/ }

TYPEINIT1( SdDrawBezierObjectBar, SfxShell );

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdDrawBezierObjectBar::SdDrawBezierObjectBar(SdViewShell* pSdViewShell,
/*N*/ 											 SdView* pSdView) :
/*N*/ 	SfxShell(pSdViewShell),
/*N*/ 	pView(pSdView),
/*N*/ 	pViewSh(pSdViewShell)
/*N*/ {
/*N*/ 	SdDrawDocShell* pDocShell = pViewSh->GetDocSh();
/*N*/ 	SetPool(&pDocShell->GetPool());
/*N*/ 	SetUndoManager(pDocShell->GetUndoManager());
/*N*/ 	SetRepeatTarget(pView);
/*N*/ 
/*N*/ 	SetHelpId( SD_IF_SDDRAWBEZIEROBJECTBAR );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdDrawBezierObjectBar::~SdDrawBezierObjectBar()
/*N*/ {
/*N*/ 	SetRepeatTarget(NULL);
/*N*/ }


/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/

//STRIP001 void SdDrawBezierObjectBar::GetAttrState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SfxItemSet aAttrSet( pView->GetDoc()->GetPool() );
//STRIP001 	pView->GetAttributes( aAttrSet );
//STRIP001 	rSet.Put(aAttrSet, FALSE); // <- FALSE, damit DontCare-Status uebernommen wird
//STRIP001 
//STRIP001 	FuPoor* pFuActual = pViewSh->GetActualFunction();
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		if (pFuActual->ISA(FuSelection))
//STRIP001 		{
//STRIP001 			USHORT nEditMode = ((FuSelection*) pFuActual)->GetEditMode();
//STRIP001 			rSet.Put(SfxBoolItem(nEditMode, TRUE));
//STRIP001 		}
//STRIP001 		else if (pFuActual->ISA(FuConstBezPoly))
//STRIP001 		{
//STRIP001 			USHORT nEditMode = ((FuConstBezPoly*) pFuActual)->GetEditMode();
//STRIP001 			rSet.Put(SfxBoolItem(nEditMode, TRUE));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!pView->IsRipUpAtMarkedPointsPossible())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_BEZIER_CUTLINE);
//STRIP001 	}
//STRIP001 	if (!pView->IsDeleteMarkedPointsPossible())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_BEZIER_DELETE);
//STRIP001 	}
//STRIP001 	if (!pView->IsSetMarkedSegmentsKindPossible())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_BEZIER_CONVERT);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdrPathSegmentKind eSegm = pView->GetMarkedSegmentsKind();
//STRIP001 		switch (eSegm)
//STRIP001 		{
//STRIP001 			case SDRPATHSEGMENT_DONTCARE: rSet.InvalidateItem(SID_BEZIER_CONVERT); break;
//STRIP001 			case SDRPATHSEGMENT_LINE    : rSet.Put(SfxBoolItem(SID_BEZIER_CONVERT,FALSE)); break; // Button reingedrueckt = Kurve
//STRIP001 			case SDRPATHSEGMENT_CURVE   : rSet.Put(SfxBoolItem(SID_BEZIER_CONVERT,TRUE));  break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (!pView->IsSetMarkedPointsSmoothPossible())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_BEZIER_EDGE);
//STRIP001 		rSet.DisableItem(SID_BEZIER_SMOOTH);
//STRIP001 		rSet.DisableItem(SID_BEZIER_SYMMTR);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdrPathSmoothKind eSmooth = pView->GetMarkedPointsSmooth();
//STRIP001 		switch (eSmooth)
//STRIP001 		{
//STRIP001 			case SDRPATHSMOOTH_DONTCARE  : break;
//STRIP001 			case SDRPATHSMOOTH_ANGULAR   : rSet.Put(SfxBoolItem(SID_BEZIER_EDGE,  TRUE)); break;
//STRIP001 			case SDRPATHSMOOTH_ASYMMETRIC: rSet.Put(SfxBoolItem(SID_BEZIER_SMOOTH,TRUE)); break;
//STRIP001 			case SDRPATHSMOOTH_SYMMETRIC : rSet.Put(SfxBoolItem(SID_BEZIER_SYMMTR,TRUE)); break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (!pView->IsOpenCloseMarkedObjectsPossible())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_BEZIER_CLOSE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdrObjClosedKind eClose = pView->GetMarkedObjectsClosedState();
//STRIP001 		switch (eClose)
//STRIP001 		{
//STRIP001 			case SDROBJCLOSED_DONTCARE: rSet.InvalidateItem(SID_BEZIER_CLOSE); break;
//STRIP001 			case SDROBJCLOSED_OPEN    : rSet.Put(SfxBoolItem(SID_BEZIER_CLOSE,FALSE)); break;
//STRIP001 			case SDROBJCLOSED_CLOSED  : rSet.Put(SfxBoolItem(SID_BEZIER_CLOSE,TRUE)); break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rSet.Put(SfxBoolItem(SID_BEZIER_ELIMINATE_POINTS, pView->IsEliminatePolyPoints()));
//STRIP001 }


/*************************************************************************
|*
|* Bearbeitung der SfxRequests
|*
\************************************************************************/

//STRIP001 void SdDrawBezierObjectBar::Execute(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	USHORT nSId = rReq.GetSlot();
//STRIP001 
//STRIP001 	switch (nSId)
//STRIP001 	{
//STRIP001 		case SID_BEZIER_CUTLINE:
//STRIP001 		case SID_BEZIER_CONVERT:
//STRIP001 		case SID_BEZIER_DELETE:
//STRIP001 		case SID_BEZIER_EDGE:
//STRIP001 		case SID_BEZIER_SMOOTH:
//STRIP001 		case SID_BEZIER_SYMMTR:
//STRIP001 		case SID_BEZIER_CLOSE:
//STRIP001 		{
//STRIP001 			const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 			if (rMarkList.GetMark(0) && !pView->IsAction())
//STRIP001 			{
//STRIP001 				switch (nSId)
//STRIP001 				{
//STRIP001 					case SID_BEZIER_DELETE:
//STRIP001 						pView->DeleteMarkedPoints();
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SID_BEZIER_CUTLINE:
//STRIP001 						pView->RipUpAtMarkedPoints();
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SID_BEZIER_CONVERT:
//STRIP001 					{
//STRIP001 						pView->SetMarkedSegmentsKind(SDRPATHSEGMENT_TOGGLE);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					case SID_BEZIER_EDGE:
//STRIP001 					case SID_BEZIER_SMOOTH:
//STRIP001 					case SID_BEZIER_SYMMTR:
//STRIP001 					{
//STRIP001 						SdrPathSmoothKind eKind;
//STRIP001 
//STRIP001 						switch (nSId)
//STRIP001 						{
//STRIP001 							case SID_BEZIER_EDGE:   eKind = SDRPATHSMOOTH_ANGULAR; break;
//STRIP001 							case SID_BEZIER_SMOOTH: eKind = SDRPATHSMOOTH_ASYMMETRIC; break;
//STRIP001 							case SID_BEZIER_SYMMTR: eKind = SDRPATHSMOOTH_SYMMETRIC; break;
//STRIP001 						}
//STRIP001 
//STRIP001 						pView->SetMarkedPointsSmooth(eKind);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					case SID_BEZIER_CLOSE:
//STRIP001 					{
//STRIP001 						SdrPathObj* pPathObj = (SdrPathObj*) rMarkList.GetMark(0)->GetObj();
//STRIP001 						pView->BegUndo(String(SdResId(STR_UNDO_BEZCLOSE)));
//STRIP001 						pView->UnmarkAllPoints();
//STRIP001 						Size aDist(pViewSh->GetActiveWindow()->PixelToLogic(Size(8,8)));
//STRIP001 						pView->AddUndo(new SdrUndoGeoObj(*pPathObj));
//STRIP001 						pPathObj->ToggleClosed(aDist.Width());
//STRIP001 						pView->EndUndo();
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( !pView->HasMarkedObj() )
//STRIP001 				pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 
//STRIP001 			rReq.Ignore();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_BEZIER_ELIMINATE_POINTS:
//STRIP001 		{
//STRIP001 			pView->SetEliminatePolyPoints(!pView->IsEliminatePolyPoints());
//STRIP001 			Invalidate(SID_BEZIER_ELIMINATE_POINTS);
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_BEZIER_MOVE:
//STRIP001 		case SID_BEZIER_INSERT:
//STRIP001 		{
//STRIP001 			FuPoor* pFuActual = pViewSh->GetActualFunction();
//STRIP001 
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				if (pFuActual->ISA(FuSelection))
//STRIP001 				{
//STRIP001 					((FuSelection*) pFuActual)->SetEditMode(rReq.GetSlot());
//STRIP001 				}
//STRIP001 				else if (pFuActual->ISA(FuConstBezPoly))
//STRIP001 				{
//STRIP001 					((FuConstBezPoly*) pFuActual)->SetEditMode(rReq.GetSlot());
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate();
//STRIP001 }



}
