/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_numfmt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:56:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#pragma hdrstop

#define _SVSTDARR_STRINGS
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#define _SVX_NUMFMT_CXX

#include "dialogs.hrc"
#include "numfmt.hrc"

#define ITEMID_NUMBERINFO 0
#include "numinf.hxx"

#include "numfmt.hxx"
#include "numfmtsh.hxx"
#include "dialmgr.hxx"
namespace binfilter {

#define NUMKEY_UNDEFINED ULONG_MAX

// static ----------------------------------------------------------------

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_NUMBERFORMAT_VALUE,
//STRIP001 	SID_ATTR_NUMBERFORMAT_INFO,
//STRIP001 	SID_ATTR_NUMBERFORMAT_NOLANGUAGE,
//STRIP001 	SID_ATTR_NUMBERFORMAT_NOLANGUAGE,
//STRIP001     SID_ATTR_NUMBERFORMAT_ONE_AREA,
//STRIP001     SID_ATTR_NUMBERFORMAT_ONE_AREA,
//STRIP001     SID_ATTR_NUMBERFORMAT_SOURCE,
//STRIP001     SID_ATTR_NUMBERFORMAT_SOURCE,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		SvxNumberPreviewImpl					Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberPreview
//STRIP001 #*
//STRIP001 #*  Funktion:	Konstruktor der Klasse SvxNumberPreviewImpl
//STRIP001 #*
//STRIP001 #*  Input:		Fenster, Resource-ID
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxNumberPreviewImpl::SvxNumberPreviewImpl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	Window( pParent, rResId )
//STRIP001 
//STRIP001 {
//STRIP001 	Font aFont( GetFont() );
//STRIP001 	aFont.SetTransparent( TRUE );
//STRIP001 	aFont.SetColor( Application::GetSettings().GetStyleSettings().GetFieldColor() );
//STRIP001 	SetFont( aFont );
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001     SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		SvxNumberPreviewImpl					Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberPreview
//STRIP001 #*
//STRIP001 #*  Funktion:	Destruktor der Klasse SvxNumberPreviewImpl
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxNumberPreviewImpl::~SvxNumberPreviewImpl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		NotifyChange							Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberPreviewImpl
//STRIP001 #*
//STRIP001 #*  Funktion:	Funktion fuer das Aendern des Preview- Strings
//STRIP001 #*
//STRIP001 #*  Input:		String, Farbe
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberPreviewImpl::NotifyChange( const String& rPrevStr,
//STRIP001                                          const Color* pColor )
//STRIP001 {
//STRIP001 	aPrevStr = rPrevStr;
//STRIP001 	svtools::ColorConfig aColorConfig;
//STRIP001 	Color aWindowTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001     aPrevCol = pColor ? *pColor : aWindowTextColor;
//STRIP001 	Invalidate();
//STRIP001 	Update();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		Paint									Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberPreviewImpl
//STRIP001 #*
//STRIP001 #*  Funktion:	Funktion fuer das neu zeichnen des Fensters.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberPreviewImpl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Font	aDrawFont	= GetFont();
//STRIP001 	Size	aSzWnd		= GetOutputSizePixel();
//STRIP001 	Point	aPosText	= Point( (aSzWnd.Width()  - GetTextWidth( aPrevStr )) /2,
//STRIP001 								 (aSzWnd.Height() - GetTextHeight())/2 );
//STRIP001 
//STRIP001 	aDrawFont.SetColor( aPrevCol );
//STRIP001 	SetFont( aDrawFont );
//STRIP001 	DrawText( aPosText, aPrevStr );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberPreviewImpl::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if ( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberPreviewImpl::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Window::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberPreviewImpl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxNumberFormatTabPage ------------------------------------------
//STRIP001 
//STRIP001 #define REMOVE_DONTKNOW() \
//STRIP001 	if ( !aFtLanguage.IsEnabled() )										\
//STRIP001 	{																	\
//STRIP001 		aFtLanguage	.Enable();											\
//STRIP001 		aLbLanguage	.Enable();											\
//STRIP001 		aLbLanguage	.SelectLanguage( pNumFmtShell->GetCurLanguage() );	\
//STRIP001 	}
//STRIP001 
//STRIP001 #define HDL(hdl) LINK( this, SvxNumberFormatTabPage, hdl )
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		SvxNumberFormatTabPage					Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Konstruktor der Klasse SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Input:		Fenster, SfxItemSet
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxNumberFormatTabPage::SvxNumberFormatTabPage( Window*				pParent,
//STRIP001 												const SfxItemSet&	rCoreAttrs )
//STRIP001 
//STRIP001 	:	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_NUMBERFORMAT ), rCoreAttrs ),
//STRIP001 
//STRIP001 		aWndPreview		( this,	ResId( WND_NUMBER_PREVIEW ) ),
//STRIP001 		aFtCategory		( this, ResId( FT_CATEGORY ) ),
//STRIP001 		aLbCategory		( this, ResId( LB_CATEGORY ) ),
//STRIP001 		aFtFormat		( this, ResId( FT_FORMAT ) ),
//STRIP001 		aLbCurrency		( this, ResId( LB_CURRENCY) ),
//STRIP001 		aLbFormat		( this, ResId( LB_FORMAT ) ),
//STRIP001 		aFtEdFormat		( this, ResId( FT_EDFORMAT ) ),
//STRIP001 		aEdFormat		( this, ResId( ED_FORMAT ) ),
//STRIP001 		aEdComment		( this, ResId( ED_COMMENT ) ),
//STRIP001 		aIbAdd			( this, ResId( IB_ADD		) ),
//STRIP001 		aIbRemove		( this, ResId( IB_REMOVE	) ),
//STRIP001 		aIbInfo			( this, ResId( IB_INFO		) ),
//STRIP001 		aBtnNegRed		( this, ResId( BTN_NEGRED ) ),
//STRIP001 		aBtnThousand	( this, ResId( BTN_THOUSAND ) ),
//STRIP001 		aFtLeadZeroes	( this, ResId( FT_LEADZEROES ) ),
//STRIP001 		aFtDecimals		( this, ResId( FT_DECIMALS ) ),
//STRIP001 		aEdLeadZeroes	( this, ResId( ED_LEADZEROES ) ),
//STRIP001 		aEdDecimals		( this, ResId( ED_DECIMALS ) ),
//STRIP001 		aFtLanguage		( this, ResId( FT_LANGUAGE ) ),
//STRIP001 		aLbLanguage		( this, ResId( LB_LANGUAGE ), FALSE ),
//STRIP001         aCbSourceFormat ( this, ResId( CB_SOURCEFORMAT ) ),
//STRIP001 		aFlOptions		( this, ResId( FL_OPTIONS ) ),
//STRIP001 		aFtComment		( this, ResId( FT_COMMENT ) ),
//STRIP001 		aStrEurope		( ResId( STR_EUROPE) ),
//STRIP001         sAutomaticEntry ( ResId( STR_AUTO_ENTRY)),
//STRIP001 //		aIconList		( ResId( IL_ICON ) ),	-> done Init_Impl
//STRIP001 		nInitFormat		( ULONG_MAX ),
//STRIP001 		pNumItem		( NULL ),
//STRIP001 		pNumFmtShell	( NULL ),
//STRIP001 		pLastActivWindow( NULL )
//STRIP001 {
//STRIP001 	Init_Impl();
//STRIP001 	SetExchangeSupport(); // diese Page braucht ExchangeSupport
//STRIP001 	FreeResource();
//STRIP001 	nFixedCategory=-1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		~SvxNumberFormatTabPage					Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Destruktor der Klasse gibt den Speicher der
//STRIP001 #*				fuer die Kopien von num. Shell und Item frei.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxNumberFormatTabPage::~SvxNumberFormatTabPage()
//STRIP001 {
//STRIP001 	delete pNumFmtShell;
//STRIP001 	delete pNumItem;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		Init_Impl								Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Initialisierung der Klassen- Member und Handler
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::Init_Impl()
//STRIP001 {
//STRIP001 	ImageList				aIconList( ResId( IL_ICON ) );
//STRIP001 	ImageList				aIconListHC( ResId( IL_ICON_HC ) );
//STRIP001 
//STRIP001 	bNumItemFlag=TRUE;
//STRIP001 	bOneAreaFlag=FALSE;
//STRIP001 
//STRIP001 	nCatHeight=aLbCategory.GetSizePixel().Height();
//STRIP001 
//STRIP001 	nCurFormatY		=aLbFormat.GetPosPixel().Y();
//STRIP001 	nCurFormatHeight=aLbFormat.GetSizePixel().Height();
//STRIP001 	nStdFormatY		=aLbCurrency.GetPosPixel().Y();
//STRIP001 	nStdFormatHeight=nCurFormatY-nStdFormatY+nCurFormatHeight;
//STRIP001 
//STRIP001 	aIbAdd.		SetImage( aIconList.GetImage( IID_ADD ) );
//STRIP001 	aIbAdd.		SetModeImage( aIconListHC.GetImage( IID_ADD ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	aIbRemove.	SetImage( aIconList.GetImage( IID_REMOVE ) );
//STRIP001 	aIbRemove.	SetModeImage( aIconListHC.GetImage( IID_REMOVE ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	aIbInfo.	SetImage( aIconList.GetImage( IID_INFO ) );
//STRIP001 	aIbInfo.	SetModeImage( aIconListHC.GetImage( IID_INFO ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	aIbAdd.Enable(FALSE );
//STRIP001 	aIbRemove.Enable(FALSE );
//STRIP001 	aIbInfo.Enable(FALSE );
//STRIP001 
//STRIP001 	aEdComment.SetText(aLbCategory.GetEntry(1));	//String fuer Benutzerdefiniert
//STRIP001 														//holen
//STRIP001 	aEdComment.Hide();
//STRIP001 
//STRIP001     aCbSourceFormat.Check( FALSE );
//STRIP001     aCbSourceFormat.Disable();
//STRIP001     aCbSourceFormat.Hide();
//STRIP001 
//STRIP001 // Handler verbinden
//STRIP001 	Link aLink = LINK( this, SvxNumberFormatTabPage, SelFormatHdl_Impl );
//STRIP001 
//STRIP001 	aLbCategory		.SetSelectHdl( aLink );
//STRIP001 	aLbFormat		.SetSelectHdl( aLink );
//STRIP001 	aLbLanguage		.SetSelectHdl( aLink );
//STRIP001 	aLbCurrency		.SetSelectHdl( aLink );
//STRIP001     aCbSourceFormat .SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxNumberFormatTabPage, OptHdl_Impl );
//STRIP001 
//STRIP001 	aEdDecimals		.SetModifyHdl( aLink );
//STRIP001 	aEdLeadZeroes	.SetModifyHdl( aLink );
//STRIP001 	aBtnNegRed		.SetClickHdl( aLink );
//STRIP001 	aBtnThousand	.SetClickHdl( aLink );
//STRIP001 	aLbFormat		.SetDoubleClickHdl( HDL( DoubleClickHdl_Impl ) );
//STRIP001 	aEdFormat		.SetModifyHdl( HDL( EditHdl_Impl ) );
//STRIP001 	aIbAdd.SetClickHdl( HDL( ClickHdl_Impl ) );
//STRIP001 	aIbRemove.SetClickHdl( HDL( ClickHdl_Impl ) );
//STRIP001 	aIbInfo.SetClickHdl( HDL( ClickHdl_Impl ) );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxNumberFormatTabPage, LostFocusHdl_Impl);
//STRIP001 
//STRIP001 	aEdComment		.SetLoseFocusHdl( aLink);
//STRIP001 	aResetWinTimer	.SetTimeoutHdl(LINK( this, SvxNumberFormatTabPage, TimeHdl_Impl));
//STRIP001 	aResetWinTimer	.SetTimeout( 10);
//STRIP001 
//STRIP001 	// Sprachen-ListBox initialisieren
//STRIP001 
//STRIP001 	aLbLanguage.InsertLanguage( LANGUAGE_SYSTEM );
//STRIP001 	// Don't list ambiguous locales where we won't be able to convert the
//STRIP001 	// LanguageType back to an identical Language_Country name and therefore
//STRIP001 	// couldn't load the i18n LocaleData. Show DebugMsg in non-PRODUCT version.
//STRIP001 	::com::sun::star::uno::Sequence< sal_uInt16 > xLang =
//STRIP001 		LocaleDataWrapper::getInstalledLanguageTypes();
//STRIP001 	sal_Int32 nCount = xLang.getLength();
//STRIP001 	for ( sal_Int32 i=0; i<nCount; i++ )
//STRIP001 	{
//STRIP001 		aLbLanguage.InsertLanguage( xLang[i] );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		GetRanges								Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert Bereichsangaben zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		Bereich
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 USHORT* SvxNumberFormatTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		Create									Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Erzeugt eine neue Zahlenformat- Seite.
//STRIP001 #*
//STRIP001 #*  Input:		Fenster, SfxItemSet
//STRIP001 #*
//STRIP001 #*	Output:		neue TabPage
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SfxTabPage*	SvxNumberFormatTabPage::Create( Window* pParent,
//STRIP001 											const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxNumberFormatTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		Reset									Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Die Attribute des Dialogs werden mit Hilfe
//STRIP001 #*				des Itemsets neu eingestellt.
//STRIP001 #*
//STRIP001 #*  Input:		SfxItemSet
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxUInt32Item*		pValFmtAttr		= NULL;
//STRIP001 	const SfxPoolItem*			pItem			= NULL;
//STRIP001     const SfxBoolItem*          pAutoEntryAttr = NULL;
//STRIP001 
//STRIP001 	USHORT						nCatLbSelPos	= 0;
//STRIP001 	USHORT						nFmtLbSelPos	= 0;
//STRIP001 	LanguageType				eLangType		= LANGUAGE_DONTKNOW;
//STRIP001 	SvxDelStrgs					aFmtEntryList;
//STRIP001 	SvxNumberValueType			eValType		= SVX_VALUE_TYPE_UNDEFINED;
//STRIP001 	double						nValDouble		= 0;
//STRIP001 	String						aValString;
//STRIP001 	SfxItemState				eState			= SFX_ITEM_DONTCARE;
//STRIP001 
//STRIP001 
//STRIP001 	eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_NOLANGUAGE ),TRUE,&pItem);
//STRIP001 
//STRIP001 	if(eState==SFX_ITEM_SET)
//STRIP001 	{
//STRIP001         const SfxBoolItem* pBoolLangItem = (const SfxBoolItem*)
//STRIP001 					  GetItem( rSet, SID_ATTR_NUMBERFORMAT_NOLANGUAGE);
//STRIP001 
//STRIP001 		if(pBoolLangItem!=NULL && pBoolLangItem->GetValue())
//STRIP001 		{
//STRIP001 			HideLanguage();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			HideLanguage(FALSE);
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_INFO ),TRUE,&pItem);
//STRIP001 
//STRIP001 	if(eState==SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		if(pNumItem==NULL)
//STRIP001 		{
//STRIP001 			bNumItemFlag=TRUE;
//STRIP001 			pNumItem= (SvxNumberInfoItem *) pItem->Clone();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bNumItemFlag=FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bNumItemFlag=FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_ONE_AREA ));
//STRIP001 
//STRIP001 	if(eState==SFX_ITEM_SET)
//STRIP001 	{
//STRIP001         const SfxBoolItem* pBoolItem = (const SfxBoolItem*)
//STRIP001 					  GetItem( rSet, SID_ATTR_NUMBERFORMAT_ONE_AREA);
//STRIP001 
//STRIP001 		if(pBoolItem!=NULL)
//STRIP001 		{
//STRIP001 			bOneAreaFlag= pBoolItem->GetValue();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//bOneAreaFlag=TRUE; //@@ Debug-Test
//STRIP001 
//STRIP001     eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_SOURCE ) );
//STRIP001 
//STRIP001     if ( eState == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001         const SfxBoolItem* pBoolItem = (const SfxBoolItem*)
//STRIP001                       GetItem( rSet, SID_ATTR_NUMBERFORMAT_SOURCE );
//STRIP001         if ( pBoolItem )
//STRIP001             aCbSourceFormat.Check( pBoolItem->GetValue() );
//STRIP001         else
//STRIP001             aCbSourceFormat.Check( FALSE );
//STRIP001         aCbSourceFormat.Enable();
//STRIP001         aCbSourceFormat.Show();
//STRIP001 	}
//STRIP001     else
//STRIP001     {
//STRIP001         BOOL bInit = FALSE;     // set to TRUE for debug test
//STRIP001         aCbSourceFormat.Check( bInit );
//STRIP001         aCbSourceFormat.Enable( bInit );
//STRIP001         aCbSourceFormat.Show( bInit );
//STRIP001     }
//STRIP001 
//STRIP001 	// pNumItem muss von aussen gesetzt worden sein!
//STRIP001 	DBG_ASSERT( pNumItem, "No NumberInfo, no NumberFormatter, good bye.CRASH. :-(" );
//STRIP001 
//STRIP001 	// aktuellen Zahlenformat-Tabellenindex holen
//STRIP001 	eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_VALUE ) );
//STRIP001 
//STRIP001 	if ( SFX_ITEM_DONTCARE != eState )
//STRIP001 		pValFmtAttr = (const SfxUInt32Item*)
//STRIP001 					  GetItem( rSet, SID_ATTR_NUMBERFORMAT_VALUE );
//STRIP001 
//STRIP001 	eValType = pNumItem->GetValueType();
//STRIP001 
//STRIP001 	switch ( eValType )
//STRIP001 	{
//STRIP001 		case SVX_VALUE_TYPE_STRING:
//STRIP001 			aValString = pNumItem->GetValueString();
//STRIP001 			break;
//STRIP001 		case SVX_VALUE_TYPE_NUMBER:
//STRIP001 			//	#50441# string may be set in addition to the value
//STRIP001 			aValString = pNumItem->GetValueString();
//STRIP001 			nValDouble = pNumItem->GetValueDouble();
//STRIP001 			break;
//STRIP001 		case SVX_VALUE_TYPE_UNDEFINED:
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// nun sind alle Informationen fuer die Formatierer-Shell beisammen:
//STRIP001 
//STRIP001 	if ( pNumFmtShell )
//STRIP001 		 delete pNumFmtShell;	// ggF. alte Shell loeschen (==Reset)
//STRIP001 
//STRIP001 	nInitFormat = ( pValFmtAttr )				// Init-Key merken
//STRIP001 					? pValFmtAttr->GetValue()	// (fuer FillItemSet())
//STRIP001 					: ULONG_MAX;				// == DONT_KNOW
//STRIP001 
//STRIP001 
//STRIP001 	if ( eValType == SVX_VALUE_TYPE_STRING )
//STRIP001 		pNumFmtShell =SvxNumberFormatShell::Create(
//STRIP001 								pNumItem->GetNumberFormatter(),
//STRIP001 								(pValFmtAttr) ? nInitFormat : 0L,
//STRIP001 								eValType,
//STRIP001 								aValString );
//STRIP001 	else
//STRIP001 		pNumFmtShell =SvxNumberFormatShell::Create(
//STRIP001 								pNumItem->GetNumberFormatter(),
//STRIP001 								(pValFmtAttr) ? nInitFormat : 0L,
//STRIP001 								eValType,
//STRIP001 								nValDouble,
//STRIP001 								&aValString );
//STRIP001 
//STRIP001 	FillCurrencyBox();
//STRIP001 
//STRIP001     String aPrevString;
//STRIP001     Color* pDummy = NULL;
//STRIP001     pNumFmtShell->GetInitSettings( nCatLbSelPos, eLangType, nFmtLbSelPos,
//STRIP001                                    aFmtEntryList, aPrevString, pDummy );
//STRIP001 
//STRIP001 	aLbCurrency.SelectEntryPos((USHORT)pNumFmtShell->GetCurrencySymbol());
//STRIP001 
//STRIP001 	nFixedCategory=nCatLbSelPos;
//STRIP001 	String sFixedCategory=aLbCategory.GetEntry(nFixedCategory);
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		String sFixedCategory=aLbCategory.GetEntry(nFixedCategory);
//STRIP001 		aLbCategory.Clear();
//STRIP001 		aLbCategory.InsertEntry(sFixedCategory);
//STRIP001 		SetCategory(0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetCategory(nCatLbSelPos );
//STRIP001 	}
//STRIP001     eState = rSet.GetItemState( GetWhich( SID_ATTR_NUMBERFORMAT_ADD_AUTO ) );    
//STRIP001     if(SFX_ITEM_SET == eState)
//STRIP001          pAutoEntryAttr = (const SfxBoolItem*)
//STRIP001                       GetItem( rSet, SID_ATTR_NUMBERFORMAT_ADD_AUTO );
//STRIP001     // no_NO is an alias for nb_NO and normally isn't listed, we need it for
//STRIP001     // backwards compatibility, but only if the format passed is of
//STRIP001     // LanguageType no_NO.
//STRIP001     if ( eLangType == LANGUAGE_NORWEGIAN )
//STRIP001     {
//STRIP001         aLbLanguage.RemoveLanguage( eLangType );    // in case we're already called
//STRIP001         aLbLanguage.InsertLanguage( eLangType );
//STRIP001     }
//STRIP001     aLbLanguage.SelectLanguage( eLangType );
//STRIP001     if(pAutoEntryAttr) 
//STRIP001         AddAutomaticLanguage_Impl(eLangType, pAutoEntryAttr->GetValue());            
//STRIP001 	UpdateFormatListBox_Impl(FALSE,TRUE);
//STRIP001 
//STRIP001 //! erAck 26.01.01
//STRIP001 //! This spoils everything because it rematches currency formats based on
//STRIP001 //! the selected aLbCurrency entry instead of the current format.
//STRIP001 //! Besides that everything seems to be initialized by now, so why call it?
//STRIP001 //	SelFormatHdl_Impl( &aLbCategory );
//STRIP001 
//STRIP001     if ( pValFmtAttr )
//STRIP001 	{
//STRIP001 		EditHdl_Impl( &aEdFormat ); // UpdateOptions_Impl() als Seiteneffekt
//STRIP001 	}
//STRIP001 	else	// DONT_KNOW
//STRIP001 	{
//STRIP001 		// Kategoriewechsel und direkte Eingabe sind moeglich, sonst nix:
//STRIP001 		Obstructing();
//STRIP001 	}
//STRIP001 
//STRIP001     if ( aCbSourceFormat.IsChecked() )
//STRIP001     {
//STRIP001         // everything disabled except SourceFormat checkbox
//STRIP001         EnableBySourceFormat_Impl();
//STRIP001     }
//STRIP001 
//STRIP001 	DeleteEntryList_Impl(aFmtEntryList);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		Obstructing								Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Sperren der Controls mit Ausnahme von Kategoriewechsel
//STRIP001 #*				und direkter Eingabe.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 void SvxNumberFormatTabPage::Obstructing()
//STRIP001 {
//STRIP001 	aLbFormat		.SetNoSelection();
//STRIP001 	aLbLanguage		.SetNoSelection();
//STRIP001 	aFtLanguage		.Disable();
//STRIP001 	aLbLanguage		.Disable();
//STRIP001 
//STRIP001 	aIbAdd.Enable(FALSE );
//STRIP001 	aIbRemove.Enable(FALSE );
//STRIP001 	aIbInfo.Enable(FALSE );
//STRIP001 
//STRIP001 	aBtnNegRed		.Disable();
//STRIP001 	aBtnThousand	.Disable();
//STRIP001 	aFtLeadZeroes	.Disable();
//STRIP001 	aFtDecimals		.Disable();
//STRIP001 	aEdLeadZeroes	.Disable();
//STRIP001 	aEdDecimals		.Disable();
//STRIP001 	aFlOptions		.Disable();
//STRIP001 	aEdDecimals		.SetText( String() );
//STRIP001 	aEdLeadZeroes	.SetText( String() );
//STRIP001 	aBtnNegRed		.Check( FALSE );
//STRIP001 	aBtnThousand	.Check( FALSE );
//STRIP001     aWndPreview     .NotifyChange( String() );
//STRIP001 
//STRIP001 	aLbCategory		.SelectEntryPos( 0 );
//STRIP001 	aEdFormat		.SetText( String() );
//STRIP001 	aFtComment		.SetText( String() );
//STRIP001 	aEdComment		.SetText(aLbCategory.GetEntry(1));	//String fuer Benutzerdefiniert
//STRIP001 														//holen
//STRIP001 
//STRIP001 	aEdFormat		.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #* Enable/Disable dialog parts depending on the value of the SourceFormat
//STRIP001 #* checkbox.
//STRIP001 #************************************************************************/
//STRIP001 void SvxNumberFormatTabPage::EnableBySourceFormat_Impl()
//STRIP001 {
//STRIP001     BOOL bEnable = !aCbSourceFormat.IsChecked();
//STRIP001     aFtCategory     .Enable( bEnable );
//STRIP001     aLbCategory     .Enable( bEnable );
//STRIP001     aFtFormat       .Enable( bEnable );
//STRIP001     aLbCurrency     .Enable( bEnable );
//STRIP001     aLbFormat       .Enable( bEnable );
//STRIP001     aFtLanguage     .Enable( bEnable );
//STRIP001     aLbLanguage     .Enable( bEnable );
//STRIP001     aFtDecimals     .Enable( bEnable );
//STRIP001     aEdDecimals     .Enable( bEnable );
//STRIP001     aFtLeadZeroes   .Enable( bEnable );
//STRIP001     aEdLeadZeroes   .Enable( bEnable );
//STRIP001     aBtnNegRed      .Enable( bEnable );
//STRIP001     aBtnThousand    .Enable( bEnable );
//STRIP001     aFlOptions      .Enable( bEnable );
//STRIP001     aFtEdFormat     .Enable( bEnable );
//STRIP001     aEdFormat       .Enable( bEnable );
//STRIP001     aIbAdd          .Enable( bEnable );
//STRIP001     aIbRemove       .Enable( bEnable );
//STRIP001     aIbInfo         .Enable( bEnable );
//STRIP001     aFtComment      .Enable( bEnable );
//STRIP001     aEdComment      .Enable( bEnable );
//STRIP001     if ( !bEnable )
//STRIP001         aCbSourceFormat.GetFocus();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	HideLanguage								Datum:14.05.98
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Versteckt die Spracheinstellung:
//STRIP001 #*
//STRIP001 #*  Input:		BOOL nFlag
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::HideLanguage(BOOL nFlag)
//STRIP001 {
//STRIP001 	Size aSize=aLbCategory.GetSizePixel();
//STRIP001 
//STRIP001 	if(nFlag)
//STRIP001 	{
//STRIP001 		aSize.Height()=aLbFormat.GetSizePixel().Height();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aSize.Height()=nCatHeight;
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbCategory.SetSizePixel(aSize);
//STRIP001 
//STRIP001 	aFtLanguage.Show(!nFlag);
//STRIP001 	aLbLanguage.Show(!nFlag);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		FillItemSet								Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Stellt die Attribute im ItemSet ein,
//STRIP001 #*				sowie in der DocShell den numItem, wenn
//STRIP001 #*				bNumItemFlag nicht gesetzt ist.
//STRIP001 #*
//STRIP001 #*  Input:		SfxItemSet
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxNumberFormatTabPage::FillItemSet( SfxItemSet& rCoreAttrs )
//STRIP001 {
//STRIP001     BOOL bDataChanged   = aFtLanguage.IsEnabled() || aCbSourceFormat.IsEnabled();
//STRIP001 	if ( bDataChanged )
//STRIP001 	{
//STRIP001         const SfxItemSet& rMyItemSet = GetItemSet();
//STRIP001 		USHORT			nWhich		 = GetWhich( SID_ATTR_NUMBERFORMAT_VALUE );
//STRIP001         SfxItemState    eItemState   = rMyItemSet.GetItemState( nWhich, FALSE );
//STRIP001 
//STRIP001         // OK chosen - Is format code input entered already taken over?
//STRIP001         // If not, simulate Add. Upon syntax error ignore input and prevent Put.
//STRIP001 		String		aFormat	= aEdFormat.GetText();
//STRIP001 		ULONG nCurKey = pNumFmtShell->GetCurNumFmtKey();
//STRIP001 
//STRIP001         if ( aIbAdd.IsEnabled() || pNumFmtShell->IsTmpCurrencyFormat(aFormat) )
//STRIP001         {   // #79599# It is not sufficient to just add the format code (or
//STRIP001             // delete it in case of bOneAreaFlag and resulting category change).
//STRIP001             // Upon switching tab pages we need all settings to be consistent
//STRIP001             // in case this page will be redisplayed later.
//STRIP001             bDataChanged = (ClickHdl_Impl( &aIbAdd ) != 0);
//STRIP001 			nCurKey = pNumFmtShell->GetCurNumFmtKey();
//STRIP001         }
//STRIP001         else if(nCurKey == NUMKEY_UNDEFINED)
//STRIP001         {   // something went wrong, e.g. in Writer #70281#
//STRIP001 			pNumFmtShell->FindEntry(aFormat, &nCurKey);
//STRIP001 		}
//STRIP001 
//STRIP001 		//---------------------------------------------------------------
//STRIP001         // Chosen format:
//STRIP001         // --------------
//STRIP001 		if ( bDataChanged )
//STRIP001 		{
//STRIP001 			bDataChanged = ( nInitFormat != nCurKey );
//STRIP001 
//STRIP001 			if (bDataChanged)
//STRIP001 			{
//STRIP001 				rCoreAttrs.Put( SfxUInt32Item( nWhich, nCurKey ) );
//STRIP001 			}
//STRIP001 			else if(SFX_ITEM_DEFAULT == eItemState)
//STRIP001 			{
//STRIP001 				rCoreAttrs.ClearItem( nWhich );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// --------------------------------------------------------------
//STRIP001         // List of changed user defined formats:
//STRIP001         // -------------------------------------
//STRIP001 		const ULONG nDelCount = pNumFmtShell->GetUpdateDataCount();
//STRIP001 
//STRIP001 		if ( nDelCount > 0 )
//STRIP001 		{
//STRIP001 			ULONG*			pDelArr = new ULONG[nDelCount];
//STRIP001 
//STRIP001 			pNumFmtShell->GetUpdateData( pDelArr, nDelCount );
//STRIP001 			pNumItem->SetDelFormatArray( pDelArr, nDelCount );
//STRIP001 
//STRIP001 			if(bNumItemFlag==TRUE)
//STRIP001 			{
//STRIP001 				rCoreAttrs.Put( *pNumItem );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SfxObjectShell*	pDocSh  = SfxObjectShell::Current();
//STRIP001 
//STRIP001 				DBG_ASSERT( pDocSh, "DocShell not found!" );
//STRIP001 
//STRIP001 
//STRIP001 				if ( pDocSh )
//STRIP001 					pDocSh->PutItem( *pNumItem );
//STRIP001 			}
//STRIP001 			delete [] pDelArr;
//STRIP001 		}
//STRIP001 
//STRIP001 		//---------------------------------------------------------------
//STRIP001         // Whether source format is to be taken or not:
//STRIP001         // --------------------------------------------
//STRIP001         if ( aCbSourceFormat.IsEnabled() )
//STRIP001         {
//STRIP001             USHORT nWhich = GetWhich( SID_ATTR_NUMBERFORMAT_SOURCE );
//STRIP001             SfxItemState eItemState = rMyItemSet.GetItemState( nWhich, FALSE );
//STRIP001             const SfxBoolItem* pBoolItem = (const SfxBoolItem*)
//STRIP001                         GetItem( rMyItemSet, SID_ATTR_NUMBERFORMAT_SOURCE );
//STRIP001             BOOL bOld = (pBoolItem ? pBoolItem->GetValue() : FALSE);
//STRIP001             rCoreAttrs.Put( SfxBoolItem( nWhich, aCbSourceFormat.IsChecked() ) );
//STRIP001             if ( !bDataChanged )
//STRIP001                 bDataChanged = (bOld != aCbSourceFormat.IsChecked() ||
//STRIP001                     eItemState != SFX_ITEM_SET);
//STRIP001         }
//STRIP001 
//STRIP001         // FillItemSet is only called on OK, here we can notify the
//STRIP001         // NumberFormatShell that all new user defined formats are valid.
//STRIP001 		pNumFmtShell->ValidateNewEntries();
//STRIP001         if(aLbLanguage.IsVisible() && 
//STRIP001                 LISTBOX_ENTRY_NOTFOUND != aLbLanguage.GetEntryPos(sAutomaticEntry))
//STRIP001                 rCoreAttrs.Put(SfxBoolItem(SID_ATTR_NUMBERFORMAT_ADD_AUTO, 
//STRIP001                     aLbLanguage.GetSelectEntry() == sAutomaticEntry));
//STRIP001 	}
//STRIP001 
//STRIP001 	return bDataChanged;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 int SvxNumberFormatTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 /*	if ( (ULONG_MAX != nInitFormat) && pSet )
//STRIP001 	{
//STRIP001 		const ULONG  nCurKey    = pNumFmtShell->GetCurNumFmtKey();
//STRIP001 		const USHORT nWhich     = GetWhich( SID_ATTR_NUMBERFORMAT_VALUE );
//STRIP001 		SfxItemState eItemState	= GetItemSet().GetItemState( nWhich, FALSE );
//STRIP001 
//STRIP001 		if ( (nInitFormat == nCurKey) && (SFX_ITEM_DEFAULT == eItemState) )
//STRIP001 			pSet->ClearItem( nWhich );
//STRIP001 		else
//STRIP001 			pSet->Put( SfxUInt32Item( nWhich, nCurKey ) );
//STRIP001 	}
//STRIP001  */
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::SetInfoItem( const SvxNumberInfoItem& rItem )
//STRIP001 {
//STRIP001 	if(pNumItem==NULL)
//STRIP001 	{
//STRIP001 		pNumItem = (SvxNumberInfoItem*)rItem.Clone();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::FillFormatListBox_Impl( SvxDelStrgs& rEntries )
//STRIP001 {
//STRIP001 	String*		pEntry;
//STRIP001 	String		aTmpString;
//STRIP001 	String		aTmpCatString;
//STRIP001 	Font		aFont=aLbCategory.GetFont();
//STRIP001 	double		nVal=0;
//STRIP001 	BOOL		bFLAG=FALSE;
//STRIP001 	USHORT		i = 0;
//STRIP001 	short		nTmpCatPos;
//STRIP001 	short		aPrivCat;
//STRIP001 
//STRIP001 	aLbFormat.Clear();
//STRIP001 	aLbFormat.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	USHORT  nCount = rEntries.Count();
//STRIP001 
//STRIP001 	if(nCount<1) return;
//STRIP001 
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nTmpCatPos=nFixedCategory;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nTmpCatPos=aLbCategory.GetSelectEntryPos();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nSelPos=LISTBOX_ENTRY_NOTFOUND;
//STRIP001 
//STRIP001 	switch (nTmpCatPos)
//STRIP001 	{
//STRIP001 		case CAT_ALL:
//STRIP001 		case CAT_TEXT:
//STRIP001 		case CAT_NUMBER:		i=1;
//STRIP001 								pEntry=rEntries[0];
//STRIP001 								if(pEntry!=NULL)
//STRIP001 								{
//STRIP001 									aTmpString=*pEntry;
//STRIP001 									aPrivCat=pNumFmtShell->GetCategory4Entry(0);
//STRIP001                                     aLbFormat.InsertFontEntry( aTmpString, aFont );
//STRIP001 								}
//STRIP001 								break;
//STRIP001 
//STRIP001 		default:				break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pNumFmtShell!=NULL)
//STRIP001 	{
//STRIP001 		for ( ; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			pEntry = rEntries[i];
//STRIP001 			aPrivCat=pNumFmtShell->GetCategory4Entry(i);
//STRIP001 			if(aPrivCat!=CAT_TEXT)
//STRIP001 			{
//STRIP001                 Color* pPreviewColor = NULL;
//STRIP001                 String aPreviewString( GetExpColorString( pPreviewColor, *pEntry, aPrivCat ) );
//STRIP001                 Font aEntryFont( aLbFormat.GetFont() );
//STRIP001                 aLbFormat.InsertFontEntry( aPreviewString, aEntryFont, pPreviewColor );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aLbFormat.InsertFontEntry(*pEntry,aFont);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aLbFormat.SetUpdateMode( TRUE );
//STRIP001 	DeleteEntryList_Impl(rEntries);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		DeleteEntryList_Impl					Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Loescht eine SvStrings- Liste
//STRIP001 #*
//STRIP001 #*  Input:		String-liste
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::DeleteEntryList_Impl( SvxDelStrgs& rEntries )
//STRIP001 {
//STRIP001 	USHORT  nCount = rEntries.Count();
//STRIP001 	rEntries.DeleteAndDestroy(0,nCount);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		UpdateOptions_Impl						Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Stellt je nach eingestelltem Format die Options-
//STRIP001 #*				attribute neu ein.
//STRIP001 #*
//STRIP001 #*  Input:		Flag, ob sich die Kategorie geaendert hat.
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::UpdateOptions_Impl( BOOL bCheckCatChange /*= FALSE*/ )
//STRIP001 {
//STRIP001 	SvxDelStrgs	aEntryList;
//STRIP001 	String	theFormat			= aEdFormat.GetText();
//STRIP001 	USHORT	nCurCategory		= aLbCategory.GetSelectEntryPos();
//STRIP001 	USHORT  nCategory			= nCurCategory;
//STRIP001 	USHORT	nDecimals			= 0;
//STRIP001 	USHORT	nZeroes				= 0;
//STRIP001 	BOOL	bNegRed				= FALSE;
//STRIP001 	BOOL	bThousand			= FALSE;
//STRIP001 	short	nTmpCatPos;
//STRIP001 	USHORT	nCurrencyPos		=aLbCurrency.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nTmpCatPos=nFixedCategory;
//STRIP001 		nCurCategory=nFixedCategory;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nTmpCatPos=nCurCategory;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	pNumFmtShell->GetOptions( theFormat,
//STRIP001 							  bThousand, bNegRed,
//STRIP001 							  nDecimals, nZeroes,
//STRIP001 							  nCategory );
//STRIP001 	BOOL bDoIt=FALSE;
//STRIP001 	if(nCategory==CAT_CURRENCY)
//STRIP001 	{
//STRIP001 		USHORT nTstPos=pNumFmtShell->FindCurrencyFormat(theFormat);
//STRIP001 		if(nCurrencyPos!=nTstPos && nTstPos!=(USHORT)-1)
//STRIP001 		{
//STRIP001 			aLbCurrency.SelectEntryPos(nTstPos);
//STRIP001 			pNumFmtShell->SetCurrencySymbol(nTstPos);
//STRIP001 			bDoIt=TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	if ( nCategory != nCurCategory || bDoIt)
//STRIP001 	{
//STRIP001 		if ( bCheckCatChange )
//STRIP001 		{
//STRIP001 			if(bOneAreaFlag)
//STRIP001 				SetCategory(0);
//STRIP001 			else
//STRIP001 				SetCategory(nCategory );
//STRIP001 
//STRIP001 			UpdateFormatListBox_Impl( TRUE, FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( aLbFormat.GetEntryCount() > 0 )
//STRIP001 	{
//STRIP001 		ULONG nCurEntryKey=NUMKEY_UNDEFINED;
//STRIP001 		if(!pNumFmtShell->FindEntry( aEdFormat.GetText(),&nCurEntryKey))
//STRIP001 		{
//STRIP001 			aLbFormat.SetNoSelection();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nCategory=nFixedCategory;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( nCategory )
//STRIP001 	{
//STRIP001 		case CAT_NUMBER:
//STRIP001 		case CAT_PERCENT:
//STRIP001 		case CAT_CURRENCY:
//STRIP001 			aFlOptions.Enable();
//STRIP001 			aFtDecimals.Enable();
//STRIP001 			aEdDecimals.Enable();
//STRIP001 			aFtLeadZeroes.Enable();
//STRIP001 			aEdLeadZeroes.Enable();
//STRIP001 			aBtnNegRed.Enable();
//STRIP001 			aBtnThousand.Enable();
//STRIP001 			/*
//STRIP001 			aEdDecimals	 .SetValue( nDecimals );
//STRIP001 			aEdLeadZeroes.SetValue( nZeroes );
//STRIP001 			*/
//STRIP001 			aEdDecimals	 .SetText( UniString::CreateFromInt32( nDecimals ) );
//STRIP001 			aEdLeadZeroes.SetText( UniString::CreateFromInt32( nZeroes ) );
//STRIP001 			aBtnNegRed	 .Check( bNegRed );
//STRIP001 			aBtnThousand .Check( bThousand );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CAT_ALL:
//STRIP001 		case CAT_USERDEFINED:
//STRIP001 		case CAT_TEXT:
//STRIP001 		case CAT_DATE:
//STRIP001 		case CAT_TIME:
//STRIP001 		case CAT_BOOLEAN:
//STRIP001 		case CAT_SCIENTIFIC:
//STRIP001 		case CAT_FRACTION:
//STRIP001 		default:
//STRIP001 			aFlOptions		.Disable();
//STRIP001 			aFtDecimals		.Disable();
//STRIP001 			aEdDecimals		.Disable();
//STRIP001 			aFtLeadZeroes	.Disable();
//STRIP001 			aEdLeadZeroes	.Disable();
//STRIP001 			aBtnNegRed		.Disable();
//STRIP001 			aBtnThousand	.Disable();
//STRIP001 			aEdDecimals		.SetText( UniString::CreateFromInt32( 0 ) );
//STRIP001 			aEdLeadZeroes	.SetText( UniString::CreateFromInt32( 0 ) );
//STRIP001 			aBtnNegRed		.Check( FALSE );
//STRIP001 			aBtnThousand	.Check( FALSE );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		UpdateFormatListBox_Impl				Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Aktualisiert die Format- Listbox und zusaetzlich
//STRIP001 #*				wird abhaengig vom bUpdateEdit- Flag der String
//STRIP001 #*				in der Editbox geaendert.
//STRIP001 #*
//STRIP001 #*  Input:		Flags fuer Kategorie und Editbox
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::UpdateFormatListBox_Impl
//STRIP001 	(
//STRIP001 		USHORT bCat,		// Category oder Land/Sprache ListBox?
//STRIP001 		BOOL   bUpdateEdit	// Format-Edit aktualisieren?
//STRIP001 	)
//STRIP001 {
//STRIP001 	SvxDelStrgs	aEntryList;
//STRIP001 	short		nFmtLbSelPos = 0;
//STRIP001 	short		nTmpCatPos;
//STRIP001 
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nTmpCatPos=nFixedCategory;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nTmpCatPos=aLbCategory.GetSelectEntryPos();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if ( bCat )
//STRIP001 	{
//STRIP001 		Point aPos=aLbFormat.GetPosPixel();
//STRIP001 		Size  aSize=aLbFormat.GetSizePixel();
//STRIP001 
//STRIP001 		if(nTmpCatPos!=CAT_CURRENCY)
//STRIP001 		{
//STRIP001 			aPos.Y()=nStdFormatY;
//STRIP001 			aSize.Height()=nStdFormatHeight;
//STRIP001 			aLbFormat.SetPosSizePixel(aPos,aSize);
//STRIP001 			aLbCurrency.Hide();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aPos.Y()=nCurFormatY;
//STRIP001 			aSize.Height()=nCurFormatHeight;
//STRIP001 			aLbFormat.SetPosSizePixel(aPos,aSize);
//STRIP001 			aLbCurrency.Show();
//STRIP001 		}
//STRIP001 
//STRIP001 		pNumFmtShell->CategoryChanged( nTmpCatPos,nFmtLbSelPos, aEntryList );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNumFmtShell->LanguageChanged( aLbLanguage.GetSelectLanguage(),
//STRIP001 									   nFmtLbSelPos,aEntryList );
//STRIP001 
//STRIP001 	REMOVE_DONTKNOW() // ggF. UI-Enable
//STRIP001 
//STRIP001 
//STRIP001 	if ( (aEntryList.Count() > 0) && (nFmtLbSelPos != SELPOS_NONE) )
//STRIP001 	{
//STRIP001 		if(bUpdateEdit)
//STRIP001 		{
//STRIP001 			String aFormat=*aEntryList[nFmtLbSelPos];
//STRIP001 			aEdFormat.SetText(aFormat);
//STRIP001 			aFtComment.SetText(pNumFmtShell->GetComment4Entry(nFmtLbSelPos));
//STRIP001 
//STRIP001 			//@23.09.97 aEdFormat.SetText( aLbFormat.GetSelectEntry() );
//STRIP001 		}
//STRIP001 
//STRIP001 		if(!bOneAreaFlag || !bCat)
//STRIP001 		{
//STRIP001 			FillFormatListBox_Impl( aEntryList );
//STRIP001 			aLbFormat.SelectEntryPos( nFmtLbSelPos );
//STRIP001 
//STRIP001 			aFtComment.SetText(pNumFmtShell->GetComment4Entry(nFmtLbSelPos));
//STRIP001 			if(pNumFmtShell->GetUserDefined4Entry(nFmtLbSelPos))
//STRIP001 			{
//STRIP001 				if(pNumFmtShell->GetComment4Entry(nFmtLbSelPos).Len()==0)
//STRIP001 				{
//STRIP001 					aFtComment.SetText(aLbCategory.GetEntry(1));
//STRIP001 				}
//STRIP001 			}
//STRIP001             ChangePreviewText( (USHORT)nFmtLbSelPos );
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FillFormatListBox_Impl( aEntryList );
//STRIP001 		if(nFmtLbSelPos != SELPOS_NONE)
//STRIP001 		{
//STRIP001 			aLbFormat.SelectEntryPos( (USHORT)nFmtLbSelPos );
//STRIP001 
//STRIP001 			aFtComment.SetText(pNumFmtShell->GetComment4Entry(nFmtLbSelPos));
//STRIP001 			if(pNumFmtShell->GetUserDefined4Entry(nFmtLbSelPos))
//STRIP001 			{
//STRIP001 				if(pNumFmtShell->GetComment4Entry(nFmtLbSelPos).Len()==0)
//STRIP001 				{
//STRIP001 					aFtComment.SetText(aLbCategory.GetEntry(1));
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aLbFormat.SetNoSelection();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bUpdateEdit )
//STRIP001 		{
//STRIP001 			aEdFormat.SetText( String() );
//STRIP001             aWndPreview.NotifyChange( String() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Handle:		DoubleClickHdl_Impl							Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Bei einem Doppelklick in die Format- Listbox
//STRIP001 #*				wird der Wert uebernommen und der OK-Button
//STRIP001 #*				ausgeloest
//STRIP001 #*
//STRIP001 #*  Input:		Pointer auf Listbox
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, DoubleClickHdl_Impl, SvxFontListBox*, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aLbFormat )
//STRIP001 	{
//STRIP001 		SelFormatHdl_Impl( pLb );
//STRIP001 		// Uebergangsloesung, sollte von SfxTabPage angeboten werden
//STRIP001 		fnOkHdl.Call( NULL );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	SelFormatHdl_Impl							Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Wird aufgerufen, wenn sich die Sprache, die Kategorie
//STRIP001 #*				oder das Format aendert. Dem entsprechend werden die
//STRIP001 #*				Einstellungen geaendert.
//STRIP001 #*
//STRIP001 #*  Input:		Pointer auf Listbox
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, SelFormatHdl_Impl, void *, pLb )
//STRIP001 {
//STRIP001     if ( (CheckBox*)pLb == &aCbSourceFormat )
//STRIP001     {
//STRIP001         EnableBySourceFormat_Impl();    // enable/disable everything else
//STRIP001         if ( aCbSourceFormat.IsChecked() )
//STRIP001             return 0;   // just disabled everything else
//STRIP001 
//STRIP001         // Reinit options enable/disable for current selection.
//STRIP001 
//STRIP001         // Current category may be UserDefined with no format entries defined.
//STRIP001         // And yes, aLbFormat is a SvxFontListBox with ULONG list positions,
//STRIP001         // implementation returns a LIST_APPEND if empty, comparison with
//STRIP001         // USHORT LISTBOX_ENTRY_NOTFOUND wouldn't match.
//STRIP001         if ( aLbFormat.GetSelectEntryPos() == LIST_APPEND )
//STRIP001             pLb = &aLbCategory; // continue with the current category selected
//STRIP001         else
//STRIP001             pLb = &aLbFormat;   // continue with the current format selected
//STRIP001     }
//STRIP001 
//STRIP001 	short		nTmpCatPos;
//STRIP001 
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nTmpCatPos=nFixedCategory;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nTmpCatPos=aLbCategory.GetSelectEntryPos();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nCurrencyPos=LISTBOX_ENTRY_NOTFOUND ;
//STRIP001 
//STRIP001 	if(nTmpCatPos==CAT_CURRENCY && (ListBox *)pLb == &aLbCurrency )
//STRIP001 	{
//STRIP001 		nCurrencyPos=aLbCurrency.GetSelectEntryPos();
//STRIP001 		pNumFmtShell->SetCurrencySymbol(nCurrencyPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	// Format-ListBox ----------------------------------------------------
//STRIP001 	if ( (SvxFontListBox *)pLb == &aLbFormat )
//STRIP001 	{
//STRIP001 		USHORT	nSelPos = (USHORT) aLbFormat.GetSelectEntryPos();
//STRIP001 		String	aFormat	= aLbFormat.GetSelectEntry();
//STRIP001 		String	aComment;
//STRIP001 		SvxDelStrgs	aEntryList;
//STRIP001 
//STRIP001 		short		nFmtLbSelPos = nSelPos;
//STRIP001 
//STRIP001 		aFormat=pNumFmtShell->GetFormat4Entry(nSelPos);
//STRIP001 		aComment=pNumFmtShell->GetComment4Entry(nSelPos);
//STRIP001 		if(pNumFmtShell->GetUserDefined4Entry(nFmtLbSelPos))
//STRIP001 		{
//STRIP001 			if(pNumFmtShell->GetComment4Entry(nFmtLbSelPos).Len()==0)
//STRIP001 			{
//STRIP001 				aComment=aLbCategory.GetEntry(1);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aFormat.Len() > 0 )
//STRIP001 		{
//STRIP001 			if(!aEdFormat.HasFocus()) aEdFormat.SetText( aFormat );
//STRIP001 			aFtComment.SetText(aComment);
//STRIP001             ChangePreviewText( nSelPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		REMOVE_DONTKNOW() // ggF. UI-Enable
//STRIP001 
//STRIP001 		if ( pNumFmtShell->FindEntry( aFormat) )
//STRIP001 		{
//STRIP001 			aIbAdd.Enable(FALSE );
//STRIP001 			BOOL bIsUserDef=pNumFmtShell->IsUserDefined( aFormat );
//STRIP001 			aIbRemove.Enable(bIsUserDef);
//STRIP001 			aIbInfo.Enable(bIsUserDef);
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aIbAdd.Enable(TRUE );
//STRIP001 			aIbInfo.Enable(TRUE );
//STRIP001 			aIbRemove.Enable(FALSE );
//STRIP001 			aFtComment.SetText(aEdComment.GetText());
//STRIP001 
//STRIP001 		}
//STRIP001 		UpdateOptions_Impl( FALSE );
//STRIP001 
//STRIP001 		//-------
//STRIP001 		return 0;
//STRIP001 		//-------
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	// Kategorie-ListBox -------------------------------------------------
//STRIP001 	if ( pLb == &aLbCategory || pLb == &aLbCurrency)
//STRIP001 	{
//STRIP001 		UpdateFormatListBox_Impl( TRUE, TRUE );
//STRIP001 		EditHdl_Impl( NULL );
//STRIP001 		UpdateOptions_Impl( FALSE );
//STRIP001 
//STRIP001 		//-------
//STRIP001 		return 0;
//STRIP001 		//-------
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	// Sprache/Land-ListBox ----------------------------------------------
//STRIP001 	if ( pLb == &aLbLanguage )
//STRIP001 	{
//STRIP001 		UpdateFormatListBox_Impl( FALSE, TRUE );
//STRIP001 		EditHdl_Impl( &aEdFormat );
//STRIP001 
//STRIP001 		//-------
//STRIP001 		return 0;
//STRIP001 		//-------
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	ClickHdl_Impl, ImageButton* pIB 			Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Wenn, der Hinzufuegen- oder Entfernen- Button
//STRIP001 #*				wird diese Funktion aufgerufen und die Zahlenformat-
//STRIP001 #*				Liste den entsprechend geaendert.
//STRIP001 #*
//STRIP001 #*  Input:		Toolbox- Button
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, ClickHdl_Impl, ImageButton*, pIB)
//STRIP001 {
//STRIP001 	BOOL		bAdded = FALSE;
//STRIP001 	BOOL		bDeleted = FALSE;
//STRIP001     ULONG       nReturn = 0;
//STRIP001     const ULONG nReturnChanged  = 0x1;  // THE boolean return value
//STRIP001     const ULONG nReturnAdded    = 0x2;  // temp: format added
//STRIP001     const ULONG nReturnOneArea  = 0x4;  // temp: one area but category changed => ignored
//STRIP001 
//STRIP001 	if(pIB==&aIbAdd)
//STRIP001     {   // Also called from FillItemSet() if a temporary currency format has
//STRIP001         // to be added, not only if the Add button is enabled.
//STRIP001 		String		aFormat	= aEdFormat.GetText();
//STRIP001 		SvxDelStrgs	aEntryList;
//STRIP001 		SvxDelStrgs	a2EntryList;
//STRIP001 		USHORT		nCatLbSelPos = 0;
//STRIP001 		short		nFmtLbSelPos = SELPOS_NONE;
//STRIP001 		ULONG		nErrPos=0;
//STRIP001 
//STRIP001 		pNumFmtShell->SetCurCurrencyEntry(NULL);
//STRIP001 		bAdded = pNumFmtShell->AddFormat( aFormat, nErrPos,
//STRIP001 										  nCatLbSelPos, nFmtLbSelPos,
//STRIP001 										  aEntryList);
//STRIP001         if ( bAdded )
//STRIP001             nReturn |= nReturnChanged | nReturnAdded;
//STRIP001 
//STRIP001 		if(pLastActivWindow== (Window *) &aEdComment)
//STRIP001 		{
//STRIP001 			aEdFormat.GrabFocus();
//STRIP001 			aEdComment.Hide();
//STRIP001 			aFtComment.Show();
//STRIP001 			aFtComment.SetText(aEdComment.GetText());
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !nErrPos ) // Syntax ok?
//STRIP001 		{
//STRIP001 			if(nCatLbSelPos==CAT_CURRENCY)
//STRIP001 			{
//STRIP001 				aLbCurrency.SelectEntryPos((USHORT)pNumFmtShell->GetCurrencySymbol());
//STRIP001 			}
//STRIP001 
//STRIP001 			if(bOneAreaFlag && (nFixedCategory!=nCatLbSelPos))
//STRIP001 			{
//STRIP001 				if(bAdded) DeleteEntryList_Impl(aEntryList);
//STRIP001 				bDeleted = pNumFmtShell->RemoveFormat( aFormat,
//STRIP001 											   nCatLbSelPos,
//STRIP001 											   nFmtLbSelPos,
//STRIP001 											   a2EntryList);
//STRIP001 				if(bDeleted) DeleteEntryList_Impl(a2EntryList);
//STRIP001 				aEdFormat.GrabFocus();
//STRIP001 				aEdFormat.SetSelection( Selection( (short)nErrPos, SELECTION_MAX ) );
//STRIP001                 nReturn |= nReturnOneArea;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if ( bAdded && (nFmtLbSelPos != SELPOS_NONE) )
//STRIP001 				{
//STRIP001 					// Alles klar
//STRIP001 					if(bOneAreaFlag)				  //@@ ???
//STRIP001 						SetCategory(0);
//STRIP001 					else
//STRIP001 						SetCategory(nCatLbSelPos );
//STRIP001 
//STRIP001 					FillFormatListBox_Impl( aEntryList );
//STRIP001 					if(aEdComment.GetText()!=aLbCategory.GetEntry(1))
//STRIP001 					{
//STRIP001 						pNumFmtShell->SetComment4Entry(nFmtLbSelPos,
//STRIP001 													aEdComment.GetText());
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pNumFmtShell->SetComment4Entry(nFmtLbSelPos,
//STRIP001 														String());
//STRIP001 					}
//STRIP001 					aLbFormat.SelectEntryPos( (USHORT)nFmtLbSelPos );
//STRIP001 					aEdFormat.SetText( aFormat );
//STRIP001 
//STRIP001 					//aEdComment.SetText(String()); //@@ ???
//STRIP001 					aEdComment.SetText(aLbCategory.GetEntry(1));	//String fuer Benutzerdefiniert
//STRIP001 																	//holen
//STRIP001                     ChangePreviewText( (USHORT)nFmtLbSelPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else // Syntaxfehler
//STRIP001 		{
//STRIP001 			aEdFormat.GrabFocus();
//STRIP001 			aEdFormat.SetSelection( Selection( (short)nErrPos, SELECTION_MAX ) );
//STRIP001 		}
//STRIP001 		EditHdl_Impl( &aEdFormat );
//STRIP001         nReturn = ((nReturn & nReturnOneArea) ? 0 : (nReturn & nReturnChanged));
//STRIP001 	}
//STRIP001 	else if(pIB==&aIbRemove)
//STRIP001 	{
//STRIP001 		String		aFormat	= aEdFormat.GetText();
//STRIP001 		SvxDelStrgs	aEntryList;
//STRIP001 		USHORT		nCatLbSelPos = 0;
//STRIP001 		short		nFmtLbSelPos = SELPOS_NONE;
//STRIP001 
//STRIP001 		bDeleted = pNumFmtShell->RemoveFormat( aFormat,
//STRIP001 											   nCatLbSelPos,
//STRIP001 											   nFmtLbSelPos,
//STRIP001 											   aEntryList );
//STRIP001 
//STRIP001 		aEdComment.SetText(aLbCategory.GetEntry(1));
//STRIP001 		if ( bDeleted )
//STRIP001 		{
//STRIP001 			if(nFmtLbSelPos>=0 &&  nFmtLbSelPos<aEntryList.Count())
//STRIP001 			{
//STRIP001 				aFormat	= *aEntryList[nFmtLbSelPos];
//STRIP001 			}
//STRIP001 
//STRIP001 			FillFormatListBox_Impl( aEntryList );
//STRIP001 
//STRIP001 			if ( nFmtLbSelPos != SELPOS_NONE )
//STRIP001 			{
//STRIP001 				if(bOneAreaFlag)				  //@@ ???
//STRIP001 						SetCategory(0);
//STRIP001 					else
//STRIP001 						SetCategory(nCatLbSelPos );
//STRIP001 
//STRIP001 				aLbFormat.SelectEntryPos( (USHORT)nFmtLbSelPos );
//STRIP001 				aEdFormat.SetText( aFormat );
//STRIP001                 ChangePreviewText( (USHORT)nFmtLbSelPos );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// auf "Alle/Standard" setzen
//STRIP001 				SetCategory(0 );
//STRIP001 				SelFormatHdl_Impl( &aLbCategory );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		EditHdl_Impl( &aEdFormat );
//STRIP001 	}
//STRIP001 	else if(pIB==&aIbInfo)
//STRIP001 	{
//STRIP001 		if(!(pLastActivWindow== (Window *) &aEdComment))
//STRIP001 		{
//STRIP001 			aEdComment.SetText(aFtComment.GetText());
//STRIP001 			aEdComment.Show();
//STRIP001 			aFtComment.Hide();
//STRIP001 			aEdComment.GrabFocus();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aEdFormat.GrabFocus();
//STRIP001 			aEdComment.Hide();
//STRIP001 			aFtComment.Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return nReturn;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	EditHdl_Impl								Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Wenn der Eintrag im Eingabefeld geaendert wird,
//STRIP001 #*				so wird die Vorschau aktualisiert und
//STRIP001 #*
//STRIP001 #*  Input:		Pointer auf Editbox
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, EditHdl_Impl, Edit*, pEdFormat )
//STRIP001 {
//STRIP001 	ULONG nCurKey = NUMKEY_UNDEFINED;
//STRIP001 
//STRIP001 	if ( aEdFormat.GetText().Len() == 0 )
//STRIP001 	{
//STRIP001 		aIbAdd.Enable(FALSE );
//STRIP001 		aIbRemove.Enable(FALSE );
//STRIP001 		aIbInfo.Enable(FALSE );
//STRIP001 		aFtComment.SetText(String());
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aFormat = aEdFormat.GetText();
//STRIP001 		//aFtComment.SetText(String());
//STRIP001         MakePreviewText( aFormat );
//STRIP001 
//STRIP001 		if ( pNumFmtShell->FindEntry( aFormat, &nCurKey ) )
//STRIP001 		{
//STRIP001 			aIbAdd.Enable(FALSE );
//STRIP001 			BOOL bUserDef=pNumFmtShell->IsUserDefined( aFormat );
//STRIP001 
//STRIP001 			aIbRemove.Enable(bUserDef);
//STRIP001 			aIbInfo.Enable(bUserDef);
//STRIP001 
//STRIP001 			if(bUserDef)
//STRIP001 			{
//STRIP001 				USHORT nTmpCurPos=pNumFmtShell->FindCurrencyFormat(aFormat );
//STRIP001 
//STRIP001 				if(nTmpCurPos!=(USHORT)-1)
//STRIP001 					aLbCurrency.SelectEntryPos(nTmpCurPos);
//STRIP001 			}
//STRIP001 			short nPosi=pNumFmtShell->GetListPos4Entry(aFormat);
//STRIP001 			if(nPosi>=0)
//STRIP001 				aLbFormat.SelectEntryPos( (USHORT)nPosi);
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 
//STRIP001 			aIbAdd.Enable(TRUE );
//STRIP001 			aIbInfo.Enable(TRUE);
//STRIP001 			aIbRemove.Enable(FALSE );
//STRIP001 
//STRIP001 			aFtComment.SetText(aEdComment.GetText());
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pEdFormat )
//STRIP001 	{
//STRIP001 		pNumFmtShell->SetCurNumFmtKey( nCurKey );
//STRIP001 		UpdateOptions_Impl( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		NotifyChange							Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Fuehrt Aenderungen in den Zahlen- Attributen durch.
//STRIP001 #*
//STRIP001 #*  Input:		Options- Controls
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, OptHdl_Impl, void *, pOptCtrl )
//STRIP001 {
//STRIP001 	if (   ((NumericField*)pOptCtrl == &aEdLeadZeroes)
//STRIP001 		|| ((NumericField*)pOptCtrl == &aEdDecimals)
//STRIP001 		|| ((CheckBox*)    pOptCtrl == &aBtnNegRed)
//STRIP001 		|| ((CheckBox*)    pOptCtrl == &aBtnThousand) )
//STRIP001 	{
//STRIP001 		String		  aFormat;
//STRIP001 		BOOL		  bThousand 	=    aBtnThousand.IsEnabled()
//STRIP001 									  && aBtnThousand.IsChecked();
//STRIP001 		BOOL		  bNegRed		=    aBtnNegRed.IsEnabled()
//STRIP001 									  && aBtnNegRed.IsChecked();
//STRIP001 		USHORT		  nPrecision	= (aEdDecimals.IsEnabled())
//STRIP001 										? (USHORT)aEdDecimals.GetValue()
//STRIP001 										: (USHORT)0;
//STRIP001 		USHORT		  nLeadZeroes	= (aEdLeadZeroes.IsEnabled())
//STRIP001 										? (USHORT)aEdLeadZeroes.GetValue()
//STRIP001 										: (USHORT)0;
//STRIP001 
//STRIP001 		pNumFmtShell->MakeFormat( aFormat,
//STRIP001 								  bThousand, bNegRed,
//STRIP001 								  nPrecision, nLeadZeroes,
//STRIP001 								  (USHORT)aLbFormat.GetSelectEntryPos() );
//STRIP001 
//STRIP001 		aEdFormat.SetText( aFormat );
//STRIP001 		//aFtComment.SetText(String());
//STRIP001         MakePreviewText( aFormat );
//STRIP001 
//STRIP001 		if ( pNumFmtShell->FindEntry( aFormat ) )
//STRIP001 		{
//STRIP001 			aIbAdd.Enable(FALSE );
//STRIP001 			BOOL bUserDef=pNumFmtShell->IsUserDefined( aFormat );
//STRIP001 			aIbRemove.Enable(bUserDef);
//STRIP001 			aIbInfo.Enable(bUserDef);
//STRIP001 			EditHdl_Impl( &aEdFormat);
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			EditHdl_Impl( NULL );
//STRIP001 			aLbFormat.SetNoSelection();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, TimeHdl_Impl, Timer*, pT)
//STRIP001 {
//STRIP001 	pLastActivWindow=NULL;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	LostFocusHdl_Impl							Datum:30.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Fuehrt Aenderungen in den Zahlen- Attributen durch.
//STRIP001 #*
//STRIP001 #*  Input:		Options- Controls
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxNumberFormatTabPage, LostFocusHdl_Impl, Edit *, pEd)
//STRIP001 {
//STRIP001 	if (pEd==&aEdComment)
//STRIP001 	{
//STRIP001 		aResetWinTimer.Start();
//STRIP001 		aFtComment.SetText(aEdComment.GetText());
//STRIP001 		aEdComment.Hide();
//STRIP001 		aFtComment.Show();
//STRIP001 		if(!aIbAdd.IsEnabled())
//STRIP001 		{
//STRIP001 			USHORT	nSelPos = (USHORT) aLbFormat.GetSelectEntryPos();
//STRIP001 			pNumFmtShell->SetComment4Entry(nSelPos,
//STRIP001 										aEdComment.GetText());
//STRIP001 			aEdComment.SetText(aLbCategory.GetEntry(1));	//String fuer Benutzerdefiniert
//STRIP001 															//holen
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:		NotifyChange							Datum:02.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Fuehrt Aenderungen in den Zahlen- Attributen durch.
//STRIP001 #*
//STRIP001 #*  Input:		Options- Controls
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 String SvxNumberFormatTabPage::GetExpColorString(
//STRIP001         Color*& rpPreviewColor, const String& rFormatStr, short nTmpCatPos)
//STRIP001 {
//STRIP001     double nVal = 0;
//STRIP001 	switch (nTmpCatPos)
//STRIP001 	{
//STRIP001 		case CAT_CURRENCY:		nVal=SVX_NUMVAL_CURRENCY; break;
//STRIP001 
//STRIP001 		case CAT_SCIENTIFIC:
//STRIP001 		case CAT_FRACTION:
//STRIP001 		case CAT_NUMBER:		nVal=SVX_NUMVAL_STANDARD; break;
//STRIP001 
//STRIP001 		case CAT_PERCENT:		nVal=SVX_NUMVAL_PERCENT; break;
//STRIP001 
//STRIP001 		case CAT_ALL:			nVal=SVX_NUMVAL_STANDARD; break;
//STRIP001 
//STRIP001 		case CAT_TIME:			nVal=SVX_NUMVAL_TIME; break;
//STRIP001 		case CAT_DATE:			nVal=SVX_NUMVAL_DATE; break;
//STRIP001 
//STRIP001 		case CAT_BOOLEAN:		nVal=SVX_NUMVAL_BOOLEAN; break;
//STRIP001 
//STRIP001 		case CAT_USERDEFINED:
//STRIP001 		case CAT_TEXT:
//STRIP001 		default:				nVal=0;break;
//STRIP001 	}
//STRIP001 
//STRIP001     String aPreviewString;
//STRIP001     pNumFmtShell->MakePrevStringFromVal( rFormatStr, aPreviewString, rpPreviewColor, nVal );
//STRIP001 	return aPreviewString;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::MakePreviewText( const String& rFormat )
//STRIP001 {
//STRIP001     String aPreviewString;
//STRIP001     Color* pPreviewColor = NULL;
//STRIP001     pNumFmtShell->MakePreviewString( rFormat, aPreviewString, pPreviewColor );
//STRIP001     aWndPreview.NotifyChange( aPreviewString, pPreviewColor );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::ChangePreviewText( USHORT nPos )
//STRIP001 {
//STRIP001     String aPreviewString;
//STRIP001     Color* pPreviewColor = NULL;
//STRIP001     pNumFmtShell->FormatChanged( nPos, aPreviewString, pPreviewColor );
//STRIP001     aWndPreview.NotifyChange( aPreviewString, pPreviewColor );
//STRIP001 }
//STRIP001 
//STRIP001 long SvxNumberFormatTabPage::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	if(rNEvt.GetType()==EVENT_LOSEFOCUS)
//STRIP001 	{
//STRIP001 		pLastActivWindow=rNEvt.GetWindow();
//STRIP001 	}
//STRIP001 
//STRIP001 	return SfxTabPage::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 /*************************************************************************
//STRIP001 #*	Methode:	SetOkHdl									Datum:01.11.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatTabPage
//STRIP001 #*
//STRIP001 #*  Funktion:	Setzt den OkHandler neu.
//STRIP001 #*
//STRIP001 #*  Input:		Neuer OkHandler
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::SetOkHdl( const Link& rOkHandler )
//STRIP001 {
//STRIP001 	fnOkHdl = rOkHandler;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::FillCurrencyBox()
//STRIP001 {
//STRIP001 	SvStringsDtor	aList;
//STRIP001 	NfShCurrencyEntries rEntries;
//STRIP001 	XubString*		pEntry = NULL;
//STRIP001 	USHORT	nPos=0;
//STRIP001 	USHORT	nSelPos=0;
//STRIP001 
//STRIP001 	pNumFmtShell->GetCurrencySymbols(aList,aStrEurope,&nSelPos);
//STRIP001 
//STRIP001 	for(USHORT i=1;i<aList.Count();i++)
//STRIP001 	{
//STRIP001 		pEntry=aList[i];
//STRIP001 		nPos=aLbCurrency.InsertEntry( *pEntry);
//STRIP001 	}
//STRIP001 	aLbCurrency.SelectEntryPos(nSelPos);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatTabPage::SetCategory(USHORT nPos)
//STRIP001 {
//STRIP001 	USHORT	nCurCategory = aLbCategory.GetSelectEntryPos();
//STRIP001 	Point aPos=aLbFormat.GetPosPixel();
//STRIP001 	Size  aSize=aLbFormat.GetSizePixel();
//STRIP001 	USHORT nTmpCatPos;
//STRIP001 
//STRIP001 	if(bOneAreaFlag)
//STRIP001 	{
//STRIP001 		nTmpCatPos=nFixedCategory;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nTmpCatPos=nPos;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(aLbCategory.GetEntryCount()==1 || nCurCategory!=nPos)
//STRIP001 	{
//STRIP001 		if(nTmpCatPos!=CAT_CURRENCY)
//STRIP001 		{
//STRIP001 			aPos.Y()=nStdFormatY;
//STRIP001 			aSize.Height()=nStdFormatHeight;
//STRIP001 			aLbFormat.SetPosSizePixel(aPos,aSize);
//STRIP001 			aLbCurrency.Hide();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aPos.Y()=nCurFormatY;
//STRIP001 			aSize.Height()=nCurFormatHeight;
//STRIP001 			aLbFormat.SetPosSizePixel(aPos,aSize);
//STRIP001 			aLbCurrency.Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aLbCategory.SelectEntryPos(nPos);
//STRIP001 }
//STRIP001 /* -----------------12.11.2002 14:35-----------------
//STRIP001  * to support Writer text field language handling an 
//STRIP001  * additional entry needs to be inserted into the ListBox
//STRIP001  * which marks a certain language as automatically detected
//STRIP001  * Additionally the "Default" language is removed
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SvxNumberFormatTabPage::AddAutomaticLanguage_Impl(LanguageType eAutoLang, BOOL bSelect)
//STRIP001 {
//STRIP001     aLbLanguage.RemoveLanguage(LANGUAGE_SYSTEM);
//STRIP001     USHORT nPos = aLbLanguage.InsertEntry(sAutomaticEntry);
//STRIP001     aLbLanguage.SetEntryData(nPos, (void*)(ULONG)eAutoLang);
//STRIP001     if(bSelect)
//STRIP001 		aLbLanguage.SelectEntryPos(nPos);
//STRIP001 }        

}
