/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_splwrap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:03:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

// include ---------------------------------------------------------------

#ifndef _RTL_USTRING_HXX_
#include<rtl/ustring.hxx>
#endif
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif


#define	_SVSTDARR_USHORTS
#define _SVSTDARR_USHORTSSORT
#ifndef _SVARRAY_HXX
#include <svtools/svstdarr.hxx>
#endif

#ifndef __RSC
#include <tools/errinf.hxx>
#endif
#ifndef _SVXERR_HXX
#include <svxerr.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif
#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <bf_linguistic/lngprops.hxx>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARY1_HPP_
#include <com/sun/star/linguistic2/XDictionary1.hpp>
#endif



#include "svxenum.hxx"
#include "spldlg.hxx"       // Der SpellDialog
#include "hyphen.hxx"       // Der HyphenDialog
#include "splwrap.hxx"      // Der Wrapper
#include "thesdlg.hxx"      // ThesaurusDlg
#include "dialmgr.hxx"

#include "dialogs.hrc"
namespace binfilter {

//STRIP001 #define WAIT_ON()	pWin->EnterWait()
//STRIP001 #define WAIT_OFF()	pWin->LeaveWait()
//STRIP001 
//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::com::sun::star::linguistic2;
//STRIP001 
//STRIP001 
//STRIP001 // misc functions ---------------------------------------------
//STRIP001 
//STRIP001 void SvxPrepareAutoCorrect( String &rOldText, String &rNewText )
//STRIP001 {
//STRIP001 	// This function should be used to strip (or add) trailing '.' from
//STRIP001 	// the strings before passing them on to the autocorrect function in
//STRIP001 	// order that the autocorrect function will hopefully
//STRIP001 	// works properly with normal words and abbreviations (with trailing '.')
//STRIP001 	// independ of if they are at the end of the sentence or not.
//STRIP001 	//
//STRIP001 	// rOldText: text to be replaced
//STRIP001 	// rNewText: replacement text
//STRIP001 
//STRIP001 	xub_StrLen	nOldLen = rOldText.Len(),
//STRIP001 				nNewLen = rNewText.Len();
//STRIP001 	if (nOldLen && nNewLen)
//STRIP001 	{
//STRIP001 		sal_Bool bOldHasDot = sal_Unicode( '.' ) == rOldText.GetChar( nOldLen - 1 ),
//STRIP001 			 bNewHasDot = sal_Unicode( '.' ) == rNewText.GetChar( nNewLen - 1 );
//STRIP001 		if (bOldHasDot && !bNewHasDot
//STRIP001 			/*this is: !(bOldHasDot && bNewHasDot) && bOldHasDot*/)
//STRIP001 			rOldText.Erase( nOldLen - 1 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 #define SVX_LANG_NEED_CHECK			0
//STRIP001 #define SVX_LANG_OK					1
//STRIP001 #define SVX_LANG_MISSING			2
//STRIP001 #define SVX_LANG_MISSING_DO_WARN	3
//STRIP001 
//STRIP001 #define SVX_FLAGS_NEW
//STRIP001 
//STRIP001 class LangCheckState
//STRIP001 {
//STRIP001     SvUShortsSort   aLang;
//STRIP001     SvUShorts       aState;     // lowerbyte spell values,
//STRIP001                                 // higherbyte hyph values
//STRIP001 
//STRIP001 public:    
//STRIP001     LangCheckState();
//STRIP001 
//STRIP001     USHORT             GetCount()   { return aLang.Count(); }
//STRIP001     inline USHORT      GetLanguagePos( USHORT nLang );
//STRIP001     inline USHORT      GetLanguage( USHORT nPos );
//STRIP001     inline USHORT      GetState( USHORT nPos );
//STRIP001     inline void        SetState( USHORT nPos, USHORT nState );
//STRIP001     inline USHORT      InsertLangState( USHORT nLang, USHORT nState );
//STRIP001 };
//STRIP001 
//STRIP001 LangCheckState::LangCheckState() :
//STRIP001     aLang   (16, 16),
//STRIP001     aState  (16, 16)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline USHORT LangCheckState::GetLanguagePos( USHORT nLang )
//STRIP001 {
//STRIP001     USHORT nPos;
//STRIP001     BOOL bFound = aLang.Seek_Entry( nLang, &nPos );
//STRIP001     return bFound ? nPos : 0xFFFF;
//STRIP001 }
//STRIP001 
//STRIP001 inline USHORT LangCheckState::GetLanguage( USHORT nPos )
//STRIP001 {
//STRIP001     DBG_ASSERT( nPos < aLang.Count(), "index out of range" );
//STRIP001     return aLang.GetObject( nPos );
//STRIP001 }
//STRIP001 
//STRIP001 inline USHORT LangCheckState::GetState( USHORT nPos )
//STRIP001 {
//STRIP001     DBG_ASSERT( nPos < aState.Count(), "index out of range" );
//STRIP001     return aState.GetObject( nPos );
//STRIP001 }
//STRIP001 
//STRIP001 inline void LangCheckState::SetState( USHORT nPos, USHORT nState )
//STRIP001 {
//STRIP001     DBG_ASSERT( nPos < aState.Count(), "index out of range" );
//STRIP001     aState.Replace( nState , nPos );
//STRIP001 }
//STRIP001 
//STRIP001 inline USHORT LangCheckState::InsertLangState( USHORT nLang, USHORT nState )
//STRIP001 {
//STRIP001     DBG_ASSERT( aLang.Count() == aState.Count(), "array length mismatch" );
//STRIP001     USHORT nPos = aLang.Count();
//STRIP001     aLang .Insert( nLang,   nPos );
//STRIP001     aState.Insert( nState , nPos );
//STRIP001     return nPos;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 static LangCheckState & GetLangCheckState()
//STRIP001 {
//STRIP001     static LangCheckState aState;
//STRIP001     return aState;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 static void ShowLanguageErrors()
//STRIP001 {
//STRIP001     // display message boxes for languages not available for
//STRIP001     // spellchecking or hyphenation
//STRIP001     LangCheckState &rLCS = GetLangCheckState();
//STRIP001     sal_uInt16 nCount = rLCS.GetCount();
//STRIP001 	for (sal_uInt16 i = 0;  i < nCount;  ++i)
//STRIP001 	{
//STRIP001         sal_Int16 nLang = (sal_Int16) rLCS.GetLanguage( i );
//STRIP001         sal_uInt16 nVal = rLCS.GetState( i );
//STRIP001 		sal_uInt16 nTmpSpell = nVal & 0x00FF;
//STRIP001 		sal_uInt16 nTmpHyph  = (nVal >> 8) & 0x00FF;
//STRIP001 
//STRIP001 		if (SVX_LANG_MISSING_DO_WARN == nTmpSpell)
//STRIP001 		{
//STRIP001 			String aErr( ::GetLanguageString( nLang ) );
//STRIP001 			ErrorHandler::HandleError(
//STRIP001 				*new StringErrorInfo( ERRCODE_SVX_LINGU_LANGUAGENOTEXISTS, aErr ) );
//STRIP001 			nTmpSpell = SVX_LANG_MISSING;
//STRIP001 		}
//STRIP001 		if (SVX_LANG_MISSING_DO_WARN == nTmpHyph)
//STRIP001 		{
//STRIP001 			String aErr( ::GetLanguageString( nLang ) );
//STRIP001 			ErrorHandler::HandleError(
//STRIP001 				*new StringErrorInfo( ERRCODE_SVX_LINGU_LANGUAGENOTEXISTS, aErr ) );
//STRIP001 			nTmpHyph = SVX_LANG_MISSING;
//STRIP001 		}
//STRIP001 
//STRIP001         rLCS.SetState( i, (nTmpHyph << 8) | nTmpSpell );
//STRIP001 	}
//STRIP001     
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001  *	Beschreibung: Ctor, die Pruefreihenfolge wird festgelegt
//STRIP001  *
//STRIP001  *  !bStart && !bOtherCntnt:	BODY_END,	BODY_START,	OTHER
//STRIP001  *  !bStart && bOtherCntnt:		OTHER,		BODY
//STRIP001  *  bStart && !bOtherCntnt:		BODY_END,	OTHER
//STRIP001  *  bStart && bOtherCntnt:		OTHER
//STRIP001  *
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SvxSpellWrapper::SvxSpellWrapper( Window* pWn,
//STRIP001 	Reference< XSpellChecker1 >  &xSpellChecker,
//STRIP001 	const sal_Bool bStart, const sal_Bool bIsAllRight,
//STRIP001 	const sal_Bool bOther, const sal_Bool bRevAllow ) :
//STRIP001 
//STRIP001 	pWin		( pWn ),
//STRIP001 	xSpell		( xSpellChecker ),
//STRIP001 	bOtherCntnt	( bOther ),
//STRIP001 	bDialog		( sal_False ),
//STRIP001 	bHyphen		( sal_False ),
//STRIP001 	bAuto		( sal_False ),
//STRIP001 	bStartChk	( bOther ),
//STRIP001 	bRevAllowed ( bRevAllow )
//STRIP001 {
//STRIP001 	Reference< beans::XPropertySet >  xProp( SvxGetLinguPropertySet() );
//STRIP001 	sal_Bool bWrapReverse = xProp.is() ?
//STRIP001 		*(sal_Bool*)xProp->getPropertyValue(
//STRIP001 			::rtl::OUString::createFromAscii(UPN_IS_WRAP_REVERSE) ).getValue()
//STRIP001 		: sal_False;
//STRIP001 	bReverse = bRevAllow && bWrapReverse;
//STRIP001 	bAllRight = bIsAllRight;
//STRIP001 	bStartDone = bOther || ( !bReverse && bStart );
//STRIP001 	bEndDone   = bReverse && bStart && !bOther;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxSpellWrapper::SvxSpellWrapper( Window* pWn,
//STRIP001 		Reference< XHyphenator >  &xHyphenator,
//STRIP001 		const sal_Bool bStart, const sal_Bool bOther ) :
//STRIP001 	pWin		( pWn ),
//STRIP001 	xHyph		( xHyphenator ),
//STRIP001 	bOtherCntnt	( bOther ),
//STRIP001 	bDialog		( sal_False ),
//STRIP001 	bHyphen		( sal_False ),
//STRIP001 	bAuto		( sal_False ),
//STRIP001 	bStartDone	( bOther || ( !bReverse && bStart ) ),
//STRIP001 	bEndDone	( bReverse && bStart && !bOther ),
//STRIP001 	bStartChk	( bOther ),
//STRIP001 	bRevAllowed ( sal_False ),
//STRIP001 	bReverse	( sal_False )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int16 SvxSpellWrapper::CheckSpellLang(
//STRIP001 		Reference< XSpellChecker1 > xSpell, sal_Int16 nLang)
//STRIP001 {
//STRIP001     LangCheckState &rLCS = GetLangCheckState();
//STRIP001 
//STRIP001     USHORT nPos = rLCS.GetLanguagePos( nLang );
//STRIP001     sal_uInt16 nVal = 0xFFFF != nPos ? rLCS.GetState( nPos ) : 0;
//STRIP001 
//STRIP001     if (0xFFFF == nPos)
//STRIP001         nPos = rLCS.InsertLangState( (sal_uInt16) nLang, nVal );
//STRIP001 
//STRIP001 	if (SVX_LANG_NEED_CHECK == (nVal & 0x00FF))
//STRIP001 	{
//STRIP001 		sal_uInt16 nTmpVal = SVX_LANG_MISSING_DO_WARN;
//STRIP001 		if (xSpell.is()  &&  xSpell->hasLanguage( nLang ))
//STRIP001 			nTmpVal = SVX_LANG_OK;
//STRIP001 		nVal &= 0xFF00;
//STRIP001 		nVal |= nTmpVal;
//STRIP001 
//STRIP001         rLCS.SetState( nPos, nVal );
//STRIP001 	}
//STRIP001 
//STRIP001     return (sal_Int16) nVal;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int16 SvxSpellWrapper::CheckHyphLang(
//STRIP001 		Reference< XHyphenator >  xHyph, sal_Int16 nLang)
//STRIP001 {
//STRIP001     LangCheckState &rLCS = GetLangCheckState();
//STRIP001 
//STRIP001     USHORT nPos = rLCS.GetLanguagePos( nLang );
//STRIP001     sal_uInt16 nVal = 0xFFFF != nPos ? rLCS.GetState( nPos ) : 0;
//STRIP001 
//STRIP001     if (0xFFFF == nPos)
//STRIP001         nPos = rLCS.InsertLangState( (sal_uInt16) nLang, nVal );
//STRIP001 
//STRIP001 	if (SVX_LANG_NEED_CHECK == ((nVal >> 8) & 0x00FF))
//STRIP001 	{
//STRIP001 		sal_uInt16 nTmpVal = SVX_LANG_MISSING_DO_WARN;
//STRIP001 		if (xHyph.is()  &&  xHyph->hasLocale( SvxCreateLocale( nLang ) ))
//STRIP001 			nTmpVal = SVX_LANG_OK;
//STRIP001 		nVal &= 0x00FF;
//STRIP001 		nVal |= nTmpVal << 8;
//STRIP001 
//STRIP001         rLCS.SetState( nPos, nVal );
//STRIP001 	}
//STRIP001 
//STRIP001     return (sal_Int16) nVal;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::SpellStart( SvxSpellArea eSpell )
//STRIP001 {	// Hier muessen die notwendigen Vorbereitungen fuer SpellContinue
//STRIP001 }	// im uebergebenen Bereich getroffen werden.
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool SvxSpellWrapper::HasOtherCnt()
//STRIP001 {
//STRIP001 	return sal_False; // Gibt es ueberhaupt einen Sonderbereich?
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool SvxSpellWrapper::SpellMore()
//STRIP001 {
//STRIP001 	return sal_False; // Sollen weitere Dokumente geprueft werden?
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::SpellEnd()
//STRIP001 {	// Bereich ist abgeschlossen, ggf. Aufraeumen
//STRIP001     
//STRIP001     // display error for last language not found
//STRIP001     ShowLanguageErrors();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool SvxSpellWrapper::SpellContinue()
//STRIP001 {
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellWrapper::AutoCorrect( const String& rAktWord,
//STRIP001 								   const String& rNewWord )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::ScrollArea()
//STRIP001 {	// Scrollarea einstellen
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::ChangeWord( const String& rNewWord, const sal_uInt16 nLang )
//STRIP001 {	// Wort ersetzen
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 String SvxSpellWrapper::GetThesWord()
//STRIP001 {
//STRIP001 	// Welches Wort soll nachgeschlagen werden?
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::ChangeThesWord( const String& )
//STRIP001 {
//STRIP001 	// Wort wg. Thesaurus ersetzen
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellWrapper::StartThesaurus( const String &rWord, sal_uInt16 nLanguage )
//STRIP001 {
//STRIP001 
//STRIP001 	String sErr( SVX_RES( RID_SVXSTR_HMERR_THESAURUS ) );
//STRIP001 
//STRIP001 	Reference< XThesaurus >  xThes( SvxGetThesaurus() );
//STRIP001 	if (!xThes.is())
//STRIP001 	{
//STRIP001 		InfoBox( pWin, sErr ).Execute();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	WAIT_ON();	// while looking up for initial word
//STRIP001 	SvxThesaurusDialog aDlg(pWin, xThes, rWord, nLanguage);
//STRIP001 	WAIT_OFF();
//STRIP001 
//STRIP001 	if ( aDlg.Execute()== RET_OK )
//STRIP001 	{
//STRIP001 		if ( bDialog )
//STRIP001 		{
//STRIP001 			SvxSpellCheckDialog* pSplDlg = (SvxSpellCheckDialog*)GetWin();
//STRIP001 			pSplDlg->SetNewEditWord( aDlg.GetWord() );
//STRIP001 			pSplDlg->SetLanguage( aDlg.GetLanguage() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ChangeThesWord( aDlg.GetWord() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSpellWrapper::ReplaceAll( const String &rNewText, sal_Int16 nLanguage )
//STRIP001 {	// Wort aus der Replace-Liste ersetzen
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::SetLanguage( const sal_uInt16 nLang )
//STRIP001 {	// Sprache aendern
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::InsertHyphen( const sal_uInt16 nPos )
//STRIP001 {	// Hyphen einfuegen bzw. loeschen
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // Pruefung der Dokumentbereiche in der durch die Flags angegebenen Reihenfolge
//STRIP001 
//STRIP001 
//STRIP001 void SvxSpellWrapper::SpellDocument( )
//STRIP001 {
//STRIP001 	if ( bOtherCntnt )
//STRIP001 	{
//STRIP001 		bReverse = sal_False;
//STRIP001 		SpellStart( SVX_SPELL_OTHER );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bStartChk = bReverse;
//STRIP001 		SpellStart( bReverse ? SVX_SPELL_BODY_START : SVX_SPELL_BODY_END );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( FindSpellError() )
//STRIP001 	{
//STRIP001 		Reference< XSpellAlternatives >  	xAlt( GetLast(), UNO_QUERY );
//STRIP001 		Reference< XHyphenatedWord > 		xHyphWord( GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 		Window *pOld = pWin;
//STRIP001 		bDialog = sal_True;
//STRIP001 		if (xHyphWord.is())
//STRIP001 		{
//STRIP001 			DBG_ASSERT(xHyphWord.is(), "NULL pointer");
//STRIP001 			SvxHyphenWordDialog* pDlg =
//STRIP001 				new SvxHyphenWordDialog( xHyphWord->getWord(),
//STRIP001 							SvxLocaleToLanguage( xHyphWord->getLocale() ),
//STRIP001 							pWin, xHyph, this );
//STRIP001 			pWin = pDlg;
//STRIP001 			pDlg->Execute();
//STRIP001 			delete pDlg;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SvxSpellCheckDialog* pDlg =
//STRIP001 				new SvxSpellCheckDialog( pWin, xSpell, this );
//STRIP001 
//STRIP001 			if ( !bAuto )
//STRIP001 				pDlg->HideAutoCorrect();
//STRIP001 			pWin = pDlg;
//STRIP001 			// Visarea richtig setzen
//STRIP001 			ScrollArea();
//STRIP001 
//STRIP001 			pDlg->Execute();
//STRIP001 			delete pDlg;
//STRIP001 		}
//STRIP001 		bDialog = sal_False;
//STRIP001 		pWin = pOld;
//STRIP001 	};
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // Naechsten Bereich auswaehlen
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool SvxSpellWrapper::SpellNext( )
//STRIP001 {
//STRIP001 	Reference< beans::XPropertySet >  xProp( SvxGetLinguPropertySet() );
//STRIP001 	sal_Bool bWrapReverse = xProp.is() ?
//STRIP001 			*(sal_Bool*)xProp->getPropertyValue(
//STRIP001 				::rtl::OUString::createFromAscii(UPN_IS_WRAP_REVERSE) ).getValue()
//STRIP001 			: sal_False;
//STRIP001 	sal_Bool bActRev = bRevAllowed && bWrapReverse;
//STRIP001 
//STRIP001 	// bActRev ist die Richtung nach dem Spellen, bReverse die am Anfang.
//STRIP001 	if( bActRev == bReverse )
//STRIP001 	{   						// Keine Richtungsaenderung, also ist
//STRIP001 		if( bStartChk )         // der gewuenschte Bereich ( bStartChk )
//STRIP001 			bStartDone = sal_True;  // vollstaendig abgearbeitet.
//STRIP001 		else
//STRIP001 			bEndDone = sal_True;
//STRIP001 	}
//STRIP001 	else if( bReverse == bStartChk ) // Bei einer Richtungsaenderung kann
//STRIP001 	{ 						   // u.U. auch ein Bereich abgearbeitet sein.
//STRIP001 		if( bStartChk )        // Sollte der vordere Teil rueckwaerts gespellt
//STRIP001 			bEndDone = sal_True;   // werden und wir kehren unterwegs um, so ist
//STRIP001 		else				   // der hintere Teil abgearbeitet (und umgekehrt).
//STRIP001 			bStartDone = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	bReverse = bActRev;
//STRIP001 	if( bOtherCntnt && bStartDone && bEndDone ) // Dokument komplett geprueft?
//STRIP001 	{
//STRIP001 		if ( SpellMore() )  // ein weiteres Dokument pruefen?
//STRIP001 		{
//STRIP001 			bOtherCntnt = sal_False;
//STRIP001 			bStartDone = !bReverse;
//STRIP001 			bEndDone  = bReverse;
//STRIP001 			SpellStart( SVX_SPELL_BODY );
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	sal_Bool bGoOn = sal_False;
//STRIP001 
//STRIP001 	if ( bOtherCntnt )
//STRIP001 	{
//STRIP001 		bStartChk = sal_False;
//STRIP001 		SpellStart( SVX_SPELL_BODY );
//STRIP001 		bGoOn = sal_True;
//STRIP001 	}
//STRIP001 	else if ( bStartDone && bEndDone )
//STRIP001 	{
//STRIP001 		sal_Bool bIsSpellSpecial = xProp.is() ?
//STRIP001 			*(sal_Bool*)xProp->getPropertyValue(
//STRIP001 				::rtl::OUString::createFromAscii(UPN_IS_SPELL_SPECIAL) ).getValue()
//STRIP001 			: sal_False;
//STRIP001 		// Bodybereich erledigt, Frage nach Sonderbereich
//STRIP001 		if( !IsHyphen() && bIsSpellSpecial && HasOtherCnt() )
//STRIP001 		{
//STRIP001 			SpellStart( SVX_SPELL_OTHER );
//STRIP001 			bOtherCntnt = bGoOn = sal_True;
//STRIP001 		}
//STRIP001 		else if ( SpellMore() )  // ein weiteres Dokument pruefen?
//STRIP001 		{
//STRIP001 			bOtherCntnt = sal_False;
//STRIP001 			bStartDone = !bReverse;
//STRIP001 			bEndDone  = bReverse;
//STRIP001 			SpellStart( SVX_SPELL_BODY );
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Ein BODY_Bereich erledigt, Frage nach dem anderen BODY_Bereich
//STRIP001 		WAIT_OFF();
//STRIP001 
//STRIP001 // Sobald im Dialog das DontWrapAround gesetzt werden kann, kann der
//STRIP001 // folgende #ifdef-Zweig aktiviert werden ...
//STRIP001 #ifdef USED
//STRIP001 		sal_Bool bDontWrapAround = IsHyphen() ?
//STRIP001 			pSpell->GetOptions() & DONT_WRAPAROUND :
//STRIP001 			pSpell->GetHyphOptions() & HYPH_DONT_WRAPAROUND;
//STRIP001 		if( bDontWrapAround )
//STRIP001 #else
//STRIP001 		sal_uInt16 nResId = bReverse ? RID_SVXQB_BW_CONTINUE : RID_SVXQB_CONTINUE;
//STRIP001 		QueryBox aBox( pWin, ResId( nResId, pMgr ) );
//STRIP001 		if ( aBox.Execute() != RET_YES )
//STRIP001 #endif
//STRIP001 
//STRIP001 		{
//STRIP001 			// Verzicht auf den anderen Bereich, ggf. Frage nach Sonderbereich
//STRIP001 			WAIT_ON();
//STRIP001 			bStartDone = bEndDone = sal_True;
//STRIP001 			return SpellNext();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bStartChk = !bStartDone;
//STRIP001 			SpellStart( bStartChk ? SVX_SPELL_BODY_START : SVX_SPELL_BODY_END );
//STRIP001 			bGoOn = sal_True;
//STRIP001 		}
//STRIP001 		WAIT_ON();
//STRIP001 	}
//STRIP001 	return bGoOn;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Reference< XDictionary1 >  SvxSpellWrapper::GetAllRightDic() const
//STRIP001 {
//STRIP001 	Reference< XDictionary1 >  xDic;
//STRIP001 
//STRIP001 	Reference< XDictionaryList >  xDicList( SvxGetDictionaryList() );
//STRIP001 	if (xDicList.is())
//STRIP001 	{
//STRIP001 		Sequence< Reference< XDictionary >  > aDics( xDicList->getDictionaries() );
//STRIP001 		const Reference< XDictionary >  *pDic = aDics.getConstArray();
//STRIP001 		sal_Int32 nCount = aDics.getLength();
//STRIP001 
//STRIP001 		sal_Int32 i = 0;
//STRIP001 		while (!xDic.is()  &&  i < nCount)
//STRIP001 		{
//STRIP001 			Reference< XDictionary1 >  xTmp( pDic[i], UNO_QUERY );
//STRIP001 			if (xTmp.is())
//STRIP001 			{
//STRIP001 				if ( xTmp->isActive() &&
//STRIP001 					 xTmp->getDictionaryType() != DictionaryType_NEGATIVE &&
//STRIP001 					 xTmp->getLanguage() == LANGUAGE_NONE )
//STRIP001 				{
//STRIP001 					Reference< frame::XStorable >  xStor( xTmp, UNO_QUERY );
//STRIP001 					if (xStor.is() && xStor->hasLocation() && !xStor->isReadonly())
//STRIP001 					{
//STRIP001 						xDic = xTmp;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			++i;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!xDic.is())
//STRIP001 		{
//STRIP001 			xDic = SvxGetOrCreatePosDic( xDicList );
//STRIP001 			if (xDic.is())
//STRIP001 				xDic->setActive( sal_True );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return xDic;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxSpellWrapper::FindSpellError()
//STRIP001 {
//STRIP001     ShowLanguageErrors();
//STRIP001     
//STRIP001  	Reference< XInterface > 	xRef;
//STRIP001 
//STRIP001 	WAIT_ON();
//STRIP001 	sal_Bool bSpell = sal_True;
//STRIP001 
//STRIP001 	Reference< XDictionary1 >  xAllRightDic;
//STRIP001 	if (IsAllRight())
//STRIP001 		xAllRightDic = GetAllRightDic();
//STRIP001 
//STRIP001 	while ( bSpell )
//STRIP001 	{
//STRIP001 		SpellContinue();
//STRIP001 
//STRIP001 		Reference< XSpellAlternatives >  	xAlt( GetLast(), UNO_QUERY );
//STRIP001 		Reference< XHyphenatedWord > 		xHyphWord( GetLast(), UNO_QUERY );
//STRIP001 
//STRIP001 		if (xAlt.is())
//STRIP001 		{
//STRIP001 			if (IsAllRight() && xAllRightDic.is())
//STRIP001 			{
//STRIP001 				xAllRightDic->add( xAlt->getWord(), sal_False, ::rtl::OUString() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// look up in ChangeAllList for misspelled word
//STRIP001 				Reference< XDictionary1 > 	xChangeAllList( 
//STRIP001 						SvxGetChangeAllList(), UNO_QUERY );
//STRIP001 				Reference< XDictionaryEntry > 	xEntry;
//STRIP001 				if (xChangeAllList.is())
//STRIP001 					xEntry = xChangeAllList->getEntry( xAlt->getWord() );
//STRIP001 
//STRIP001 				if (xEntry.is())
//STRIP001 				{
//STRIP001 					// replace word without asking
//STRIP001 					ReplaceAll( xEntry->getReplacementText(), 
//STRIP001 								SvxLocaleToLanguage( xAlt->getLocale() ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					bSpell = sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (xHyphWord.is())
//STRIP001 			bSpell = sal_False;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SpellEnd();
//STRIP001 			bSpell = SpellNext();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	WAIT_OFF();
//STRIP001 	return GetLast().is();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 String SvxSpellWrapper::GetNewEditWord()
//STRIP001 {
//STRIP001 	String sReturn;
//STRIP001 
//STRIP001 	DBG_ASSERT( IsDialog(), "SvxSpellWrapper::GetNewEditWord: do not have the dialog!" );
//STRIP001 	if ( IsDialog() )
//STRIP001 		sReturn = static_cast< SvxSpellCheckDialog* >( pWin )->GetNewEditWord();
//STRIP001 	return sReturn;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxSpellWrapper::SetNewEditWord( const String& _rNew )
//STRIP001 {
//STRIP001 	DBG_ASSERT( IsDialog(), "SvxSpellWrapper::SetNewEditWord: do not have the dialog!" );
//STRIP001 	if ( IsDialog() )
//STRIP001 		static_cast< SvxSpellCheckDialog* >( pWin )->SetNewEditWord( _rNew );
//STRIP001 }
}
