/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wrt_db.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:01:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <stdlib.h>
#include "pam.hxx"
#include "doc.hxx"
#include "segmentc.hxx"
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif
#ifndef _NODE_HXX //autogen
#include <node.hxx>
#endif
#include "wrt_db.hxx"
namespace binfilter {

#if defined(MAC)
const sal_Char SwDBWriter::sNewLine = '\015';
#elif defined(UNX)
const sal_Char SwDBWriter::sNewLine = '\012';
#else
const sal_Char __FAR_DATA SwDBWriter::sNewLine[] = "\015\012";
#endif


static void OutNodeNm( const SwNodes& rNds, SwNode* pNode, Writer& rWrt )
{
	const sal_Char* aSttNdArr[] = { "", "Box", "Fly", "Footnote",
								"Header", "Footer" };

	switch( pNode->GetNodeType() )
	{
	case ND_STARTNODE:      rWrt.Strm() << aSttNdArr[ ((SwStartNode*)pNode)->GetStartNodeType() ]
										<< "StartNode: Ende= ";
							rWrt.OutULong( pNode->EndOfSectionIndex() );
							break;
	case ND_TABLENODE:      rWrt.Strm() << "TableNode: Ende= ";
							rWrt.OutULong( pNode->EndOfSectionIndex() );
							break;
	case ND_SECTIONNODE:    rWrt.Strm() << "SectionNode: Ende= ";
							rWrt.OutULong( pNode->EndOfSectionIndex() );
							break;
	case ND_ENDNODE:        rWrt.Strm()
								<< aSttNdArr[ pNode->FindStartNode()->GetStartNodeType() ]
								<< "EndNode:";
							break;
   case ND_TEXTNODE:        rWrt.Strm() << "TxtNode:";    break;
	case ND_GRFNODE:        rWrt.Strm() << "GrfNode:";    break;
	case ND_OLENODE:        rWrt.Strm() << "OleNode:";    break;
	default:
		ASSERT( FALSE, "was ist das fuer ein Node??");
	}
	rWrt.Strm() << " Start= ";
	rWrt.OutULong( pNode->StartOfSectionIndex() ) << " Lvl= ";
	rWrt.OutULong( pNode->GetSectionLevel() );
}


SwDBWriter::SwDBWriter()
{
	bOutTable = TRUE;
	bTxtAttr = FALSE;
	pNdCondColl = pNdFmt = 0;
}


SEXPORT SwDBWriter::~SwDBWriter() {}


ULONG SwDBWriter::WriteStream()
{
	//$ long nFlags = rStrm().setf( ios::fixed, ios::floatfield );
	//$ rStrm().precision( 3 );

// gebe das gesamte Dokument aus - mit allen Sections
pCurPam->GetPoint()->nNode = 0;
pCurPam->GetMark()->nNode = pDoc->GetNodes().Count()-1;

	Out_SwDoc( pOrigPam, pDoc->GetNodes() );

	Strm() << SwDBWriter::sNewLine << SwDBWriter::sNewLine
			<< "========================================"
			<< SwDBWriter::sNewLine << "Die PageDescriptoren: "
			<< SwDBWriter::sNewLine;
	OutDB_SwPageDescs( *this, *pDoc );

	Strm() << SwDBWriter::sNewLine << SwDBWriter::sNewLine
			<< "========================================"
			<< SwDBWriter::sNewLine << "Die Fly-Formate: "
			<< SwDBWriter::sNewLine;
	for( USHORT n = 0; n < pDoc->GetSpzFrmFmts()->Count(); ++n )
	{
		Strm() << "Fly (";
		OutULong( n ) << "):";
		OutDB_SwFmt( *this, *(*pDoc->GetSpzFrmFmts())[n] );
		Strm() << SwDBWriter::sNewLine;
	}
	Strm() << SwDBWriter::sNewLine << SwDBWriter::sNewLine
			<< "========================================"
			<< SwDBWriter::sNewLine << "Die NumRules: "
			<< SwDBWriter::sNewLine;
	for( n = 0; n < pDoc->GetNumRuleTbl().Count(); ++n )
	{
		Strm() << "Rule ";
		OutULong( n ) << ':';
		OutDB_SwNumRule( *this, *pDoc->GetNumRuleTbl()[ n ] );
		Strm() << SwDBWriter::sNewLine;
	}

	Strm() << SwDBWriter::sNewLine << SwDBWriter::sNewLine
			<< "========================================"
			<< SwDBWriter::sNewLine << "Es folgt das UndoNodesArray: "
			<< SwDBWriter::sNewLine;
	SwPaM * pDebug = NewSwPaM( *pDoc, 0,
						pDoc->GetUndoNds()->Count()-1, FALSE );
	pDebug->Exchange();
	SwPaM * pOldPam = pCurPam, *pOldEnd = pOrigPam;
	pOrigPam = pCurPam = pDebug;
	Out_SwDoc( pDebug, *pDoc->GetUndoNds() );

	pCurPam = pOldPam;
	pOrigPam = pOldEnd;

	delete pDebug; 		// Pam wieder loeschen

	Strm() << '\0';

	return 0;
}



void SwDBWriter::Out_SwDoc( SwPaM * pPam, const SwNodes& rNds  )
{
	// gebe alle Bereiche des Pams in das RTF-File aus.
	do {
		while( pCurPam->GetPoint()->nNode < pCurPam->GetMark()->nNode ||
			  (pCurPam->GetPoint()->nNode == pCurPam->GetMark()->nNode &&
			   pCurPam->GetPoint()->nContent.GetIndex() <= pCurPam->GetMark()->nContent.GetIndex()) )
		{
			SwNode* pNode = &pCurPam->GetPoint()->nNode.GetNode();
			SwCntntNode * pNd = pNode->GetCntntNode();

			Strm() << SwDBWriter::sNewLine << "No: ";
			OutULong( pCurPam->GetPoint()->nNode.GetIndex() ) << ' ';

			OutNodeNm( rNds, pNode, *this );
			if( pNode->GetTableNode() )
			{
				// Verkettung der Tabellen-Nodes ausgeben
				SwNodeIndex aIdx( pCurPam->GetPoint()->nNode, 1 );
				while( aIdx.GetIndex() <= pNode->EndOfSectionIndex() )
				{
					Strm() << SwDBWriter::sNewLine << "No: ";
					OutULong( aIdx.GetIndex() ) << ' ';
					OutNodeNm( rNds, rNds[ aIdx ], *this );
					aIdx++;
				}
			}
			else if( pNode->IsSectionNode() )
				OutDB_SwSectionNode( *this, *pNode->GetSectionNode() );

			if( bOutTable && pNd )
			{
				SwTableNode* pTblNd = pNd->StartOfSectionNode()->
							StartOfSectionNode()->GetTableNode();
				if( pTblNd )
					OutDB_SwTableNode( *this, *pTblNd );
				else
					Out( aDBNodeFnTab, *pNd, *this );
			}
			else if( pNd )
				Out( aDBNodeFnTab, *pNd, *this );

			if( pCurPam->GetPoint()->nNode.GetIndex() == rNds.Count() - 1 )
				break;
			pCurPam->GetPoint()->nNode++;
		}
	} while( CopyNextPam( &pPam ) );		// bis alle Pam bearbeitet
}


#ifndef PRODUCT

void GetDebugWriter( const String&, WriterRef& xRet )
{
	xRet = new SwDBWriter;
}

#endif

}
