
#ifndef __ACPID_DRIVER__
#define __ACPID_DRIVER__

#include <poll.h>
#include <lua.h>

int acpi_dbus_event(const char *hid, unsigned long event, unsigned long data);


/*
 *	ACPI Channel
 */
struct acpi_channel;

struct acpi_channel_descriptor {
	struct acpi_channel *channel;
	int fd, events;
};

struct acpi_channel_ops {
	int (*setup)(struct acpi_channel *channel, struct acpi_channel_descriptor *cds, unsigned long ncds);
	int (*handle)(struct acpi_channel *channel, lua_State *L, int fd, int events);
};

struct acpi_channel {
	const struct acpi_channel_ops *ops;
	void *private;
};

int acpi_channel_create(lua_State *L);
void acpi_channel_register(struct acpi_channel *channel, const struct acpi_channel_ops *ops);
void acpi_channel_watch(struct acpi_channel *channel, struct acpi_channel_descriptor *cds, int fd, int events);
int acpi_channel_event(struct acpi_channel *channel, lua_State *L, const char *hid, unsigned long event, unsigned long data);


/*
 *	ACPI Driver
 */
struct acpi_driver_ops {
	int (*create)(struct acpi_channel *channel, lua_State *L);
	void (*destroy)(struct acpi_channel *channnel);
};

struct acpi_driver {
	const char *name;
	const struct acpi_driver_ops ops;
};

void acpi_driver_register(const struct acpi_driver *driver);
const struct acpi_driver_ops *acpi_driver_find(const char *name);

#endif /* __ACPID_DRIVER__ */

