.ig
Copyright (C) 1989-1995, 2001, 2002 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.TH @G@TBL @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
@g@tbl \- format tables for troff
.
.
.SH SYNOPSIS
.B @g@tbl
[
.B \-Cv
]
[
.IR files \|.\|.\|.\&
]
.
.
.SH DESCRIPTION
This manual page describes the GNU version of
.BR tbl ,
which is part of the groff document formatting system.
.B tbl
compiles descriptions of tables embedded within
.B troff
input files into commands that are understood by
.BR troff .
Normally, it should be invoked using the
.B \-t
option of
.B groff.
It is highly compatible with Unix
.BR tbl .
The output generated by GNU
.B tbl
cannot be processed with Unix
.BR troff ;
it must be processed with GNU
.BR troff .
If no files are given on the command line, the standard input
will be read.
A filename of
.B \-
will cause the standard input to be read.
.
.
.SH OPTIONS
.TP
.B \-C
Recognize
.B .TS
and
.B .TE
even when followed by a character other than space or newline.
.TP
.B \-v
Print the version number.
.
.
.SH USAGE
.B tbl
expects to find table descriptions wrapped in the
.B .TS
(table start) and
.B .TE
(table end) macros.
The line immediately following the
.B .TS
macro may contain any of the following global options (ignoring the case
of characters -- Unix tbl only accepts options with all characters lowercase
or all characters uppercase):
.
.TP
.B center
Centers the table (default is left-justified).
The alternative keyword name
.B centre
is also recognized (this is a GNU tbl extension).
.
.TP
.BI delim( xy )
Use
.I x
and
.I y
as start and end delimiters for
.BR @g@eqn (@MAN1EXT@).
.
.TP
.B expand
Makes the table as wide as the current line length.
.
.TP
.B box
Encloses the table in a box.
.
.TP
.B doublebox
Encloses the table in a double box.
.
.TP
.B allbox
Encloses each item of the table in a box.
.
.TP
.B frame
Same as box (GNU tbl only).
.
.TP
.B doubleframe
Same as doublebox (GNU tbl only).
.
.TP
.BI tab( x )
Uses the character
.I x
instead of a tab to separate items in a line of input data.
.
.TP
.BI linesize( n )
Sets lines or rules (e.g. from
.BR box )
in
.IR n -point
type.
.
.TP
.B nokeep
Don't use diversions to prevent page breaks (GNU tbl only).
Normally
.B tbl
attempts to prevent undesirable breaks in the table by using diversions.
This can sometimes interact badly with macro packages' own use of
diversions, when footnotes, for example, are used.
.
.TP
.BI decimalpoint( c )
Set the character to be recognized as the decimal point in numeric
columns (GNU tbl only).
.
.TP
.B nospaces
Ignore leading and trailing spaces in data items (GNU tbl only).
.
.LP
The global options must end with a semicolon.
There might be whitespace after an option and its argument in parentheses.
.LP
After global options come lines describing the format of each line of
the table.
Each such format line describes one line of the table itself, except that
the last format line (which you must end with a period) describes all
remaining lines of the table.
A single key character describes each column of each line of the table.
You may run format specs for multiple lines together on the same line by
separating them with commas.
.LP
You may follow each key character with specifiers that determine the font
and point size of the corresponding item, that determine column width,
inter-column spacing, etc.
.LP
The longest format line defines the number of columns in the table; missing
format descriptors at the end of format lines are assumed to be `L'.
Extra columns in the data (which have no corresponding format entry) are
ignored.
.LP
The available key characters are:
.
.TP
c,C
Centers item within the column.
.
.TP
r,R
Right-justifies item within the column.
.
.TP
l,L
Left-justifies item within the column.
.
.TP
n,N
Numerically justifies item in the column: Units positions of numbers are
aligned vertically.
.
.TP
s,S
Spans previous item on the left into this column.
.
.TP
a,A
Centers longest line in this column and then left-justifies all other lines
in this column with respect to that centered line.
.
.TP
^
Spans down entry from previous row in this column.
.
.TP
_,-
Replaces this entry with a horizontal line.
.
.TP
=
.
Replaces this entry with a double horizontal line.
.
.TP
|
The corresponding column becomes a vertical rule (if two of these are
adjacent, a double vertical rule).
.
.LP
A vertical bar to the left of the first key-letter or to the right of the
last one produces a line at the edge of the table.
.LP
Here are the specifiers that can appear in suffixes to column key letters:
.
.TP
b,B
Short form of fB (make affected entries bold).
.
.TP
i,I
Short form of fI (make affected entries italic).
.
.TP
t,T
Start an item vertically spanning rows at the top of its range rather than
vertically centering it.
.
.TP
d,D
Start an item vertically spanning rows at the bottom of its range rather
than vertically centering it (GNU tbl only).
.
.TP
v,V
Followed by a number, this indicates the vertical line spacing to be used in
a multi-line table entry.
If signed, the current vertical line spacing is incremented or decremented
(using a signed number instead of a signed digit is a GNU tbl extension).
A vertical line spacing specifier followed by a column separation number
must be separated by one or more blanks.
No effect if the corresponding table entry isn't a text block.
.
.TP
f,F
Either of these specifiers may be followed by a font name (either one or two
characters long), font number (a single digit), or long name in parentheses
(the last form is a GNU tbl extension).
A one-letter font name must be separated by one or more blanks from whatever
follows.
.
.TP
p,P
Followed by a number, this does a point size change for the affected fields.
If signed, the current point size is incremented or decremented (using a
signed number instead of a signed digit is a GNU tbl extension).
A point size specifier followed by a column separation number must be
separated by one or more blanks.
.
.TP
w,W
Minimal column width value.
Must be followed either by a
.BR @g@troff (@MAN1EXT@)
width expression in parentheses or a unitless integer.
If no unit is given, en units are used.
Also used as the default line length for included text blocks.
If used multiple times, the last entry takes effect.
.
.TP
e,E
Make equally-spaced columns.
.
.TP
u,U
Move the corresponding column up one half-line.
.
.TP
z,Z
Ignore the corresponding column for width-calculation purposes.
.
.LP
A number suffix on a key character is interpreted as a column
separation in ens (multiplied in proportion if the
.B expand
option is on).
Default separation is 3n.
.LP
The format lines are followed by lines containing the actual data for the
table, followed finally by
.BR .TE .
Within such data lines, items are normally separated by tab characters (or
the character specified with the
.B tab
option).
Long input lines can be broken across multiple lines if the last character
on the line is `\e' (which vanishes after concatenation).
.LP
A dot starting a line, followed by anything but a digit is handled as a
troff command, passed through without changes.
The table position is unchanged in this case.
.LP
If a data line consists of only `_' or `=', a single or double line,
respectively, is drawn across the table at that point; if a single item in a
data line consists of only `_' or `=', then that item is replaced by a
single or double line, joining its neighbours.
If a data item consists only of `\e_' or `\e=', a single or double line,
respectively, is drawn across the field at that point which does not join
its neighbours.
.LP
A data item consisting only of `\eRx' (`x' any character) is replaced by
repetitions of character `x' as wide as the column (not joining its
neighbours).
.LP
A data item consisting only of `\e^' indicates that the field immediately
above spans downward over this row.
.LP
A text block can be used to enter data as a single entry which would be
too long as a simple string between tabs.
It is started with `T{' and closed with `T}'.
The latter must start a line, probably followed by other data columns
(separated with tabs).
.LP
To change the data format within a table, use the
.B .T&
command (at the start of a line).
It is followed by format and data lines (but no global options) similar to
the
.B .TS
request.
.
.
.SH "INTERACTION WITH @G@EQN"
.BR @g@tbl (@MAN1EXT@)
should always be called before
.BR @g@eqn (@MAN1EXT@)
.RB ( groff (@MAN1EXT@)
automatically takes care of the correct order of preprocessors).
.
.
.SH "GNU TBL ENHANCEMENTS"
There is no limit on the number of columns in a table, nor any limit on the
number of text blocks.
All the lines of a table are considered in deciding column widths, not just
the first 200.
Table continuation
.RB ( .T& )
lines are not restricted to the first 200 lines.
.LP
Numeric and alphabetic items may appear in the same column.
.LP
Numeric and alphabetic items may span horizontally.
.LP
.B @g@tbl
uses register, string, macro and diversion names beginning with the digit\~\c
.BR 3 .
When using
.B @g@tbl
you should avoid using any names beginning with a\~\c
.BR 3 .
.
.
.SH BUGS
You should use
.BR .TS\ H / .TH
in conjunction with a supporting macro package for
.I all
multi-page boxed tables.
If there is no header that you wish to appear at the top of each page
of the table, place the
.B .TH
line immediately after the format section.
Do not enclose a multi-page table within keep/release macros,
or divert it in any other way.
.LP
A text block within a table must be able to fit on one page.
.LP
The
.B bp
request cannot be used to force a page-break in a multi-page table.
Instead, define
.B BP
as follows
.IP
.B .de BP
.br
.B .ie '\e\en(.z'' .bp \e\e$1
.br
.B .el \e!.BP \e\e$1
.br
.B ..
.br
.LP
and use
.B BP
instead of
.BR bp .
.LP
Using \ea directly in a table to get leaders will not work.
This is correct behaviour: \ea is an
.B uninterpreted
leader.
To get leaders use a real leader, either by using a control A or like
this:
.IP
.nf
.ft B
\&.ds a \ea
\&.TS
tab(;);
lw(1i) l.
A\e*a;B
\&.TE
.ft
.fi
.
.
.SH REFERENCE
Lesk, M.E.: "TBL -- A Program to Format Tables".
For copyright reasons it cannot be included in the groff distribution,
but copies can be found with a title search on the World Wide Web.
.
.
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@)
.
.\" Local Variables:
.\" mode: nroff
.\" End:
