/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/common/irmp3tools.c,v $ -- some useful functions
 * $Id: irmp3tools.c,v 1.6 2004/02/08 10:30:31 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 * Please contact the current maintainer, Jrmy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "config.h"
#include "irmp3tools.h"
#include "irmp3log.h"

/*************************************************************************
 * GLOBAL VARIABLES
 */
// signals to reading function that they shouldn't wait for input and return.
int terminate=0;


/*************************************************************************
 * READ ONE TRIMED LINE FROM FH
 */
int freadtrimedline(FILE *fh, char *buf, int count)
{
	int	rc, c;

	buf[0]=0;
	c=0;

	do
	{
		rc=getc(fh);

		if(rc == EOF)
			return	-1;

		// CR/LF are read but ignored
		if(rc==0 || rc=='\r' || rc=='\n')
		{
			if(rc!=0)	// if we have CR or LF remove both
			{
				int	rc2;
			
				rc2=getc(fh);
	
				if(rc2==rc || (rc2!='\r' || rc2=='\n'))
					ungetc(rc2, fh);
			}
			
			break;
		}
		else if(c>0 || (rc!=' ' && rc!='\t'))	// ignore spaces at begin
		{
			buf[c++]=(char)rc;
		}
	}while(!terminate && c<count);
	buf[c]=0;

	// now trim spaces at the end
	while(c>1 && (buf[c-1]==' ' || buf[c-1]=='\t'))
	{
		buf[--c]=0;
	}
	
	return c;
}

/*************************************************************************
 * READ ONE LINE FROM FD
 */
int readline (int fd, char *buf, int count)
{
	int rc, c;

	buf[0] = 0;
	c = 0;
	do {
		rc = read(fd, buf+c, 1);
		if (rc <= 0)
			return rc-1;
		// CR/LF at beginning of line is ignored.
		if (!c && (*buf == '\r' || *buf == '\n')) {
			break;
		}
		// skip CR and/or LF at end of line
		if (buf[c] == 0 || buf[c] == '\r' || buf[c] == '\n')
			break;
		c++;
	} while (!terminate && c < count);
	buf[c] = 0;

	return c;
}


/*************************************************************************
 * SEND TEXT TO FD
 */
int sendtext (int fd, char *text, ...)
{
	char buf[1024];
	va_list ap;

	va_start(ap, text);
	vsnprintf(buf, sizeof(buf), text, ap);
	buf[sizeof(buf)-1] = 0;
	va_end(ap);

	return write(fd, buf, strlen(buf));
}


/*************************************************************************
 * TRIM BLANKS
 */
char *trimleft (char *str)
{
	char *s = str;
	while (*s==' ' || *s=='\t')
		s++;
	memmove(str,s,strlen(s)+1);
	return str;
}

char *trimright (char *str)
{
	char *s = str + strlen(str) - 1;
	while (s>=str && (*s==' ' || *s=='\t'))
		*s-- = 0;
	return str;
}

char *trim (char *str)
{
	return trimleft(trimright(str));
}


/*************************************************************************
 * EOF
 */
