/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/modules.inc,v $ -- List of available modules
 * $Id: modules.inc,v 1.13 2004/08/10 22:23:32 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#ifndef MODULES_INC
#define MODULES_INC

#include "irmp3mod.h"


/*************************************************************************
 * MODULE INIT FUNCTION PROTOTYPES
 */
extern mod_t mod_mpg123;
extern mod_t mod_browser;
extern mod_t mod_playlist;
extern mod_t mod_playlistlist;
extern mod_t mod_beep;
extern mod_t mod_mixer;
extern mod_t mod_env;
extern mod_t mod_timer;
extern mod_t mod_alarm;
extern mod_t mod_lirc;
extern mod_t mod_lcdproc;
extern mod_t mod_netctl;
extern mod_t mod_idle;
extern mod_t mod_autoshutdown;
extern mod_t mod_cd;
extern mod_t mod_debug;
extern mod_t mod_fifo;
extern mod_t mod_magic;
extern mod_t mod_timidity;
extern mod_t mod_mplayer;
extern mod_t mod_player;
extern mod_t mod_flac123;
extern mod_t mod_radio;
extern mod_t mod_kbd;


/*************************************************************************
 * LIST OF MODULE INIT FUNCTIONS
 */
mod_t *mod_list_init[] = {

#ifdef MOD_MPG123
	&mod_mpg123,
#endif

#ifdef MOD_BROWSER
	&mod_browser,
#endif

#ifdef MOD_PLAYLIST
	&mod_playlist,
#endif

#ifdef MOD_PLAYLISTLIST
	&mod_playlistlist,
#endif

#ifdef MOD_BEEP
	&mod_beep,
#endif

#ifdef MOD_MIXER
	&mod_mixer,
#endif

#ifdef MOD_ENV
	&mod_env,
#endif

#ifdef MOD_TIMER
	&mod_timer,
#endif

#ifdef MOD_ALARM
	&mod_alarm,
#endif

#ifdef MOD_LIRC
	&mod_lirc,
#endif

#ifdef MOD_LCDPROC
	&mod_lcdproc,
#endif

#ifdef MOD_CD
	&mod_cd,
#endif

#ifdef MOD_NETCTL
	&mod_netctl,
#endif

#ifdef MOD_IDLE
	&mod_idle,
#endif

#ifdef MOD_AUTOSHUTDOWN
	&mod_autoshutdown,
#endif

#ifdef MOD_FIFO
	&mod_fifo,
#endif

#ifdef MOD_MAGIC
	&mod_magic,
#endif

#ifdef MOD_TIMIDITY
	&mod_timidity,
#endif

#ifdef MOD_PLAYER
	&mod_player,
#endif

#ifdef MOD_FLAC123
	&mod_flac123,
#endif
#ifdef MOD_RADIO
	&mod_radio,
#endif
#ifdef MOD_MPLAYER
	&mod_mplayer,
#endif
#ifdef MOD_KBD
	&mod_kbd,
#endif

// should be left last
#ifdef MOD_DEBUG
	&mod_debug,
#endif

	NULL
};


#endif /* MODULES_INC */

/*************************************************************************
 * EOF
 */
