/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SEARCH_LOCATION_ID_H
#define SEARCH_LOCATION_ID_H

#include <qmap.h>

#include "http_client.h"
#include "misc.h"
#include "config_file.h"

#include "weather_parser.h"
#include "weather_global.h"
#include "citysearchresult.h"

/**
	\class SearchLocationID
	Klasa zajmujca si wyszukiwaniem kodu miejscowoci.
	Wyszukiwanie inicujuj si przez wywoanie findID(), a obsug realizuj gniazda
	finished(), redirected() i error()
**/
class SearchLocationID : public QObject
{
	Q_OBJECT

	public:
	
		SearchLocationID();
		~SearchLocationID();
		
		bool findID( const QString& city, const QString& serverConfigFile );
		bool findID( const QString& city );
		
		void cancel();
		const CITYSEARCHRESULTS& getResult() const { return results_; }
	
	signals:
		void finished();
		void error( QString url );
		void nextServerSearch( const QString& city, const QString& serverName_ );
	
	private:
		HttpClient httpClient_;
		QTextCodec* decoder_;
		QString host_;
		QString url_;
		WeatherParser parser_;
		PlainConfigFile* weatherConfig_;
		QString serverConfigFile_;
		
		WeatherGlobal::SERVERITERATOR currentServer_;
		bool searchAllServers_;
		bool redirected_;
		
		QTimer* timerTimeout_;
		int timeoutCount_;
		
		QString city_;
		
		CITYSEARCHRESULTS results_;
		
		void encodeUrl( QString* str, const QString& enc) const;
		void splitUrl(const QString& url, QString& host, QString& path) const;
		void findNext( const QString& serverConfigFile );
		void findNext();

	private slots:
		void downloadingFinished();
		void downloadingRedirected(QString link);
		void downloadingError();
		void connectionTimeout();
	
};

#endif // SEARCH_LOCATION_ID_H
