#ifndef FILTERING_H
#define FILTERING_H

#include "usergroup.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qevent.h>

class Filtering : public QWidget {
	Q_OBJECT
	
	public:
		Filtering();
		virtual ~Filtering();
		
	protected:
		virtual void keyPressEvent (QKeyEvent *e);
		bool eventFilter (QObject *o, QEvent *e);
	
	private slots:
		void on_clearPB_clicked ();
		void on_textLE_textChanged (const QString& s);
		void on_textLE_returnPressed ();
		void on_kadu_keyPressed(QKeyEvent*);
		
	private:
		void clearFilter ();
		void filterWith (const QString& f);
		bool checkString (const QString& hay, const QString& needle, bool startsWith);
		
		QPushButton *clearPB;
		QLineEdit *textLE;
		
		UserGroup *filter;
};

extern Filtering *filtering;

#endif
