#ifndef TRANSLATOR_H
#define TRANSLATOR_H

#include <qobject.h>
#include <qstring.h>

class UserGroup;
class Chat;

/*!
 * This class provides strings encoding mechanism using Morse, 1337 and
 * alternative 1337 codes.
 * \brief String encoding class
 */
class Translator : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor.
		 * \param cType is one of the following: "morse", "1337", or "alt1337". Holds the code type.
		 * \param parent points to patent's object.
		 * \param name is an object's name.
		 */
		Translator(QString cType, QObject *parent = 0, const char *name = 0);

		//! Default destructor.
		~Translator();

		/*!
		 * Encodes the string.
		 * \brief String encoding function.
		 * \param text is text that is to be encoded.
		 * \return It returns encoded string from the <i>text</i> argument.
		 */
		QString encode(const QString &text);

	public slots:
		/*!
		 * \fn void translateCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * Various translation commands implementations.
		 * \param chat This chat window contains text to encode in input edit.
		 * \param users Encoded text will be sent to this users.
		 * \param cmd Command
		 * \param args %Ignored
		 * \param msg Message
		 */
		void translateCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);

	protected:
		//! A "dictionary oriented" type, holding the encoding patterns.
		typedef QMap<QChar, QString> KeyList;

		/*!
		 * It holds a dictionary oriented list of QChar characters
		 * and theirs QString code representatives.
		 */
		KeyList keyList;

		/*!
		 * It holds the name of used code.
		 */
		QString codeType;
};

#endif
