/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef PROFILEWIDGET_H
#define PROFILEWIDGET_H

#include <qptrlist.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include "profilewidgetbase.h"
#include "vpnaccountdata.h"
#include "kvpncconfig.h"

/**
@author Christoph Thielecke
*/
class ProfileWidget : public ProfileWidgetBase {
		Q_OBJECT

	public:
		/**
		 *     Konstruktor
		 * @return nothing
		 */
		ProfileWidget( KVpncConfig *GlobalConfig, QWidget * parent=0, const char * name=0, WFlags f=0 );

		/**
		 *     Destruktor
		 * @return nothing
		 */
		~ProfileWidget();

	public slots:

		/**
		 *     Imports a p12 certificate
		 */
		void importCertificate();

		/**
		 *     The current profile has changed
		 * @param item the new item
		 */
		void profileChanged( const QString& itemtext );

		/**
		 * Adds a new session
		 */
		void newSessionClicked();

		/**
		 *     Save the current session
		 */
		void saveSessionClicked();

		/**
		 *     deletes the current session
		 */
		void deleteSessionClicked();

		/**
		 *     Cancels the dialog
		 */
		void slotCancelClicked();

		/**
		 *     Current connection type has changed
		 * @param  the new type
		 */
		void connectionTypeChanged( int connectiontype );

		/**
		 *     Current authentication type has changed
		 * @param  the new authentication type
		 */
		void authTypeChanged( int authtype );

		/**
		 *    State of ping check has changed
		 * @param  the new state
		 */
		void pingIpToggled( bool );

		/**
		 *     Calls advanced settings dialog
		 */
		void advancedSettingsClicked();
		
		/**
		 *     The state of use special remote id checkbox has changed
		 */
		void useSpecialRemoteIDClicked();
		
	protected slots:
		void renameSessionClicked();
		void useVirtualIPClicked();
    void PskInFileToggled();
    void addNetworkRouteClicked();
    void delNetworkRouteClicked();
    void additionalNetworkRoutesToggled(bool);
    void useSpecialServerCertificateToggled(bool);
		void udpPortToggled(bool);
		void useUdpToggled (bool);
    void useDnsServerToggled(bool);
    void setDefaultRouteToggled(bool);
    void mtuToggled(bool);
		void userdefinedPortToggled(bool);


	protected:
		bool cancelClicked; //< True if cancal has clicked
		KVpncConfig *GlobalConfig;

		
	public:
		bool profileAddedOrDeleted;
		QString NewProfileName;

};

#endif
