/**
 * \file GTableCreate.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Huang Ying
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

// Too hard to make concept checks work with this file
#ifdef _GLIBCXX_CONCEPT_CHECKS
#undef _GLIBCXX_CONCEPT_CHECKS
#endif
#ifdef _GLIBCPP_CONCEPT_CHECKS
#undef _GLIBCPP_CONCEPT_CHECKS
#endif

#include "GTableCreate.h"
#include "ghelpers.h"

#include "support/lstrings.h"

#include <libglademm.h>

using std::string;

namespace lyx {
namespace frontend {

GTableCreate::GTableCreate(Dialog & parent)
	: GViewCB<ControlTabularCreate, GViewGladeB>(parent, _("Insert Table"))
{
}


void GTableCreate::doBuild()
{
	string const gladeName = findGladeFile("tableCreate");
	xml_ = Gnome::Glade::Xml::create(gladeName);
	Gtk::Button * ok;
	Gtk::Button * apply;
	Gtk::Button * cancel;
	xml_->get_widget("Ok", ok);
	xml_->get_widget("Apply", apply);
	xml_->get_widget("Cancel", cancel);
	xml_->get_widget("Rows", rows_);
	xml_->get_widget("Columns", columns_);
	setOK(ok);
	setCancel(cancel);
	setApply(apply);
}


void GTableCreate::apply()
{
	size_t const rows = rows_->get_value_as_int();
	size_t const columns = columns_->get_value_as_int();
	controller().params() = std::make_pair(rows, columns);
}

} // namespace frontend
} // namespace lyx
