#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ=..

PRJNAME=sal
TARGET=typesconfig
TARGETTYPE=CUI

LIBSALCPPRT=$(0)

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

CFLAGS+= $(LFS_CFLAGS)
CXXFLAGS+= $(LFS_CFLAGS)

# --- Files --------------------------------------------------------

.IF "$(CROSS_COMPILING)"!="YES" && "$(COM)"!="MSC"

APP1TARGET=	$(TARGET)
APP1OBJS=		$(OBJ)$/typesconfig.obj
APP1STDLIBS=
APP1DEF=

.ENDIF

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

.IF "$(L10N-framework)"==""
.IF "$(COM)"!="MSC"
ALLTAR : $(INCCOM)$/sal$/typesizes.h
.ENDIF
.ENDIF			# "$(L10N-framework)"==""

.IF "$(CROSS_COMPILING)"!="YES"

$(INCCOM)$/sal$/typesizes.h : $(BIN)$/$(TARGET)
    -$(MKDIR) $(INCCOM)$/sal
    $(AUGMENT_LIBRARY_PATH) $(BIN)$/$(TARGET) $@

.ELSE

$(INCCOM)$/sal$/typesizes.h : 
    -$(MKDIRHIER) $(INCCOM)$/sal
    echo '/* This file is autogenerated from configure script data */' >$@
    echo >>$@
    echo "#define SAL_TYPES_ALIGNMENT2	$(ALIGNOF_SHORT)" >>$@
    echo "#define SAL_TYPES_ALIGNMENT4	$(ALIGNOF_INT)" >>$@
.IF "$(SIZEOF_LONG)"=="8"
    echo "#define SAL_TYPES_ALIGNMENT8	$(ALIGNOF_LONG)" >>$@
.ELIF "$(SIZEOF_DOUBLE)"=="8"
    echo "#define SAL_TYPES_ALIGNMENT8	$(ALIGNOF_DOUBLE)" >>$@
.ELSE
    echo "#error alignment of some 8-byte type unknown" >>$@
.ENDIF
    echo "#define SAL_TYPES_SIZEOFSHORT	$(SIZEOF_SHORT)" >>$@
    echo "#define SAL_TYPES_SIZEOFINT	$(SIZEOF_INT)" >>$@
    echo "#define SAL_TYPES_SIZEOFLONG	$(SIZEOF_LONG)" >>$@
    echo "#define SAL_TYPES_SIZEOFLONGLONG	$(SIZEOF_LONGLONG)" >>$@
    echo "#define SAL_TYPES_SIZEOFPOINTER	$(SIZEOF_POINTER)" >>$@

.ENDIF
