#include <iostream>
#include <fstream>
#include <string>

using std::cerr;
using std::cout;
using std::endl;
using std::ifstream;
using std::string;
using std::exit;

int main(int argc, char **argv)
{
  if (argc <  3 || argc > 5)
    {
      cerr << "usage: " << argv[0] << " [--strip-trailing] [--no-static] <filename> <arrayname> " << endl;
      exit(1);
    }

  bool do_strip_trailing = false;
  bool do_static = false;
  string static_decl("static ");
  int i = 1;
  if (string(argv[i]) == "--strip-trailing")
    {
      do_strip_trailing = true;
      i++;
    }
  if (string(argv[i]) == "--no-static")
    {
      do_static = true;
      static_decl = "";
      i++;
    }
  ifstream fin(argv[i++]);
  string arr(argv[i++]);

  if (!fin)
    {
      cerr << "could not open " << argv[1] << " for reading" << endl;
      exit(1);
    }

  char c;
  string dat;
  while(fin.get(c))
    dat += c;

  if (do_strip_trailing)
    {
      int last = dat.find_last_not_of(" \t\n");
      dat.erase(last + 1);
    }

  cout << "// DO NOT EDIT\n"
       << "// this file is automatically generated from " << argv[1 + do_strip_trailing + do_static] << ",\n"
       << "// any changes you make will be destroyed when it is regenerated\n"
       << "\n\n"
       << static_decl
       << "char const " << arr << "_constant[" << (dat.size() + 1) << "] = {\n";

  for (unsigned int i = 0; i < dat.size(); ++i)
    {
      if (i == 0) cout << "\t";
      else if (i % 20 == 0) cout << "\n\t";
      cout << static_cast<int>(dat[i]) << ", ";
    }
  cout << "0\n};\n";
}

// Local Variables:
// mode: C++
// fill-column: 76
// c-file-style: "gnu"
// indent-tabs-mode: nil
// End:
// vim: et:sw=2:sts=2:ts=2:cino=>2s,{s,\:s,+s,t0,g0,^-2,e-2,n-2,p2s,(0,=s:
