//
//  MWDocument.h
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/6/17.
//  Copyright MySQL AB 2005 . All rights reserved.
//


#import <Cocoa/Cocoa.h>
#import "MWEditCanvasView.h"
#include <MySQLGRT/MGRTValue.h>
#import <MySQLGRT/myx_grt_public_interface.h>
#import <MySQLGRT/MGRTShell.h>
#import <MySQLGRT/MGRT.h>
#import <MySQLGRT/MGRTTreeDataSource.h>

@class MTabView;
@class MWorkbench;
@class MWLayerDataSource;

class CLayer;

typedef enum {
  MWToolCursor = 0,
  MWToolPanning,
  MWToolEraser,
  MWToolTable,
  MWToolView,
  MWToolRoutine,
  MWToolRelationship1,
  MWToolRelationship2,
  MWToolRelationship3,
  MWToolImage,
  MWToolNote,
  MWToolLayer
} MWToolType;


@interface MWDocument : NSDocument
{
  IBOutlet NSWindow *modelWindow;
  IBOutlet NSView *paletteView;
  IBOutlet NSSplitView *splitView;
  IBOutlet MTabView *tabView;
  IBOutlet MTabView *btabView;
  IBOutlet NSDrawer *drawer;
  IBOutlet NSView *scrollTools;
  IBOutlet NSOutlineView *schemaTree;
  IBOutlet NSOutlineView *layerTree;
  IBOutlet NSPopUpButton *zoomPop;
  IBOutlet NSTextField *statusText;
  IBOutlet NSTextField *extraStatusText;
  
  IBOutlet NSTabView *upperSideTab;
  IBOutlet NSTabView *lowerSideTab;
  
  IBOutlet NSView *layerOptions;
  IBOutlet NSView *tableOptions;
  IBOutlet NSView *cursorOptions;
  IBOutlet NSView *noteOptions;
  IBOutlet NSView *imageOptions;
  IBOutlet NSView *viewOptions;
  IBOutlet NSView *routineOptions;
  IBOutlet NSView *relationshipOptions;
  
  IBOutlet NSView *basePropsView;
  IBOutlet NSTextView *basePropsText;
  IBOutlet NSView *relPropsView;
  IBOutlet NSTextView *relPropsText;

  IBOutlet NSTextField *pluginSearch;
  IBOutlet NSTableView *pluginList;
  IBOutlet NSTextView *pluginOutput;
  
  IBOutlet MGRTTreeDataSource *catalogDS;
  
  NSMenu *_pluginsPopup;
  NSEvent *_lastClickEvent;
  
  MCanvasScrollView *_scrollView;
  MWEditCanvasView *_canvas;

  MGRT *_grt;
  MGRTShell *_grtShell;
  
  NSArray *_toolCursors;
  NSView *_currentOptionsView;

  MWLayerDataSource *_layerDS;
  
  CLayer *_mainLayer;
  
  NSImage *_layerIcon;
  NSImage *_tableIcon;
  NSImage *_viewIcon;
  NSImage *_routinesIcon;
  
  id _currentWindow;
  
  int _tableIndex;
  int _viewIndex;
  int _routineIndex;
  int _layerIndex;
  
  NSMutableDictionary *_openEditors;
  
  NSMutableArray *_pluginArray;

  MYX_GRT_VALUE *_loadedDocumentData;
  
  MYX_GRT_VALUE *_relationshipContext;
  
  NSGRTValue *_objectForPlugin;
  
  MGRTValue *_currentElement;
  MGRTValue *_currentObject;
  
  MWToolType _currentTool;
  
  BOOL _postedIdle;
  
  BOOL _requestingInput;
}

- (IBAction)createSchema:(id)sender;

- (IBAction)toggleOverview:(id)sender;
- (IBAction)alignObjects:(id)sender;
- (IBAction)toggleGrid:(id)sender;
- (IBAction)toggleTool:(id)sender;
- (IBAction)changeZoom:(id)sender;
- (IBAction)pickImageFile:(id)sender;
- (IBAction)reverseEngineer:(id)sender;
- (IBAction)arrangeObjects:(id)sender;
- (IBAction)changedProperty:(id)sender;
- (IBAction)searchPlugins:(id)sender;

- (void)updateToolOptions;

- (void)pluginTextOut:(NSString*)text;

- (void)displayObjectProperties:(MGRTValue)object
                        element:(MGRTValue)element;

- (void)menu:(NSMenu*)menu needsUpdate:(MWorkbench*)sender;
- (NSArray*)selectedObjectTypes;
- (BOOL)plugin:(MGRTValue)plugin matchesSelection:(NSArray*)selection;

@end
