/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stmstate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:40:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ADC_STMSTATE_HXX
#define ADC_STMSTATE_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
class StmArrayStatus;
class StmBoundsStatus;

/**	A StmStatus is a state within a StateMachine.
	There are two kinds of it.  Either its an array of pointers to
	other states within the state machine - an ArrayStatus.

	Or it is a BoundsStatus, which shows, the token cannot be
	followed further within the StateMachine.
**/
class StmStatus	// := "State machine status"
{
  public:
	typedef intt		Branch;			/// Values >= 0 give a next #Status' ID.
										/// Values <= 0 tell, that a token is finished.
										/// a value < 0 returns the status back to an upper level state machine.
		// LIFECYCLE
	virtual 			~StmStatus() {}

		// OPERATIONS
	virtual StmArrayStatus *
						AsArray();
	virtual StmBoundsStatus *
						AsBounds();

		// INQUIRY
	virtual bool		IsADefault() const = 0;
};



#endif


