/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: delayload.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/10/15 12:51:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2007 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SAL_SYSTOOLS_WIN32_DELAYLOAD_DELAYLOAD_HXX
#define INCLUDED_SAL_SYSTOOLS_WIN32_DELAYLOAD_DELAYLOAD_HXX

#include "sal/config.h"

#include <cstddef>

#define WIN32_LEAN_AND_MEAN
#pragma warning(push, 1)
#include <windows.h>
#pragma warning(pop)

// Internal API to access certain file paths.
//
// Only available on Windows, where it is used by both delay load hooks and
// application loaders.  (In principle, it should be factored out of
// delayload.obj, but since that is linked into every executable and DLL,
// anyway, it is left in there for convenience.)
//
// TODO:  This functionality may fail as it handles file names through Windows
// (ANSI) code page functionality instead of Unicode functionality.
//
// TODO:  All this functionality (including the delay loading itself) does not
// really belong in sal but rather someplace outside the URE (no exectuable or
// library in URE needs to delay load URE libraries).

namespace delayload {

// Get the ANSI path of a module, with a final backslash.
//
// @param path
// An output parameter taking the resulting path; must point at a valid range of
// memory of size at least MAX_PATH.  If NULL is returned, the content is
// unspecified.
//
// @param module
// A valid module handle, or NULL to get the path of the executable.
//
// @return
// A pointer to the terminating null character of path, or NULL if a failure
// occurred.
char * getModulePath(char * path, HMODULE module);

// Get the path to the URE bin directory, via the ure-link file, with a final
// backslash.
//
// @param path
// An output parameter taking the resulting path; must point at a valid range of
// memory of size at least MAX_PATH.  If NULL is returned, the content is
// unspecified.
//
// @param programPath, programPathEnd
// A pair of pointers so that [programPath .. programPathEnd) is a valid range
// of at most MAX_PATH size that denotes the program directory with a final
// backslash.
//
// @return
// A pointer to the terminating null character of path, or NULL if a failure
// occurred.
char * getUreBinPath(
    char * path, char const * programPath, char const * programPathEnd);

}

#endif
