/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unoutl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 21:52:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"



#include "doc.hxx"
#include "swundo.hxx"			// fuer die UndoIds
#include "pam.hxx"
#include "ndtxt.hxx"

#include "undobj.hxx"


inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }

SwUndoOutlineLeftRight::SwUndoOutlineLeftRight( const SwPaM& rPam,
												short nOff )
	: SwUndo( UNDO_OUTLINE_LR ), SwUndRng( rPam ), nOffset( nOff )
{
}


void SwUndoOutlineLeftRight::Undo( SwUndoIter& rUndoIter )
{
	SetPaM( rUndoIter );
	rUndoIter.GetDoc().OutlineUpDown( *rUndoIter.pAktPam, -nOffset );
}


void SwUndoOutlineLeftRight::Redo( SwUndoIter& rUndoIter )
{
	SetPaM( rUndoIter );
	rUndoIter.GetDoc().OutlineUpDown( *rUndoIter.pAktPam, nOffset );
}


void SwUndoOutlineLeftRight::Repeat( SwUndoIter& rUndoIter )
{
	rUndoIter.GetDoc().OutlineUpDown( *rUndoIter.pAktPam, nOffset );
}



