/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: filnot.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:26:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FILNOT_HXX_
#define _FILNOT_HXX_

#include <hash_map>
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIER_HPP_
#include <com/sun/star/ucb/XContentIdentifier.hpp>
#endif
#ifndef _FILGLOB_HXX_
#include "filglob.hxx"
#endif


namespace fileaccess {
	
	class shell;
	class BaseContent;
	
	class ContentEventNotifier
	{
	private:
		shell* m_pMyShell;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContent >	m_xCreatorContent;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > m_xCreatorId;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > m_xOldId;
		com::sun::star::uno::Sequence< com::sun::star::uno::Reference< com::sun::star::uno::XInterface > > m_sListeners;
	public:
		
		ContentEventNotifier( 
			shell* pMyShell,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& xCreatorContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& xCreatorId,
			const com::sun::star::uno::Sequence<
			com::sun::star::uno::Reference< com::sun::star::uno::XInterface > >& sListeners );
		
		ContentEventNotifier(
			shell* pMyShell,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& xCreatorContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& xCreatorId,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& xOldId,
			const com::sun::star::uno::Sequence<
			com::sun::star::uno::Reference< com::sun::star::uno::XInterface > >& sListeners );
		
		void notifyChildInserted( const rtl::OUString& aChildName );
		void notifyDeleted( void );
		void notifyRemoved( const rtl::OUString& aChildName );
		void notifyExchanged( );
	};
	
	
	class PropertySetInfoChangeNotifier
	{
	private:
		shell* m_pMyShell;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContent >	m_xCreatorContent;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > m_xCreatorId;
		com::sun::star::uno::Sequence< com::sun::star::uno::Reference< com::sun::star::uno::XInterface > > m_sListeners;
	public:
		PropertySetInfoChangeNotifier(
			shell* pMyShell,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& xCreatorContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& xCreatorId,
			const com::sun::star::uno::Sequence<
			com::sun::star::uno::Reference< com::sun::star::uno::XInterface > >& sListeners );

		void SAL_CALL notifyPropertyAdded( const rtl::OUString & aPropertyName );
		void SAL_CALL notifyPropertyRemoved( const rtl::OUString & aPropertyName );
	};

	
	typedef std::hash_map< rtl::OUString,
						   com::sun::star::uno::Sequence< com::sun::star::uno::Reference< com::sun::star::uno::XInterface > >,
		                   hashOUString,
		                   equalOUString >      ListenerMap;
	
	class PropertyChangeNotifier
	{
	private:
		shell* m_pMyShell;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContent >	m_xCreatorContent;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > m_xCreatorId;
		ListenerMap* m_pListeners;
	public:
		PropertyChangeNotifier(
			shell* pMyShell,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& xCreatorContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& xCreatorId,
			ListenerMap* pListeners );
		
		~PropertyChangeNotifier();

		void notifyPropertyChanged( 
			com::sun::star::uno::Sequence< com::sun::star::beans::PropertyChangeEvent > seqChanged );
	};

	
	class Notifier
	{
	public:
		// Side effect of this function is the change of the name
		virtual ContentEventNotifier*          cEXC( const rtl::OUString aNewName ) = 0;
		// Side effect is the change of the state of the object to "deleted".
		virtual ContentEventNotifier*          cDEL( void ) = 0;
	    virtual ContentEventNotifier*          cCEL( void ) = 0;
		virtual PropertySetInfoChangeNotifier* cPSL( void ) = 0;
		virtual PropertyChangeNotifier*        cPCL( void ) = 0;
		virtual rtl::OUString                  getKey( void ) = 0;
	};
	
	
}   // end namespace fileaccess

#endif
