/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: provconf.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: ihi $ $Date: 2007/06/05 14:55:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_ucbhelper.hxx"

/**************************************************************************
								TODO
 **************************************************************************

  *************************************************************************/

#ifndef _UCBHELPER_PROVCONF_HXX_
#include <provconf.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

using namespace com::sun::star;

//=========================================================================

#define CONFIG_CONTENTPROVIDERS_KEY	\
				"/org.openoffice.ucb.Configuration/ContentProviders"

//=========================================================================

namespace ucbhelper {

void makeAndAppendXMLName(
                rtl::OUStringBuffer & rBuffer, const rtl::OUString & rIn )
{
    sal_Int32 nCount = rIn.getLength();
    for ( sal_Int32 n = 0; n < nCount; ++n )
    {
        const sal_Unicode c = rIn.getStr()[ n ];
        switch ( c )
        {
            case '&':
                rBuffer.appendAscii( "&amp;" );
                break;

            case '"':
                rBuffer.appendAscii( "&quot;" );
                break;

            case '\'':
                rBuffer.appendAscii( "&apos;" );
                break;

            case '<':
                rBuffer.appendAscii( "&lt;" );
                break;

            case '>':
                rBuffer.appendAscii( "&gt;" );
                break;

            default:
                rBuffer.append( c );
                break;
        }
    }
}

//=========================================================================
bool getContentProviderData(
			const uno::Reference< lang::XMultiServiceFactory > & rServiceMgr,
            const rtl::OUString & rKey1,
            const rtl::OUString & rKey2,
			ContentProviderDataList & rListToFill )
{
	if ( !rServiceMgr.is() || !rKey1.getLength() || !rKey2.getLength() )
	{
		OSL_ENSURE( false,
					"getContentProviderData - Invalid argument!" );
		return false;
	}

	try
	{
		uno::Reference< lang::XMultiServiceFactory > xConfigProv(
				rServiceMgr->createInstance(
                    rtl::OUString::createFromAscii(
						"com.sun.star.configuration.ConfigurationProvider" ) ),
				uno::UNO_QUERY );

        if ( !xConfigProv.is() )
		{
			OSL_ENSURE( false,
                        "getContentProviderData - No config provider!" );
			return false;
		}

        rtl::OUStringBuffer aFullPath;
        aFullPath.appendAscii( CONFIG_CONTENTPROVIDERS_KEY "/['" );
        makeAndAppendXMLName( aFullPath, rKey1 );
        aFullPath.appendAscii( "']/SecondaryKeys/['" );
        makeAndAppendXMLName( aFullPath, rKey2 );
        aFullPath.appendAscii( "']/ProviderData" );

        uno::Sequence< uno::Any > aArguments( 1 );
        beans::PropertyValue      aProperty;
        aProperty.Name
            = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "nodepath" ) );
        aProperty.Value <<= aFullPath.makeStringAndClear();
        aArguments[ 0 ] <<= aProperty;

		uno::Reference< uno::XInterface > xInterface(
				xConfigProv->createInstanceWithArguments(
                    rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                        "com.sun.star.configuration.ConfigurationAccess" ) ),
					aArguments ) );

		if ( !xInterface.is() )
		{
			OSL_ENSURE( false,
						"getContentProviderData - No config access!" );
			return false;
		}

		uno::Reference< container::XNameAccess > xNameAccess(
											xInterface, uno::UNO_QUERY );

		if ( !xNameAccess.is() )
		{
			OSL_ENSURE( false,
						"getContentProviderData - No XNameAccess!" );
			return false;
		}

        uno::Sequence< rtl::OUString > aElems = xNameAccess->getElementNames();
        const rtl::OUString* pElems = aElems.getConstArray();
		sal_Int32 nCount = aElems.getLength();

		if ( nCount > 0 )
		{
			uno::Reference< container::XHierarchicalNameAccess >
								xHierNameAccess( xInterface, uno::UNO_QUERY );

			if ( !xHierNameAccess.is() )
			{
				OSL_ENSURE( false,
							"getContentProviderData - "
							"No XHierarchicalNameAccess!" );
				return false;
			}

			// Iterate over children.
			for ( sal_Int32 n = 0; n < nCount; ++n )
			{
                rtl::OUStringBuffer aElemBuffer;
                aElemBuffer.appendAscii( "['" );
                makeAndAppendXMLName( aElemBuffer, pElems[ n ] );

				try
				{
					ContentProviderData aInfo;

					// Obtain service name.
                    rtl::OUStringBuffer aKeyBuffer = aElemBuffer;
                    aKeyBuffer.appendAscii( "']/ServiceName" );

                    rtl::OUString aValue;
                    if ( !( xHierNameAccess->getByHierarchicalName(
                                aKeyBuffer.makeStringAndClear() ) >>= aValue ) )
					{
						OSL_ENSURE( false,
									"getContentProviderData - "
									"Error getting item value!" );
						continue;
					}

					aInfo.ServiceName = aValue;

					// Obtain URL Template.
                    aKeyBuffer = aElemBuffer;
                    aKeyBuffer.appendAscii( "']/URLTemplate" );

                    if ( !( xHierNameAccess->getByHierarchicalName(
                                aKeyBuffer.makeStringAndClear() ) >>= aValue ) )
					{
						OSL_ENSURE( false,
									"getContentProviderData - "
									"Error getting item value!" );
						continue;
					}

					aInfo.URLTemplate = aValue;

					// Obtain Arguments.
                    aKeyBuffer = aElemBuffer;
                    aKeyBuffer.appendAscii( "']/Arguments" );

                    if ( !( xHierNameAccess->getByHierarchicalName(
                                aKeyBuffer.makeStringAndClear() ) >>= aValue ) )
					{
						OSL_ENSURE( false,
									"getContentProviderData - "
									"Error getting item value!" );
						continue;
					}

					aInfo.Arguments = aValue;

					// Append info to list.
					rListToFill.push_back( aInfo );
				}
				catch ( container::NoSuchElementException& )
				{
					// getByHierarchicalName

					OSL_ENSURE( false,
								"getContentProviderData - "
								"caught NoSuchElementException!" );
				}
			}
		}
	}
	catch ( uno::RuntimeException& )
	{
		OSL_ENSURE( false,
					"getContentProviderData - caught RuntimeException!" );
		return false;
	}
	catch ( uno::Exception& )
	{
		// createInstance, createInstanceWithArguments

		OSL_ENSURE( false,
					"getContentProviderData - caught Exception!" );
		return false;
	}

	return true;
}

}
