/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salsound.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2007/09/25 10:04:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALSOUND_HXX
#define _SV_SALSOUND_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif
#ifndef _SV_SALSTYPE_HXX
#include <salstype.hxx>
#endif
#ifndef _SV_SALSOUND_HXX
#include <salsound.hxx>
#endif

// ------------
// - SalSound -
// ------------

class SalSound
{
private:
						
	static HMODULE		mhMCILib;
	static ULONG		mnSoundState;
	static void*		mpMCIFnc;
	SALSOUNDPROC		mpProc;
	void*				mpInst;
	ULONG				mnStartTime;
	ULONG				mnPlayLen;
	HWND				mhSoundWnd;
    USHORT				mnDeviceId;
	BOOL				mbLoop;
	BOOL				mbPaused;

public:

    void                ImplSetError( ULONG nMciErr );
	void				ImplNotify( SoundNotification eNotification, ULONG nError );

public:					
						
						SalSound();
						~SalSound();

	BOOL				Create();
	static void			Release();
	static BOOL			IsValid() { return( SOUND_STATE_VALID == SalSound::mnSoundState ); } 

	BOOL				Init( SalFrame* pFrame, const String& rSoundName, ULONG& rSoundLen );
	BOOL				Init( SalFrame* pFrame, const BYTE* pSound, ULONG nDataLen, ULONG& rSoundLen );
	void				Play( ULONG nStartTime, ULONG nPlayTime, BOOL bLoop );
	void				Stop();
	void				Pause();

	void				SetNotifyProc( void* pInst, SALSOUNDPROC pProc ) 
							{ mpInst = pInst; mpProc = pProc; }
};

#endif // _SV_SALSOUND_HXX
