/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ContentHandler.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* Copyright 2006 SUN Microsystems, Inc. */
#ifndef INCLUDED_CONTENTHANDLER_HXX
#define INCLUDED_CONTENTHANDLER_HXX

#include <odiapi/qname/QName.hxx>
#include <WriterFilterDllApi.hxx>
#include <rtl/ustring.hxx>
#include <string>


namespace writerfilter { namespace xxml {

class WRITERFILTER_DLLPUBLIC Value
{
public:
	virtual rtl::OUString getOUString() const = 0;
	virtual rtl::OString getOString() const = 0;
	virtual std::string getString() const = 0;
	virtual QName_t getQName() const = 0;
};

class WRITERFILTER_DLLPUBLIC ContentHandler
{
public:
	virtual void startDocument() = 0;
	virtual void endDocument() = 0;
	virtual void startElement(QName_t name, QName_t attrName[], const Value *attrValue[], int attrs) = 0;
	virtual void endElement(QName_t name) = 0;
	virtual void characters(const Value &value) = 0;

	virtual void startStream(QName_t stream) = 0;
	virtual void endStream(QName_t stream) = 0;

	virtual void startReading(size_t totalBytes) = 0;
	virtual void continueReading(size_t bytes) = 0;
	virtual void endReading() = 0;
};

} } /* writerfilter.xxml */

#endif /* INCLUDED_CONTENTHANDLER_HXX */
