/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdbcoretools.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 06:42:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#ifndef DBACORE_SDBCORETOOLS_HXX
#include "sdbcoretools.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_ 
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_ 
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XDOCUMENTDATASOURCE_HPP_
#include <com/sun/star/sdb/XDocumentDataSource.hpp>
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif

//.........................................................................
namespace dbaccess
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::util;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::container;

    // =========================================================================
    // -------------------------------------------------------------------------
    void notifyDataSourceModified(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _rxObject,sal_Bool _bModified)
    {
        Reference< XInterface > xDs = getDataSource( _rxObject );
		Reference<XDocumentDataSource> xDocumentDataSource(xDs,UNO_QUERY);
		if ( xDocumentDataSource.is() )
            xDs = xDocumentDataSource->getDatabaseDocument();
        Reference< XModifiable > xModi( xDs, UNO_QUERY );
		if ( xModi.is() )
			xModi->setModified(_bModified);
    }

    // -------------------------------------------------------------------------
    Reference< XInterface > getDataSource( const Reference< XInterface >& _rxDependentObject )
    {
	    Reference< XInterface > xParent = _rxDependentObject;
	    Reference< XInterface > xReturn;
	    while( xParent.is() )
	    {
		    xReturn = xParent;
		    Reference<XChild> xChild(xParent,UNO_QUERY);
		    xParent.set(xChild.is() ? xChild->getParent() : Reference< XInterface >(),UNO_QUERY);
	    }
        return xReturn;
    }

    // -------------------------------------------------------------------------
    bool getDataSourceSetting( const Reference< XInterface >& _rxDataSource, const sal_Char* _pAsciiSettingsName,
        Any& /* [out] */ _rSettingsValue )
    {
        bool bIsPresent = false;
        try
        {
            Reference< XPropertySet > xDataSource( _rxDataSource, UNO_QUERY );
            OSL_ENSURE( xDataSource.is(), "getDataSourceSetting: invalid data source object!" );
            if ( !xDataSource.is() )
                return false;

            Sequence< PropertyValue > aSettings;
            OSL_VERIFY( xDataSource->getPropertyValue( PROPERTY_INFO ) >>= aSettings );
            const PropertyValue* pSetting = aSettings.getConstArray();
            const PropertyValue* pSettingEnd = aSettings.getConstArray() + aSettings.getLength();
            for ( ; pSetting != pSettingEnd; ++pSetting )
            {
                if ( pSetting->Name.equalsAscii( _pAsciiSettingsName ) )
                {
                    _rSettingsValue = pSetting->Value;
                    bIsPresent = true;
                    break;
                }
            }
        }
        catch( const Exception& )
        {
    	    OSL_ENSURE( sal_False, "getDataSourceSetting: caught an exception!" );
        }
        return bIsPresent;
    }

// -----------------------------------------------------------------------------
//.........................................................................
}	// namespace dbaccess
//.........................................................................

