/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Adler32.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 17:25:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_package.hxx"
#ifndef _ADLER32_HXX
#include <Adler32.hxx>
#endif
#ifndef _ZLIB_H
#ifdef SYSTEM_ZLIB
#include <zlib.h>
#else
#include <external/zlib/zlib.h>
#endif
#endif

/**
 * A class that can be used to compute the Adler-32 checksum of a data
 * stream. An Adler-32 checksum is almost as reliable as a CRC-32 but
 * can be computed much faster.
 *
 */

using namespace rtl;
using namespace com::sun::star;

Adler32::Adler32() : nAdler(1) 
{ 
}

Adler32::~Adler32()
{
}
/** Updates checksum with specified byte
 */
void SAL_CALL Adler32::updateByte (sal_Int8 nByte)
{
	sal_uInt8 pBuf[1];
	pBuf[0] = (sal_uInt8)nByte;
	nAdler  = adler32(nAdler, pBuf, 1);
}
/** Updates checksum with specified sequence of bytes
 */
void SAL_CALL Adler32::updateSegment(const uno::Sequence< sal_Int8 > &b, 
									 sal_Int32 off, 
									 sal_Int32 len)
{
	nAdler = adler32(nAdler, (const unsigned char*)b.getConstArray()+off, len );
}
/** Updates checksum with specified sequence of bytes
 */
void SAL_CALL Adler32::update(const uno::Sequence< sal_Int8 > &b)
{
	nAdler = adler32(nAdler, (const unsigned char*)b.getConstArray(),b.getLength());
}
/** Returns checksum value.
 */
sal_Int32 SAL_CALL Adler32::getValue()
{
	return (sal_Int32) nAdler & 0xFFFFFFFFL;
}
/** Resets checksum to initial value.
 */
void SAL_CALL Adler32::reset()
{
	nAdler = 1;
}
