/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdpopup.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: kz $ $Date: 2007/05/10 15:25:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"


#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif

#include <svx/editeng.hxx>
#include <svx/flditem.hxx>
#ifndef _ZFORLIST_HXX
#include <svtools/zforlist.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <sfx2/objsh.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif

#include "strings.hrc"
#include "sdpopup.hxx"
#include "sdresid.hxx"
#include "sdmod.hxx"
#include "drawdoc.hxx"
#ifndef SD_DRAW_DOC_SHELL_HXX
#include "DrawDocShell.hxx"
#endif

/*************************************************************************
|*
|* PopupMenu zum Bearbeiten von Feldbefehlen
|*
\************************************************************************/

SdFieldPopup::SdFieldPopup( const SvxFieldData* pInField, LanguageType eLanguage ) :
		PopupMenu	(),
		pField		( pInField )
{
	Fill( eLanguage );
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SdFieldPopup::~SdFieldPopup()
{
}

/*************************************************************************
|*
|* Fill
|*
\************************************************************************/

void SdFieldPopup::Fill( LanguageType eLanguage )
{
	USHORT nID = 1;
	USHORT nStyle = MIB_RADIOCHECK | MIB_AUTOCHECK;
	InsertItem( nID++, String( SdResId( STR_FIX ) ), nStyle );
	InsertItem( nID++, String( SdResId( STR_VAR ) ), nStyle );
	InsertSeparator();

	if( pField->ISA( SvxDateField ) )
	{
		const SvxDateField* pDateField = (const SvxDateField*) pField;
		SvxDateField aDateField( *pDateField );

		if( pDateField->GetType() == SVXDATETYPE_FIX )
			CheckItem( 1 );
		else
			CheckItem( 2 );

		//SVXDATEFORMAT_APPDEFAULT, 	// Wird nicht benutzt
		//SVXDATEFORMAT_SYSTEM, 		// Wird nicht benutzt
		InsertItem( nID++, String( SdResId( STR_STANDARD_SMALL ) ), nStyle );
		InsertItem( nID++, String( SdResId( STR_STANDARD_BIG ) ), nStyle );

		SvNumberFormatter* pNumberFormatter = SD_MOD()->GetNumberFormatter();
		aDateField.SetFormat( SVXDATEFORMAT_A );	// 13.02.96
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aDateField.SetFormat( SVXDATEFORMAT_B );	// 13.02.1996
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aDateField.SetFormat( SVXDATEFORMAT_C );	// 13.Feb 1996
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );

		aDateField.SetFormat( SVXDATEFORMAT_D );	// 13.Februar 1996
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aDateField.SetFormat( SVXDATEFORMAT_E );	// Die, 13.Februar 1996
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aDateField.SetFormat( SVXDATEFORMAT_F );	// Dienstag, 13.Februar 1996
		InsertItem( nID++, aDateField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );

		CheckItem( (USHORT) ( pDateField->GetFormat() ) + 1 ); // - 2 + 3 !
	}
	else if( pField->ISA( SvxExtTimeField ) )
	{
		const SvxExtTimeField* pTimeField = (const SvxExtTimeField*) pField;
		SvxExtTimeField aTimeField( *pTimeField );

		if( pTimeField->GetType() == SVXTIMETYPE_FIX )
			CheckItem( 1 );
		else
			CheckItem( 2 );

		//SVXTIMEFORMAT_APPDEFAULT, 	// Wird nicht benutzt
		//SVXTIMEFORMAT_SYSTEM, 		// Wird nicht benutzt
		InsertItem( nID++, String( SdResId( STR_STANDARD_NORMAL ) ), nStyle );

		SvNumberFormatter* pNumberFormatter = SD_MOD()->GetNumberFormatter();
		aTimeField.SetFormat( SVXTIMEFORMAT_24_HM );	// 13:49
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aTimeField.SetFormat( SVXTIMEFORMAT_24_HMS );	// 13:49:38
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aTimeField.SetFormat( SVXTIMEFORMAT_24_HMSH );	// 13:49:38.78
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );

		aTimeField.SetFormat( SVXTIMEFORMAT_12_HM );	// 01:49
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aTimeField.SetFormat( SVXTIMEFORMAT_12_HMS );	// 01:49:38
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		aTimeField.SetFormat( SVXTIMEFORMAT_12_HMSH );	// 01:49:38.78
		InsertItem( nID++, aTimeField.GetFormatted( *pNumberFormatter, eLanguage ), nStyle );
		//SVXTIMEFORMAT_AM_HM,	// 01:49 PM
		//SVXTIMEFORMAT_AM_HMS,	// 01:49:38 PM
		//SVXTIMEFORMAT_AM_HMSH	// 01:49:38.78 PM

		CheckItem( (USHORT) ( pTimeField->GetFormat() ) + 1 ); // - 2 + 3 !
	}
	else if( pField->ISA( SvxExtFileField ) )
	{
		const SvxExtFileField* pFileField = (const SvxExtFileField*) pField;
		//SvxExtFileField aFileField( *pFileField );

		if( pFileField->GetType() == SVXFILETYPE_FIX )
			CheckItem( 1 );
		else
			CheckItem( 2 );

		InsertItem( nID++, String( SdResId( STR_FILEFORMAT_NAME_EXT ) ), nStyle );
		InsertItem( nID++, String( SdResId( STR_FILEFORMAT_FULLPATH ) ), nStyle );
		InsertItem( nID++, String( SdResId( STR_FILEFORMAT_PATH ) ), nStyle );
		InsertItem( nID++, String( SdResId( STR_FILEFORMAT_NAME ) ), nStyle );

		CheckItem( (USHORT) ( pFileField->GetFormat() ) + 3 );
	}
	else if( pField->ISA( SvxAuthorField ) )
	{
		const SvxAuthorField* pAuthorField = (const SvxAuthorField*) pField;
		SvxAuthorField aAuthorField( *pAuthorField );

		if( pAuthorField->GetType() == SVXAUTHORTYPE_FIX )
			CheckItem( 1 );
		else
			CheckItem( 2 );

		for( USHORT i = 0; i < 4; i++ )
		{
			aAuthorField.SetFormat( (SvxAuthorFormat) i );
			InsertItem( nID++, aAuthorField.GetFormatted(), nStyle );
		}
		CheckItem( (USHORT) ( pAuthorField->GetFormat() ) + 3 );
	}
}

/*************************************************************************
|*
|* Gibt das neue Feld zurueck, gehoert dem Caller.
|* Liefert NULL, wenn sich nichts geaendert hat.
|*
\************************************************************************/

SvxFieldData* SdFieldPopup::GetField()
{
	SvxFieldData* pNewField = NULL;
	USHORT nCount = GetItemCount();

	if( pField->ISA( SvxDateField ) )
	{
		const SvxDateField* pDateField = (const SvxDateField*) pField;
		SvxDateType	  eType;
		SvxDateFormat eFormat;
		USHORT i;

		if( IsItemChecked( 1 ) )
			eType = SVXDATETYPE_FIX;
		else
			eType = SVXDATETYPE_VAR;

		for( i = 3; i <= nCount; i++ )
		{
			if( IsItemChecked( i ) )
				break;
		}
		eFormat = (SvxDateFormat) ( i - 1 );

		if( pDateField->GetFormat() != eFormat ||
			pDateField->GetType() != eType )
		{
			pNewField = new SvxDateField( *pDateField );
			( (SvxDateField*) pNewField )->SetType( eType );
			( (SvxDateField*) pNewField )->SetFormat( eFormat );

			if( (pDateField->GetType() == SVXDATETYPE_VAR) && (eType == SVXDATETYPE_FIX) )
			{
				Date aDate;
				( (SvxDateField*) pNewField )->SetFixDate( aDate );
			}
		}
	}
	else if( pField->ISA( SvxExtTimeField ) )
	{
		const SvxExtTimeField* pTimeField = (const SvxExtTimeField*) pField;
		SvxTimeType	  eType;
		SvxTimeFormat eFormat;
		USHORT i;

		if( IsItemChecked( 1 ) )
			eType = SVXTIMETYPE_FIX;
		else
			eType = SVXTIMETYPE_VAR;

		for( i = 3; i <= nCount; i++ )
		{
			if( IsItemChecked( i ) )
				break;
		}
		eFormat = (SvxTimeFormat) ( i - 1 );

		if( pTimeField->GetFormat() != eFormat ||
			pTimeField->GetType() != eType )
		{
			pNewField = new SvxExtTimeField( *pTimeField );
			( (SvxExtTimeField*) pNewField )->SetType( eType );
			( (SvxExtTimeField*) pNewField )->SetFormat( eFormat );

			if( (pTimeField->GetType() == SVXTIMETYPE_VAR) && (eType == SVXTIMETYPE_FIX) )
			{
				Time aTime;
				( (SvxExtTimeField*) pNewField )->SetFixTime( aTime );
			}

		}
	}
	else if( pField->ISA( SvxExtFileField ) )
	{
		const SvxExtFileField* pFileField = (const SvxExtFileField*) pField;
		SvxFileType	  eType;
		SvxFileFormat eFormat;
		USHORT i;

		if( IsItemChecked( 1 ) )
			eType = SVXFILETYPE_FIX;
		else
			eType = SVXFILETYPE_VAR;

		for( i = 3; i <= nCount; i++ )
		{
			if( IsItemChecked( i ) )
				break;
		}
		eFormat = (SvxFileFormat) ( i - 3 );

		if( pFileField->GetFormat() != eFormat ||
			pFileField->GetType() != eType )
		{
			::sd::DrawDocShell* pDocSh = PTR_CAST(::sd::DrawDocShell,
                SfxObjectShell::Current() );

			if( pDocSh )
			{
				SvxExtFileField aFileField( *pFileField );
				
				String aName;
				if( pDocSh->HasName() )
					aName = pDocSh->GetMedium()->GetName();

				// #91225# Get current filename, not the one stored in the old field
				pNewField = new SvxExtFileField( aName );
				( (SvxExtFileField*) pNewField )->SetType( eType );
				( (SvxExtFileField*) pNewField )->SetFormat( eFormat );
			}
		}
	}
	else if( pField->ISA( SvxAuthorField ) )
	{
		const SvxAuthorField* pAuthorField = (const SvxAuthorField*) pField;
		SvxAuthorType	eType;
		SvxAuthorFormat eFormat;
		USHORT i;

		if( IsItemChecked( 1 ) )
			eType = SVXAUTHORTYPE_FIX;
		else
			eType = SVXAUTHORTYPE_VAR;

		for( i = 3; i <= nCount; i++ )
		{
			if( IsItemChecked( i ) )
				break;
		}
		eFormat = (SvxAuthorFormat) ( i - 3 );

		if( pAuthorField->GetFormat() != eFormat ||
			pAuthorField->GetType() != eType )
		{
			// #91225# Get current state of address, not the old one
            SvtUserOptions aUserOptions;
            pNewField = new SvxAuthorField( aUserOptions.GetFirstName(), aUserOptions.GetLastName(), aUserOptions.GetID() );
			( (SvxAuthorField*) pNewField )->SetType( eType );
			( (SvxAuthorField*) pNewField )->SetFormat( eFormat );
		}
	}
	return( pNewField );
}


