/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: impanmvw.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 20:15:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_IMPANMVW_HXX
#define _SV_IMPANMVW_HXX

#include <vcl/animate.hxx>

// ----------------
// - ImplAnimView -
// ----------------

class Animation;
class OutputDevice;
class VirtualDevice;
struct AnimationBitmap;

class ImplAnimView
{
private:

	Animation*		mpParent;
	OutputDevice*	mpOut;
	long			mnExtraData;
	Point			maPt;
	Point			maDispPt;
	Point			maRestPt;
	Size			maSz;
	Size			maSzPix;
	Size			maDispSz;
	Size			maRestSz;
	MapMode			maMap;
	Region			maClip;
	VirtualDevice*	mpBackground;
	VirtualDevice*	mpRestore;
	ULONG			mnActPos;
	Disposal		meLastDisposal;
	BOOL			mbPause;
	BOOL			mbFirst;
	BOOL			mbMarked;
	BOOL			mbHMirr;
	BOOL			mbVMirr;

	void			ImplGetPosSize( const AnimationBitmap& rAnm, Point& rPosPix, Size& rSizePix );
	void			ImplDraw( ULONG nPos, VirtualDevice* pVDev );

public:

					ImplAnimView( Animation* pParent, OutputDevice* pOut,
								  const Point& rPt, const Size& rSz, ULONG nExtraData,
								  OutputDevice* pFirstFrameOutDev = NULL );
					~ImplAnimView();

	BOOL			ImplMatches( OutputDevice* pOut, long nExtraData ) const;
	void			ImplDrawToPos( ULONG nPos );
	void			ImplDraw( ULONG nPos );
	void			ImplRepaint();
	AInfo*			ImplCreateAInfo() const;

	const Point&	ImplGetOutPos() const { return maPt; }

	const Size&		ImplGetOutSize() const { return maSz; }
	const Size&		ImplGetOutSizePix() const { return maSzPix; }

	void			ImplPause( BOOL bPause ) { mbPause = bPause; }
	BOOL			ImplIsPause() const { return mbPause; }

	void			ImplSetMarked( BOOL bMarked ) { mbMarked = bMarked; }
	BOOL			ImplIsMarked() const { return mbMarked; }
};

#endif
