/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: XMLTextListItemContext.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLTEXTLISTITEMCONTEXT_HXX
#define _XMLTEXTLISTITEMCONTEXT_HXX

#ifndef _XMLOFF_XMLICTXT_HXX 
#include "xmlictxt.hxx"
#endif
namespace binfilter {

class XMLTextImportHelper;

class XMLTextListItemContext : public SvXMLImportContext
{
	XMLTextImportHelper& rTxtImport;

	sal_Int16					nStartValue;

//	SwXMLImport& GetSwImport() { return (SwXMLImport&)GetImport(); }

public:

	TYPEINFO();

	XMLTextListItemContext(
			SvXMLImport& rImport,
			XMLTextImportHelper& rTxtImp, sal_uInt16 nPrfx,
			const ::rtl::OUString& rLName,
			const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList,
			sal_Bool bIsHeader = sal_False );
	virtual ~XMLTextListItemContext();

	virtual void EndElement();

	SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
				 const ::rtl::OUString& rLocalName,
				 const ::com::sun::star::uno::Reference<
				 	::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	sal_Bool HasStartValue() const { return -1 != nStartValue; }
	sal_Int16 GetStartValue() const { return nStartValue; }
};


}//end of namespace binfilter
#endif
