/* $Cambridge: hermes/src/prayer/cmd/cmd_copy.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_copy(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct folderlist *fl = folderlist_fetch(session);
    struct prefs *prefs = session->options->prefs;
    BOOL suppress_dotfiles = prefs->suppress_dotfiles;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    MAILSTREAM *stream = session->stream;
    unsigned long msgno, msgno_uid;
    unsigned long count = 1;
    struct folderitem *fi;
    char *name;

    if ((request->argc == 3) && !strcmp(request->argv[1], "toggle")) {
        name = string_canon_decode(request->argv[2]);
        fi   = folderlist_lookup(folderlist_fetch(session), name);
        if (fi) {
            if (fi->expanded) {
                session_message(session, "Collapsed \"%s\"", name);
                fi->expanded = NIL;
            } else {
                folderlist_expand(session, fi);
                session_message(session, "Expanded \"%s\"", name);
                fi->expanded = T;
            }
        }
    } else if ((request->argc > 1) && !strcmp(request->argv[1], "aggregate")) {
        if (prefs->use_mark_persist)
            count = msgmap_marked_count(session->zm);
        else
            count = msgmap_tmp_marked_count(session->zm);

        if (count > 1)
            session_message(session, "Copying %lu marked messages", count);
        else if (count == 1)
            session_message(session, "Copying single marked message");
        else {
            session_message(session, "No marked messages to copy");
            session_redirect(session, request, "list");
            return;
        }

        session->aggregate = T;
    } else if (request->argc > 2) {
        msgno = atoi(request->argv[1]);
        msgno_uid = atoi(request->argv[2]);

        if (!(msgno = stream_check_uid(session, stream, msgno, msgno_uid))) {
            session_redirect(session, request, "restart");
            return;
        }

        session->current = msgno;
        session->aggregate = NIL;
        session_message(session, "Copying message %lu", msgno);
    } else if (session->aggregate)
        count = msgmap_marked_count(session->zm);
    else
        count = 1;

    folderlist_template_vals_tree(fl, suppress_dotfiles, tvals, "@folder");
    folderlist_template_vals_list(fl, suppress_dotfiles, tvals,
                                  T, "@dirlist");
    template_vals_string(tvals, "fcmd", "copy_msg");
    template_vals_string(tvals, "copy_parent_cmd", session->copy_parent_cmd);

    session_seed_template(session, tvals);
    template_expand("copy", tvals, b);
    response_html(request, 200);
}
