/* $Cambridge: hermes/src/prayer/cmd/cmd_fullname.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static void generate_form(struct session *session, char *new)
{
    struct template_vals *tvals = session->template_vals;
    struct config *config = session->config;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    struct account *account = session->account;
    char *oldname, *delay = NIL;

    oldname = account_fullname(account, request->pool);

    if (config->accountd_fullname_delay > (2 * 60 * 60))
        delay = pool_printf(tvals->pool, "%lu hours",
                            config->accountd_fullname_delay / (60 * 60));
    else if (config->accountd_fullname_delay > 120)
        delay = pool_printf(tvals->pool, "%lu minutes",
                            config->accountd_fullname_delay / 60);
    else if (config->accountd_fullname_delay > 1)
        delay = pool_printf(tvals->pool, "%lu seconds",
                            config->accountd_fullname_delay);

    if (oldname && oldname[0])
        template_vals_string(tvals, "fullname", oldname);
    else
        template_vals_string(tvals, "fullname", "(Unknown)");

    template_vals_string(tvals, "new", new);

    if (delay)
        template_vals_string(tvals, "delay", delay);

    session_seed_template(session, tvals);
    template_expand("fullname", tvals, b);
    response_html(request, 200);
}

/* ====================================================================== */

static BOOL process_form(struct session *session, char *new)
{
    struct request *request = session->request;
    struct pool *pool = request->pool;

    if (!(new && new[0])) {
        session_message(session, "New password not supplied");
        return (NIL);
    }

    if (!account_change_fullname(session->account, pool, new)) {
        char *msg = account_fetch_message(session->account);

        session_message(session, "Unable to change fullname: %s", msg);
        session_log(session,
                    "[cmd_fullname] Unable to change fullname: %s", msg);
        return (NIL);
    }

    session_message(session, "Fullname updated");
    return (T);
}

void cmd_fullname(struct session *session)
{
    struct request *request = session->request;
    char *new;

    if (request->method == POST) {
        struct assoc *h;

        request_decode_form(request);
        h = request->form;

        if (assoc_lookup(h, "sub_change")) {
            if ((new = assoc_lookup(h, "new")))
                new = string_trim_whitespace(new);

            if (!process_form(session, new)) {
                generate_form(session, new);
                return;
            }
        }

        session_redirect(session, request, "manage");
        return;
    }

    generate_form(session, NIL);
}
