# arch-tag: 1f8d8266-c869-4f7e-ad7f-4f74ac8ea47b
# Copyright (C) 2004  David Allouche <david@allouche.net>
#                     Canonical Ltd.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Command line logging
"""

import sys


class Logger(object):
    def log_command(self, cmd, args): pass
    def log_output(self, text): pass
    def log_error(self, text): pass


class DebugLogger(Logger):
    def log_command(self, cmd, args):
        print >> sys.stderr, "%% %s %s" % (cmd, ' '.join(args))
    def log_output(self, text):
        if text:
            print >> sys.stderr, ">>> output\n%s<<<" % text
    def log_error(self, text):
        if text:
            print >> sys.stderr, ">>> error\n%s<<<" % text
