# arch-tag: d47dc41c-4dc6-496b-8c77-785ede80cf0d
# Copyright (C) 2004 Canonical Ltd.
#               Author: David Allouche <david@canonical.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Framework for Twisted testing
"""

from twisted import trial
from twisted.python import threadable
threadable.init()

def run_in_thread(callable, *args, **kwargs):
    from twisted.internet import threads
    d = threads.deferToThread(callable, *args, **kwargs)
    trial.util.deferredResult(d)
