/*
	Description: files tree view

	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef TREEVIEW_H
#define TREEVIEW_H

#include <qlistview.h>
#include <qpixmap.h>
#include <qdict.h>
#include "common.h"

class DirItem;
class TreeView;
class Git;
class StateInfo;
class Domain;

class FileItem : public QListViewItem {
public:
	FileItem(FileItem* p, SCRef nm) : QListViewItem(p, nm), isModified(false) {}
	FileItem(QListView* p, SCRef nm) : QListViewItem(p, nm), isModified(false) {}

	virtual void setModified(bool b) { isModified = b; }
	virtual QString fullName() const;
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int c, int w, int a);

protected:
	bool isModified;
};

class DirItem : public FileItem {
public:
	DirItem(QListView* parent, SCRef ts, SCRef nm, TreeView* t);
	DirItem(DirItem* parent, SCRef ts, SCRef nm, TreeView* t);

	virtual void setOpen(bool b);
	virtual void setup();

protected:
	friend class TreeView;

	QString treeSha;
	TreeView* tv;
	bool isWorkingDir;
};

class TreeView : public QObject {
Q_OBJECT
public:
	TreeView(Domain* d, Git* g, QListView* lv);
	void setTreeName(SCRef treeName) { rootName = treeName; }
	void initMimePix();
	void update();
	void setMimePix(SCRef ext, QPixmap* pix);
	const QPixmap* mimePix(SCRef ext);
	const QString fullName(QListViewItem* item);
	bool isDir(SCRef fileName);
	bool isModified(SCRef path, bool isDir = false);
	void clear();
	void getTreeSelectedItems(QStringList& selectedItems);
	bool getTree(SCRef tSha, SList nm, SList shas, SList types, bool wd, SCRef tPath);

	QPixmap* folderClosed;
	QPixmap* folderOpen;
	QPixmap* fileDefault;

signals:
	void updateViews(const QString& newRevSha, const QString& newFileName);
	void contextMenu(const QString&, int type);

protected slots:
	void on_contextMenuRequested(QListViewItem*,const QPoint&,int);
	void on_currentChanged(QListViewItem*);

private:
	void setTree(SCRef treeSha);
	void setFile(SCRef fileName);
	void restoreStuff();

	Domain* d;
	Git* git;
	QListView* listView;
	StateInfo* st;
	QDict<QPixmap> mimePixMap;
	QString rootName;
	QStringList modifiedFiles; // no need a map, should not be a lot
	QStringList modifiedDirs;
	bool ignoreCurrentChanged;
	bool treeIsValid;
};

#endif
