/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void splitlog(const char *arq, char *df, int dfrom, int duntil, char *convert)
{

   FILE *fp_in;
   char buf[MAXLEN];
   char data[30];
   char dia[11];
   char wdata[20];
   time_t tt;
   int idata=0;
   struct tm *t;
   struct getwordstruct gwarea;

   if(arq[0] == '\0')
      arq="/var/log/squid/access.log";

   if((fp_in=MY_FOPEN(arq,"r"))==NULL) {
      fprintf(stderr, "SARG: (splitlog) %s: %s\n",text[8],arq);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(data,sizeof(data),&gwarea,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",arq);
         exit(1);
      }
      tt=atoi(data);
      t=localtime(&tt);

      if(dfrom) {
         strftime(wdata, sizeof(wdata), "%Y%m%d", t);
         idata=atoi(wdata);
         if(idata < dfrom || idata > duntil)
            continue;
      }

      if(strcmp(convert,"onvert") != 0) {
         printf("%s %s",data,gwarea.current);
         continue;
      }

      if(strncmp(df,"e",1) == 0)
         strftime(dia, sizeof(dia), "%d/%m/%Y", t);
       else
         strftime(dia, sizeof(dia), "%m/%d/%Y", t);

      printf("%s %02d:%02d:%02d %s",dia,t->tm_hour,t->tm_min,t->tm_sec,gwarea.current);
   }

   fclose(fp_in);
}
