<?php

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.5
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

// Try to load our extension if it's not already loaded.
if (!extension_loaded('xapian')) {
  if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
    if (!dl('php_xapian.dll')) return;
  } else {
    // PHP_SHLIB_SUFFIX gives 'dylib' on MacOS X but modules are 'so'.
    if (PHP_SHLIB_SUFFIX === 'dylib') {
      if (!dl('xapian.so')) return;
    } else {
      if (!dl('xapian.'.PHP_SHLIB_SUFFIX)) return;
    }
  }
}



abstract class Xapian {
	static function BAD_VALUENO_get() {
		return BAD_VALUENO_get();
	}

	static function version_string() {
		return version_string();
	}

	static function major_version() {
		return major_version();
	}

	static function minor_version() {
		return minor_version();
	}

	static function revision() {
		return revision();
	}

	const DB_CREATE_OR_OPEN = DB_CREATE_OR_OPEN;

	const DB_CREATE = DB_CREATE;

	const DB_CREATE_OR_OVERWRITE = DB_CREATE_OR_OVERWRITE;

	const DB_OPEN = DB_OPEN;

	static function auto_open_stub($file) {
		$r=auto_open_stub($file);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDatabase($r);
		}
		return $r;
	}

	static function brass_open($dir,$action=null,$block_size=8192) {
		switch (func_num_args()) {
		case 1: $r=brass_open($dir); break;
		default: $r=brass_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_Xapian__WritableDatabase': return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function chert_open($dir,$action=null,$block_size=8192) {
		switch (func_num_args()) {
		case 1: $r=chert_open($dir); break;
		default: $r=chert_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_Xapian__WritableDatabase': return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function flint_open($dir,$action=null,$block_size=8192) {
		switch (func_num_args()) {
		case 1: $r=flint_open($dir); break;
		default: $r=flint_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_Xapian__WritableDatabase': return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function inmemory_open() {
		$r=inmemory_open();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianWritableDatabase($r);
		}
		return $r;
	}

	static function remote_open($host_or_program,$port_or_args,$timeout=10000,$connect_timeout=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=remote_open($host_or_program,$port_or_args,$timeout); break;
		default: $r=remote_open($host_or_program,$port_or_args,$timeout,$connect_timeout);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDatabase($r);
		}
		return $r;
	}

	static function remote_open_writable($host_or_program,$port_or_args,$timeout=10000,$connect_timeout=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=remote_open_writable($host_or_program,$port_or_args,$timeout); break;
		default: $r=remote_open_writable($host_or_program,$port_or_args,$timeout,$connect_timeout);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianWritableDatabase($r);
		}
		return $r;
	}

	static function sortable_serialise($value) {
		return sortable_serialise($value);
	}

	static function sortable_unserialise($value) {
		return sortable_unserialise($value);
	}
}

/* PHP Proxy Classes */
class XapianPositionIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__PositionIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_PositionIterator(); break;
		default: $this->_cPtr=new_PositionIterator($other);
		}
	}

	function get_termpos() {
		return PositionIterator_get_termpos($this->_cPtr);
	}

	function next() {
		PositionIterator_next($this->_cPtr);
	}

	function equals($other) {
		return PositionIterator_equals($this->_cPtr,$other);
	}

	function skip_to($pos) {
		PositionIterator_skip_to($this->_cPtr,$pos);
	}

	function get_description() {
		return PositionIterator_get_description($this->_cPtr);
	}
}

class XapianPostingIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__PostingIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_PostingIterator(); break;
		default: $this->_cPtr=new_PostingIterator($other);
		}
	}

	function skip_to($did) {
		PostingIterator_skip_to($this->_cPtr,$did);
	}

	function get_doclength() {
		return PostingIterator_get_doclength($this->_cPtr);
	}

	function get_wdf() {
		return PostingIterator_get_wdf($this->_cPtr);
	}

	function positionlist_begin() {
		$r=PostingIterator_positionlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end() {
		$r=PostingIterator_positionlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function get_description() {
		return PostingIterator_get_description($this->_cPtr);
	}

	function get_docid() {
		return PostingIterator_get_docid($this->_cPtr);
	}

	function next() {
		PostingIterator_next($this->_cPtr);
	}

	function equals($other) {
		return PostingIterator_equals($this->_cPtr,$other);
	}
}

class XapianTermIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__TermIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_TermIterator(); break;
		default: $this->_cPtr=new_TermIterator($other);
		}
	}

	function get_term() {
		return TermIterator_get_term($this->_cPtr);
	}

	function next() {
		TermIterator_next($this->_cPtr);
	}

	function equals($other) {
		return TermIterator_equals($this->_cPtr,$other);
	}

	function skip_to($tname) {
		TermIterator_skip_to($this->_cPtr,$tname);
	}

	function get_wdf() {
		return TermIterator_get_wdf($this->_cPtr);
	}

	function get_termfreq() {
		return TermIterator_get_termfreq($this->_cPtr);
	}

	function positionlist_count() {
		return TermIterator_positionlist_count($this->_cPtr);
	}

	function positionlist_begin() {
		$r=TermIterator_positionlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end() {
		$r=TermIterator_positionlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function get_description() {
		return TermIterator_get_description($this->_cPtr);
	}
}

class XapianValueIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__ValueIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ValueIterator(); break;
		default: $this->_cPtr=new_ValueIterator($other);
		}
	}

	function get_value() {
		return ValueIterator_get_value($this->_cPtr);
	}

	function next() {
		ValueIterator_next($this->_cPtr);
	}

	function equals($other) {
		return ValueIterator_equals($this->_cPtr,$other);
	}

	function get_docid() {
		return ValueIterator_get_docid($this->_cPtr);
	}

	function get_valueno() {
		return ValueIterator_get_valueno($this->_cPtr);
	}

	function skip_to($docid_or_slot) {
		ValueIterator_skip_to($this->_cPtr,$docid_or_slot);
	}

	function check($docid) {
		return ValueIterator_check($this->_cPtr,$docid);
	}

	function get_description() {
		return ValueIterator_get_description($this->_cPtr);
	}
}

class XapianDocument {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__Document') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Document(); break;
		default: $this->_cPtr=new_Document($other);
		}
	}

	function get_value($slot) {
		return Document_get_value($this->_cPtr,$slot);
	}

	function add_value($slot,$value) {
		Document_add_value($this->_cPtr,$slot,$value);
	}

	function remove_value($slot) {
		Document_remove_value($this->_cPtr,$slot);
	}

	function clear_values() {
		Document_clear_values($this->_cPtr);
	}

	function get_data() {
		return Document_get_data($this->_cPtr);
	}

	function set_data($data) {
		Document_set_data($this->_cPtr,$data);
	}

	function add_posting($tname,$tpos,$wdfinc=1) {
		Document_add_posting($this->_cPtr,$tname,$tpos,$wdfinc);
	}

	function add_term($tname,$wdfinc=1) {
		Document_add_term($this->_cPtr,$tname,$wdfinc);
	}

	function add_boolean_term($term) {
		Document_add_boolean_term($this->_cPtr,$term);
	}

	function remove_posting($tname,$tpos,$wdfdec=1) {
		Document_remove_posting($this->_cPtr,$tname,$tpos,$wdfdec);
	}

	function remove_term($tname) {
		Document_remove_term($this->_cPtr,$tname);
	}

	function clear_terms() {
		Document_clear_terms($this->_cPtr);
	}

	function termlist_count() {
		return Document_termlist_count($this->_cPtr);
	}

	function termlist_begin() {
		$r=Document_termlist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function termlist_end() {
		$r=Document_termlist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function values_count() {
		return Document_values_count($this->_cPtr);
	}

	function values_begin() {
		$r=Document_values_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function values_end() {
		$r=Document_values_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function get_docid() {
		return Document_get_docid($this->_cPtr);
	}

	function serialise() {
		return Document_serialise($this->_cPtr);
	}

	static function unserialise($s) {
		$r=Document_unserialise($s);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_description() {
		return Document_get_description($this->_cPtr);
	}
}

abstract class XapianPostingSource {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	protected function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__PostingSource') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianPostingSource') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_PostingSource($_this);
	}

	function get_termfreq_min() {
		return PostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return PostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return PostingSource_get_termfreq_max($this->_cPtr);
	}

	function get_maxweight() {
		return PostingSource_get_maxweight($this->_cPtr);
	}

	function get_weight() {
		return PostingSource_get_weight($this->_cPtr);
	}

	function get_docid() {
		return PostingSource_get_docid($this->_cPtr);
	}

	function next($min_wt) {
		PostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($did,$min_wt) {
		PostingSource_skip_to($this->_cPtr,$did,$min_wt);
	}

	function check($did,$min_wt) {
		return PostingSource_check($this->_cPtr,$did,$min_wt);
	}

	function at_end() {
		return PostingSource_at_end($this->_cPtr);
	}

	function name() {
		return PostingSource_name($this->_cPtr);
	}

	function init($db) {
		PostingSource_init($this->_cPtr,$db);
	}

	function get_description() {
		return PostingSource_get_description($this->_cPtr);
	}
}

class XapianValuePostingSource extends XapianPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianPostingSource::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianPostingSource::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianPostingSource::__get($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValuePostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_ValuePostingSource($slot_);
	}

	function get_termfreq_min() {
		return ValuePostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return ValuePostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return ValuePostingSource_get_termfreq_max($this->_cPtr);
	}

	function next($min_wt) {
		ValuePostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		ValuePostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return ValuePostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function at_end() {
		return ValuePostingSource_at_end($this->_cPtr);
	}

	function get_docid() {
		return ValuePostingSource_get_docid($this->_cPtr);
	}

	function init($db_) {
		ValuePostingSource_init($this->_cPtr,$db_);
	}
}

class XapianValueWeightPostingSource extends XapianValuePostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValuePostingSource::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValuePostingSource::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValuePostingSource::__get($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueWeightPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_ValueWeightPostingSource($slot_);
	}

	function get_weight() {
		return ValueWeightPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return ValueWeightPostingSource_name($this->_cPtr);
	}

	function init($db_) {
		ValueWeightPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return ValueWeightPostingSource_get_description($this->_cPtr);
	}
}

class XapianDecreasingValueWeightPostingSource extends XapianValueWeightPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValueWeightPostingSource::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValueWeightPostingSource::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValueWeightPostingSource::__get($var);
	}

	function __construct($slot_,$range_start_=0,$range_end_=0) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__DecreasingValueWeightPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_DecreasingValueWeightPostingSource($slot_,$range_start_,$range_end_);
	}

	function get_weight() {
		return DecreasingValueWeightPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return DecreasingValueWeightPostingSource_name($this->_cPtr);
	}

	function init($db_) {
		DecreasingValueWeightPostingSource_init($this->_cPtr,$db_);
	}

	function next($min_wt) {
		DecreasingValueWeightPostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		DecreasingValueWeightPostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return DecreasingValueWeightPostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function get_description() {
		return DecreasingValueWeightPostingSource_get_description($this->_cPtr);
	}
}

class XapianValueMapPostingSource extends XapianValuePostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValuePostingSource::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValuePostingSource::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValuePostingSource::__get($var);
	}

	function __construct($slot_) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueMapPostingSource') {
			$this->_cPtr=$slot_;
			return;
		}
		$this->_cPtr=new_ValueMapPostingSource($slot_);
	}

	function add_mapping($key,$wt) {
		ValueMapPostingSource_add_mapping($this->_cPtr,$key,$wt);
	}

	function clear_mappings() {
		ValueMapPostingSource_clear_mappings($this->_cPtr);
	}

	function set_default_weight($wt) {
		ValueMapPostingSource_set_default_weight($this->_cPtr,$wt);
	}

	function get_weight() {
		return ValueMapPostingSource_get_weight($this->_cPtr);
	}

	function name() {
		return ValueMapPostingSource_name($this->_cPtr);
	}

	function init($db_) {
		ValueMapPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return ValueMapPostingSource_get_description($this->_cPtr);
	}
}

class XapianFixedWeightPostingSource extends XapianPostingSource {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianPostingSource::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianPostingSource::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianPostingSource::__get($var);
	}

	function __construct($wt) {
		if (is_resource($wt) && get_resource_type($wt) === '_p_Xapian__FixedWeightPostingSource') {
			$this->_cPtr=$wt;
			return;
		}
		$this->_cPtr=new_FixedWeightPostingSource($wt);
	}

	function get_termfreq_min() {
		return FixedWeightPostingSource_get_termfreq_min($this->_cPtr);
	}

	function get_termfreq_est() {
		return FixedWeightPostingSource_get_termfreq_est($this->_cPtr);
	}

	function get_termfreq_max() {
		return FixedWeightPostingSource_get_termfreq_max($this->_cPtr);
	}

	function get_weight() {
		return FixedWeightPostingSource_get_weight($this->_cPtr);
	}

	function next($min_wt) {
		FixedWeightPostingSource_next($this->_cPtr,$min_wt);
	}

	function skip_to($min_docid,$min_wt) {
		FixedWeightPostingSource_skip_to($this->_cPtr,$min_docid,$min_wt);
	}

	function check($min_docid,$min_wt) {
		return FixedWeightPostingSource_check($this->_cPtr,$min_docid,$min_wt);
	}

	function at_end() {
		return FixedWeightPostingSource_at_end($this->_cPtr);
	}

	function get_docid() {
		return FixedWeightPostingSource_get_docid($this->_cPtr);
	}

	function name() {
		return FixedWeightPostingSource_name($this->_cPtr);
	}

	function init($db_) {
		FixedWeightPostingSource_init($this->_cPtr,$db_);
	}

	function get_description() {
		return FixedWeightPostingSource_get_description($this->_cPtr);
	}
}

class XapianMSet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__MSet') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_MSet(); break;
		default: $this->_cPtr=new_MSet($other);
		}
	}

	function fetch($begin_or_item=null,$end=null) {
		switch (func_num_args()) {
		case 0: MSet_fetch($this->_cPtr); break;
		case 1: MSet_fetch($this->_cPtr,$begin_or_item); break;
		default: MSet_fetch($this->_cPtr,$begin_or_item,$end);
		}
	}

	function convert_to_percent($wt_or_item) {
		return MSet_convert_to_percent($this->_cPtr,$wt_or_item);
	}

	function get_termfreq($tname) {
		return MSet_get_termfreq($this->_cPtr,$tname);
	}

	function get_termweight($tname) {
		return MSet_get_termweight($this->_cPtr,$tname);
	}

	function get_firstitem() {
		return MSet_get_firstitem($this->_cPtr);
	}

	function get_matches_lower_bound() {
		return MSet_get_matches_lower_bound($this->_cPtr);
	}

	function get_matches_estimated() {
		return MSet_get_matches_estimated($this->_cPtr);
	}

	function get_matches_upper_bound() {
		return MSet_get_matches_upper_bound($this->_cPtr);
	}

	function get_uncollapsed_matches_lower_bound() {
		return MSet_get_uncollapsed_matches_lower_bound($this->_cPtr);
	}

	function get_uncollapsed_matches_estimated() {
		return MSet_get_uncollapsed_matches_estimated($this->_cPtr);
	}

	function get_uncollapsed_matches_upper_bound() {
		return MSet_get_uncollapsed_matches_upper_bound($this->_cPtr);
	}

	function get_max_possible() {
		return MSet_get_max_possible($this->_cPtr);
	}

	function get_max_attained() {
		return MSet_get_max_attained($this->_cPtr);
	}

	function size() {
		return MSet_size($this->_cPtr);
	}

	function is_empty() {
		return MSet_is_empty($this->_cPtr);
	}

	function begin() {
		$r=MSet_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function end() {
		$r=MSet_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function back() {
		$r=MSet_back($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function get_hit($i) {
		$r=MSet_get_hit($this->_cPtr,$i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSetIterator($r);
		}
		return $r;
	}

	function get_document_percentage($i) {
		return MSet_get_document_percentage($this->_cPtr,$i);
	}

	function get_document($i) {
		$r=MSet_get_document($this->_cPtr,$i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_docid($i) {
		return MSet_get_docid($this->_cPtr,$i);
	}

	function get_description() {
		return MSet_get_description($this->_cPtr);
	}
}

class XapianMSetIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__MSetIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_MSetIterator(); break;
		default: $this->_cPtr=new_MSetIterator($other);
		}
	}

	function get_docid() {
		return MSetIterator_get_docid($this->_cPtr);
	}

	function next() {
		MSetIterator_next($this->_cPtr);
	}

	function prev() {
		MSetIterator_prev($this->_cPtr);
	}

	function equals($other) {
		return MSetIterator_equals($this->_cPtr,$other);
	}

	function get_document() {
		$r=MSetIterator_get_document($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_rank() {
		return MSetIterator_get_rank($this->_cPtr);
	}

	function get_weight() {
		return MSetIterator_get_weight($this->_cPtr);
	}

	function get_collapse_key() {
		return MSetIterator_get_collapse_key($this->_cPtr);
	}

	function get_collapse_count() {
		return MSetIterator_get_collapse_count($this->_cPtr);
	}

	function get_percent() {
		return MSetIterator_get_percent($this->_cPtr);
	}

	function get_description() {
		return MSetIterator_get_description($this->_cPtr);
	}
}

class XapianESet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__ESet') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ESet(); break;
		default: $this->_cPtr=new_ESet($other);
		}
	}

	function get_ebound() {
		return ESet_get_ebound($this->_cPtr);
	}

	function size() {
		return ESet_size($this->_cPtr);
	}

	function is_empty() {
		return ESet_is_empty($this->_cPtr);
	}

	function begin() {
		$r=ESet_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function end() {
		$r=ESet_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function back() {
		$r=ESet_back($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESetIterator($r);
		}
		return $r;
	}

	function get_description() {
		return ESet_get_description($this->_cPtr);
	}
}

class XapianESetIterator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__ESetIterator') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ESetIterator(); break;
		default: $this->_cPtr=new_ESetIterator($other);
		}
	}

	function get_term() {
		return ESetIterator_get_term($this->_cPtr);
	}

	function next() {
		ESetIterator_next($this->_cPtr);
	}

	function prev() {
		ESetIterator_prev($this->_cPtr);
	}

	function equals($other) {
		return ESetIterator_equals($this->_cPtr,$other);
	}

	function get_weight() {
		return ESetIterator_get_weight($this->_cPtr);
	}

	function get_description() {
		return ESetIterator_get_description($this->_cPtr);
	}
}

class XapianRSet {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__RSet') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_RSet(); break;
		default: $this->_cPtr=new_RSet($other);
		}
	}

	function size() {
		return RSet_size($this->_cPtr);
	}

	function is_empty() {
		return RSet_is_empty($this->_cPtr);
	}

	function add_document($did_or_i) {
		RSet_add_document($this->_cPtr,$did_or_i);
	}

	function remove_document($did_or_i) {
		RSet_remove_document($this->_cPtr,$did_or_i);
	}

	function contains($did_or_i) {
		return RSet_contains($this->_cPtr,$did_or_i);
	}

	function get_description() {
		return RSet_get_description($this->_cPtr);
	}
}

abstract class XapianMatchDecider {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($doc) {
		return MatchDecider_apply($this->_cPtr,$doc);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MatchDecider') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianMatchDecider') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_MatchDecider($_this);
	}
}

abstract class XapianExpandDecider {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($term) {
		return ExpandDecider_apply($this->_cPtr,$term);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ExpandDecider') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianExpandDecider') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ExpandDecider($_this);
	}
}

class XapianEnquire {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($databases) {
		if (is_resource($databases) && get_resource_type($databases) === '_p_Xapian__Enquire') {
			$this->_cPtr=$databases;
			return;
		}
		$this->_cPtr=new_Enquire($databases);
	}

	function set_query($query,$qlen=0) {
		Enquire_set_query($this->_cPtr,$query,$qlen);
	}

	function get_query() {
		$r=Enquire_get_query($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function add_matchspy($spy) {
		Enquire_add_matchspy($this->_cPtr,$spy);
	}

	function clear_matchspies() {
		Enquire_clear_matchspies($this->_cPtr);
	}

	function set_weighting_scheme($weight) {
		Enquire_set_weighting_scheme($this->_cPtr,$weight);
	}

	function set_collapse_key($collapse_key,$collapse_max=1) {
		Enquire_set_collapse_key($this->_cPtr,$collapse_key,$collapse_max);
	}

	const ASCENDING = 1;

	const DESCENDING = 0;

	const DONT_CARE = 2;

	function set_docid_order($order) {
		Enquire_set_docid_order($this->_cPtr,$order);
	}

	function set_cutoff($percent_cutoff,$weight_cutoff=0.0) {
		Enquire_set_cutoff($this->_cPtr,$percent_cutoff,$weight_cutoff);
	}

	function set_sort_by_relevance() {
		Enquire_set_sort_by_relevance($this->_cPtr);
	}

	function set_sort_by_value($sort_key,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_value($this->_cPtr,$sort_key); break;
		default: Enquire_set_sort_by_value($this->_cPtr,$sort_key,$reverse);
		}
	}

	function set_sort_by_value_then_relevance($sort_key,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_value_then_relevance($this->_cPtr,$sort_key); break;
		default: Enquire_set_sort_by_value_then_relevance($this->_cPtr,$sort_key,$reverse);
		}
	}

	function set_sort_by_relevance_then_value($sort_key,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_relevance_then_value($this->_cPtr,$sort_key); break;
		default: Enquire_set_sort_by_relevance_then_value($this->_cPtr,$sort_key,$reverse);
		}
	}

	function set_sort_by_key($sorter,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_key($this->_cPtr,$sorter); break;
		default: Enquire_set_sort_by_key($this->_cPtr,$sorter,$reverse);
		}
	}

	function set_sort_by_key_then_relevance($sorter,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_key_then_relevance($this->_cPtr,$sorter); break;
		default: Enquire_set_sort_by_key_then_relevance($this->_cPtr,$sorter,$reverse);
		}
	}

	function set_sort_by_relevance_then_key($sorter,$reverse=null) {
		switch (func_num_args()) {
		case 1: Enquire_set_sort_by_relevance_then_key($this->_cPtr,$sorter); break;
		default: Enquire_set_sort_by_relevance_then_key($this->_cPtr,$sorter,$reverse);
		}
	}

	const INCLUDE_QUERY_TERMS = Enquire_INCLUDE_QUERY_TERMS;

	const USE_EXACT_TERMFREQ = Enquire_USE_EXACT_TERMFREQ;

	function get_mset($first,$maxitems,$checkatleast_or_omrset=null,$omrset_or_mdecider=null,$mdecider=null,$matchspy=null) {
		switch (func_num_args()) {
		case 2: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems); break;
		case 3: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset); break;
		case 4: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider); break;
		case 5: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider,$mdecider); break;
		default: $r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider,$mdecider,$matchspy);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianMSet($r);
		}
		return $r;
	}

	function get_eset($maxitems,$omrset,$flags_or_edecider=null,$k=null,$edecider=null,$min_wt=null) {
		switch (func_num_args()) {
		case 2: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset); break;
		case 3: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset,$flags_or_edecider); break;
		case 4: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset,$flags_or_edecider,$k); break;
		case 5: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset,$flags_or_edecider,$k,$edecider); break;
		default: $r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset,$flags_or_edecider,$k,$edecider,$min_wt);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianESet($r);
		}
		return $r;
	}

	function get_matching_terms_begin($did_or_i) {
		$r=Enquire_get_matching_terms_begin($this->_cPtr,$did_or_i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_matching_terms_end($did_or_i) {
		$r=Enquire_get_matching_terms_end($this->_cPtr,$did_or_i);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_matching_terms($hit) {
		return Enquire_get_matching_terms($this->_cPtr,$hit);
	}

	function get_description() {
		return Enquire_get_description($this->_cPtr);
	}
}

class XapianRegistry {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($other=null) {
		if (is_resource($other) && get_resource_type($other) === '_p_Xapian__Registry') {
			$this->_cPtr=$other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Registry(); break;
		default: $this->_cPtr=new_Registry($other);
		}
	}

	function register_weighting_scheme($wt) {
		Registry_register_weighting_scheme($this->_cPtr,$wt);
	}

	function get_weighting_scheme($name) {
		$r=Registry_get_weighting_scheme($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}

	function register_posting_source($source) {
		Registry_register_posting_source($this->_cPtr,$source);
	}

	function get_posting_source($name) {
		$r=Registry_get_posting_source($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}

	function register_match_spy($spy) {
		Registry_register_match_spy($this->_cPtr,$spy);
	}

	function get_match_spy($name) {
		$r=Registry_get_match_spy($this->_cPtr,$name);
		$this->_cPtr = $r;
		return $this;
	}
}

abstract class XapianWeight {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function name() {
		return Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen) {
		return Weight_get_sumpart($this->_cPtr,$wdf,$doclen);
	}

	function get_maxpart() {
		return Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen) {
		return Weight_get_sumextra($this->_cPtr,$doclen);
	}

	function get_maxextra() {
		return Weight_get_maxextra($this->_cPtr);
	}

	function get_sumpart_needs_doclength_() {
		return Weight_get_sumpart_needs_doclength_($this->_cPtr);
	}

	function get_sumpart_needs_wdf_() {
		return Weight_get_sumpart_needs_wdf_($this->_cPtr);
	}
}

class XapianBoolWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__BoolWeight') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_BoolWeight();
	}

	function name() {
		return BoolWeight_name($this->_cPtr);
	}

	function serialise() {
		return BoolWeight_serialise($this->_cPtr);
	}

	function unserialise($s) {
		$r=BoolWeight_unserialise($this->_cPtr,$s);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianBoolWeight($r);
		}
		return $r;
	}

	function get_sumpart($wdf,$doclen) {
		return BoolWeight_get_sumpart($this->_cPtr,$wdf,$doclen);
	}

	function get_maxpart() {
		return BoolWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen) {
		return BoolWeight_get_sumextra($this->_cPtr,$doclen);
	}

	function get_maxextra() {
		return BoolWeight_get_maxextra($this->_cPtr);
	}
}

class XapianBM25Weight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __construct($k1=null,$k2=null,$k3=null,$b=null,$min_normlen=null) {
		if (is_resource($k1) && get_resource_type($k1) === '_p_Xapian__BM25Weight') {
			$this->_cPtr=$k1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_BM25Weight(); break;
		case 1: $this->_cPtr=new_BM25Weight($k1); break;
		case 2: $this->_cPtr=new_BM25Weight($k1,$k2); break;
		case 3: $this->_cPtr=new_BM25Weight($k1,$k2,$k3); break;
		case 4: $this->_cPtr=new_BM25Weight($k1,$k2,$k3,$b); break;
		default: $this->_cPtr=new_BM25Weight($k1,$k2,$k3,$b,$min_normlen);
		}
	}

	function name() {
		return BM25Weight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen) {
		return BM25Weight_get_sumpart($this->_cPtr,$wdf,$doclen);
	}

	function get_maxpart() {
		return BM25Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen) {
		return BM25Weight_get_sumextra($this->_cPtr,$doclen);
	}

	function get_maxextra() {
		return BM25Weight_get_maxextra($this->_cPtr);
	}
}

class XapianTradWeight extends XapianWeight {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianWeight::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianWeight::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianWeight::__get($var);
	}

	function __construct($k=1.0) {
		if (is_resource($k) && get_resource_type($k) === '_p_Xapian__TradWeight') {
			$this->_cPtr=$k;
			return;
		}
		$this->_cPtr=new_TradWeight($k);
	}

	function name() {
		return TradWeight_name($this->_cPtr);
	}

	function get_sumpart($wdf,$doclen) {
		return TradWeight_get_sumpart($this->_cPtr,$wdf,$doclen);
	}

	function get_maxpart() {
		return TradWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($doclen) {
		return TradWeight_get_sumextra($this->_cPtr,$doclen);
	}

	function get_maxextra() {
		return TradWeight_get_maxextra($this->_cPtr);
	}
}

abstract class XapianMatchSpy {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	protected function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MatchSpy') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianMatchSpy') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_MatchSpy($_this);
	}

	function apply($doc,$wt) {
		MatchSpy_apply($this->_cPtr,$doc,$wt);
	}

	function name() {
		return MatchSpy_name($this->_cPtr);
	}

	function merge_results($s) {
		MatchSpy_merge_results($this->_cPtr,$s);
	}

	function get_description() {
		return MatchSpy_get_description($this->_cPtr);
	}
}

class XapianValueCountMatchSpy extends XapianMatchSpy {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianMatchSpy::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianMatchSpy::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianMatchSpy::__get($var);
	}

	function __construct($slot_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__ValueCountMatchSpy') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ValueCountMatchSpy(); break;
		default: $this->_cPtr=new_ValueCountMatchSpy($slot_);
		}
	}

	function get_total() {
		return ValueCountMatchSpy_get_total($this->_cPtr);
	}

	function values_begin() {
		$r=ValueCountMatchSpy_values_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function values_end() {
		$r=ValueCountMatchSpy_values_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function top_values_begin($maxvalues) {
		$r=ValueCountMatchSpy_top_values_begin($this->_cPtr,$maxvalues);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function top_values_end($arg1) {
		$r=ValueCountMatchSpy_top_values_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function apply($doc,$wt) {
		ValueCountMatchSpy_apply($this->_cPtr,$doc,$wt);
	}

	function name() {
		return ValueCountMatchSpy_name($this->_cPtr);
	}

	function merge_results($s) {
		ValueCountMatchSpy_merge_results($this->_cPtr,$s);
	}

	function get_description() {
		return ValueCountMatchSpy_get_description($this->_cPtr);
	}
}

class XapianDatabase {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function add_database($database) {
		Database_add_database($this->_cPtr,$database);
	}

	function __construct($path_or_other=null) {
		if (is_resource($path_or_other) && get_resource_type($path_or_other) === '_p_Xapian__Database') {
			$this->_cPtr=$path_or_other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Database(); break;
		default: $this->_cPtr=new_Database($path_or_other);
		}
	}

	function reopen() {
		Database_reopen($this->_cPtr);
	}

	function close() {
		Database_close($this->_cPtr);
	}

	function get_description() {
		return Database_get_description($this->_cPtr);
	}

	function postlist_begin($tname) {
		$r=Database_postlist_begin($this->_cPtr,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPostingIterator($r);
		}
		return $r;
	}

	function postlist_end($tname) {
		$r=Database_postlist_end($this->_cPtr,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPostingIterator($r);
		}
		return $r;
	}

	function termlist_begin($did) {
		$r=Database_termlist_begin($this->_cPtr,$did);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function termlist_end($did) {
		$r=Database_termlist_end($this->_cPtr,$did);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function positionlist_begin($did,$tname) {
		$r=Database_positionlist_begin($this->_cPtr,$did,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function positionlist_end($did,$tname) {
		$r=Database_positionlist_end($this->_cPtr,$did,$tname);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianPositionIterator($r);
		}
		return $r;
	}

	function allterms_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_allterms_begin($this->_cPtr); break;
		default: $r=Database_allterms_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function allterms_end($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_allterms_end($this->_cPtr); break;
		default: $r=Database_allterms_end($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_doccount() {
		return Database_get_doccount($this->_cPtr);
	}

	function get_lastdocid() {
		return Database_get_lastdocid($this->_cPtr);
	}

	function get_avlength() {
		return Database_get_avlength($this->_cPtr);
	}

	function get_termfreq($tname) {
		return Database_get_termfreq($this->_cPtr,$tname);
	}

	function term_exists($tname) {
		return Database_term_exists($this->_cPtr,$tname);
	}

	function get_collection_freq($tname) {
		return Database_get_collection_freq($this->_cPtr,$tname);
	}

	function get_value_freq($valno) {
		return Database_get_value_freq($this->_cPtr,$valno);
	}

	function get_value_lower_bound($valno) {
		return Database_get_value_lower_bound($this->_cPtr,$valno);
	}

	function get_value_upper_bound($valno) {
		return Database_get_value_upper_bound($this->_cPtr,$valno);
	}

	function get_doclength_lower_bound() {
		return Database_get_doclength_lower_bound($this->_cPtr);
	}

	function get_doclength_upper_bound() {
		return Database_get_doclength_upper_bound($this->_cPtr);
	}

	function get_wdf_upper_bound($term) {
		return Database_get_wdf_upper_bound($this->_cPtr,$term);
	}

	function valuestream_begin($slot) {
		$r=Database_valuestream_begin($this->_cPtr,$slot);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function valuestream_end($arg1) {
		$r=Database_valuestream_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianValueIterator($r);
		}
		return $r;
	}

	function get_doclength($docid) {
		return Database_get_doclength($this->_cPtr,$docid);
	}

	function keep_alive() {
		Database_keep_alive($this->_cPtr);
	}

	function get_document($did) {
		$r=Database_get_document($this->_cPtr,$did);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function get_spelling_suggestion($word,$max_edit_distance=2) {
		return Database_get_spelling_suggestion($this->_cPtr,$word,$max_edit_distance);
	}

	function spellings_begin() {
		$r=Database_spellings_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function spellings_end() {
		$r=Database_spellings_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonyms_begin($term) {
		$r=Database_synonyms_begin($this->_cPtr,$term);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonyms_end($arg1) {
		$r=Database_synonyms_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonym_keys_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_synonym_keys_begin($this->_cPtr); break;
		default: $r=Database_synonym_keys_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function synonym_keys_end($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_synonym_keys_end($this->_cPtr); break;
		default: $r=Database_synonym_keys_end($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_metadata($key) {
		return Database_get_metadata($this->_cPtr,$key);
	}

	function metadata_keys_begin($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_metadata_keys_begin($this->_cPtr); break;
		default: $r=Database_metadata_keys_begin($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function metadata_keys_end($prefix=null) {
		switch (func_num_args()) {
		case 0: $r=Database_metadata_keys_end($this->_cPtr); break;
		default: $r=Database_metadata_keys_end($this->_cPtr,$prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_uuid() {
		return Database_get_uuid($this->_cPtr);
	}

	function has_positions() {
		return Database_has_positions($this->_cPtr);
	}
}

class XapianWritableDatabase extends XapianDatabase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianDatabase::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianDatabase::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianDatabase::__get($var);
	}

	function __construct($path_or_other=null,$action=null) {
		if (is_resource($path_or_other) && get_resource_type($path_or_other) === '_p_Xapian__WritableDatabase') {
			$this->_cPtr=$path_or_other;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_WritableDatabase(); break;
		case 1: $this->_cPtr=new_WritableDatabase($path_or_other); break;
		default: $this->_cPtr=new_WritableDatabase($path_or_other,$action);
		}
	}

	function commit() {
		WritableDatabase_commit($this->_cPtr);
	}

	function flush() {
		WritableDatabase_flush($this->_cPtr);
	}

	function begin_transaction($flushed=true) {
		WritableDatabase_begin_transaction($this->_cPtr,$flushed);
	}

	function commit_transaction() {
		WritableDatabase_commit_transaction($this->_cPtr);
	}

	function cancel_transaction() {
		WritableDatabase_cancel_transaction($this->_cPtr);
	}

	function add_document($document) {
		return WritableDatabase_add_document($this->_cPtr,$document);
	}

	function delete_document($did_or_unique_term) {
		WritableDatabase_delete_document($this->_cPtr,$did_or_unique_term);
	}

	function replace_document($did_or_unique_term,$document) {
		return WritableDatabase_replace_document($this->_cPtr,$did_or_unique_term,$document);
	}

	function add_spelling($word,$freqinc=1) {
		WritableDatabase_add_spelling($this->_cPtr,$word,$freqinc);
	}

	function remove_spelling($word,$freqdec=1) {
		WritableDatabase_remove_spelling($this->_cPtr,$word,$freqdec);
	}

	function add_synonym($term,$synonym) {
		WritableDatabase_add_synonym($this->_cPtr,$term,$synonym);
	}

	function remove_synonym($term,$synonym) {
		WritableDatabase_remove_synonym($this->_cPtr,$term,$synonym);
	}

	function clear_synonyms($term) {
		WritableDatabase_clear_synonyms($this->_cPtr,$term);
	}

	function set_metadata($key,$value) {
		WritableDatabase_set_metadata($this->_cPtr,$key,$value);
	}

	function get_description() {
		return WritableDatabase_get_description($this->_cPtr);
	}
}

class XapianQuery {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	const OP_AND = 0;

	const OP_OR = Query_OP_OR;

	const OP_AND_NOT = Query_OP_AND_NOT;

	const OP_XOR = Query_OP_XOR;

	const OP_AND_MAYBE = Query_OP_AND_MAYBE;

	const OP_FILTER = Query_OP_FILTER;

	const OP_NEAR = Query_OP_NEAR;

	const OP_PHRASE = Query_OP_PHRASE;

	const OP_VALUE_RANGE = Query_OP_VALUE_RANGE;

	const OP_SCALE_WEIGHT = Query_OP_SCALE_WEIGHT;

	const OP_ELITE_SET = Query_OP_ELITE_SET;

	const OP_VALUE_GE = Query_OP_VALUE_GE;

	const OP_VALUE_LE = Query_OP_VALUE_LE;

	const OP_SYNONYM = Query_OP_SYNONYM;

	static function MatchAll() {
		$r=Query_MatchAll_get();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	static function MatchNothing() {
		$r=Query_MatchNothing_get();
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function get_length() {
		return Query_get_length($this->_cPtr);
	}

	function get_terms_begin() {
		$r=Query_get_terms_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function get_terms_end() {
		$r=Query_get_terms_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function is_empty() {
		return Query_is_empty($this->_cPtr);
	}

	function serialise() {
		return Query_serialise($this->_cPtr);
	}

	static function unserialise($s,$registry=null) {
		switch (func_num_args()) {
		case 1: $r=Query_unserialise($s); break;
		default: $r=Query_unserialise($s,$registry);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function get_description() {
		return Query_get_description($this->_cPtr);
	}

	function __construct($copyme_or_tname__or_op__or_external_source_or_op=null,$wqf__or_left_or_q_or_slot_or_subqs=null,$pos__or_right_or_parameter_or_begin_or_value_or_param=null,$end=null) {
		if (is_resource($copyme_or_tname__or_op__or_external_source_or_op) && get_resource_type($copyme_or_tname__or_op__or_external_source_or_op) === '_p_Xapian__Query') {
			$this->_cPtr=$copyme_or_tname__or_op__or_external_source_or_op;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_Query(); break;
		case 1: $this->_cPtr=new_Query($copyme_or_tname__or_op__or_external_source_or_op); break;
		case 2: $this->_cPtr=new_Query($copyme_or_tname__or_op__or_external_source_or_op,$wqf__or_left_or_q_or_slot_or_subqs); break;
		case 3: $this->_cPtr=new_Query($copyme_or_tname__or_op__or_external_source_or_op,$wqf__or_left_or_q_or_slot_or_subqs,$pos__or_right_or_parameter_or_begin_or_value_or_param); break;
		default: $this->_cPtr=new_Query($copyme_or_tname__or_op__or_external_source_or_op,$wqf__or_left_or_q_or_slot_or_subqs,$pos__or_right_or_parameter_or_begin_or_value_or_param,$end);
		}
	}
}

abstract class XapianStopper {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($term) {
		return Stopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return Stopper_get_description($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Stopper') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianStopper') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_Stopper($_this);
	}
}

class XapianSimpleStopper extends XapianStopper {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStopper::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStopper::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStopper::__get($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__SimpleStopper') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_SimpleStopper();
	}

	function add($word) {
		SimpleStopper_add($this->_cPtr,$word);
	}

	function apply($term) {
		return SimpleStopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return SimpleStopper_get_description($this->_cPtr);
	}
}

abstract class XapianValueRangeProcessor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($begin,$end) {
		return ValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__ValueRangeProcessor') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianValueRangeProcessor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_ValueRangeProcessor($_this);
	}
}

class XapianStringValueRangeProcessor extends XapianValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianValueRangeProcessor::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianValueRangeProcessor::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianValueRangeProcessor::__get($var);
	}

	function __construct($slot_,$str_=null,$prefix_=true) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__StringValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_StringValueRangeProcessor($slot_); break;
		default: $this->_cPtr=new_StringValueRangeProcessor($slot_,$str_,$prefix_);
		}
	}

	function apply($begin,$end) {
		return StringValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

class XapianDateValueRangeProcessor extends XapianStringValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStringValueRangeProcessor::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStringValueRangeProcessor::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStringValueRangeProcessor::__get($var);
	}

	function __construct($slot_,$prefer_mdy__or_str_=null,$epoch_year__or_prefix_=null,$prefer_mdy_=null,$epoch_year_=null) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__DateValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_DateValueRangeProcessor($slot_); break;
		case 2: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_); break;
		case 3: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_); break;
		case 4: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_,$prefer_mdy_); break;
		default: $this->_cPtr=new_DateValueRangeProcessor($slot_,$prefer_mdy__or_str_,$epoch_year__or_prefix_,$prefer_mdy_,$epoch_year_);
		}
	}

	function apply($begin,$end) {
		return DateValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

class XapianNumberValueRangeProcessor extends XapianStringValueRangeProcessor {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianStringValueRangeProcessor::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianStringValueRangeProcessor::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianStringValueRangeProcessor::__get($var);
	}

	function __construct($slot_,$str_=null,$prefix_=true) {
		if (is_resource($slot_) && get_resource_type($slot_) === '_p_Xapian__NumberValueRangeProcessor') {
			$this->_cPtr=$slot_;
			return;
		}
		switch (func_num_args()) {
		case 1: $this->_cPtr=new_NumberValueRangeProcessor($slot_); break;
		default: $this->_cPtr=new_NumberValueRangeProcessor($slot_,$str_,$prefix_);
		}
	}

	function apply($begin,$end) {
		return NumberValueRangeProcessor_apply($this->_cPtr,$begin,$end);
	}
}

class XapianQueryParser {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	const FLAG_BOOLEAN = 1;

	const FLAG_PHRASE = 2;

	const FLAG_LOVEHATE = 4;

	const FLAG_BOOLEAN_ANY_CASE = 8;

	const FLAG_WILDCARD = 16;

	const FLAG_PURE_NOT = 32;

	const FLAG_PARTIAL = 64;

	const FLAG_SPELLING_CORRECTION = 128;

	const FLAG_SYNONYM = 256;

	const FLAG_AUTO_SYNONYMS = 512;

	const FLAG_AUTO_MULTIWORD_SYNONYMS = QueryParser_FLAG_AUTO_MULTIWORD_SYNONYMS;

	const FLAG_DEFAULT = QueryParser_FLAG_DEFAULT;

	const STEM_NONE = 0;

	const STEM_SOME = QueryParser_STEM_SOME;

	const STEM_ALL = QueryParser_STEM_ALL;

	const STEM_ALL_Z = QueryParser_STEM_ALL_Z;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__QueryParser') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_QueryParser();
	}

	function set_stemmer($stemmer) {
		QueryParser_set_stemmer($this->_cPtr,$stemmer);
	}

	function set_stemming_strategy($strategy) {
		QueryParser_set_stemming_strategy($this->_cPtr,$strategy);
	}

	function set_stopper($stop=null) {
		QueryParser_set_stopper($this->_cPtr,$stop);
	}

	function set_default_op($default_op) {
		QueryParser_set_default_op($this->_cPtr,$default_op);
	}

	function get_default_op() {
		return QueryParser_get_default_op($this->_cPtr);
	}

	function set_database($db) {
		QueryParser_set_database($this->_cPtr,$db);
	}

	function set_max_wildcard_expansion($limit) {
		QueryParser_set_max_wildcard_expansion($this->_cPtr,$limit);
	}

	function parse_query($query_string,$flags=null,$default_prefix=null) {
		switch (func_num_args()) {
		case 1: $r=QueryParser_parse_query($this->_cPtr,$query_string); break;
		case 2: $r=QueryParser_parse_query($this->_cPtr,$query_string,$flags); break;
		default: $r=QueryParser_parse_query($this->_cPtr,$query_string,$flags,$default_prefix);
		}
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianQuery($r);
		}
		return $r;
	}

	function add_prefix($field,$prefix) {
		QueryParser_add_prefix($this->_cPtr,$field,$prefix);
	}

	function add_boolean_prefix($field,$prefix,$exclusive=null) {
		switch (func_num_args()) {
		case 2: QueryParser_add_boolean_prefix($this->_cPtr,$field,$prefix); break;
		default: QueryParser_add_boolean_prefix($this->_cPtr,$field,$prefix,$exclusive);
		}
	}

	function stoplist_begin() {
		$r=QueryParser_stoplist_begin($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function stoplist_end() {
		$r=QueryParser_stoplist_end($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function unstem_begin($term) {
		$r=QueryParser_unstem_begin($this->_cPtr,$term);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function unstem_end($arg1) {
		$r=QueryParser_unstem_end($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianTermIterator($r);
		}
		return $r;
	}

	function add_valuerangeprocessor($vrproc) {
		QueryParser_add_valuerangeprocessor($this->_cPtr,$vrproc);
	}

	function get_corrected_query_string() {
		return QueryParser_get_corrected_query_string($this->_cPtr);
	}

	function get_description() {
		return QueryParser_get_description($this->_cPtr);
	}
}

abstract class XapianStemImplementation {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($word) {
		return StemImplementation_apply($this->_cPtr,$word);
	}

	function get_description() {
		return StemImplementation_get_description($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__StemImplementation') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianStemImplementation') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_StemImplementation($_this);
	}
}

class XapianStem {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($language_or_p) {
		if (is_resource($language_or_p) && get_resource_type($language_or_p) === '_p_Xapian__Stem') {
			$this->_cPtr=$language_or_p;
			return;
		}
		$this->_cPtr=new_Stem($language_or_p);
	}

	function apply($word) {
		return Stem_apply($this->_cPtr,$word);
	}

	function get_description() {
		return Stem_get_description($this->_cPtr);
	}

	static function get_available_languages() {
		return Stem_get_available_languages();
	}
}

class XapianTermGenerator {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__TermGenerator') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_TermGenerator();
	}

	function set_stemmer($stemmer) {
		TermGenerator_set_stemmer($this->_cPtr,$stemmer);
	}

	function set_stopper($stop=null) {
		TermGenerator_set_stopper($this->_cPtr,$stop);
	}

	function set_document($doc) {
		TermGenerator_set_document($this->_cPtr,$doc);
	}

	function get_document() {
		$r=TermGenerator_get_document($this->_cPtr);
		if (is_resource($r)) {
			$c='Xapian'.substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new XapianDocument($r);
		}
		return $r;
	}

	function set_database($db) {
		TermGenerator_set_database($this->_cPtr,$db);
	}

	const FLAG_SPELLING = 128;

	const STEM_NONE = 0;

	const STEM_SOME = TermGenerator_STEM_SOME;

	const STEM_ALL = TermGenerator_STEM_ALL;

	const STEM_ALL_Z = TermGenerator_STEM_ALL_Z;

	function set_flags($toggle,$mask=null) {
		switch (func_num_args()) {
		case 1: $r=TermGenerator_set_flags($this->_cPtr,$toggle); break;
		default: $r=TermGenerator_set_flags($this->_cPtr,$toggle,$mask);
		}
		return $r;
	}

	function set_stemming_strategy($strategy) {
		TermGenerator_set_stemming_strategy($this->_cPtr,$strategy);
	}

	function index_text($text,$wdf_inc=1,$prefix=null) {
		switch (func_num_args()) {
		case 1: case 2: TermGenerator_index_text($this->_cPtr,$text,$wdf_inc); break;
		default: TermGenerator_index_text($this->_cPtr,$text,$wdf_inc,$prefix);
		}
	}

	function index_text_without_positions($text,$wdf_inc=1,$prefix=null) {
		switch (func_num_args()) {
		case 1: case 2: TermGenerator_index_text_without_positions($this->_cPtr,$text,$wdf_inc); break;
		default: TermGenerator_index_text_without_positions($this->_cPtr,$text,$wdf_inc,$prefix);
		}
	}

	function increase_termpos($delta=100) {
		TermGenerator_increase_termpos($this->_cPtr,$delta);
	}

	function get_termpos() {
		return TermGenerator_get_termpos($this->_cPtr);
	}

	function set_termpos($termpos) {
		TermGenerator_set_termpos($this->_cPtr,$termpos);
	}

	function get_description() {
		return TermGenerator_get_description($this->_cPtr);
	}
}

abstract class XapianKeyMaker {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function apply($doc) {
		return KeyMaker_apply($this->_cPtr,$doc);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__KeyMaker') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianKeyMaker') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_KeyMaker($_this);
	}
}

class XapianMultiValueKeyMaker extends XapianKeyMaker {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianKeyMaker::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianKeyMaker::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianKeyMaker::__get($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MultiValueKeyMaker') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_MultiValueKeyMaker();
	}

	function apply($doc) {
		return MultiValueKeyMaker_apply($this->_cPtr,$doc);
	}

	function add_value($slot,$reverse=false) {
		MultiValueKeyMaker_add_value($this->_cPtr,$slot,$reverse);
	}
}

abstract class XapianSorter extends XapianKeyMaker {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianKeyMaker::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianKeyMaker::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianKeyMaker::__get($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}
}

class XapianMultiValueSorter extends XapianSorter {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianSorter::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianSorter::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianSorter::__get($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__MultiValueSorter') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_MultiValueSorter();
	}

	function apply($doc) {
		return MultiValueSorter_apply($this->_cPtr,$doc);
	}

	function add($slot,$forward=true) {
		MultiValueSorter_add($this->_cPtr,$slot,$forward);
	}
}

class XapianValueSetMatchDecider extends XapianMatchDecider {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		XapianMatchDecider::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return XapianMatchDecider::__isset($var);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return XapianMatchDecider::__get($var);
	}

	function __construct($slot,$inclusive_) {
		if (is_resource($slot) && get_resource_type($slot) === '_p_Xapian__ValueSetMatchDecider') {
			$this->_cPtr=$slot;
			return;
		}
		$this->_cPtr=new_ValueSetMatchDecider($slot,$inclusive_);
	}

	function add_value($value) {
		ValueSetMatchDecider_add_value($this->_cPtr,$value);
	}

	function remove_value($value) {
		ValueSetMatchDecider_remove_value($this->_cPtr,$value);
	}

	function apply($doc) {
		return ValueSetMatchDecider_apply($this->_cPtr,$doc);
	}
}

class XapianCompactor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_xapian_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_xapian_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	const STANDARD = 0;

	const FULL = Compactor_FULL;

	const FULLER = Compactor_FULLER;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_Xapian__Compactor') {
			$this->_cPtr=$res;
			return;
		}
		if (get_class($this) === 'XapianCompactor') {
			$_this = null;
		} else {
			$_this = $this;
		}
		$this->_cPtr=new_Compactor($_this);
	}

	function set_block_size($block_size) {
		Compactor_set_block_size($this->_cPtr,$block_size);
	}

	function set_renumber($renumber) {
		Compactor_set_renumber($this->_cPtr,$renumber);
	}

	function set_multipass($multipass) {
		Compactor_set_multipass($this->_cPtr,$multipass);
	}

	function set_compaction_level($compaction) {
		Compactor_set_compaction_level($this->_cPtr,$compaction);
	}

	function set_destdir($destdir) {
		Compactor_set_destdir($this->_cPtr,$destdir);
	}

	function add_source($srcdir) {
		Compactor_add_source($this->_cPtr,$srcdir);
	}

	function compact() {
		Compactor_compact($this->_cPtr);
	}

	function set_status($table,$status) {
		Compactor_set_status($this->_cPtr,$table,$status);
	}

	function resolve_duplicate_metadata($key,$num_tags,$tags) {
		return Compactor_resolve_duplicate_metadata($this->_cPtr,$key,$num_tags,$tags);
	}
}


?>
