/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

 
#include <includes.h>
#ifdef NESSUSNT
#include "wstuff.h"
#endif

#include "log.h"
#include "ntp.h"
#include "threads.h"
#include "auth.h"
#include "comm.h"
#include "plugs_deps.h"

extern int g_max_threads;

/*
 * Sort the plugins by type (SCANNER, GATHER_INFO, ATTACK, DENIAL, PASSIVE)
 *
 * This "algorithm" is downright ugly, but it works, and since I'm
 * not seeking the best performances right now, well, it fits my need
 *
 */
struct arglist * sort_plugins_by_type(lplugs)
 struct arglist * lplugs;
{
 struct arglist * plugins = lplugs;
 struct arglist * ret;
 struct arglist * tplugs = emalloc(sizeof(struct arglist));
 int i;
 ret = tplugs;

 for(i=ACT_SCANNER;i<=ACT_PASSIVE;i++)
    {
      while(lplugs && lplugs->next)
	{
	  struct arglist * args;
	  
	  args = arg_get_value(lplugs->value, "plugin_args");
	  if(args && ((int)arg_get_value(args, "CATEGORY")==i))
	    {
#ifdef DEBUG
	      if(i == ACT_SCANNER)printf("add %s\n", lplugs->name);
#endif	      
	      tplugs->value = lplugs->value;
	      tplugs->name = lplugs->name;
	      tplugs->type = lplugs->type;
	      tplugs->length = lplugs->length;
	      tplugs->next = emalloc(sizeof(struct arglist));
	      tplugs = tplugs->next;
	    }
	  lplugs = lplugs->next;
	}
      lplugs = plugins;
    }
   return(deps_plugins_sort(ret));
}

/* 
 * Get the max number of threads that
 * the user allowed us to use. If it's not
 * set correctly, we return 5
 */
int get_max_thread_number(preferences)
 struct arglist * preferences;
{
  int max_threads;
  if(arg_get_value(preferences, "max_threads"))
    {
      max_threads = atoi(arg_get_value(preferences, "max_threads"));
      if(max_threads<=0)
	{
	  log_write("Error ! max_threads = %d -- check %s\n", 
		    max_threads, (char *)arg_get_value(preferences, "config_file"));
	  max_threads = g_max_threads;
	}
    else if(max_threads > g_max_threads)
     {
     	log_write("Client tried to raise the maximum threads number - %d. Using %d. Change 'max_threads' in nessusd.conf if\
you believe this is incorrect\n",
			max_threads, g_max_threads);
	max_threads = g_max_threads;
     }
    }
  else max_threads = g_max_threads;
  return(max_threads);
}


/*
 * Returns the number of plugins that will be launched
 */
int 
get_active_plugins_number(plugins)
 struct arglist *  plugins;
{
  int i = 0;
  while(plugins && plugins->next)
    { 
      if(plug_get_launch(plugins->value))i++;
      plugins = plugins->next;
    }
 return(i);
}


void send_plugin_order(globals, plugins)
 struct arglist * globals;
 struct arglist * plugins;
{
 int num; 
 char * str;
 
 
  num = get_active_plugins_number(plugins);
  if(!num)num = 1;
  str = malloc(num*10+1);
  str[0]='\0';
  while(plugins && plugins->next)
  {
    char * sp;
    
    if(plug_get_launch(plugins->value))
     {
      struct arglist *v = arg_get_value(plugins->value, "plugin_args");
      sp = emalloc(9);
      sprintf(sp, "%d", (int)arg_get_value(v, "ID"));
      strcat(str, sp);
      efree(&sp);
      strcat(str, ";");
     }
     plugins = plugins->next;
   }
  auth_printf(globals, "SERVER <|> PLUGINS_ORDER <|> %s <|> SERVER\n",
  		str);	
  free(str);
 
}


void plugins_set_ntp_caps(plugins, caps)
 struct arglist * plugins;
 ntp_caps* caps;
{
 while(plugins && plugins->next)
 {
  struct arglist * v;
  
  v = arg_get_value(plugins->value, "plugin_args");
  if(v)arg_add_value(v, "NTP_CAPS", ARG_STRUCT, sizeof(*caps), caps);
  plugins = plugins->next;
 }
}


int check_client_input(globals)
 struct arglist * globals;
{
 int soc = (int)arg_get_value(globals, "global_socket");
 unsigned long i = 0;
 struct timeval tv = {60,0};
 fd_set rd,wr;
 int R,W;
 
 FD_ZERO(&rd);
 FD_SET(soc, &rd);
 FD_ZERO(&wr);
 FD_SET(soc, &wr);
 select(soc+1, &rd, &wr,NULL,&tv);
 R = FD_ISSET(soc, &rd);
 W = FD_ISSET(soc, &wr);
 if(R)
 {
  struct nessusd_threads * threads = arg_get_value(globals, "threads");
  char * buf = emalloc(4096);
  char * t, * t2;
  auth_gets(globals, buf, 4095);
  if(!strlen(buf))return(-1);
  if((t = strstr(buf, "STOP_ATTACK")))
  {  
    t2 = strstr(t, "<|> ");
    if(!t2)return;
    t2+=strlen("<|> ");
    t = strstr(t2, " <|>");
    if(!t)return;
    t[0] = 0;
    nessusd_thread_kill_by_name(&threads, threads, t2);
    auth_printf(globals, "SERVER <|> FINISHED <|> %s <|> SERVER\n",
				t2);
    t[0] = ' ';
   } else if((t = strstr(buf,"STOP_WHOLE_TEST"))){
        log_write("stopping the whole test (requested by client)");
        nessusd_thread_kill_all(threads);
        return(-1);
        }
   efree(&buf);
   arg_set_value(globals, "threads", -1, threads);
 }
 else if(!W)return(-1);
}


void
check_client_input_thread(globals)
 struct arglist * globals;
{
 while(1){
 	if((check_client_input(globals))<0)return;
	}
}


int
is_symlink(name)
 char * name;
{
#ifndef NESSUSNT
 struct stat sb;
 if(stat(name, &sb))return(0);
 return(S_ISLNK(sb.st_mode));
#else
 return(0);
#endif
}

void check_symlink(name)
 char * name;
{
 if(is_symlink(name))
 { 
  fprintf(stderr, "The file %s is a symlink -- can't continue\n", name);
  DO_EXIT(0);
 }
}

/*
 * Converts a hostnames arglist 
 * to a space delimited lists of hosts
 * in one string
 */
char * 
hosts_arglist_to_string(hosts)
 struct arglist * hosts;
{
 int num_hosts = 0;
 struct arglist * start = hosts;
 int hosts_len = 0;
 char * ret;

 while(hosts && hosts->next){
  if(hosts->value)
  {
    num_hosts++;
    hosts_len+=strlen(hosts->value);
  }
  hosts = hosts->next;
 }       
  
 ret = emalloc(hosts_len + 2 * num_hosts + 1);
 
 hosts = start;
 
 while(hosts && hosts->next) {
  if(hosts->value){
   strcat(ret, hosts->value);
   strcat(ret, " ");
  }
  hosts = hosts->next;
 }
return(ret);
} 


 
 
